<?php
/**
 * @package ScholarsGate
 */

/**
 * Footer
 */
if (! function_exists( 'scholarsgate_footer_copyrights' ) ):
    function scholarsgate_footer_copyrights() {
        ?>
            <div class="row">
                <div class="copyrights">
                    <p>
                        <?php
                            if("" != esc_html(get_theme_mod( 'scholarsgate_footer_copyright_text'))) :
                                echo esc_html(get_theme_mod( 'scholarsgate_footer_copyright_text'));
                                if(get_theme_mod('scholarsgate_en_footer_credits',true)) :
                                    ?> 
                                    <span class="copyrg-link"><a href="<?php echo esc_url(SCHOLARSGATE_AUT); ?>" target="_blank" rel="nofollow noopener"><?php esc_html_e(' | Scholarsgate WordPress Theme','scholarsgate') ?></a><?php esc_html_e(' by Legacy Themes','scholarsgate') ?></span>
                                    <?php   
                                endif;
                            else :
                                echo date_i18n(
                                    /* translators: Copyright date format, see https://secure.php.net/date */
                                    _x( 'Y', 'copyright date format', 'scholarsgate' )
                                );
                                ?>
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a>
                                    <span class="copyrg-link"><a href="<?php echo esc_url(SCHOLARSGATE_AUT); ?>" target="_blank" rel="nofollow noopener"><?php esc_html_e(' | Scholarsgate WordPress Theme','scholarsgate') ?></a><?php esc_html_e(' by Legacy Themes','scholarsgate') ?></span>
                                <?php
                            endif;
                        ?>
                    </p>
                </div>
            </div>
        <?php    
    }
endif;
add_action( 'scholarsgate_action_footer', 'scholarsgate_footer_copyrights' );


/**
 * Page Title Settings
 */
if (!function_exists('scholarsgate_show_page_title')) :
    function scholarsgate_show_page_title() {
        if (!is_front_page()) {
            ?>
            <div class="page-title"> 
                <div class="content-section img-overlay">
                    <div class="container">
                        <div class="row text-center">
                            <div class="col-md-12">
                                <div class="section-title"> 
                                    <?php
                                    if (is_singular('post')) {
                                        // Single blog post
                                        echo '<h1 class="main-title">' . get_the_title() . '</h1>';
                                    } elseif (is_category()) {
                                        echo '<h1 class="main-title">' . single_cat_title('', false) . '</h1>';
                                    } elseif (is_tag()) {
                                        echo '<h1 class="main-title">' . single_tag_title('', false) . '</h1>';
                                    } elseif (is_author()) {
                                        echo '<h1 class="main-title">' . get_the_author() . '</h1>';
                                    } elseif (is_archive()) {
                                        echo '<h1 class="main-title">' . get_the_archive_title() . '</h1>';
                                    } elseif (is_search()) {
                                        echo '<h1 class="main-title">' . esc_html__('Search Results', 'scholarsgate') . '</h1>';
                                    } elseif (is_404()) {
                                        echo '<h1 class="main-title">' . esc_html__('Page Not Found', 'scholarsgate') . '</h1>';
                                    } else {
                                        echo '<h1 class="main-title">' . get_the_title() . '</h1>';
                                    }
                                    ?>
                                </div>                      
                            </div>
                        </div>
                    </div>  
                </div>
            </div>  <!-- End page-title --> 
            <?php
        }
    }
endif;

/**
 * Home Banner Section
 */
if (! function_exists( 'scholarsgate_home_banner_section' ) ):
    function scholarsgate_home_banner_section() {
        ?>
        <section id="main-banner-wrap">
            <div class="container-fluid">
                <div class="banner-side-margin">
                    <div class="row">
                        <div class="col-lg-11 col-md-11 col-11 position-relative">
                            <div class="main-banner-inner-box">
                                <?php
                                $scholarsgate_banner_image = get_theme_mod( 'scholarsgate_banner_image', '' );
                                if ( ! empty( $scholarsgate_banner_image ) ) { ?>
                                    <img src="<?php echo esc_url( $scholarsgate_banner_image ); ?>">
                                <?php } ?>
                            </div>
                            <?php
                            $scholarsgate_alignment_class = get_theme_mod( 'scholarsgate_slider_content_alignment', 'left' );
                            ?>
                            <div class="main-banner-content-box content-<?php echo esc_attr( $scholarsgate_alignment_class ); ?>">
                                <?php
                                    $scholarsgate_banner_small_heading = get_theme_mod( 'scholarsgate_banner_small_heading', '' );
                                    if ( ! empty( $scholarsgate_banner_small_heading ) ) { ?>
                                    <h6><?php echo esc_html( $scholarsgate_banner_small_heading ); ?></h6>
                                <?php } ?>
                                <?php
                                    $scholarsgate_banner_heading = get_theme_mod( 'scholarsgate_banner_heading', '' );
                                    if ( ! empty( $scholarsgate_banner_heading ) ) { ?>
                                    <h3><?php echo esc_html( $scholarsgate_banner_heading ); ?></h3>
                                <?php } ?>
                                <?php
                                    $scholarsgate_banner_text = get_theme_mod( 'scholarsgate_banner_text', '' );
                                    if ( ! empty( $scholarsgate_banner_text ) ) { ?>
                                    <p><?php echo esc_html( $scholarsgate_banner_text ); ?></p>
                                <?php } ?>
                                <div class="banner-button">
                                    <?php
                                    $scholarsgate_banner_button_link = get_theme_mod( 'scholarsgate_banner_button_link', '' );
                                    if ( ! empty( $scholarsgate_banner_button_link ) ) { ?>
                                        <a href="<?php echo esc_url( $scholarsgate_banner_button_link ); ?>"><?php echo esc_html('Get A Quote','scholarsgate'); ?></a>
                                    <?php } ?>
                                </div>                            
                            </div>
                        </div>
                        <div class="col-lg-1 col-md-1 col-1 position-relative">
                            <div class="follow-us">
                                <span><?php echo esc_html( 'Follow Us','scholarsgate' ); ?></span>
                                <?php
                                    $scholarsgate_social_media1_heading = get_theme_mod( 'scholarsgate_social_media1_heading', '' );
                                    if ( ! empty( $scholarsgate_social_media1_heading ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_social_media1_heading ); ?>"><i class="bi bi-facebook"></i></a>
                                <?php } ?>
                                <?php
                                    $scholarsgate_social_media2_heading = get_theme_mod( 'scholarsgate_social_media2_heading', '' );
                                    if ( ! empty( $scholarsgate_social_media2_heading ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_social_media2_heading ); ?>"><i class="bi bi-instagram"></i></a>
                                <?php } ?>
                                <?php
                                    $scholarsgate_social_media3_heading = get_theme_mod( 'scholarsgate_social_media3_heading', '' );
                                    if ( ! empty( $scholarsgate_social_media3_heading ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_social_media3_heading ); ?>"><i class="bi bi-twitter-x"></i></a>
                                <?php } ?>
                                <?php
                                    $scholarsgate_social_media4_heading = get_theme_mod( 'scholarsgate_social_media4_heading', '' );
                                    if ( ! empty( $scholarsgate_social_media4_heading ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_social_media4_heading ); ?>"><i class="bi bi-youtube"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php    
    }
endif;
add_action( 'scholarsgate_action_home_banner', 'scholarsgate_home_banner_section' );


/**
 * Home About Section
 */
if (! function_exists( 'scholarsgate_home_services_section' ) ):
    function scholarsgate_home_services_section() {
        ?>
        <section id="services-wrap" class="py-5">
            <div class="container">
                <?php
                    $scholarsgate_services_short_heading = get_theme_mod( 'scholarsgate_services_short_heading', '' );
                    if ( ! empty( $scholarsgate_services_short_heading ) ) { ?>
                    <h4><?php echo esc_html( $scholarsgate_services_short_heading ); ?></h4>
                <?php } ?>
                <?php
                    $scholarsgate_services_heading = get_theme_mod( 'scholarsgate_services_heading', '' );
                    if ( ! empty( $scholarsgate_services_heading ) ) { ?>
                    <h3><?php echo esc_html( $scholarsgate_services_heading ); ?></h3>
                <?php } ?>
                <?php
                    $scholarsgate_services_content = get_theme_mod( 'scholarsgate_services_content', '' );
                    if ( ! empty( $scholarsgate_services_content ) ) { ?>
                    <p><?php echo esc_html( $scholarsgate_services_content ); ?></p>
                <?php } ?>
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="services-box my-3">
                            <?php
                                $scholarsgate_services_icon1 = get_theme_mod( 'scholarsgate_services_icon1', '' );
                                if ( ! empty( $scholarsgate_services_icon1 ) ) { ?>
                                <i class="<?php echo esc_attr( $scholarsgate_services_icon1 ); ?>"></i>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_heading1 = get_theme_mod( 'scholarsgate_services_box_heading1', '' );
                                if ( ! empty( $scholarsgate_services_box_heading1 ) ) { ?>
                                <h4><?php echo esc_html( $scholarsgate_services_box_heading1 ); ?></h4>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_content1 = get_theme_mod( 'scholarsgate_services_box_content1', '' );
                                if ( ! empty( $scholarsgate_services_box_content1 ) ) { ?>
                                <p><?php echo esc_html( $scholarsgate_services_box_content1 ); ?></p>
                            <?php } ?>
                            <div class="banner-button">
                                <?php
                                $scholarsgate_services_button_link1 = get_theme_mod( 'scholarsgate_services_button_link1', '' );
                                if ( ! empty( $scholarsgate_services_button_link1 ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_services_button_link1 ); ?>"><?php echo esc_html('Read More','scholarsgate'); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="services-box mb-3">
                            <?php
                                $scholarsgate_services_icon2 = get_theme_mod( 'scholarsgate_services_icon2', '' );
                                if ( ! empty( $scholarsgate_services_icon2 ) ) { ?>
                                <i class="<?php echo esc_attr( $scholarsgate_services_icon2 ); ?>"></i>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_heading2 = get_theme_mod( 'scholarsgate_services_box_heading2', '' );
                                if ( ! empty( $scholarsgate_services_box_heading2 ) ) { ?>
                                <h4><?php echo esc_html( $scholarsgate_services_box_heading2 ); ?></h4>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_content2 = get_theme_mod( 'scholarsgate_services_box_content2', '' );
                                if ( ! empty( $scholarsgate_services_box_content2 ) ) { ?>
                                <p><?php echo esc_html( $scholarsgate_services_box_content2 ); ?></p>
                            <?php } ?>
                            <div class="banner-button">
                                <?php
                                $scholarsgate_services_button_link2 = get_theme_mod( 'scholarsgate_services_button_link2', '' );
                                if ( ! empty( $scholarsgate_services_button_link2 ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_services_button_link2 ); ?>"><?php echo esc_html('Read More','scholarsgate'); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-12">
                        <div class="services-box mb-3">
                            <?php
                                $scholarsgate_services_icon3 = get_theme_mod( 'scholarsgate_services_icon3', '' );
                                if ( ! empty( $scholarsgate_services_icon3 ) ) { ?>
                                <i class="<?php echo esc_attr( $scholarsgate_services_icon3 ); ?>"></i>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_heading3 = get_theme_mod( 'scholarsgate_services_box_heading3', '' );
                                if ( ! empty( $scholarsgate_services_box_heading3 ) ) { ?>
                                <h4><?php echo esc_html( $scholarsgate_services_box_heading3 ); ?></h4>
                            <?php } ?>
                            <?php
                                $scholarsgate_services_box_content3 = get_theme_mod( 'scholarsgate_services_box_content3', '' );
                                if ( ! empty( $scholarsgate_services_box_content3 ) ) { ?>
                                <p><?php echo esc_html( $scholarsgate_services_box_content3 ); ?></p>
                            <?php } ?>
                            <div class="banner-button">
                                <?php
                                $scholarsgate_services_button_link3 = get_theme_mod( 'scholarsgate_services_button_link3', '' );
                                if ( ! empty( $scholarsgate_services_button_link3 ) ) { ?>
                                    <a href="<?php echo esc_url( $scholarsgate_services_button_link3 ); ?>"><?php echo esc_html('Read More','scholarsgate'); ?></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php
    }
endif;
add_action( 'scholarsgate_action_home_services', 'scholarsgate_home_services_section' );

/**
 * Home page another adding Section
 */
if (! function_exists( 'scholarsgate_home_extra_section' ) ):
    function scholarsgate_home_extra_section() {
        ?>
        <div id="custom-home-extra-content" class="py-3">
            <div class="container">
              <?php while ( have_posts() ) : the_post(); ?>
                <?php the_content(); ?>
              <?php endwhile; ?>
            </div>
        </div>
        <?php    
    }
endif;
add_action( 'scholarsgate_action_home_extra', 'scholarsgate_home_extra_section' );