<?php
/*
 * @package ScholarsGate
 */

function scholarsgate_admin_enqueue_scripts() {
    wp_enqueue_style( 'scholarsgate-admin-style', esc_url( get_template_directory_uri() ).'/inc/quick-start-page.css' );
}
add_action( 'admin_enqueue_scripts', 'scholarsgate_admin_enqueue_scripts' );

function scholarsgate_theme_info_menu_link() {
    add_theme_page(
        esc_html__( 'Theme Demo Import', 'scholarsgate' ),
        esc_html__( 'Theme Demo Import', 'scholarsgate' ),
        'edit_theme_options',
        'scholarsgate-demo',
        'scholarsgate_demo_content_page'
    );

}
add_action( 'admin_menu', 'scholarsgate_theme_info_menu_link' );


function scholarsgate_demo_content_page() {

    $scholarsgate_theme = wp_get_theme();
    ?>
    <div class="demo-box">
        <div class="wrapper-demo">
            <div class="importer-content">
                <h2><?php echo esc_html( 'Welcome to ScholarsGate', 'scholarsgate' ); ?> <span class="demo-versn"><?php echo $scholarsgate_theme->get( 'Version' ); ?></span></h2>
                <h6><?php echo esc_html('Importing Demo Content','scholarsgate');?> </h6>
                <p><?php echo esc_html('Click Run Importer to begin the process of configuring your website. This will enable you to easily duplicate the theme\'s sample layout by automatically importing all required demo content, such as pages, settings, and configurations. It is strongly advised that you create a complete backup of your website before launching the importer. This guarantees that your current data is secure and recoverable in the event of an emergency. For best speed and appearance, the suggested Customizer settings are automatically applied by the demo importer, which is designed to work perfectly with ScholarsGate. All of the settings and content will be applied after the import is finished. You can, however, freely alter things further to suit your tastes using the WordPress Customizer.','scholarsgate'); ?></p>
                <?php require get_parent_theme_file_path( '/inc/quick-start-content.php' ); ?>
            </div>
            <div class="thme-img-box">
                <img src="<?php echo esc_url( get_template_directory_uri().'/screenshot.png' ); ?>" />
            </div>
        </div>
    </div>

<?php
}

?>