<div class="theme-offer">
<?php

    function scholarsgate_create_customizer_nav_menu() {
        // ------- Create Nav Menu --------
        $scholarsgate_menuname = 'Primary';
        $scholarsgate_menulocation = 'primary';
        $scholarsgate_menu_exists = wp_get_nav_menu_object($scholarsgate_menuname);

        if (!$scholarsgate_menu_exists) {
            $scholarsgate_menu_id = wp_create_nav_menu($scholarsgate_menuname);

            wp_update_nav_menu_item($scholarsgate_menu_id, 0, array(
                'menu-item-title' => __('Home', 'scholarsgate'),
                'menu-item-url' => home_url('/'),
                'menu-item-status' => 'publish',
            ));

            wp_update_nav_menu_item($scholarsgate_menu_id, 0, array(
                'menu-item-title' => __('About Us', 'scholarsgate'),
                'menu-item-url' => home_url('/index.php/about-us/'),
                'menu-item-status' => 'publish',
            ));

            wp_update_nav_menu_item($scholarsgate_menu_id, 0, array(
                'menu-item-title' => __('Services', 'scholarsgate'),
                'menu-item-url' => home_url('/index.php/services/'),
                'menu-item-status' => 'publish',
            ));

            wp_update_nav_menu_item($scholarsgate_menu_id, 0, array(
                'menu-item-title' => __('Pages', 'scholarsgate'),
                'menu-item-url' => home_url('/index.php/pages/'),
                'menu-item-status' => 'publish',
            ));

            wp_update_nav_menu_item($scholarsgate_menu_id, 0, array(
                'menu-item-title' => __('Blog', 'scholarsgate'),
                'menu-item-url' => home_url('/index.php/blog/'),
                'menu-item-status' => 'publish',
            ));

            // Set menu to location
            $scholarsgate_locations = get_theme_mod('nav_menu_locations');
            if (!is_array($scholarsgate_locations)) {
                $scholarsgate_locations = array();
            }
            $scholarsgate_locations[$scholarsgate_menulocation] = $scholarsgate_menu_id;
            set_theme_mod('nav_menu_locations', $scholarsgate_locations);
        }
    }

    // POST and update the customizer and other related data of ScholarsGate
    if (isset($_POST['submit'])) {

        // -------- Plugin Installation and Activation (WooCommerce & Classic Widgets) -------- //
        include_once(ABSPATH . 'wp-admin/includes/plugin.php');
        include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
        include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
        include_once(ABSPATH . 'wp-admin/includes/file.php');
        include_once(ABSPATH . 'wp-admin/includes/misc.php');

        // Plugin list
        $scholarsgate_plugins = array(
            array(
                'slug' => 'classic-widgets',
                'file' => 'classic-widgets/classic-widgets.php',
                'download_url' => 'https://downloads.wordpress.org/plugin/classic-widgets.zip'
            )
        );

        foreach ($scholarsgate_plugins as $plugin) {
            $installed_plugins = get_plugins();

            // Install the plugin if it's not installed
            if (!isset($installed_plugins[$plugin['file']])) {
                $upgrader = new Plugin_Upgrader();
                $upgrader->install($plugin['download_url']);
            }

            // Activate the plugin if it's not active
            if (file_exists(WP_PLUGIN_DIR . '/' . $plugin['file']) && !is_plugin_active($plugin['file'])) {
                activate_plugin($plugin['file']);
            }
        }

        // ------- Create Menu --------
        scholarsgate_create_customizer_nav_menu();

        // ------- Create Pages --------
        function create_demo_page($title, $content = '', $template = '') {
            $page_id = scholarsgate_get_page_id_by_title($title);
        
            if (!$page_id) {
                $page_data = array(
                    'post_type'    => 'page',
                    'post_title'   => $title,
                    'post_content' => $content,
                    'post_status'  => 'publish',
                    'post_author'  => 1,
                );
        
                $page_id = wp_insert_post($page_data);
        
                if ($template && !is_wp_error($page_id)) {
                    update_post_meta($page_id, '_wp_page_template', $template);
                }
            }
        
            return $page_id;
        }
        

        $scholarsgate_home_id = create_demo_page('Home', '', 'home/home.php');
        update_option('page_on_front', $scholarsgate_home_id);
        update_option('show_on_front', 'page');

        create_demo_page('Pages', '<p>Lorem Ipsum ...</p>');
        create_demo_page('About Us', '<p>Lorem Ipsum ...</p>');
        create_demo_page('Services', '<p>Service description...</p>');
        // Create blog page and assign it to display posts
        $blog_page_id = create_demo_page('Blog');
        update_option('page_for_posts', $blog_page_id);

        // Create the nav menu
        scholarsgate_create_customizer_nav_menu();

        // ------- Set Theme Mods --------


        set_theme_mod('scholarsgate_header_calling_text', 'Have Any Question');
        set_theme_mod('scholarsgate_header_calling_number', '+12 345678912');       

        // ------- Banner Section --------
        set_theme_mod('scholarsgate_social_media1_heading', 'www.facebook.com');
        set_theme_mod('scholarsgate_social_media2_heading', 'www.instagram.com');
        set_theme_mod('scholarsgate_social_media3_heading', 'www.twitter.com');
        set_theme_mod('scholarsgate_social_media4_heading', 'www.youtube.com');
        
        set_theme_mod("scholarsgate_banner_image", get_template_directory_uri() . "/img/banner.png");
        
        set_theme_mod("scholarsgate_banner_small_heading", 'Growth Your Education');
        set_theme_mod("scholarsgate_banner_heading", 'Education Is A Path To Success In Life');
        set_theme_mod("scholarsgate_banner_text", 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since.');
        set_theme_mod("scholarsgate_banner_button_link", '#');


        // ------- Services Section --------


        set_theme_mod('scholarsgate_services_short_heading', 'Categories');
        set_theme_mod('scholarsgate_services_heading', 'Popular Topic To Learn');
        set_theme_mod('scholarsgate_services_content', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy tex');       
        
        set_theme_mod("scholarsgate_services_icon1", 'bi bi-graph-up');
        set_theme_mod("scholarsgate_services_box_heading1", 'Data Science');
        set_theme_mod("scholarsgate_services_box_content1", 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text');
        set_theme_mod("scholarsgate_services_button_link1", '#');
        set_theme_mod("scholarsgate_services_icon2", 'bi bi-pencil');
        set_theme_mod("scholarsgate_services_box_heading2", 'UI/UX Design');
        set_theme_mod("scholarsgate_services_box_content2", 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text');
        set_theme_mod("scholarsgate_services_button_link2", '#');
        set_theme_mod("scholarsgate_services_icon3", 'bi bi-heart-pulse');
        set_theme_mod("scholarsgate_services_box_heading3", 'Health & Fitness');
        set_theme_mod("scholarsgate_services_box_content3", 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text');
        set_theme_mod("scholarsgate_services_button_link3", '#');
        

        echo '<div class="success">Demo Import Successful</div>';
    }
?>

<ul>
    <li>
        <hr>
        <?php if (!isset($_POST['submit'])) : ?>
            <?php echo esc_html__('Click on the below button to get demo content installed.', 'scholarsgate'); ?>
            <br>
            <form id="demo-importer-form" action="" method="POST" onsubmit="return confirm('Do you really want to do this?');">
                <input class="run-btn" type="submit" name="submit" value="<?php echo esc_attr('Run Importer', 'scholarsgate'); ?>">
            </form>
        <?php else: ?>
            <div class="visit">
                <a href="<?php echo esc_url(home_url()); ?>" class="button button-primary button-large run-btn" style="margin-top: 10px;" target="_blank">View Site</a>
            </div>
        <?php endif; ?>
        <hr>
    </li>
</ul>
</div>