<?php
/**
 * Template part for displaying header menu
 *
 * @package ScholarsGate
 */

?>
<?php
    $page_val= is_front_page() ? 'home':'page' ;

?>

<header id="<?php echo esc_attr($page_val);?>-inner" class="elementer-menu-anchor theme-menu-wrapper full-width-menu style1 page" role="banner">
    <?php
        if(true===get_theme_mod('scholarsgate_enable_highlighted area',true) && is_front_page()){
            ?><a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('skip to content','scholarsgate'); ?> </a> <?php
        }
        else{
        ?><a class="skip-link screen-reader-text" href="#main"><?php esc_html_e('skip to content','scholarsgate');?></a> <?php
    }
    ?>
<div id="custom-header">
    <?php if ( display_header_text() ) : ?>
    <div id="header-main" class="header-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-2 col-md-6 col-8 align-self-center">
                    <div class="logo <?php echo (has_custom_logo() ? 'has-logo' : 'no-logo'); ?>" itemscope itemtype="https://schema.org/Organization">
                                <?php 
                                    // Display custom logo if available
                                    if ( has_custom_logo() ) {
                                        scholarsgate_custom_logo();
                                    }

                                    // Display sticky header logo if enabled
                                    if ( get_theme_mod( 'scholarsgate_enable_logo_stickyheader', false ) ) {
                                        $scholarsgate_alt_logo = esc_url( get_theme_mod( 'scholarsgate_logo_stickyheader' ) );
                                        if ( ! empty( $scholarsgate_alt_logo ) ) {
                                            ?>
                                            <a id="logo-alt" class="logo-alt" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <img src="<?php echo esc_url( $scholarsgate_alt_logo ); ?>" alt="<?php esc_attr_e( 'logo', 'scholarsgate' ); ?>">
                                            </a>
                                            <?php
                                        }
                                    }

                                    // Site title and tagline settings
                                    $scholarsgate_show_title   = get_theme_mod( 'scholarsgate_display_site_title', true );
                                    $scholarsgate_show_tagline = get_theme_mod( 'scholarsgate_display_site_tagline', false );
                                    $scholarsgate_header_class = $scholarsgate_show_title ? 'site-title' : 'screen-reader-text';

                                    // Display site title
                                    if ( $scholarsgate_show_title && get_bloginfo( 'name' ) ) {
                                        if ( is_front_page() ) {
                                            ?>
                                            <h1 class="<?php echo esc_attr( $scholarsgate_header_class ); ?>">
                                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a>
                                            </h1>
                                            <?php
                                        } else {
                                            ?>
                                            <p class="<?php echo esc_attr( $scholarsgate_header_class ); ?>">
                                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a>
                                            </p>
                                            <?php
                                        }
                                    }

                                    // Display tagline
                                    if ( $scholarsgate_show_tagline ) {
                                        $scholarsgate_description = get_bloginfo( 'description', 'display' );
                                        if ( $scholarsgate_description || is_customize_preview() ) {
                                            ?>
                                            <p class="site-description"><?php echo esc_html( $scholarsgate_description ); ?></p>
                                            <?php
                                        }
                                    }
                                ?>
                            </div>                     
                </div>
                <div class="col-lg-8 col-md-2 col-4 align-self-center">
                    <div class="top-menu-wrapper">
                        <div class="navigation_header">
                                <div class="toggle-nav mobile-menu">
                                    <button onclick="scholarsgate_openNav()"><i class="bi bi-list"></i></button>
                                </div>
                                <div id="mySidenav" class="nav sidenav">
                                    <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'scholarsgate' ); ?>">
                                        <?php {
                                                wp_nav_menu(
                                                    array(
                                                        'theme_location' => 'primary',
                                                        'container_class' => 'navi clearfix navbar-nav' ,
                                                        'menu_class'     => 'menu clearfix', 
                                                        'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                                        'fallback_cb' => 'wp_page_menu',
                                                    )
                                                );
                                            } ?>
                                    </nav>
                                    <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="scholarsgate_closeNav()"><i class="bi bi-x"></i></a>
                                </div>
                            </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-12 calling-box align-self-center">
                    <?php
                        $scholarsgate_header_calling_text = get_theme_mod( 'scholarsgate_header_calling_text', '' );
                        $scholarsgate_header_calling_number = get_theme_mod( 'scholarsgate_header_calling_number', '' );
                        if ( ! empty( $scholarsgate_header_calling_text ) || ! empty( $scholarsgate_header_calling_number ) ) { ?>
                        <div class="row">
                            <div class="col-lg-3 col-md-3 col-4 text-center align-self-center">
                                <i class="bi bi-headset"></i>
                            </div>
                            <div class="col-lg-9 col-md-9 col-8 align-self-center">
                                <p><?php echo esc_html( $scholarsgate_header_calling_text ); ?></p>
                                <h5><?php echo esc_html( $scholarsgate_header_calling_number ); ?></h5>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div> 
</header>

<div class="clearfix"></div>
<div id="content" class="elementor-menu-anchor"></div>

<div class="content-wrap">