<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */

if ( ! function_exists( 'scholarsgate_customizer_typography_setting_register' ) ) :
function scholarsgate_customizer_typography_setting_register( $wp_customize ) {

    // Add Typography Panel for Body and Heading
    $wp_customize->add_panel(
        'scholarsgate_typography_settings_panel',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Typography Settings', 'scholarsgate' ),
        )
    );

    // Section Body Typography
    $wp_customize->add_section(
        'scholarsgate_body_typography_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Body', 'scholarsgate' ),
            'panel'         => 'scholarsgate_typography_settings_panel',
        )
    );

    // Body Font Family Setting
    $wp_customize->add_setting(
        'scholarsgate_body_font_family',
        array(
            'default'           => 'Figtree, sans-serif', // Default font
            'sanitize_callback' => 'scholarsgate_sanitize_font_family', // Custom sanitize function
        )
    );
    $wp_customize->add_control( new Scholarsgate_Font_Select_Control(
    $wp_customize,
    'scholarsgate_body_font_family',
    array(
        'label'   => esc_html__( 'Body Font Family', 'scholarsgate' ),
        'section' => 'scholarsgate_body_typography_settings',
        'choices' => scholarsgate_get_google_fonts(),
    )
    ));

    // Section Heading Typography
    $wp_customize->add_section(
        'scholarsgate_heading_typography_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Heading', 'scholarsgate' ),
            'panel'         => 'scholarsgate_typography_settings_panel',
        )
    );

    // Heading Font Family Setting
    $wp_customize->add_setting(
        'scholarsgate_heading_font_family',
        array(
            'default'           => 'Figtree, sans-serif', // Default font
            'sanitize_callback' => 'scholarsgate_sanitize_font_family', // Custom sanitize function
        )
    );
    $wp_customize->add_control( new Scholarsgate_Font_Select_Control(
    $wp_customize,
    'scholarsgate_heading_font_family',
    array(
        'label'   => esc_html__( 'Heading Font Family', 'scholarsgate' ),
        'section' => 'scholarsgate_heading_typography_settings',
        'choices' => scholarsgate_get_google_fonts(),
    )
    ));
}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_typography_setting_register' );

// Function to fetch Google Fonts
function scholarsgate_get_google_fonts() {
    // Add Google Fonts to be available for selection
    return array(
        'Figtree, sans-serif' => 'Figtree',
        'Arial, sans-serif'   => 'Arial',
        'Georgia, serif'      => 'Georgia',
        'Verdana, sans-serif' => 'Verdana',
        'Times New Roman, serif' => 'Times New Roman',
        'Roboto, sans-serif'  => 'Roboto',
        'Open Sans, sans-serif' => 'Open Sans',
        'Lora, serif'         => 'Lora',
        'Merriweather, serif' => 'Merriweather',
        'Montserrat, sans-serif' => 'Montserrat',
        // Add more Google fonts as needed
    );
}

// Sanitize Google Fonts input
function scholarsgate_sanitize_font_family( $value ) {
    $allowed_fonts = array(
        'Figtree, sans-serif','Arial, sans-serif', 'Georgia, serif', 'Verdana, sans-serif','Times New Roman, serif', 'Roboto, sans-serif', 'Open Sans, sans-serif','Lora, serif', 'Merriweather, serif', 'Montserrat, sans-serif',
        // Add more allowed fonts to this array
    );

    if ( in_array( $value, $allowed_fonts ) ) {
        return $value;
    } else {
        return 'Figtree, sans-serif'; // Default fallback font
    }
}

function scholarsgate_sanitize_title( $value ) {
    return sanitize_text_field( $value );
}
