<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_home_services_register' ) ) :
function scholarsgate_customizer_home_services_register( $wp_customize ) {

    $wp_customize->add_section(
        'scholarsgate_home_services_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Services Settings', 'scholarsgate' )
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'scholarsgate_label_services_settings_title', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_services_settings_title', 
        array(
            'label'       => esc_html__( 'Services Settings', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_services_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_services_settings_title',
        ) 
    ));

    // Services Short Title
    $wp_customize->add_setting(
        'scholarsgate_services_short_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_short_heading',
        array(
            'label'           => sprintf( esc_html__( 'Services Short Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_short_heading' ,
            'type'            => 'text',
        )
    );

    // Services Title
    $wp_customize->add_setting(
        'scholarsgate_services_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_heading',
        array(
            'label'           => sprintf( esc_html__( 'Services Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_heading' ,
            'type'            => 'text',
        )
    );

    // Services Text
    $wp_customize->add_setting(
        'scholarsgate_services_content',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_content',
        array(
            'label'           => sprintf( esc_html__( 'Services Text', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_content' ,
            'type'            => 'text',
        )
    );

    // Title label 1
    $wp_customize->add_setting( 
        'scholarsgate_label_services_extra_content_settings_title1', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_services_extra_content_settings_title1', 
        array(
            'label'       => esc_html__( 'Services Box 1', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_services_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_services_extra_content_settings_title1',
        ) 
    ));

    // Icon
    $wp_customize->add_setting(
        'scholarsgate_services_icon1',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_icon1',
        array(
            'label'           => sprintf( esc_html__( 'Icon', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_icon1' ,
            'type'            => 'text',
        )
    );

    // Heading
    $wp_customize->add_setting(
        'scholarsgate_services_box_heading1',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_heading1',
        array(
            'label'           => sprintf( esc_html__( 'Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_heading1' ,
            'type'            => 'text',
        )
    );

    // Content
    $wp_customize->add_setting(
        'scholarsgate_services_box_content1',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_content1',
        array(
            'label'           => sprintf( esc_html__( 'Content', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_content1' ,
            'type'            => 'text',
        )
    );

    // Button Url
    $wp_customize->add_setting(
        'scholarsgate_services_button_link1',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_button_link1',
        array(
            'label'           => sprintf( esc_html__( 'Button Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_button_link1' ,
            'type'            => 'url',
        )
    );

    // Title label 2
    $wp_customize->add_setting( 
        'scholarsgate_label_services_extra_content_settings_title2', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_services_extra_content_settings_title2', 
        array(
            'label'       => esc_html__( 'Services Box 2', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_services_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_services_extra_content_settings_title2',
        ) 
    ));

    // Icon
    $wp_customize->add_setting(
        'scholarsgate_services_icon2',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_icon2',
        array(
            'label'           => sprintf( esc_html__( 'Icon', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_icon2' ,
            'type'            => 'text',
        )
    );

    // Heading
    $wp_customize->add_setting(
        'scholarsgate_services_box_heading2',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_heading2',
        array(
            'label'           => sprintf( esc_html__( 'Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_heading2' ,
            'type'            => 'text',
        )
    );

    // Content
    $wp_customize->add_setting(
        'scholarsgate_services_box_content2',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_content2',
        array(
            'label'           => sprintf( esc_html__( 'Content', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_content2' ,
            'type'            => 'text',
        )
    );

    // Button Url
    $wp_customize->add_setting(
        'scholarsgate_services_button_link2',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_button_link2',
        array(
            'label'           => sprintf( esc_html__( 'Button Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_button_link2' ,
            'type'            => 'url',
        )
    );

    // Title label 3
    $wp_customize->add_setting( 
        'scholarsgate_label_services_extra_content_settings_title3', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_services_extra_content_settings_title3', 
        array(
            'label'       => esc_html__( 'Services Box 3', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_services_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_services_extra_content_settings_title3',
        ) 
    ));

    // Icon
    $wp_customize->add_setting(
        'scholarsgate_services_icon3',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_icon3',
        array(
            'label'           => sprintf( esc_html__( 'Icon', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_icon3' ,
            'type'            => 'text',
        )
    );

    // Heading
    $wp_customize->add_setting(
        'scholarsgate_services_box_heading3',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_heading3',
        array(
            'label'           => sprintf( esc_html__( 'Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_heading3' ,
            'type'            => 'text',
        )
    );

    // Content
    $wp_customize->add_setting(
        'scholarsgate_services_box_content3',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_box_content3',
        array(
            'label'           => sprintf( esc_html__( 'Content', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_box_content3' ,
            'type'            => 'text',
        )
    );

    // Button Url
    $wp_customize->add_setting(
        'scholarsgate_services_button_link3',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_services_button_link3',
        array(
            'label'           => sprintf( esc_html__( 'Button Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_services_settings',
            'settings'        => 'scholarsgate_services_button_link3' ,
            'type'            => 'url',
        )
    );

}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_home_services_register' );