<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_page_register' ) ) :
function scholarsgate_customizer_page_register( $wp_customize ) {
 
 	$wp_customize->add_section(
        'scholarsgate_page_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Page Settings', 'scholarsgate' )
        )
    );

    // Info label
     $wp_customize->add_setting( 
        'scholarsgate_label_page_title_hide_settings', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_page_title_hide_settings', 
        array(
            'label'       => esc_html__( 'Hide Page Title', 'scholarsgate' ),
            'section'     => 'scholarsgate_page_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_page_title_hide_settings',
        ) 
    ));

  

    // Hide page title section
    $wp_customize->add_setting(
        'scholarsgate_enable_page_title',
        array(
            'type' => 'theme_mod',
            'default'           => true,
            'sanitize_callback' => 'scholarsgate_sanitize_checkbox'
        )
    );

    $wp_customize->add_control(
        new scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_page_title', 
        array(
            'settings'      => 'scholarsgate_enable_page_title',
            'section'       => 'scholarsgate_page_settings',
            'type'          => 'scholarsgate-toggle',
            'label'         => esc_html__( 'Show Page Title Section:', 'scholarsgate' ),
            'description'   => '',           
        )
    ));

    // Info label
    $wp_customize->add_setting( 
        'scholarsgate_label_page_title_bg_settings', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_page_title_bg_settings', 
        array(
            'label'       => esc_html__( 'Page Title Background', 'scholarsgate' ),
            'section'     => 'scholarsgate_page_settings',
            'type'        => 'title',
            'settings'    => 'scholarsgate_label_page_title_bg_settings',
            'active_callback' => 'scholarsgate_page_title_enable',
        ) 
    ));

    // Background selection
    $wp_customize->add_setting(
        'scholarsgate_page_bg_radio',
        array(
            'type' => 'theme_mod',
            'default'           => 'color',
            'sanitize_callback' => 'scholarsgate_sanitize_select'
        )
    );

    $wp_customize->add_control(
    	new Scholarsgate_Text_Radio_Control( $wp_customize, 'scholarsgate_page_bg_radio',
        array(
            'settings'      => 'scholarsgate_page_bg_radio',
            'section'       => 'scholarsgate_page_settings',
            'type'          => 'radio',
            'label'         => esc_html__( 'Choose Page Title Background Color or Background Image:', 'scholarsgate' ),
            'description'   => esc_html__('This setting will change the background of the page title area.', 'scholarsgate'),
            'choices' => array(
                            'color' => esc_html__('Background Color','scholarsgate'),
                            'image' => esc_html__('Background Image','scholarsgate'),
                            ),
            'active_callback' => 'scholarsgate_page_title_enable',
        )
    ));

    // Background color
    $wp_customize->add_setting(
        'scholarsgate_page_bg_color',
        array(
            'type' => 'theme_mod',
            'default'           => '',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'scholarsgate_page_bg_color',
            array(
                'label'      => esc_html__( 'Select Background Color', 'scholarsgate' ),
                'description'   => esc_html__('This setting will add background color to the page title area if Background Color was selected above.', 'scholarsgate'),
                'section'    => 'scholarsgate_page_settings',
                'settings'   => 'scholarsgate_page_bg_color',
                'active_callback' => 'scholarsgate_page_title_color_enable',
            )
        )
    );

     // Background image
    $wp_customize->add_setting(
        'scholarsgate_page_bg_image',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'esc_url_raw'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'scholarsgate_page_bg_image',
            array(
                'label'       => esc_html__( 'Upload Background Image', 'scholarsgate' ),
                'description' => esc_html__('This setting will add a background image to the page title area if Background Image was selected above.', 'scholarsgate'),
                'section'     => 'scholarsgate_page_settings',
                'settings'    => 'scholarsgate_page_bg_image',
                'active_callback' => 'scholarsgate_page_title_image_enable',
            )
        )
    );
    
}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_page_register' );