<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_header_register' ) ) :
function scholarsgate_customizer_header_register( $wp_customize ) {

    $wp_customize->add_section(
        'scholarsgate_home_header_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Header Settings', 'scholarsgate' )
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'scholarsgate_label_header_settings_title', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_header_settings_title', 
        array(
            'label'       => esc_html__( 'Header Settings', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_header_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_header_settings_title',
        ) 
    ));

    $wp_customize->add_setting(
        'scholarsgate_header_calling_text',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_header_calling_text',
        array(
            'label'           => sprintf( esc_html__( 'Calling Text', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_header_settings',
            'settings'        => 'scholarsgate_header_calling_text' ,
            'type'            => 'text',
        )
    );

    $wp_customize->add_setting(
        'scholarsgate_header_calling_number',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_header_calling_number',
        array(
            'label'           => sprintf( esc_html__( 'Calling Number', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_header_settings',
            'settings'        => 'scholarsgate_header_calling_number' ,
            'type'            => 'text',
        )
    );

}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_header_register' );