<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */

if ( ! function_exists( 'scholarsgate_customizer_global_color_setting_register' ) ) :
function scholarsgate_customizer_global_color_setting_register( $wp_customize ) {
 
 	$wp_customize->add_section(
        'scholarsgate_global_color_settings',
        array (
            'priority'      => 40,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Global Color Settings', 'scholarsgate' )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_theme_color_settings', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_theme_color_settings', 
		array(
		    'label'       => esc_html__( 'Global Color Settings', 'scholarsgate' ),
		    'section'     => 'scholarsgate_global_color_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_theme_color_settings',
		) 
	));

	$wp_customize->add_setting('scholarsgate_global_color1',
        array(
            'type' => 'theme_mod',
            'default'           => '#0d8ae9',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'scholarsgate_global_color1',
            array(
                'label'      => esc_html__( 'Global Color1', 'scholarsgate' ),
                'section'    => 'scholarsgate_global_color_settings',
                'settings'   => 'scholarsgate_global_color1',
            )
        )
    ); 

    $wp_customize->add_setting('scholarsgate_global_color2',
        array(
            'type' => 'theme_mod',
            'default'           => '#000000',
            'sanitize_callback' => 'sanitize_hex_color'
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'scholarsgate_global_color2',
            array(
                'label'      => esc_html__( 'Global Color2', 'scholarsgate' ),
                'section'    => 'scholarsgate_global_color_settings',
                'settings'   => 'scholarsgate_global_color2',
            )
        )
    );   

}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_global_color_setting_register' );