<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */

if ( ! function_exists( 'scholarsgate_customizer_general_setting_register' ) ) :
function scholarsgate_customizer_general_setting_register( $wp_customize ) {
 
 	$wp_customize->add_section(
        'scholarsgate_general_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'General Settings', 'scholarsgate' )
        )
    );

 	// Add general Panel for preloader and scrolltop
    $wp_customize->add_panel(
        'scholarsgate_general_settings_panel',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'General Settings', 'scholarsgate' ),
        )
    );

    // Section preloader
    $wp_customize->add_section(
        'scholarsgate_prelodr_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Preloader', 'scholarsgate' ),
            'panel'         => 'scholarsgate_general_settings_panel',
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_preloader_settings', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_preloader_settings', 
		array(
		    'label'       => esc_html__( 'Preloader Settings', 'scholarsgate' ),
		    'section'     => 'scholarsgate_prelodr_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_preloader_settings',
		) 
	));

	// Add an option to enable the preloader
	$wp_customize->add_setting( 
		'scholarsgate_enable_preloader', 
		array(
		    'default'           => false,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_preloader', 
		array(
		    'label'       => esc_html__( 'Show Preloader', 'scholarsgate' ),
		    'section'     => 'scholarsgate_prelodr_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_preloader',
		) 
	));


    // Section Body Typography
    $wp_customize->add_section(
        'scholarsgate_scrol_settings',
        array(
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Scroll Top', 'scholarsgate' ),
            'panel'         => 'scholarsgate_general_settings_panel',
        )
    );


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_scroll_top_settings', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_scroll_top_settings', 
		array(
		    'label'       => esc_html__( 'Scroll Top Settings', 'scholarsgate' ),
		    'section'     => 'scholarsgate_scrol_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_scroll_top_settings',
		) 
	));

	// Add an option to enable the scrolltop
	$wp_customize->add_setting( 
		'scholarsgate_enable_scrolltop', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_scrolltop', 
		array(
		    'label'       => esc_html__( 'Show Scroll Top', 'scholarsgate' ),
		    'section'     => 'scholarsgate_scrol_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_scrolltop',
		) 
	));

	 $wp_customize->add_section(
        'scholarsgate_button_settings',
        array(
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Buttons', 'scholarsgate' ),
            'panel'         => 'scholarsgate_general_settings_panel',
        )
    );

	 // Border Radius Setting
	$wp_customize->add_setting(
	    'scholarsgate_button_border_radius',
	    array(
	        'default'           => '5px',
	        'sanitize_callback' => 'sanitize_text_field',
	        'transport'         => 'refresh',
	    )
	);

	$wp_customize->add_control(
	    'scholarsgate_button_border_radius',
	    array(
	        'type'     => 'text',
	        'label'    => esc_html__( 'Button Border Radius (e.g. 4px, 50%)', 'scholarsgate' ),
	        'section'  => 'scholarsgate_button_settings',
	    )
	);

	// Button Padding Setting
	$wp_customize->add_setting(
	    'scholarsgate_button_padding',
	    array(
	        'default'           => '8px 30px',
	        'sanitize_callback' => 'sanitize_text_field',
	        'transport'         => 'refresh',
	    )
	);

	$wp_customize->add_control(
	    'scholarsgate_button_padding',
	    array(
	        'type'     => 'text',
	        'label'    => esc_html__( 'Button Padding (e.g. 10px 20px)', 'scholarsgate' ),
	        'section'  => 'scholarsgate_button_settings',
	    )
	);


}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_general_setting_register' );