<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_footer_register' ) ) :
function scholarsgate_customizer_footer_register( $wp_customize ) {
 	
 	$wp_customize->add_section(
        'scholarsgate_footer_settings',
        array (
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Footer Settings', 'scholarsgate' )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_footer_settings_title', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_footer_settings_title', 
		array(
		    'label'       => esc_html__( 'Footer Settings', 'scholarsgate' ),
		    'section'     => 'scholarsgate_footer_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_footer_settings_title',
		) 
	));

	// Copyright text
    $wp_customize->add_setting(
        'scholarsgate_footer_copyright_text',
        array(
            'type' => 'theme_mod',
            'sanitize_callback' => 'scholarsgate_sanitize_textarea_field'
        )
    );

    $wp_customize->add_control(
        'scholarsgate_footer_copyright_text',
        array(
            'settings'      => 'scholarsgate_footer_copyright_text',
            'section'       => 'scholarsgate_footer_settings',
            'type'          => 'textarea',
            'label'         => esc_html__( 'Footer Copyright Text', 'scholarsgate' )
        )
    );
}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_footer_register' );