<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_blog_register' ) ) :
function scholarsgate_customizer_blog_register( $wp_customize ) {
	
	$wp_customize->add_panel(
        'scholarsgate_blog_settings_panel',
        array (
            'priority'      => 30,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Blog Settings', 'scholarsgate' ),
        )
    );

	// Section Posts
    $wp_customize->add_section(
        'scholarsgate_posts_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Posts', 'scholarsgate' ),
            'panel'          => 'scholarsgate_blog_settings_panel',
        )
    ); 


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_post_meta_show', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_post_meta_show', 
		array(
		    'label'       => esc_html__( 'Posts Meta', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_post_meta_show',
		) 
	));

	// Add an option to enable the date
	$wp_customize->add_setting( 
		'scholarsgate_enable_posts_meta_date', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_posts_meta_date', 
		array(
		    'label'       => esc_html__( 'Show Date', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_posts_meta_date',
		) 
	));

	// Add an option to enable the author
	$wp_customize->add_setting( 
		'scholarsgate_enable_posts_meta_author', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_posts_meta_author', 
		array(
		    'label'       => esc_html__( 'Show Author', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_posts_meta_author',
		) 
	));

	// Add an option to enable the comments
	$wp_customize->add_setting( 
		'scholarsgate_enable_posts_meta_comments', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_posts_meta_comments', 
		array(
		    'label'       => esc_html__( 'Show Comments', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_posts_meta_comments',
		) 
	));


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_sidebar_layout', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_sidebar_layout', 
		array(
		    'label'       => esc_html__( 'Sidebar', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_sidebar_layout',
		) 
	));

	// Sidebar layout
    $wp_customize->add_setting(
        'scholarsgate_blog_sidebar_layout',
        array(
            'default'			=> 'right',
            'type'				=> 'theme_mod',
            'capability'		=> 'edit_theme_options',
            'sanitize_callback'	=> 'scholarsgate_sanitize_select'
        )
    );
    $wp_customize->add_control(
        new Scholarsgate_Radio_Image_Control( $wp_customize,'scholarsgate_blog_sidebar_layout',
            array(
                'settings'		=> 'scholarsgate_blog_sidebar_layout',
                'section'		=> 'scholarsgate_posts_settings',
                'label'			=> esc_html__( 'Sidebar Layout', 'scholarsgate' ),
                'choices'		=> array(
                    'right'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cr.png',
                    'left' 	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cl.png',
                    'three_colm'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/c3.png',
                    'four_colm'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/c4.png',
                    'grid_layout'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/c5.png',
                    'grid_left_sidebar'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/c6.png',
                    'grid_right_sidebar'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/c7.png',
                    'no' 	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cn.png',
                )
            )
        )
    );


    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_blog_excerpt', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_blog_excerpt', 
		array(
		    'label'       => esc_html__( 'Post Excerpt', 'scholarsgate' ),
		    'section'     => 'scholarsgate_posts_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_blog_excerpt',
		) 
	));

	// add post excerpt textbox
    $wp_customize->add_setting(
        'scholarsgate_posts_excerpt_length',
        array(
            'type' => 'theme_mod',
            'default'           => 30,
            'sanitize_callback' => 'scholarsgate_sanitize_number',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_posts_excerpt_length',
        array(
            'settings'      => 'scholarsgate_posts_excerpt_length',
            'section'       => 'scholarsgate_posts_settings',
            'type'          => 'number',
            'label'         => esc_html__( 'Post Excerpt Length', 'scholarsgate' ),
        )
    );

    // add readmore textbox
    $wp_customize->add_setting(
        'scholarsgate_posts_readmore_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'READ MORE', 'scholarsgate' ),
            'sanitize_callback' => 'scholarsgate_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_posts_readmore_text',
        array(
            'settings'      => 'scholarsgate_posts_readmore_text',
            'section'       => 'scholarsgate_posts_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Read More Text', 'scholarsgate' ),
        )
    );

    //=========================================================================

	// Section Single Post
    $wp_customize->add_section(
        'scholarsgate_single_post_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Single Post', 'scholarsgate' ),
            'panel'          => 'scholarsgate_blog_settings_panel',
        )
    ); 


    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_single_post_category_show', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_single_post_category_show', 
		array(
		    'label'       => esc_html__( 'Post Category', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_single_post_category_show',
		) 
	));

	// Add an option to enable the category
	$wp_customize->add_setting( 
		'scholarsgate_enable_single_post_cat', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_single_post_cat', 
		array(
		    'label'       => esc_html__( 'Show Category', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_single_post_cat',
		) 
	));

	// add category textbox
    $wp_customize->add_setting(
        'scholarsgate_single_post_category_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Category:', 'scholarsgate' ),
            'sanitize_callback' => 'scholarsgate_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_single_post_category_text',
        array(
            'settings'      => 'scholarsgate_single_post_category_text',
            'section'       => 'scholarsgate_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Category Text', 'scholarsgate' ),
        )
    );


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_single_post_tag_show', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_single_post_tag_show', 
		array(
		    'label'       => esc_html__( 'Post Tags', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_single_post_tag_show',
		) 
	));

	// Add an option to enable the tags
	$wp_customize->add_setting( 
		'scholarsgate_enable_single_post_tags', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_single_post_tags', 
		array(
		    'label'       => esc_html__( 'Show Tags', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_single_post_tags',
		) 
	));

	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_single_pos_meta_show', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_single_pos_meta_show', 
		array(
		    'label'       => esc_html__( 'Post Meta', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_single_pos_meta_show',
		) 
	));

	// Add an option to enable the date
	$wp_customize->add_setting( 
		'scholarsgate_enable_single_post_meta_date', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_single_post_meta_date', 
		array(
		    'label'       => esc_html__( 'Show Date', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_single_post_meta_date',
		) 
	));

	// Add an option to enable the author
	$wp_customize->add_setting( 
		'scholarsgate_enable_single_post_meta_author', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_single_post_meta_author', 
		array(
		    'label'       => esc_html__( 'Show Author', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_single_post_meta_author',
		) 
	));

	// Add an option to enable the comments
	$wp_customize->add_setting( 
		'scholarsgate_enable_single_post_meta_comments', 
		array(
		    'default'           => true,
		    'type'              => 'theme_mod',
		    'sanitize_callback' => 'scholarsgate_sanitize_checkbox',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Toggle_Control( $wp_customize, 'scholarsgate_enable_single_post_meta_comments', 
		array(
		    'label'       => esc_html__( 'Show Comments', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-toggle',
		    'settings'    => 'scholarsgate_enable_single_post_meta_comments',
		) 
	));


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_single_pos_nav_show', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_single_pos_nav_show', 
		array(
		    'label'       => esc_html__( 'Post Navigation', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_single_pos_nav_show',
		) 
	));

    // add next article textbox
    $wp_customize->add_setting(
        'scholarsgate_single_post_next_article_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Next Article', 'scholarsgate' ),
            'sanitize_callback' => 'scholarsgate_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_single_post_next_article_text',
        array(
            'settings'      => 'scholarsgate_single_post_next_article_text',
            'section'       => 'scholarsgate_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Next Article Text', 'scholarsgate' ),
            'description'         => esc_html__( 'You can change the text displayed in the single post navigation', 'scholarsgate' ),
        )
    );

    // add previous article textbox
    $wp_customize->add_setting(
        'scholarsgate_single_post_previous_article_text',
        array(
            'type' => 'theme_mod',
            'default'           => esc_html__( 'Previous Article', 'scholarsgate' ),
            'sanitize_callback' => 'scholarsgate_sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_single_post_previous_article_text',
        array(
            'settings'      => 'scholarsgate_single_post_previous_article_text',
            'section'       => 'scholarsgate_single_post_settings',
            'type'          => 'textbox',
            'label'         => esc_html__( 'Previous Article Text', 'scholarsgate' ),
            'description'         => esc_html__( 'You can change the text displayed in the single post navigation', 'scholarsgate' ),
        )
    );


	// Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_single_sidebar_layout', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_single_sidebar_layout', 
		array(
		    'label'       => esc_html__( 'Sidebar', 'scholarsgate' ),
		    'section'     => 'scholarsgate_single_post_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_single_sidebar_layout',
		) 
	));

	// Sidebar layout
    $wp_customize->add_setting(
        'scholarsgate_blog_single_sidebar_layout',
        array(
            'default'			=> 'no',
            'type'				=> 'theme_mod',
            'capability'		=> 'edit_theme_options',
            'sanitize_callback'	=> 'scholarsgate_sanitize_select'
        )
    );
    $wp_customize->add_control(
        new Scholarsgate_Radio_Image_Control( $wp_customize,'scholarsgate_blog_single_sidebar_layout',
            array(
                'settings'		=> 'scholarsgate_blog_single_sidebar_layout',
                'section'		=> 'scholarsgate_single_post_settings',
                'label'			=> esc_html__( 'Sidebar Layout', 'scholarsgate' ),
                'choices'		=> array(
                    'right'	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cr.png',
                    'left' 	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cl.png',
                    'no' 	        => SCHOLARSGATE_DIR_URI . '/inc/customizer/assets/images/cn.png',
                )
            )
        )
    );

}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_blog_register' );