<?php
/**
 * Theme Customizer Controls
 *
 * @package ScholarsGate
 */


if ( ! function_exists( 'scholarsgate_customizer_home_banner_register' ) ) :
function scholarsgate_customizer_home_banner_register( $wp_customize ) {
 	
 	$wp_customize->add_section(
        'scholarsgate_home_banner_settings',
        array (
            'priority'      => 25,
            'capability'    => 'edit_theme_options',
            'title'         => esc_html__( 'Banner Settings', 'scholarsgate' )
        )
    );

    // Title label
	$wp_customize->add_setting( 
		'scholarsgate_label_banner_settings_title', 
		array(
		    'sanitize_callback' => 'scholarsgate_sanitize_title',
		) 
	);

	$wp_customize->add_control( 
		new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_banner_settings_title', 
		array(
		    'label'       => esc_html__( 'Banner Settings', 'scholarsgate' ),
		    'section'     => 'scholarsgate_home_banner_settings',
		    'type'        => 'scholarsgate-title',
		    'settings'    => 'scholarsgate_label_banner_settings_title',
		) 
	));

    // Button Image
    $wp_customize->add_setting(
        'scholarsgate_banner_image',
        array(
            'default'           => '',
            'sanitize_callback' => 'scholarsgate_sanitize_image',

        )
    );
    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize, 'scholarsgate_banner_image', 
            array(
                'label'           => sprintf( esc_html__( 'Banner Image', 'scholarsgate' ), ),
                'settings'  => 'scholarsgate_banner_image',
                'section'   => 'scholarsgate_home_banner_settings'
            ) 
        )
    );

    $wp_customize->add_setting(
        'scholarsgate_banner_small_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_banner_small_heading',
        array(
            'label'           => sprintf( esc_html__( 'Banner Small Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_banner_small_heading' ,
            'type'            => 'text',
        )
    );

    // Banner Heading
	$wp_customize->add_setting(
        'scholarsgate_banner_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_banner_heading',
        array(
            'label'           => sprintf( esc_html__( 'Banner Heading', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_banner_heading' ,
            'type'            => 'text',
        )
    );

    // Banner Text
    $wp_customize->add_setting(
        'scholarsgate_banner_text',
        array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_banner_text',
        array(
            'label'           => sprintf( esc_html__( 'Banner Text', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_banner_text' ,
            'type'            => 'text',
        )
    );

    // Button Link
    $wp_customize->add_setting(
        'scholarsgate_banner_button_link',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_banner_button_link',
        array(
            'label'           => sprintf( esc_html__( 'Banner Button Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_banner_button_link' ,
            'type'            => 'url',
        )
    );

    // Title label
    $wp_customize->add_setting( 
        'scholarsgate_label_social_meida_settings_title', 
        array(
            'sanitize_callback' => 'scholarsgate_sanitize_title',
        ) 
    );

    $wp_customize->add_control( 
        new Scholarsgate_Title_Info_Control( $wp_customize, 'scholarsgate_label_social_meida_settings_title', 
        array(
            'label'       => esc_html__( 'Social Media Links', 'scholarsgate' ),
            'section'     => 'scholarsgate_home_banner_settings',
            'type'        => 'scholarsgate-title',
            'settings'    => 'scholarsgate_label_social_meida_settings_title',
        ) 
    ));

    // Facebook Link
    $wp_customize->add_setting(
        'scholarsgate_social_media1_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_social_media1_heading',
        array(
            'label'           => sprintf( esc_html__( 'Facebook Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_social_media1_heading' ,
            'type'            => 'url',
        )
    );

    // Instagram Link
    $wp_customize->add_setting(
        'scholarsgate_social_media2_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_social_media2_heading',
        array(
            'label'           => sprintf( esc_html__( 'Instagram Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_social_media2_heading' ,
            'type'            => 'url',
        )
    );

    // Twitter Link
    $wp_customize->add_setting(
        'scholarsgate_social_media3_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_social_media3_heading',
        array(
            'label'           => sprintf( esc_html__( 'Twitter Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_social_media3_heading' ,
            'type'            => 'url',
        )
    );

    // Youtube Link
    $wp_customize->add_setting(
        'scholarsgate_social_media4_heading',
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_social_media4_heading',
        array(
            'label'           => sprintf( esc_html__( 'Youtube Link', 'scholarsgate' ), ),
            'section'         => 'scholarsgate_home_banner_settings',
            'settings'        => 'scholarsgate_social_media4_heading' ,
            'type'            => 'url',
        )
    );

    // Slider Content Alignment Setting
    $wp_customize->add_setting(
        'scholarsgate_slider_content_alignment',
        array(
            'default'           => 'left',
            'sanitize_callback' => 'scholarsgate_sanitize_select',
        )
    );

    $wp_customize->add_control(
        'scholarsgate_slider_content_alignment',
        array(
            'label'    => esc_html__( 'Slider Content Alignment', 'scholarsgate' ),
            'section'  => 'scholarsgate_home_banner_settings',
            'settings' => 'scholarsgate_slider_content_alignment',
            'type'     => 'select',
            'choices'  => array(
                'left'   => esc_html__( 'Left', 'scholarsgate' ),
                'center' => esc_html__( 'Center', 'scholarsgate' ),
                'right'  => esc_html__( 'Right', 'scholarsgate' ),
            ),
        )
    );   
}
endif;

add_action( 'customize_register', 'scholarsgate_customizer_home_banner_register' );