<?php

/**
 * Welcome Notice class.
 */
class Scholarsgate_Welcome_Notice {

	/**
	** Constructor.
	*/
	public function __construct() {
		// Render Notice
		add_action( 'admin_notices', [$this, 'scholarsgate_render_notice'] );

		// Enque AJAX Script
		add_action( 'admin_enqueue_scripts', [$this, 'scholarsgate_admin_enqueue_scripts'], 5 );

		// Dismiss
		add_action( 'admin_enqueue_scripts', [$this, 'scholarsgate_notice_enqueue_scripts'], 5 );
		add_action( 'wp_ajax_scholarsgate_dismissed_handler', [$this, 'scholarsgate_dismissed_handler'] );

		// Reset
		add_action( 'switch_theme', [$this, 'scholarsgate_reset_notices'] );
		add_action( 'after_switch_theme', [$this, 'scholarsgate_reset_notices'] );

	}

	/**
	** Render Notice
	*/
	public function scholarsgate_render_notice() {
	global $pagenow;

	$scholarsgate_screen = get_current_screen();

	if (
		$scholarsgate_screen &&
		$scholarsgate_screen->id !== 'appearance_page_scholarsgate-theme-info' &&
		$scholarsgate_screen->id !== 'appearance_page_scholarsgate-demo'
	) {
		$scholarsgate_transient_name = sprintf('%s_activation_notice', get_template());

		if ( ! get_transient($scholarsgate_transient_name) ) {
			?>
			<div class="scholarsgate-notice notice notice-info is-dismissible" data-notice="<?php echo esc_attr($scholarsgate_transient_name); ?>">
				<button type="button" class="notice-dismiss"></button>

				<?php $this->scholarsgate_render_notice_content(); ?>
			</div>
			<?php
		}
	}
}


	/**
	** Render Notice Content
	*/
	public function scholarsgate_render_notice_content() {
		$scholarsgate_action = 'install-activate';
		$scholarsgate_redirect_url = 'admin.php?page=scholarsgate-theme-info';
		$scholarsgate_demo_redirect_url = 'themes.php?page=scholarsgate-demo';
		$scholarsgate_screen = get_current_screen();

		?>
		<div class="notice-left-icon-box">
			<span class="dashicons dashicons-businessperson notc-theme-icon"></span>
		</div>
		<div class="welcome-message">
			<div class="notc-contnt">
				<h4><?php esc_html_e('Thank you for installing Legacy Themes!', 'scholarsgate'); ?></h4>
				<h1><?php esc_html_e('Welcome to Scholarsgate WordPress Theme!', 'scholarsgate'); ?></h1>
				<p><?php esc_html_e( 'Our WordPress themes are modern, minimalist, fully responsive, SEO-friendly, and packed with features—perfect for designers, bloggers, and creative professionals across various fields.', 'scholarsgate' );?>
				</p>			
				<div class="action-buttons">
					<a href="<?php echo esc_url(admin_url($scholarsgate_redirect_url)); ?>" class="button notice-btn button-hero" data-action="<?php echo esc_attr($scholarsgate_action); ?>">
						<span class="notc-btn-txt"><?php echo esc_html__( 'Get Started with Scholarsgate', 'scholarsgate' ); ?></span>
					</a>
					<a href="<?php echo esc_url(admin_url($scholarsgate_demo_redirect_url)); ?>" class="demo-btn btn" >
						<span class="demo-btn-txt"><?php echo esc_html__( 'Demo Import', 'scholarsgate' ); ?></span>
					</a>
					<a href="<?php echo esc_url(SCHOLARSGATE_THEME_BUNDLE_URL); ?>" target="_blank" class="bundle-btn btn" >
						<span class="demo-btn-txt"><?php echo esc_html__( 'Get All Themes', 'scholarsgate' ); ?></span>
					</a>
				</div>
			</div>			
		</div>
		<div class="notice-right-img-box">
			<img class="notc-right-img" src="<?php echo esc_url( get_template_directory_uri() . '/inc/activation-notice/img/notice-right.png' ); ?>" alt="<?php esc_attr_e( 'notice themes img', 'scholarsgate' ); ?>" />
		</div>

		<?php
	}

	/**
	** Reset Notice.
	*/
	public function scholarsgate_reset_notices() {
		delete_transient( sprintf( '%s_activation_notice', get_template() ) );
	}

	/**
	** Dismissed handler
	*/
	public function scholarsgate_dismissed_handler() {
		wp_verify_nonce( null );

		if ( isset( $_POST['notice'] ) ) {
			set_transient( sanitize_text_field( wp_unslash( $_POST['notice'] ) ), true, 0 );
		}
	}

	/**
	** Notice Enqunue Scripts
	*/
	public function scholarsgate_notice_enqueue_scripts( $page ) {
		
		wp_enqueue_script( 'jquery' );

		ob_start();
		?>
		<script>
			jQuery(function($) {
				$( document ).on( 'click', '.scholarsgate-notice .notice-dismiss', function () {
					jQuery.post( 'ajax_url', {
						action: 'scholarsgate_dismissed_handler',
						notice: $( this ).closest( '.scholarsgate-notice' ).data( 'notice' ),
					});
					$( '.scholarsgate-notice' ).hide();
				} );
			});
		</script>
		<?php
		$script = str_replace( 'ajax_url', admin_url( 'admin-ajax.php' ), ob_get_clean() );

		wp_add_inline_script( 'jquery', str_replace( ['<script>', '</script>'], '', $script ) );
	}

	/**
	** Register scripts and styles for welcome notice.
	*/
	public function scholarsgate_admin_enqueue_scripts( $page ) {
		// Enqueue Styles.
		wp_enqueue_style( 'scholarsgate-welcome-notic-css', get_template_directory_uri() . '/inc/activation-notice/css/notice-bar.css' );
	}

}

new Scholarsgate_Welcome_Notice();