<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package sangeet
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php endif; ?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'sangeet' ); ?></a>

	<div id="search-container" class="search-box-wrapper clear">
        <div class="search-box clear">
            <?php get_search_form(); ?>
        </div>
    </div> 
            
	<header id="masthead" class="site-header" role="banner">
        <?php 
            if ( get_header_image() && !('blank' == get_header_textcolor()) ) { 
                echo '<div class="site-branding header-background-image" style="background-image: url(' . get_header_image() . ')">'; 
            } else {
                echo '<div class="site-branding">';
            }
        ?>
			<div class="title-box">
                
                <?php $logoOutput = sangeet_get_custom_logo(); 
				if( ($logoOutput != '') ): ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo $logoOutput; ?></a>
                <?php endif; ?>  
                
                <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
    			<?php
                $description = get_bloginfo( 'description', 'display' );
                if ( $description || is_customize_preview() ) : ?>
                    <p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
                <?php
                endif; ?>
            </div>
            
            <?php sangeet_social_menu(); ?>
            
            <div class="search-toggle">
                <i class="fa fa-search"></i>
                <a href="#search-container" class="screen-reader-text"><?php _e( 'Search', 'sangeet' ); ?></a>
            </div>
            
		</div><!-- .site-branding -->

		<nav id="site-navigation" class="main-navigation" role="navigation">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><i class="fa fa-bars"></i></button>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
		</nav><!-- #site-navigation -->

	</header><!-- #masthead -->

	<div id="content" class="site-content">
