<?php
/**
 * Social media functions.
 *
 * @package ThinkUpThemes
 */

/* ----------------------------------------------------------------------------------
	PRE HEADER STYLE
---------------------------------------------------------------------------------- */
function thinkup_input_headerstylepre($classes) {

// Get theme options values.
$thinkup_header_styleswitchpre = thinkup_var ( 'thinkup_header_styleswitchpre' );

	// Check which header style should be output
	if ( empty( $thinkup_header_styleswitchpre ) or $thinkup_header_styleswitchpre == 'option1' ) {
		$classes[] = 'pre-header-style1';
	} else if ( $thinkup_header_styleswitchpre == 'option2' ) {
		$classes[] = 'pre-header-style2';
	}
	return $classes;
}
add_action( 'body_class', 'thinkup_input_headerstylepre');


/* ----------------------------------------------------------------------------------
	HEADER STYLE
---------------------------------------------------------------------------------- */
function thinkup_input_headerstyle($classes) {

	$classes[] = 'header-style1';

	return $classes;
}
add_action( 'body_class', 'thinkup_input_headerstyle');


/* ----------------------------------------------------------------------------------
	SEARCH - DISABLE SEARCH (PRE HEADER)
---------------------------------------------------------------------------------- */
function thinkup_input_preheadersearch() {

// Get theme options values.
$thinkup_header_searchswitchpre = thinkup_var ( 'thinkup_header_searchswitchpre' );

	if ( $thinkup_header_searchswitchpre == '1' ) {
		echo '<div id="pre-header-search">',
			 '<div class="fa fa-search"></div>',
		     get_search_form(),
		     '</div>';
	}
}

/* ----------------------------------------------------------------------------------
	SEARCH - DISABLE SEARCH (HEADER)
---------------------------------------------------------------------------------- */
function thinkup_input_headersearch() {

// Get theme options values.
$thinkup_header_searchswitch = thinkup_var ( 'thinkup_header_searchswitch' );

	if ( $thinkup_header_searchswitch == '1' ) {
		echo '<div id="header-search">',
			 '<a><div class="fa fa-search"></div></a>',
		     get_search_form(),
		     '</div>';
	}
}

/* ----------------------------------------------------------------------------------
	SOCIAL MEDIA - DISPLAY MESSAGE
---------------------------------------------------------------------------------- */

/* Message Settings */
function thinkup_input_socialmessage(){

// Get theme options values.
$thinkup_header_socialmessage  = thinkup_var ( 'thinkup_header_socialmessage' );
$thinkup_header_facebookswitch = thinkup_var ( 'thinkup_header_facebookswitch' );
$thinkup_header_twitterswitch  = thinkup_var ( 'thinkup_header_twitterswitch' );
$thinkup_header_googleswitch   = thinkup_var ( 'thinkup_header_googleswitch' );
$thinkup_header_linkedinswitch = thinkup_var ( 'thinkup_header_linkedinswitch' );
$thinkup_header_flickrswitch   = thinkup_var ( 'thinkup_header_flickrswitch' );
$thinkup_header_youtubeswitch  = thinkup_var ( 'thinkup_header_youtubeswitch' );
$thinkup_header_rssswitch      = thinkup_var ( 'thinkup_header_rssswitch' );

	if ( empty( $thinkup_header_facebookswitch )
		and empty( $thinkup_header_twitterswitch )
		and empty( $thinkup_header_googleswitch )
		and empty( $thinkup_header_linkedinswitch )
		and empty( $thinkup_header_flickrswitch )
		and empty( $thinkup_header_lastfmswitch )
		and empty( $thinkup_header_youtubeswitch )
		and empty( $thinkup_header_rssswitch ) ) {
		return '';
	} else if ( ! empty( $thinkup_header_socialmessage ) ) {
		return esc_html( $thinkup_header_socialmessage );
	} else if ( empty( $thinkup_header_socialmessage ) ) {
		return '';
	}
}


/* ----------------------------------------------------------------------------------
	SOCIAL MEDIA - CUSTOM ICONS
---------------------------------------------------------------------------------- */

/* Facebook - Custom Icon */
function thinkup_input_facebookicon(){

// Get theme options values.
$thinkup_header_facebookiconswitch = thinkup_var ( 'thinkup_header_facebookiconswitch' );
$thinkup_header_facebookcustomicon = thinkup_var ( 'thinkup_header_facebookcustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_facebookiconswitch == '1' and ! empty( $thinkup_header_facebookcustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.facebook a,';
		$output .= '#pre-header-social li.facebook a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_facebookcustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.facebook i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.facebook a,';
		$output .= '#post-footer-social li.facebook a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_facebookcustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.facebook i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* Twitter - Custom Icon */
function thinkup_input_twittericon(){

// Get theme options values.
$thinkup_header_twittericonswitch = thinkup_var ( 'thinkup_header_twittericonswitch' );
$thinkup_header_twittercustomicon = thinkup_var ( 'thinkup_header_twittercustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_twittericonswitch == '1' and ! empty( $thinkup_header_twittercustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.twitter a,';
		$output .= '#pre-header-social li.twitter a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_twittercustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.twitter i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.twitter a,';
		$output .= '#post-footer-social li.twitter a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_twittercustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.twitter i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* Google+ - Custom Icon */
function thinkup_input_googleicon(){

// Get theme options values.
$thinkup_header_googleiconswitch = thinkup_var ( 'thinkup_header_googleiconswitch' );
$thinkup_header_googlecustomicon = thinkup_var ( 'thinkup_header_googlecustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_googleiconswitch == '1' and ! empty( $thinkup_header_googlecustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.google-plus a,';
		$output .= '#pre-header-social li.google-plus a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_googlecustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.google-plus i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.google-plus a,';
		$output .= '#post-footer-social li.google-plus a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_googlecustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.google-plus i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* LinkedIn - Custom Icon */
function thinkup_input_linkedinicon(){

// Get theme options values.
$thinkup_header_linkediniconswitch = thinkup_var ( 'thinkup_header_linkediniconswitch' );
$thinkup_header_linkedincustomicon = thinkup_var ( 'thinkup_header_linkedincustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_linkediniconswitch == '1' and ! empty( $thinkup_header_linkedincustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.linkedin a,';
		$output .= '#pre-header-social li.linkedin a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_linkedincustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.linkedin i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.linkedin a,';
		$output .= '#post-footer-social li.linkedin a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_linkedincustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.linkedin i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* Flickr - Custom Icon */
function thinkup_input_flickricon(){

// Get theme options values.
$thinkup_header_flickriconswitch = thinkup_var ( 'thinkup_header_flickriconswitch' );
$thinkup_header_flickrcustomicon = thinkup_var ( 'thinkup_header_flickrcustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_flickriconswitch == '1' and ! empty( $thinkup_header_flickrcustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.flickr a,';
		$output .= '#pre-header-social li.flickr a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_flickrcustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.flickr i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.flickr a,';
		$output .= '#post-footer-social li.flickr a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_flickrcustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.flickr i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* YouTube - Custom Icon */
function thinkup_input_youtubeicon(){

// Get theme options values.
$thinkup_header_youtubeiconswitch = thinkup_var ( 'thinkup_header_youtubeiconswitch' );
$thinkup_header_youtubecustomicon = thinkup_var ( 'thinkup_header_youtubecustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_youtubeiconswitch == '1' and ! empty( $thinkup_header_youtubecustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.youtube a,';
		$output .= '#pre-header-social li.youtube a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_youtubecustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.youtube i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.youtube a,';
		$output .= '#post-footer-social li.youtube a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_youtubecustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.youtube i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* RSS - Custom Icon */
function thinkup_input_rssicon(){

// Get theme options values.
$thinkup_header_rssiconswitch = thinkup_var ( 'thinkup_header_rssiconswitch' );
$thinkup_header_rsscustomicon = thinkup_var ( 'thinkup_header_rsscustomicon', 'url' );

	$output = NULL;

	if ( $thinkup_header_rssiconswitch == '1' and ! empty( $thinkup_header_rsscustomicon ) ) {

		// Output for header social media
		$output .= '#pre-header-social li.rss a,';
		$output .= '#pre-header-social li.rss a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_rsscustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 25px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#pre-header-social li.rss i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

		// Output for footer social media
		$output .= '#post-footer-social li.rss a,';
		$output .= '#post-footer-social li.rss a:hover {';
		$output .= 'background: url("' . esc_url( $thinkup_header_rsscustomicon ) . '") no-repeat center !important;';
		$output .= 'background-size: 40px !important;';
		$output .= 'border: none !important;';
		$output .= '-webkit-border-radius: 0 !important;';
		$output .= '-moz-border-radius: 0 !important;';
		$output .= '-o-border-radius: 0 !important;';
		$output .= 'border-radius: 0 !important;';
		$output .= '}' . "\n";
		$output .= '#post-footer-social li.rss i {';
		$output .= 'display: none !important;';
		$output .= '}' . "\n";

	}
	return $output;
}

/* Input Custom Social Media Icons */
function thinkup_input_socialicon(){

	$output = NULL;

	$output .= thinkup_input_facebookicon();
	$output .= thinkup_input_twittericon();
	$output .= thinkup_input_googleicon();
	$output .= thinkup_input_linkedinicon();
	$output .= thinkup_input_flickricon();
	$output .= thinkup_input_youtubeicon();
	$output .= thinkup_input_rssicon();

	if ( ! empty( $output ) ) {
		echo    '<style type="text/css">' . "\n" . $output . '</style>';
	}
}
add_action( 'wp_head', 'thinkup_input_socialicon', 13 );


/* ----------------------------------------------------------------------------------
	SOCIAL MEDIA - OUTPUT SOCIAL MEDIA SELECTIONS (PRE HEADER)
---------------------------------------------------------------------------------- */

function thinkup_input_socialmediaheaderpre() {

// Get theme options values.
$thinkup_header_socialswitchpre = thinkup_var ( 'thinkup_header_socialswitchpre' );
$thinkup_header_socialmessage   = thinkup_var ( 'thinkup_header_socialmessage' );
$thinkup_header_facebookswitch  = thinkup_var ( 'thinkup_header_facebookswitch' );
$thinkup_header_facebooklink    = thinkup_var ( 'thinkup_header_facebooklink' );
$thinkup_header_twitterswitch   = thinkup_var ( 'thinkup_header_twitterswitch' );
$thinkup_header_twitterlink     = thinkup_var ( 'thinkup_header_twitterlink' );
$thinkup_header_googleswitch    = thinkup_var ( 'thinkup_header_googleswitch' );
$thinkup_header_googlelink      = thinkup_var ( 'thinkup_header_googlelink' );
$thinkup_header_linkedinswitch  = thinkup_var ( 'thinkup_header_linkedinswitch' );
$thinkup_header_linkedinlink    = thinkup_var ( 'thinkup_header_linkedinlink' );
$thinkup_header_flickrswitch    = thinkup_var ( 'thinkup_header_flickrswitch' );
$thinkup_header_flickrlink      = thinkup_var ( 'thinkup_header_flickrlink' );
$thinkup_header_youtubeswitch   = thinkup_var ( 'thinkup_header_youtubeswitch' );
$thinkup_header_youtubelink     = thinkup_var ( 'thinkup_header_youtubelink' );
$thinkup_header_rssswitch       = thinkup_var ( 'thinkup_header_rssswitch' );
$thinkup_header_rsslink         = thinkup_var ( 'thinkup_header_rsslink' );

// Reset count values used in foreach loop
$i = 0;
$j = 0;

	if ( $thinkup_header_socialswitchpre == '1' ) {

		// Assign social media link to an array
		$social_links = array(
			array( 'social' => __( 'Facebook', 'ryan' ),  'icon' => 'facebook',     'toggle' => $thinkup_header_facebookswitch,  'link' => $thinkup_header_facebooklink ),
			array( 'social' => __( 'Twitter', 'ryan' ),   'icon' => 'twitter',      'toggle' => $thinkup_header_twitterswitch,   'link' => $thinkup_header_twitterlink ),
			array( 'social' => __( 'Google+', 'ryan' ),   'icon' => 'google-plus',  'toggle' => $thinkup_header_googleswitch,    'link' => $thinkup_header_googlelink ),
			array( 'social' => __( 'LinkedIn', 'ryan' ),  'icon' => 'linkedin',     'toggle' => $thinkup_header_linkedinswitch,  'link' => $thinkup_header_linkedinlink ),
			array( 'social' => __( 'Flickr', 'ryan' ),    'icon' => 'flickr',       'toggle' => $thinkup_header_flickrswitch,    'link' => $thinkup_header_flickrlink ),
			array( 'social' => __( 'YouTube', 'ryan' ),   'icon' => 'youtube',      'toggle' => $thinkup_header_youtubeswitch,   'link' => $thinkup_header_youtubelink ),
			array( 'social' => __( 'RSS', 'ryan' ),       'icon' => 'rss',          'toggle' => $thinkup_header_rssswitch,       'link' => $thinkup_header_rsslink ),
		);


		// Output social media links if any link is set
		foreach( $social_links as $social ) {
			if ( ! empty( $social['link'] ) and $j == 0 ) {
				echo '<div id="pre-header-social"><ul>'; $j = 1;

				if ( ! empty ( $thinkup_header_socialmessage ) ) {
					echo '<li class="social message">' . thinkup_input_socialmessage() . '</li>';
				}
			}

			if ( ! empty( $social['link'] ) and $social['toggle'] == '1' ) {

			echo '<li class="social ' . esc_attr( $social['icon'] ) . '">',
				 '<a href="' . esc_url( $social['link'] ) . '" data-tip="bottom" data-original-title="' . esc_attr( $social['social'] ) . '" target="_blank">',
				 '<i class="fa fa-' . esc_attr( $social['icon'] ) . '"></i>',
				 '</a>',
				 '</li>';
			}
		}

		// Close list output of social media links if any link is set
		if ( $j !== 0 ) echo '</ul></div>';
	}
}


/* ----------------------------------------------------------------------------------
	SOCIAL MEDIA - OUTPUT SOCIAL MEDIA SELECTIONS (FOOTER)
---------------------------------------------------------------------------------- */

function thinkup_input_socialmediafooter() {

// Get theme options values.
$thinkup_header_socialswitchfooter = thinkup_var ( 'thinkup_header_socialswitchfooter' );
$thinkup_header_socialmessage      = thinkup_var ( 'thinkup_header_socialmessage' );
$thinkup_header_facebookswitch     = thinkup_var ( 'thinkup_header_facebookswitch' );
$thinkup_header_facebooklink       = thinkup_var ( 'thinkup_header_facebooklink' );
$thinkup_header_twitterswitch      = thinkup_var ( 'thinkup_header_twitterswitch' );
$thinkup_header_twitterlink        = thinkup_var ( 'thinkup_header_twitterlink' );
$thinkup_header_googleswitch       = thinkup_var ( 'thinkup_header_googleswitch' );
$thinkup_header_googlelink         = thinkup_var ( 'thinkup_header_googlelink' );
$thinkup_header_linkedinswitch     = thinkup_var ( 'thinkup_header_linkedinswitch' );
$thinkup_header_linkedinlink       = thinkup_var ( 'thinkup_header_linkedinlink' );
$thinkup_header_flickrswitch       = thinkup_var ( 'thinkup_header_flickrswitch' );
$thinkup_header_flickrlink         = thinkup_var ( 'thinkup_header_flickrlink' );
$thinkup_header_youtubeswitch      = thinkup_var ( 'thinkup_header_youtubeswitch' );
$thinkup_header_youtubelink        = thinkup_var ( 'thinkup_header_youtubelink' );
$thinkup_header_rssswitch          = thinkup_var ( 'thinkup_header_rssswitch' );
$thinkup_header_rsslink            = thinkup_var ( 'thinkup_header_rsslink' );

// Reset count values used in foreach loop
$i = 0;
$j = 0;

	if ( $thinkup_header_socialswitchfooter == '1' ) {

		// Assign social media link to an array
		$social_links = array(
			array( 'social' => __( 'Facebook', 'ryan' ),  'icon' => 'facebook',     'toggle' => $thinkup_header_facebookswitch,  'link' => $thinkup_header_facebooklink ),
			array( 'social' => __( 'Twitter', 'ryan' ),   'icon' => 'twitter',      'toggle' => $thinkup_header_twitterswitch,   'link' => $thinkup_header_twitterlink ),
			array( 'social' => __( 'Google+', 'ryan' ),   'icon' => 'google-plus',  'toggle' => $thinkup_header_googleswitch,    'link' => $thinkup_header_googlelink ),
			array( 'social' => __( 'LinkedIn', 'ryan' ),  'icon' => 'linkedin',     'toggle' => $thinkup_header_linkedinswitch,  'link' => $thinkup_header_linkedinlink ),
			array( 'social' => __( 'Flickr', 'ryan' ),    'icon' => 'flickr',       'toggle' => $thinkup_header_flickrswitch,    'link' => $thinkup_header_flickrlink ),
			array( 'social' => __( 'YouTube', 'ryan' ),   'icon' => 'youtube',      'toggle' => $thinkup_header_youtubeswitch,   'link' => $thinkup_header_youtubelink ),
			array( 'social' => __( 'RSS', 'ryan' ),       'icon' => 'rss',          'toggle' => $thinkup_header_rssswitch,       'link' => $thinkup_header_rsslink ),
		);


		// Output social media links if any link is set
		foreach( $social_links as $social ) {
			if ( ! empty( $social['link'] ) and $j == 0 ) {
				echo '<div id="post-footer-social"><ul>'; $j = 1;

				if ( ! empty ( $thinkup_header_socialmessage ) ) {
					echo '<li class="social message">' . thinkup_input_socialmessage() . '</li>';
				}
			}

			if ( ! empty( $social['link'] ) and $social['toggle'] == '1' ) {

			echo '<li class="social ' . esc_attr( $social['icon'] ) . '">',
				 '<a href="' . esc_url( $social['link'] ) . '" data-tip="top" data-original-title="' . esc_attr( $social['social'] ) . '" target="_blank">',
				 '<i class="fa fa-' . esc_attr( $social['icon'] ) . '"></i>',
				 '</a>',
				 '</li>';
			}
		}

		// Close list output of social media links if any link is set
		if ( $j !== 0 ) echo '</ul></div>';
	}
}