jQuery(document).ready(function ($) {
    // Attach click event to the dismiss button
    $(document).on('click', '.notice[data-notice="get-start"] button.notice-dismiss', function () {
        // Dismiss the notice via AJAX
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: {
                action: 'rt_education_school_dismissed_notice',
            },
            success: function () {
                // Remove the notice on success
                $('.notice[data-notice="example"]').remove();
            }
        });
    });
});

// WordClever – AI Content Writer plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const rt_education_school_button = document.getElementById('install-activate-button');

    if (!rt_education_school_button) return;

    rt_education_school_button.addEventListener('click', function (e) {
        e.preventDefault();

        const rt_education_school_redirectUrl = rt_education_school_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const rt_education_school_checkData = new FormData();
        rt_education_school_checkData.append('action', 'check_wordclever_activation');

        fetch(installWordcleverData.ajaxurl, {
            method: 'POST',
            body: rt_education_school_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = rt_education_school_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                rt_education_school_button.textContent = 'Installing & Activating...';

                const rt_education_school_installData = new FormData();
                rt_education_school_installData.append('action', 'install_and_activate_wordclever_plugin');
                rt_education_school_installData.append('_ajax_nonce', installWordcleverData.nonce);

                fetch(installWordcleverData.ajaxurl, {
                    method: 'POST',
                    body: rt_education_school_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = rt_education_school_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        rt_education_school_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    rt_education_school_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
