<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Royale_News
 */

if ( ! function_exists( 'royale_news_posted_on' ) ) {
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function royale_news_posted_on() {
		$show_date = royale_news_get_option( 'royale_news_show_date' );

		$show_author = royale_news_get_option( 'royale_news_show_author' );

		$show_comments_no = royale_news_get_option( 'royale_news_show_comments_no' );

		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		$posted_on = '';

		if ( true === $show_date || 1 === $show_date ) {
			?>
			<a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><?php echo $time_string; // phpcs:ignore. ?></a>
			<?php
		}

		$byline = '';

		if ( true === $show_author || 1 === $show_author ) {
			?>
			<span class="author vcard"><a class="url fn n" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><?php echo esc_html( get_the_author() ); ?></a>
			<?php
		}

		$comments_no = 0;

		$comment = '';

		if (
			( true === $show_comments_no || 1 === $show_comments_no ) &&
			comments_open()
		) {

			$comments_no = get_comments_number();

			$comment = '<span class="comments-link"><a href="' . esc_url( get_comments_link() ) . '">' . absint( $comments_no ) . '</span>';
		}

		echo '<span class="posted-on">' . $posted_on . '</span><span class="byline"> ' . $byline . '</span>' . $comment; // phpcs:ignore.

	}
}


if ( ! function_exists( 'royale_news_entry_footer' ) ) {
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function royale_news_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'royale-news' ) );
			if ( $categories_list ) {
				/* translators: 1: list of categories. */
				printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'royale-news' ) . '</span>', $categories_list ); // phpcs:ignore.
			}

			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'royale-news' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'royale-news' ) . '</span>', $tags_list ); // phpcs:ignore.
			}
		}

		if (
			! is_single() &&
			! post_password_required() &&
			(
				comments_open() ||
				get_comments_number()
			)
		) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'royale-news' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				)
			);
			echo '</span>';
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'royale-news' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
}
