<?php
/**
 * Template Name: Default Template With Post Slider
 *
 * @package royal
 */

get_header(); 
get_template_part('breadcrumb'); ?> 

<?php       $royal_slider_cat = get_theme_mod( 'slider_cat', '' );
			$royal_slider_count = get_theme_mod( 'slider_count', 5 );
			$royal_slider_posts = array(
				'cat' => absint($royal_slider_cat),
				'posts_per_page' => absint($royal_slider_count)
			);

				if ($royal_slider_cat) {

				$royal_query = new WP_Query($royal_slider_posts);
				if( $royal_query->have_posts()) : ?>
					<div class="flexslider">
						<ul class="slides">
					<?php while($royal_query->have_posts()) :
							$royal_query->the_post();
							if( has_post_thumbnail() ) : ?>
							    <li>
							    	<div class="flex-image">
							    		<?php the_post_thumbnail('full'); ?>
							    	</div>
							    	<div class="flex-caption">
							    		<?php the_content(); ?>
							    	</div>
							    </li>
							<?php endif; ?>
					<?php endwhile; ?>
						</ul>
					</div>
				<?php endif;
				} ?>
			<?php  
				$royal_query = null;
				wp_reset_postdata(); ?>
<?php //do_action('royal_single_page_flexslider_featured_image'); ?>

	<div id="content" class="site-content">
	<div class="container">

	<?php do_action('royal_two_sidebar_left'); ?>	

		<div id="primary" class="content-area <?php royal_layout_class();?> columns">
			<main id="main" class="site-main" role="main">

				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'content', 'page' ); ?>

					<?php
						// If comments are open or we have at least one comment, load up the comment template
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;
					?>

				<?php endwhile; // end of the loop. ?>

			</main><!-- #main -->
		</div><!-- #primary -->
	<?php do_action('royal_two_sidebar_right'); ?>	

<?php get_footer(); ?>
