<?php
$page_builder = __( 'Page Builder', 'royal' );  
$page_builder_details = __( 'Royal Pro supports Page Builder. All our shortcodes can be used as widgets too. You can drag and drop our widgets with page builder visual editor.', 'royal' );
$page_layout = __( 'Page Layout', 'royal' );
$page_layout_details = __( 'Royal Pro offers many different page layouts so you can quickly and easily create your pages with various layout without any hassle!', 'royal' );
$unlimited_sidebar = __( 'Unlimited Sidebar', 'royal' );
$unlimited_sidebar_details = __( 'Unlimited sidebars allows you to create multiple sidebars. Check out our demo site to see how different pages displays different sidebars!', 'royal' );
$shortcode_builder = __( 'Shortcode Builder', 'royal' );
$shortcode_builder_details = __( 'With our shortcode builder and lots of shortcodes, you can easily create nested shortcodes and build custom pages!', 'royal' );
$portfolio = __( 'Multi Portfolio', 'royal' );
$portfolio_details = __( '7 portfolio layouts with Isotope filtering, 3 blog layouts and multiple other alternate layouts for interior pages!', 'royal' );
$typography = __( 'Typography', 'royal' ); 
$typography_details = __( 'Royal Pro loves typography, you can choose from over 500+ Google Fonts and Standard Fonts to customize your site!', 'royal' );
$slider = __( 'Awesome Sliders', 'royal' );
$slider_details = __( 'Royal Pro includes two types of slider. You can use both Flex and Elastic sliders anywhere in your site.', 'royal' );
$woocommerce = __( 'Woo Commerce', 'royal' );          
$woocommerce_details = __( 'Royal Pro has full design/code integration for WooCommerce, your shop will look as good as the rest of your site!', 'royal' );
$custom_widget = __( 'Custom Widget', 'royal' );
$custom_widget_details = __( 'We offer many custom widgets that are stylized and ready for use. Simply drag &amp; drop into place to activate!', 'royal' );
$advanced_admin = __( 'Advanced Admin', 'royal' );
$advanced_admin_details = __( 'Advanced Redux Framework for theme options panel, you can customize any part of your site quickly and easily!', 'royal' );
$font_awesome = __( 'Font Awesome', 'royal' );
$font_awesome_details = __( 'Font Awesome icons are fully integrated into the theme. Use them anywhere in your site in 6 different sizes!', 'royal' );
$responsive_layout = __( 'Responsive Layout', 'royal' );
$responsive_layout_details = __( 'Royal Pro is fully responsive and can adapt to any screen size. Resize your browser window to view it!', 'royal' );
$testimonials = __( 'Testimonials', 'royal' );
$testimonials_details = __( 'With our testimonial post type, shortcode and widget, Displaying testimonials is a breeze.', 'royal' );
$social_media = __( 'Social Media', 'royal' );
$social_media_details = __( 'Want your users to stay in touch? No problem, royal Pro has Social Media icons all throughout the theme!', 'royal' );
$google_map = __( 'Google Map', 'royal' );
$google_map_details = __( 'Royal Pro includes Goole Map as shortcode and widget. So, you can use it anywhere in your site!', 'royal' );
$view_demo = __( 'View Demo', 'royal');
$upgrade_to_pro = __( 'Upgrade To Pro', 'royal' );  
$royal_ask_question = __( 'Ask a Question', 'royal' );
$royal_documentation = __( 'Documentation', 'royal' );                   

       
$royal_why_upgrade = <<< FEATURES
<p class="wrap-header">

<div class="one-third column clear">
    <div class="icon-wrap"><i class="fa  fa-5x fa-cog"></i></div>    
    <h3>$page_builder</h3>
    <p>$page_builder_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-th-large"></i></div>
    <h3>$page_layout</h3>
    <p>$page_layout_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-th"></i></div>
    <h3>$unlimited_sidebar</h3>
    <p>$unlimited_sidebar_details</p>
</div>
<div class="one-third column clear">
    <div class="icon-wrap"><i class="fa  fa-5x fa-code-fork"></i></div>
    <h3>$shortcode_builder</h3>
    <p>$shortcode_builder_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-camera"></i></div>
    <h3>$portfolio</h3>
    <p>$portfolio_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-font"></i></div>
    <h3>$typography</h3>
    <p>$typography_details</p>
</div>
<div class="one-third column clear">
    <div class="icon-wrap"><i class="fa  fa-5x fa-slideshare"></i></div>
    <h3>$slider</h3>
    <p>$slider_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-leaf"></i></div>
    <h3>$woocommerce</h3>
    <p>$woocommerce_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-tasks"></i></div>
    <h3>$custom_widget</h3>
    <p>$custom_widget_details</p>
</div>
<div class="one-third column clear">
    <div class="icon-wrap"><i class="fa  fa-5x fa-dashboard"></i></div>
    <h3>$advanced_admin</h3>
    <p>$advanced_admin_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
    <h3>$font_awesome</h3>
    <p>$font_awesome_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-arrows"></i></div>
    <h3>$responsive_layout</h3>
    <p>$responsive_layout_details</p>
</div>
<div class="one-third column clear">
    <div class="icon-wrap"><i class="fa  fa-5x fa-magic"></i></div>
    <h3>$testimonials</h3>
    <p>$testimonials_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-twitter"></i></div>
    <h3>$social_media</h3>
    <p>$social_media_details</p>
</div>
<div class="one-third column">
    <div class="icon-wrap"><i class="fa  fa-5x fa-map-marker"></i></div>
    <h3>$google_map</h3>
    <p>$google_map_details</p>
</div>
FEATURES;

function royal_theme_page() {
    $title = esc_html(__('Royal Theme','royal'));   
    add_theme_page( 
        esc_html(__( 'Upgrade To Royal Pro','royal')),
        $title.'<i class="fa fa-plane theme-icon"></i>', 
        'edit_theme_options',
        'royal_upgrade',
        'royal_display_upgrade' 
    );
}    

add_action('admin_menu','royal_theme_page');


function royal_display_upgrade() {
  $theme_data = wp_get_theme('royal'); 
    
    // Check for current viewing tab
    $tab = null;
    if ( isset( $_GET['tab'] ) ) {
        $tab = $_GET['tab'];
    } else {
        $tab = null;
    } 
     
    $pro_theme_url = 'https://www.webulousthemes.com/theme/royal-pro/';
    $doc_url  = 'https://www.webulousthemes.com/royal-free/';
    $support_url = 'https://www.webulousthemes.com/free-support-request/';   
    
    $current_action_link =  admin_url( 'themes.php?page=royal_upgrade&tab=pro_features' ); ?>
    <div class="royal-wrapper about-wrap">
        <h1><?php printf(esc_html__('Welcome to %1$s - Version %2$s', 'royal'), $theme_data->Name ,$theme_data->Version ); ?></h1><?php
        printf( __('<div class="about-text"> Royal is elegantly designed clean and responsive theme. It comes with customizer option panel and one primary widget area and 7 other widget areas. It uses skeleton grid for layout which keeps minimal css. Also, it uses SASS to generate stylesheet. Best suited for Corporate/Business and Blog sites, but can be used for any type of site. </div>', 'royal') ); ?>
        <a href="https://www.webulousthemes.com/" target="_blank" class="wp-badge welcome-logo"></a>   
        <p class="upgrade-btn"><a class="upgrade" href="<?php echo esc_url($pro_theme_url); ?>" target="_blank"><?php printf( __( 'Buy %1s Pro - $39', 'royal'), $theme_data->Name ); ?></a></p>

       <h2 class="nav-tab-wrapper">
            <a href="?page=royal_upgrade" class="nav-tab<?php echo is_null($tab) ? ' nav-tab-active' : null; ?>"><?php echo $theme_data->Name; ?></a>
            <a href="?page=royal_upgrade&tab=pro_features" class="nav-tab<?php echo $tab == 'pro_features' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'PRO Features', 'royal' );  ?></a>
            <a href="?page=royal_upgrade&tab=free_vs_pro" class="nav-tab<?php echo $tab == 'free_vs_pro' ? ' nav-tab-active' : null; ?>"><?php esc_html_e( 'Free VS PRO', 'royal' ); ?></a>
            <?php do_action( 'royal_admin_more_tabs' ); ?>
        </h2>      

        <?php if ( is_null( $tab ) ) { ?>
            <div class="theme_info info-tab-content">
                <div class="theme_info_column clearfix">
                    <div id="webulous-create-web">
	                	<a href="https://www.webulousthemes.com/checkout?edd_action=add_to_cart&download_id=23052" target="_blank">
							<div id="webulous-mode-wrap">
								<?php echo sprintf ('<h3>%1$s</h3><p>%2$s</p>',__('New to Creating a Website?','royal'),__('We will build you a complete website based on the theme you selected. We will populate content, change colors and do any look and feel customisation work you prefer.','royal') ); ?>
							</div>
							<div class="image-wrap">
								<?php echo sprintf ( '<img src="'. esc_url(get_template_directory_uri()) .'/images/api.png" alt="%1$s" />',__('Image','royal') ); ?>
							</div>
						</a>
					</div>
                    <div class="theme_info_left">
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Customizer', 'royal' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('%s supports the Theme Customizer for all theme settings. Click "Customize" to start customize your site.', 'royal'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo admin_url('customize.php'); ?>" class="button button-primary"><?php esc_html_e('Start Customize', 'royal'); ?></a>
                            </p>
                        </div>
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Theme Documentation', 'royal' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Need any help to setup and configure %s? Please have a look at our documentations instructions.', 'royal'), $theme_data->Name); ?></p>
                            <p>
                                <a href="<?php echo esc_url($doc_url); ?>" target="_blank" class="button button-secondary"><?php esc_html_e(' Documentation', 'royal'); ?></a>
                            </p>
                            <?php do_action( 'royal_dashboard_theme_links' ); ?>
                        </div>  
                        <div class="theme_link">
                            <h3><?php esc_html_e( 'Having Trouble, Need Support?', 'royal' ); ?></h3>
                            <p class="about"><?php printf(esc_html__('Support for %s WordPress theme is conducted through Webulous free support ticket system.', 'royal'), $theme_data->Name); ?></p>
                            <p>  
                                <a href="<?php echo esc_url($support_url); ?>" target="_blank" class="button button-secondary"><?php echo sprintf( esc_html('Create a support ticket', 'royal'), $theme_data->Name); ?></a>
                            </p>
                        </div> 
                       
                    </div>  

                    <div class="theme_info_right">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png" alt="Theme Screenshot" />
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if ( $tab == 'pro_features' ) { ?>
            <div class="pro-features-tab info-tab-content"><?php
                global $royal_why_upgrade; ?>
                <div class="wrap clearfix">
                    <?php echo $royal_why_upgrade; ?>
                </div>
            </div><?php   
        } ?>  

       <!-- Free VS PRO tab -->
        <?php if ( $tab == 'free_vs_pro' ) { ?>
            <div class="free-vs-pro-tab info-tab-content">
                <div id="free_pro">
                    <table class="free-pro-table">
                        <thead>
                            <tr>
                                <th></th>
                                <th><?php echo $theme_data->Name; ?> Lite</th>
                                <th><?php echo $theme_data->Name; ?> PRO</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><h3><?php _e('Flex Slider', 'royal'); ?></h3></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                <td><h3><?php _e('Support', 'royal'); ?></h3></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                <td><h3><?php _e('Responsive Design', 'royal'); ?></h3></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                <td><h3><?php _e('Custom Logo Option', 'royal'); ?></h3></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                 <td><h3><?php _e('Social Links', 'royal'); ?></h3></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                 <td><h3><?php _e('Unlimited color option', 'royal'); ?></h3></td>
                                 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                 <td><h3><?php _e('Elastic Slider', 'royal'); ?></h3></td>
                                 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                 <td><h3><?php _e('Page Builder Support', 'royal');?></h3></td>
                                 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                 <td><h3><?php _e('Page Templates', 'royal');?></h3></td>
                                 <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                 <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                <td><h3><?php _e('Google Map', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            <tr>
                                <td><h3><?php _e('Demo Content', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                <td><h3><?php _e('Polylang Compatible', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                <td><h3><?php _e('Multiple Portfolio Layouts', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                <td><h3><?php _e('Multiple Blog Layouts', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                <td><h3><?php _e('Page Animation', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                             <tr>
                                <td><h3><?php _e('Unlimited Sidebar', 'royal');?></h3></td>
                                <td class="only-pro"><span class="dashicons-before dashicons-no-alt"></span></td>
                                <td class="only-lite"><span class="dashicons-before dashicons-yes"></span></td>
                            </tr>
                            
                            <tr class="ti-about-page-text-center">
                                <td></td>
                                <td colspan="2"><a href="<?php echo esc_url($pro_theme_url); ?>" target="_blank" class="button button-primary button-hero"><?php printf( __( 'Buy %1s Pro - $39', 'royal'), $theme_data->Name ); ?></a></td>
                            </tr>
                        </tbody>
                    </table>                
                </div>
            </div><?php 
        } ?>

    </div><?php
}