<?php
/**
 * Created by PhpStorm.
 * User: venkat
 * Date: 2/5/16
 * Time: 4:32 PM        
 */

include_once( get_template_directory() . '/admin/kirki/kirki.php' );     
include_once( get_template_directory() . '/admin/kirki-helpers/class-royal-kirki.php' );
       
Royal_Kirki::add_config( 'royal', array(     
	'capability'    => 'edit_theme_options',                  
	'option_type'   => 'theme_mod',         
) );             
     
// Royal option start //   

//  site identity section // 

Royal_Kirki::add_section( 'title_tagline', array(
	'title'          => __( 'Site Identity','royal' ),
	'description'    => __( 'Site Header Options', 'royal'),       
	'priority'       => 8,         			
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'logo_title',
	'label'    => __( 'Enable Logo as Title', 'royal' ),
	'section'  => 'title_tagline',
	'type'     => 'switch',
	'priority' => 5,
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',   
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'apple_touch', 
	'label'    => __( 'Upload	 Apple Icon', 'royal' ),
	'section'  => 'title_tagline',    
	'type'     => 'upload',
	'priority' =>9,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'tagline',
	'label'    => __( 'Show site Tagline', 'royal' ), 
	'section'  => 'title_tagline',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'on',
) );

// home panel //

Royal_Kirki::add_panel( 'home_options', array(     
	'title'       => __( 'Home', 'royal' ),
	'description' => __( 'Home Page Related Options', 'royal' ),     
) );  

// home page type section

Royal_Kirki::add_section( 'home_type_section', array(
	'title'          => __( 'General Settings','royal' ),
	'description'    => __( 'Home Page options', 'royal'),
	'panel'          => 'home_options', // Not typically needed. 
) );


Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_home_default_content',
	'label'    => __( 'Enable Home Page Default Content', 'royal' ),
	'section'  => 'home_type_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'off',
	'tooltip' => __('Enable home page default content ( home page content )','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'home_sidebar',
	'label'    => __( 'Enable sidebar on the Home page', 'royal' ),
	'section'  => 'home_type_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
	'tooltip' => __('Disable by default. If you want to display the sidebars in your frontpage, turn this Enable.','royal'),
) );


// Slider section

Royal_Kirki::add_section( 'slider_section', array(
	'title'          => __( 'Slider Section','royal' ),
	'description'    => __( 'Home Page Slider Related Options', 'royal'),
	'panel'          => 'home_options', // Not typically needed. 
) );
Royal_Kirki::add_field( 'royal', array(  
	'settings' => 'enable_slider',
	'label'    => __( 'Enable Slider Post ( Section )', 'royal' ),
	'section'  => 'slider_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ),
	),
	'default'  => 'on',	
	'tooltip' => __('Enable Slider Post in home page','royal'),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'slider_cat',
	'label'    => __( 'Slider Posts category', 'royal' ),
	'section'  => 'slider_section',
	'type'     => 'select',
	'choices' => Kirki_Helper::get_terms( 'category' ),
	
    'tooltip' => __('Create post ( Goto Dashboard => Post => Add New ) and Post Featured Image ( Preferred size is 1200 x 450 pixels ) as taken as slider image and Post Content as taken as Flexcaption.','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'slider_count',
	'label'    => __( 'No. of Sliders', 'royal' ),
	'section'  => 'slider_section',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 999,
		'step' => 1,
	),
	'default'  => 2,
	'active_callback' => array(
		array(
			'setting'  => 'enable_slider',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Enter number of slides you want to display under your selected Category','royal'),
) );


     
// service section 

Royal_Kirki::add_section( 'service_section', array(
	'title'          => __( 'Service Section','royal' ),
	'description'    => __( 'Home Page - Service Related Options', 'royal'),
	'panel'          => 'home_options', // Not typically needed. 
) );

Royal_Kirki::add_field( 'royal', array( 
	'settings' => 'enable_service',
	'label'    => __( 'Enable Service Section', 'royal' ),
	'section'  => 'service_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	
	'default'  => 'on',
	'tooltip' => __('Enable service section in home page','royal'),
) ); 
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'service_count',
	'label'    => __( 'No. of Service Section', 'royal' ),
	'description' => __('Save the Settings, and Reload this page to Configure the service section','royal'),
	'section'  => 'service_section',
	'type'     => 'number',
	'choices' => array(
		'min' => 3,
		'max' => 99,
		'step' => 3,
	),
	'default'  => 3,
	'active_callback' => array(
		array(
			'setting'  => 'enable_service',
			'operator' => '==',
			'value'    => true,
		),
	
    ),
    'tooltip' => __('Enter number of service page you want to display','royal'),
) );

//if ( get_theme_mod('service_count') > 0 ) {
 $service = get_theme_mod('service_count',3);
 		for ( $i = 1 ; $i <= $service ; $i++ ) {
             //Create the settings Once, and Loop through it.
 			Royal_Kirki::add_field( 'royal', array(
				'settings' => 'service_'.$i,
				'label'    => sprintf(__( 'Service Section #%1$s', 'royal' ), $i ),
				'section'  => 'service_section',
				'type'     => 'dropdown-pages',	
				//'tooltip' => __('Create Page ( Goto Dashboard => Page =>Add New ) and Page Featured Image ( Preferred size is 100 x 100 pixels )','royal'),
				'active_callback' => array(
					array(
						'setting'  => 'enable_service',
						'operator' => '==',
						'value'    => true,
					),
					
                ), 
               // 'description' => __('Create Page ( Goto Dashboard => Page =>Add New ) and Page Featured Image ( Preferred size is 100 x 100 pixels )','royal'),
        
			) );
 		}
//}

// latest blog section 

Royal_Kirki::add_section( 'latest_blog_section', array(
	'title'          => __( 'Latest Blog Section','royal' ),
	'description'    => __( 'Home Page - Latest Blog Options', 'royal'),
	'panel'          => 'home_options', // Not typically needed. 
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_recent_post_service',
	'label'    => __( 'Enable Recent Post Section', 'royal' ),
	'section'  => 'latest_blog_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	 
	'default'  => 'on',
	'tooltip' => __('Enable recent post section in home page','royal'),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'recent_posts_count',
	'label'    => __( 'No. of Recent Posts', 'royal' ),
	'section'  => 'latest_blog_section',
	'type'     => 'number',
	'choices' => array(
		'min' => 3,
		'max' => 99,
		'step' => 3,
	),
	'default'  => 3,
	'active_callback' => array(
		array(
			'setting'  => 'enable_recent_post_service',
			'operator' => '==',
			'value'    => true,
		),
		
    ),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'recent_posts_exclude', 
	'label'    => __( 'Exclude the Posts from Home Page. Post IDs, separated by commas', 'royal' ),
	'section'  => 'latest_blog_section',
	'type'     => 'text',
	'active_callback' => array(
		array(
			'setting'  => 'enable_recent_post_service',
			'operator' => '==',
			'value'    => true,
		),
		
    ),
) );

// general panel   

Royal_Kirki::add_panel( 'general_panel', array(   
	'title'       => __( 'General Settings', 'royal' ),  
	'description' => __( 'general settings', 'royal' ),         
) );

//  Page title bar section // 

Royal_Kirki::add_section( 'header-pagetitle-bar', array(   
	'title'          => __( 'Page Title Bar','royal' ),
	'description'    => __( 'Page Title bar related options', 'royal'),
	'panel'          => 'general_panel', // Not typically needed.
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'page_titlebar',  
	'label'    => __( 'Page Title Bar', 'royal' ),
	'section'  => 'header-pagetitle-bar', 
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		1 => __('Show', 'royal'),
		2 => __('Hide','royal'),
    ),
    'default' => 1,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'page_titlebar_text',  
	'label'    => __( 'Page Title Bar Text', 'royal' ),
	'section'  => 'header-pagetitle-bar', 
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		1 => __( 'Show', 'royal' ),
		2 => __( 'Hide', 'royal' ), 
    ),
    'default' => 1,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'breadcrumb',  
	'label'    => __( 'Breadcrumb', 'royal' ),
	'section'  => 'header-pagetitle-bar', 
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ),
	),
	'default'  => 'on',
) ); 

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'breadcrumb_char',
	'label'    => __( 'Breadcrumb Character', 'royal' ),
	'section'  => 'header-pagetitle-bar',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		1 => __( ' >> ', 'royal' ),
		2 => __( ' / ', 'royal' ),
		3 => __( ' > ', 'royal' ),
	),
	'default'  => 1,
	'active_callback' => array(
		array(
			'setting'  => 'breadcrumb',
			'operator' => '==',
			'value'    => true,
		),
	),
	//'sanitize_callback' => 'allow_htmlentities'
) );

//  pagination section // 

Royal_Kirki::add_section( 'general-pagination', array(   
	'title'          => __( 'Pagination','royal' ),
	'description'    => __( 'Pagination related options', 'royal'),
	'panel'          => 'general_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'numeric_pagination',
	'label'    => __( 'Numeric Pagination', 'royal' ),   
	'section'  => 'general-pagination',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Numbered', 'royal' ),
		'off' => esc_attr__( 'Next/Previous', 'royal' )
	),
	'default'  => 'on',
) );

// skin color panel 

Royal_Kirki::add_panel( 'skin_color_panel', array(   
	'title'       => __( 'Skin Color', 'royal' ),  
	'description' => __( 'Color Settings', 'royal' ),         
) );

// Change Color Options

Royal_Kirki::add_section( 'primary_color_field', array(
	'title'          => __( 'Change Color Options','royal' ),
	'description'    => __( 'This will reflect in links, buttons,Navigation and many others. Choose a color to match your site.', 'royal'),
	'panel'          => 'skin_color_panel', // Not typically needed.
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_primary_color',
	'label'    => __( 'Enable Custom Primary color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'primary_color',
	'label'    => __( 'Primary color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '#830b7e',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array (
			'setting'  => 'enable_primary_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element'  => 'input[type="text"]:focus,
						   .widget_image-box-widget 
						   .image-box img,
							input[type="url"]:focus,
							input[type="search"]:focus,
							.home .post-wrapper .latest-post:hover h4,
							textarea:focus,ol.comment-list li.byuser article,.home.post-wrapper .latest-post:hover',

			'property' => 'border-color',
		),
		array(
			'element'  => '.main-navigation .current_page_item > a,.main-navigation .current-menu-item > a, .main-navigation .current_page_ancestor > a,.main-navigation ul.nav-menu > li a:hover,.current-menu-parent',
			'property' => 'background-color',
		),
		array(
			'element' =>'.widget_search .search-form input[type="submit"],input[type="button"],.widget_testimonial-widget h3:after, .our-services .textwidget:after, .flex-slider-title h3.widget-title:after,.icon-right .fa-stack,.widget_webulous-image-widget i,.ourservice .panel-grid-cell,
				.icon-left .fa-stack,.portfolioeffects .portfolio_link_icons a,.portfolioeffects .content-details h3:after,.widget_recent-posts-gallery-widget .recent-post .readmore a,.widget_recent-work-widget ul.flex-direction-nav a,.widget_recent-work-widget .portfolio3col .overlay_icon a,
				.widget_recent-work-widget .recent_work_overlay .icon-link,.widget.widget_skill-widget .skill-container .skill .skill-percentage,.widget.widget_ourteam-widget .team-avator,.header-wrap .social ul li a:hover,.footer-bottom,.widget_social-networks-widget ul li a,
				.share-box ul li a,.entry-header .header-entry-meta a.box-title,
				.entry-body .header-entry-meta a.box-title,.widget .ei-slider-thumbs li.ei-slider-element,.dropcap-circle,.wide-stats .circle-icon-box:hover .icon-wrapper,
				.dropcap-box,.dropcap-book,.cnt-form .wpcf7-form input[type="submit"],.dropcap-book,.sep:before,.circle-icon-box:hover .icon-wrapper,
				ul.ei-slider-thumbs li.ei-slider-element,.tabs-container ul.ui-tabs-nav li.ui-tabs-active a:before,
				.tabs-container ul.ui-tabs-nav li a:hover:before, .tabs-container ul.ui-tabs-nav li.ui-tabs-active a:before,
				input[type="reset"],.sidebar .dropcap-circle,.sidebar .icon-horizontal .fa-stack,
				.sidebar .icon-vertical .fa-stack,#secondary.sidebar .widget_testimonial-widget .testimonial-container .testimonials,
				.sidebar .dropcap-box,ol.webulous_page_navi li a,.ui-accordion .ui-accordion-header-active,.widget_calendar table th,
				input[type="submit"],.nav-wrap,.widget_recent-posts-gallery-widget .recent-post .entry-date a,.main-navigation ul ul li,.navigation a:hover,.widget.widget_ourteam-widget .team-content h4 span,
				.comment-navigation a:hover,#secondary.sidebar .callout-widget,.not-found-inner,.home .services,.ui-accordion .ui-accordion-header:hover,.widget_flexslider-widget .flexcarousel .flex-direction-nav a:hover,
				.woocommerce #content div.product .woocommerce-tabs ul.tabs li a:hover,
				.woocommerce div.product .woocommerce-tabs ul.tabs li a:hover,
				.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li a:hover,
				.woocommerce-page div.product .woocommerce-tabs ul.tabs li a:hover,
				.woocommerce #content div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce-page #content div.product .woocommerce-tabs ul.tabs li.active,
				.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active,.woocommerce #content nav.woocommerce-pagination ul li a:focus,
				.woocommerce #content nav.woocommerce-pagination ul li a:hover,
				.woocommerce #content nav.woocommerce-pagination ul li span.current,
				.woocommerce nav.woocommerce-pagination ul li a:focus,
				.woocommerce nav.woocommerce-pagination ul li a:hover,
				.woocommerce nav.woocommerce-pagination ul li span.current,
				.woocommerce-page #content nav.woocommerce-pagination ul li a:focus,
				.woocommerce-page #content nav.woocommerce-pagination ul li a:hover,
				.woocommerce-page #content nav.woocommerce-pagination ul li span.current,
				.woocommerce-page nav.woocommerce-pagination ul li a:focus,
				.woocommerce-page nav.woocommerce-pagination ul li a:hover,
				.woocommerce-page nav.woocommerce-pagination ul li span.current,.woocommerce a.remove',
			'property' =>'background-color'
		),
		array(
			'element'  => 'blockquote',
			'property' => 'border-left-color',
		),
		array(
			'element'  => '#filters ul.filter-options li a.selected,.widget.widget_ourteam-widget:hover .team-content h4,.ui-accordion h3:hover span.ui-icon.fa,
				.page-links,.entry-header .entry-title-meta span:hover,.entry-header .entry-title-meta a:hover,
				.entry-body .entry-title-meta a:hover,.single footer.entry-meta a:hover,.site-footer .widget_list-widget ul li i,
				.entry-body .entry-title-meta span:hover,.site-footer .callout-widget .call-btn a,.sidebar ul li a:hover,#secondary .widget_rss a,.widget_tag_cloud a,
				.footer-top ul li a:hover,.sidebar .icon-horizontal .icon-title,.sidebar .widget_list-widget ul li i,#secondary.sidebar .widget.widget_ourteam-widget .team-content p,
				#secondary.sidebar .widget.widget_ourteam-widget .team-content h4 span,#secondary .btn-white:hover,
				#secondary .widget_button-widget .btn.white:hover,
				.sidebar .icon-vertical .icon-title,.sidebar .dropcap,.content-area .widget_list-widget ul li i, .content-area .widget_list-widget ol li i,.widget_calendar table th a, .widget_calendar table td a,.site-footer .footer-top a:hover,
				.page-links a:hover,.home .post-wrapper .latest-post:hover h4,.portfolioeffects:hover .content-details p a:hover,
				.portfolioeffects:hover .content-details h3 a:hover,.widget_testimonial-widget ul.flex-direction-nav li a:hover,.widget_testimonial-widget ul li .client,
				.hentry.sticky h1.entry-title a:hover,.hentry.sticky a:hover,.hentry.post h1 a:hover,.comment-metadata a:hover,ol.comment-list .reply a:hover:before,.header-wrap .contact a:hover,a.more-link:hover,.site-main .comment-navigation a,.site-header #search .search-box:hover i,
				.order-total .amount,
                .cart-subtotal .amount,.woocommerce #content table.cart a.remove,
				.woocommerce table.cart a.remove,.header-wrap .contact ul li a:hover,
				.woocommerce-page #content table.cart a.remove,
				.woocommerce-page table.cart a.remove,.woocommerce .woocommerce-breadcrumb a:hover,
                .woocommerce-page .woocommerce-breadcrumb a:hover,.star-rating',


			'property' => 'color',
		),
		/*array(
			'element'  => 'th a,
							.left-sidebar #recentcomments a,
							#recentcomments a,
							.left-sidebar .widget_rss a,
							.widget_tag_cloud a:hover,.widget_magazine-featured-slider-widget .magazine-featured-slider-wrapper .flexslider .slides .flex-caption a:hover',
			'property' => 'color',
			'suffix' => '!important',
		),*/
		array(
			'element'  => '.woocommerce #content input.button:hover,
				.woocommerce #respond input#submit:hover,
				.woocommerce a.button:hover,
				.woocommerce button.button:hover,
				.woocommerce input.button:hover,
				.woocommerce-page #content input.button:hover,
				.woocommerce-page #respond input#submit:hover,
				.woocommerce-page a.button:hover,
				.woocommerce-page button.button:hover,
				.woocommerce-page input.button:hover ',
			'property' => 'background-color',
			'suffix' => '!important',
		),
		array(
			'element' => '
			
				.header-wrap .social ul li a:hover:after,.widget_flexslider-widget .flexcarousel .flex-direction-nav a:hover:after,ol.webulous_page_navi li a:after, ol.webulous_page_navi li.bpn-current:after, .widget.widget_ourteam-widget ul.team-social li a:after, .widget.widget_ourteam-widget .team-avator:after, .widget_recent-work-widget .recent_work_overlay .icon-link:after, .widget_recent-work-widget ul.flex-direction-nav a:after, .widget_recent-work-widget .portfolio3col .overlay_icon a:after, .portfolioeffects .portfolio_link_icons a:after, .widget_flexslider-widget .flexcarousel .flex-direction-nav a:after, .alert-message:after,
				.widget_button-widget .btn:after,.widget_testimonial-widget ul.flex-direction-nav li a:after, .entry-header .header-entry-meta:after,
				.entry-body .header-entry-meta:after,.widget_social-networks-widget ul li a:after,.icon-right .fa-stack:after,
				.icon-left .fa-stack:after,#filters ul.filter-options li a:hover::after, #filters ul.filter-options li a.selected::after,
				.share-box ul li a:after,#filters ul.filter-options li a:hover:after,
				#filters ul.filter-options li a.selected:after,.widget.widget_ourteam-widget .team-avator:after,.tabs-container ul.ui-tabs-nav li.ui-tabs-active a:after,
				.tabs-container ul.ui-tabs-nav li a:hover:after,.tabs-container ul.ui-tabs-nav li.ui-tabs-active a:after',
			'property' => 'border-top-color',
		),
		array(
			'element' => '.left-sidebar h4.widget-title, .footer-top h4.widget-title ',
			'property' => 'border-bottom-color',
		),
		array(
			'element' => 'blockquote ',
			'property' => 'border-right-color',
		),
		
	),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_nav_bar_color',
	'label'    => __( 'Enable Navigation Bar BG Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'nav_bar_color',
	'label'    => __( 'Navigation Bar BG Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '#242424',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_nav_bar_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element' => '.nav-wrap',
			'property' => 'background-color',
		),
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_nav_hover_color',
	'label'    => __( 'Enable Navigation Hover color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );    
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'nav_hover_color',
	'label'    => __( 'Navigation Hover Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '#5f015b',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_nav_hover_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element' => '.main-navigation .current_page_item > a,.main-navigation 	.current-menu-item > a, .main-navigation .current_page_ancestor > a,.main-navigation ul.nav-menu > li a:hover,.current-menu-parent',
			'property' => 'background-color',
		),
		/*array(
			'element' => '.main-navigation a:hover::after',
			'property' => 'border-left-color',
		),*/
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_dd_bg_color',
	'label'    => __( 'Enable Navigation Dropdown Background color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );    
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'dd_bg_color',
	'label'    => __( 'Navigation Dropdown Background Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_dd_bg_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element' => '.nav-wrap .main-navigation ul li .sub-menu li ',
			'property' => 'background-color',
		),
		/*array(
			'element' => '.main-navigation a:hover::after',
			'property' => 'border-left-color',
		),*/
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_dd_hover_color',
	'label'    => __( 'Enable Navigation Dropdown Hover color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );    
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'dd_hover_color',
	'label'    => __( 'Navigation Dropdown Hover Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_dd_hover_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element' => '.nav-wrap .main-navigation ul li .sub-menu li a:hover',
			'property' => 'background-color',
		),
		/*array(
			'element' => '.main-navigation a:hover::after',
			'property' => 'border-left-color',
		),*/
	),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_secondary_color',
	'label'    => __( 'Enable Custom Secondary color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'secondary_color',
	'label'    => __( 'Secondary Color', 'royal' ),
	'section'  => 'primary_color_field',
	'type'     => 'color',
	'default'  => '#000',
	'choices' => array(
		'alpha'  => true,
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_secondary_color',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output' => array(
		array(
			'element' => '
				input[type="text"],
				input[type="email"],.not-found-inner a:hover,.cnt-form .wpcf7-form input[type="text"],
				input[type="url"],.footer-bottom p a:hover,#secondary.sidebar .widget_testimonial-widget h3,
				input[type="password"],.entry-meta span a:hover,#filters ul.filter-options li a,.sidebar .widget_siteorigin-panels-postloop article h1 a:hover,
				.entry-footer span a:hover,.widget_testimonial-widget ul li .client strong,
				input[type="search"],.search-form input[type="search"],.widget_testimonial-widget .testimony p:before,
				textarea,input[type="text"]:focus,#secondary .widget_rss .widget-title .rsswidget,
				input[type="email"]:focus,.footer-top ul li a,.tabs-container ul.ui-tabs-nav li a,.site-footer .footer-bottom ul.menu li a:hover,.site-footer .footer-bottom ul.menu li.current_page_item a,.site-footer .widget_siteorigin-panels-postloop article h1 a:hover,
				input[type="url"]:focus,.byuser .comment-metadata a:hover,.widget_tag_cloud a:hover,
				.byuser .comment-content a:hover,.hentry.sticky code,.footer-bottom .widget_nav_menu a:hover,
				input[type="password"]:focus,.nav-links .meta-nav,.hentry.post h1 a,.widget.widget_ourteam-widget .team-content h4,
				.more-link .meta-nav,.screen-reader-text:hover, .screen-reader-text:active, .screen-reader-text:focus,
				input[type="search"]:focus,.header-wrap .social ul li a,.error-404.not-found,.tabs-container ul.ui-tabs-nav li.ui-tabs-active a,
				.tabs-container ul.ui-tabs-nav li a:hover,.site-footer .widget_social-networks-widget ul li a:hover,.royal-process.white-bg .textwidget h4,.tabs-container ul.ui-tabs-nav li.ui-tabs-active a,
				textarea:focus,a.more-link,.site-main .comment-navigation a:hover,#filters ul.filter-options li a:hover:before,
				#filters ul.filter-options li a.selected:before',
			'property' => 'color',
		),
		/*array(
			'element' => 'th a:hover,
							#recentcomments a:hover,
							.left-sidebar .widget_rss a:hover',
			'property' => 'color',
			'suffix' => '!important',
		),*/
		array(
			'element' => '
				
				button:hover,ul.ei-slider-thumbs li a,.widget .ei-slider-thumbs li a:hover,.widget_testimonial-widget ul.flex-direction-nav li a,
				.cnt-form .wpcf7-form input[type="submit"]:hover,.site-footer .widget_social-networks-widget ul li a,
				ul.ei-slider-thumbs li a:hover,.withtip:before,.circle-icon-box .more-button a,.error-404.not-found .page-header,
				.widget_recent-posts-gallery-widget .recent-post .readmore a:hover,.site-footer .footer-top,.widget_social-networks-widget ul li a:hover,
				.share-box ul li a:hover,.widget_flexslider-widget .flexcarousel .flex-direction-nav a,.widget_recent-work-widget .portfolio3col:hover .overlay_icon a:hover,
				input[type="button"]:hover,.page-links,.widget.widget_ourteam-widget ul.team-social li a:hover,
				input[type="reset"]:hover,.home .services h4,.page-slider .ei-slider-thumbs li a,.widget.widget_skill-widget .skill-container .skill .skill-percentage span,
				input[type="submit"]:hover,.widget_webulous-image-widget .image-widget-overlay:hover i:hover,.sidebar .widget.widget_flexslider-widget .flexcarousel .flex-direction-nav a.flex-prev,
				.sidebar .widget.widget_flexslider-widget .flexcarousel .flex-direction-nav a.flex-next,
				.portfolioeffects:hover .content-details .portfolio_link_icons a:hover,.comment-navigation .nav-previous,.widget_recent-posts-gallery-widget .recent-post .entry-date,
				.paging-navigation .nav-previous,.header-wrap,.icon-right:hover .fa-stack,.widget_testimonial-widget .flex-control-nav a.flex-active,.widget_image-box-widget a.more-button:hover,
				.icon-left:hover .fa-stack,.site-footer .widget.widget_flexslider-widget .flexcarousel .flex-direction-nav a.flex-prev,
				.site-footer .widget.widget_flexslider-widget .flexcarousel .flex-direction-nav a.flex-next,.entry-header .header-entry-meta,.entry-header .header-entry-meta a.box-title:hover,
				.entry-body .header-entry-meta a.box-title:hover,.panel-row-style-wide-black,
				.entry-body .header-entry-meta,.widget.widget_ourteam-widget:hover .team-content h4 span,.widget.widget_ourteam-widget:hover .team-avator,
				.post-navigation .nav-previous,.navigation a,.callout-widget a:hover,ol.webulous_page_navi li.bpn-current, .flexslider ol.flex-control-paging li a.flex-active,
				.comment-navigation a,.sidebar .widget.widget_skill-widget .skill-container .skill,#secondary.sidebar .callout-widget p.call-btn a:hover,ol.webulous_page_navi li a:hover,.widget_recent-work-widget .work:hover .recent_work_overlay .icon-link,
				.site-footer .scroll-to-top,.site-footer .scroll-to-top:hover',
			'property' => 'background-color',
		),
       /*array(
			'element' => '.flexslider .slides .flex-caption p a::after',
			'property' => 'border-left-color',
			'suffix' => '!important',
		),*/
        array(
			'element' => '
				ol.webulous_page_navi li a:hover:after,.icon-right:hover .fa-stack:after,.entry-header .header-entry-meta:after,
				.entry-body .header-entry-meta:after,.site-footer .widget_social-networks-widget ul li a:after,
				.withtip.top:after, .circle-icon-box .more-button a:after,.widget.widget_ourteam-widget ul.team-social li a:hover::after,
				.widget_testimonial-widget ul.flex-direction-nav li a:after,
				.widget_button-widget a.btn.black:after,.callout-widget a:hover:after,.widget_flexslider-widget .flexcarousel .flex-direction-nav a:after,.portfolioeffects:hover .content-details .portfolio_link_icons a:hover:after,.widget_recent-posts-gallery-widget .recent-post .entry-date:after,.widget_recent-work-widget .portfolio3col:hover .overlay_icon a:hover:after,.widget_recent-work-widget .work:hover .recent_work_overlay .icon-link:after,.widget.widget_ourteam-widget ul.team-social li a:hover:after,ol.webulous_page_navi li.bpn-current:after,.widget_social-networks-widget ul li a:hover:after,
				.share-box ul li a:hover:after,.widget.widget_ourteam-widget:hover .team-avator:after,.widget.widget_skill-widget .skill-container .skill .skill-percentage span:after',
			'property' => 'border-top-color',
		),
	),
) );
// typography panel //

Royal_Kirki::add_panel( 'typography', array( 
	'title'       => __( 'Typography', 'royal' ),
	'description' => __( 'Typography and Link Color Settings', 'royal' ),
) );
   
    Royal_Kirki::add_section( 'typography_section', array(
		'title'          => __( 'General Settings','royal' ),
		'description'    => __( 'General Settings', 'royal'),
		'panel'          => 'typography', // Not typically needed.
	) );
	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'custom_typography',
		'label'    => __( 'Enable Custom Typography', 'royal' ),
		'description' => __('Save the Settings, and Reload this page to Configure the typography section','royal'),
		'section'  => 'typography_section',
		'type'     => 'switch',
		'choices' => array(
			'on'  => esc_attr__( 'Enable', 'royal' ),
			'off' => esc_attr__( 'Disable', 'royal' )
		),
		'tooltip' => __('Turn on to customize typography and turn off for default typography','royal'),
		'default'  => 'off',
	) );

$typography_setting = get_theme_mod('custom_typography',false );
if( $typography_setting ) :

        $body_font = get_theme_mod('body_family','Roboto');		        
	    $body_color = get_theme_mod( 'body_color','#262626' );
		$body_size = get_theme_mod( 'body_size','16');
		$body_weight = get_theme_mod( 'body_weight','normal');
		$body_weight == 'bold' ? $body_weight = '700':  $body_weight = 'regular';
		

	Royal_Kirki::add_section( 'body_font', array(
		'title'          => __( 'Body Font','royal' ),
		'description'    => __( 'Specify the body font properties', 'royal'),
		'panel'          => 'typography', // Not typically needed.
	) ); 


	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'body',
		'label'    => __( 'Body Settings', 'royal' ),
		'section'  => 'body_font', 
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $body_font,
			'variant'        => $body_weight,
			'font-size'      => $body_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $body_color,
		),
		'output'      => array(
			array(
				'element' => 'body',
				//'suffix' => '!important',
			),
		),
	) );


	Royal_Kirki::add_section( 'heading_section', array(
		'title'          => __( 'Heading Font','royal' ),
		'description'    => __( 'Specify typography of h1,h2,h3,h4,h5,h6', 'royal'),
		'panel'          => 'typography', // Not typically needed.
	) );


	$h1_font = get_theme_mod('h1_family','Oswald');
	$h1_color = get_theme_mod( 'h1_color','#000' );
	$h1_size = get_theme_mod( 'h1_size','48');
	$h1_weight = get_theme_mod( 'h1_weight','bold');
	$h1_weight == 'bold' ? $h1_weight = '700' : $h1_weight = 'regular';

	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h1',
		'label'    => __( 'H1 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $h1_font,
			'variant'        => $h1_weight,
			'font-size'      => $h1_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h1_color,
		),
		'output'      => array(
			array(
				'element' => 'h1',
			),
		),
	) );

	$h2_font = get_theme_mod('h2_family','Oswald');
	$h2_color = get_theme_mod( 'h2_color','#000' );
	$h2_size = get_theme_mod( 'h2_size','36');
	$h2_weight = get_theme_mod( 'h2_weight','bold');
	$h2_weight == 'bold' ? $h2_weight = '700' : $h2_weight = 'regular';

	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h2',
		'label'    => __( 'H2 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $h2_font,
			'variant'        => $h2_weight,
			'font-size'      => $h2_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h2_color,
		),
		'output'      => array(
			array(
				'element' => 'h2',
			),
		),
	) );

	$h3_font = get_theme_mod('h3_family','Oswald');
	$h3_color = get_theme_mod( 'h3_color','#000' );
	$h3_size = get_theme_mod( 'h3_size','30');
	$h3_weight = get_theme_mod( 'h3_weight','bold');
	$h3_weight == 'bold' ? $h3_weight = '700' : $h3_weight = 'regular';

	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h3',
		'label'    => __( 'H3 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default' => array(
			'font-family'    => $h3_font,
			'variant'        => $h3_weight,
			'font-size'      => $h3_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h3_color,
		),
		'output'      => array(
			array(
				'element' => 'h3',
			),
		),
		
	) );

	$h4_font = get_theme_mod('h4_family','Oswald');
	$h4_color = get_theme_mod( 'h4_color','#000' );
	$h4_size = get_theme_mod( 'h4_size','24');
	$h4_weight = get_theme_mod( 'h4_weight','bold');
	$h4_weight == 'bold' ? $h4_weight = '700' : $h4_weight = 'regular';


	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h4',
		'label'    => __( 'H4 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $h4_font,
			'variant'        => $h4_weight,
			'font-size'      => $h4_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h4_color,
		),
		'output'      => array(
			array(
				'element' => 'h4',
			),
		),
		
	) );

    $h5_font = get_theme_mod('h5_family','Oswald');
	$h5_color = get_theme_mod( 'h5_color','#000' );
	$h5_size = get_theme_mod( 'h5_size','18');
	$h5_weight = get_theme_mod( 'h5_weight','bold');
	$h5_weight == 'bold' ? $h5_weight = '700' : $h5_weight = 'regular';


	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h5',
		'label'    => __( 'H5 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $h5_font,
			'variant'        => $h5_weight,
			'font-size'      => $h5_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h5_color,
		),
		'output'      => array(
			array(
				'element' => 'h5',
			),
		),
		
	) );

	$h6_font = get_theme_mod('h6_family','Oswald');
	$h6_color = get_theme_mod( 'h6_color','#000' );
	$h6_size = get_theme_mod( 'h6_size','16');
	$h6_weight = get_theme_mod( 'h6_weight','bold');
	$h6_weight == 'bold' ? $h6_weight = '700' : $h6_weight = 'regular';


	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'h6',
		'label'    => __( 'H6 Settings', 'royal' ),
		'section'  => 'heading_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => $h6_font,
			'variant'        => $h6_weight,
			'font-size'      => $h6_size.'px',
			'line-height'    => '1.4',
			'letter-spacing' => '0',
			'color'          => $h6_color,
		),
		'output'      => array(
			array(
				'element' => 'h6',
			),
		),
	) ); 

	// navigation font 
	Royal_Kirki::add_section( 'navigation_section', array(
		'title'          => __( 'Navigation Font','royal' ),
		'description'    => __( 'Specify Navigation font properties', 'royal'),
		'panel'          => 'typography', // Not typically needed.
	) );

	Royal_Kirki::add_field( 'royal', array(
		'settings' => 'navigation_font',
		'label'    => __( 'Navigation Font Settings', 'royal' ),
		'section'  => 'navigation_section',
		'type'     => 'typography',
		'default'     => array(
			'font-family'    => 'Oswald',
			'variant'        => '400',
			'font-size'      => '1.5rem',
			'line-height'    => '1.4',
			'letter-spacing' => '0.5',
			'color'          => '',
		),
		'output'      => array(
			array(
				'element' => '.main-navigation a',
			),
		),
	) );
endif; 


// header panel //

Royal_Kirki::add_panel( 'header_panel', array(     
	'title'       => __( 'Header', 'royal' ),
	'description' => __( 'Header Related Options', 'royal' ), 
) );  

Royal_Kirki::add_section( 'header', array(
	'title'          => __( 'General Header','royal' ),
	'description'    => __( 'Header options', 'royal'),
	'panel'          => 'header_panel', // Not typically needed.  
) );    

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_text_color',
	'label'    => __( 'Header Text Color', 'royal' ),
	'section'  => 'header',
	'type'     => 'color',
	'choices' => array(
		'alpha'  => true,
	),
	'default'  => '', 
	'output'   => array(
		array(
			'element'  => '.main-navigation a,.site-header .branding .site-branding .site-title a,.main-navigation ul ul a,.main-navigation a:hover, .main-navigation .current_page_item > a, .main-navigation .current-menu-item > a, .main-navigation .current-menu-parent > a, .main-navigation .current_page_ancestor > a, .main-navigation .current_page_parent > a',
			'property' => 'color',
		),
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_search',
	'label'    => __( 'Enable to Show Search box in Header', 'royal' ), 
	'section'  => 'header',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'on',
) );
/* Breaking News section  */
/*Royal_Kirki::add_section( 'header_breaking_news', array(
	'title'          => __( 'Breaking News','royal' ),
	'description'    => __( 'Breaking News', 'royal'),
	'panel'          => 'header_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_breaking_news',
	'label'    => __( 'Enable Breaking News', 'royal' ), 
	'section'  => 'header_breaking_news',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	
	'default'  => 'off',
) );*/
/* STICKY HEADER section */   

Royal_Kirki::add_section( 'stricky_header', array(
	'title'          => __( 'Sticky Menu','royal' ),
	'description'    => __( 'sticky header', 'royal'),
	'panel'          => 'header_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(    
	'settings' => 'sticky_header',
	'label'    => __( 'Enable Sticky Header', 'royal' ),
	'section'  => 'stricky_header',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'sticky_header_position',
	'label'    => __( 'Enable Sticky Header Position', 'royal' ),
	'section'  => 'stricky_header',
	'type'     => 'radio-buttonset',
	'choices' => array(
		'top'  => esc_attr__( 'Top', 'royal' ),
		'bottom' => esc_attr__( 'Bottom', 'royal' )
	),
	'active_callback'    => array(
		array(
			'setting'  => 'sticky_header',
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'top',
) );

Royal_Kirki::add_section( 'scroll_to_top', array(
	'title'          => __( 'Scroll to Top','royal' ),
	'description'    => __( 'Scroll to Top Button', 'royal'),
	'panel'          => 'header_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(    
	'settings' => 'scroll_to_top_button',
	'label'    => __( 'Enable Scroll to Top', 'royal' ),
	'section'  => 'scroll_to_top',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'on',
) );

/*
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_top_margin',
	'label'    => __( 'Header Top Margin', 'royal' ),
	'description' => __('Select the top margin of header in pixels','royal'),
	'section'  => 'header',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 1000,
		'step' => 1,
	),
	//'default'  => '213',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_bottom_margin',
	'label'    => __( 'Header Bottom Margin', 'royal' ),
	'description' => __('Select the bottom margin of header in pixels','royal'),
	'section'  => 'header',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 1000,
		'step' => 1,
	),
	//'default'  => '213',
) );*/

Royal_Kirki::add_section( 'header_image', array(
	'title'          => __( 'Header Background Image & Video','royal' ),
	'description'    => __( 'Custom Header Image & Video options', 'royal'),
	'panel'          => 'header_panel', // Not typically needed.  
) );

Royal_Kirki::add_field( 'royal', array(   
	'settings' => 'header_bg_size',
	'label'    => __( 'Header Background Size', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'radio-buttonset', 
    'choices' => array(
		'cover'  => esc_attr__( 'Cover', 'royal' ),
		'contain' => esc_attr__( 'Contain', 'royal' ),
		'auto'  => esc_attr__( 'Auto', 'royal' ),
		'inherit'  => esc_attr__( 'Inherit', 'royal' ),
	),
	'output'   => array(
		array(
			'element'  => '.header-image',
			'property' => 'background-size',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'header_image',
			'operator' => '!=',
			'value'    => 'remove-header',
		),
	),
	'default'  => 'cover',
	'tooltip' => __('Header Background Image Size','royal'),
) );

/*Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_height',
	'label'    => __( 'Header Background Image Height', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'number',
	'choices' => array(
		'min' => 100,
		'max' => 600,
		'step' => 1,
	),
	'default'  => '213',
) ); */
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_bg_repeat',
	'label'    => __( 'Header Background Repeat', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'no-repeat' => esc_attr__('No Repeat', 'royal'),
        'repeat' => esc_attr__('Repeat', 'royal'),
        'repeat-x' => esc_attr__('Repeat Horizontally','royal'),
        'repeat-y' => esc_attr__('Repeat Vertically','royal'),
	),
	'output'   => array(
		array(
			'element'  => '.header-image',
			'property' => 'background-repeat',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'header_image',
			'operator' => '!=',
			'value'    => 'remove-header',
		),
	),
	'default'  => 'repeat',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_bg_position', 
	'label'    => __( 'Header Background Position', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'center top' => esc_attr__('Center Top', 'royal'),
        'center center' => esc_attr__('Center Center', 'royal'),
        'center bottom' => esc_attr__('Center Bottom', 'royal'),
        'left top' => esc_attr__('Left Top', 'royal'),
        'left center' => esc_attr__('Left Center', 'royal'),
        'left bottom' => esc_attr__('Left Bottom', 'royal'),
        'right top' => esc_attr__('Right Top', 'royal'),
        'right center' => esc_attr__('Right Center', 'royal'),
        'right bottom' => esc_attr__('Right Bottom', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.header-image',
			'property' => 'background-position',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'header_image',
			'operator' => '!=',
			'value'    => 'remove-header',
		),
	),
	'default'  => 'center center',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_bg_attachment',
	'label'    => __( 'Header Background Attachment', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'scroll' => esc_attr__('Scroll', 'royal'),
        'fixed' => esc_attr__('Fixed', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.header-image',
			'property' => 'background-attachment',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'header_image',
			'operator' => '!=',
			'value'    => 'remove-header',
		),
	),
	'default'  => 'scroll',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_overlay',
	'label'    => __( 'Enable Header( Background ) Overlay', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
  
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'header_overlay_color',
	'label'    => __( 'Header Overlay ( Background )color', 'royal' ),
	'section'  => 'header_image',
	'type'     => 'color',
	'choices' => array(
		'alpha'  => true,
	),
	'default'  => '', 
	'output'   => array(
		array(
			'element'  => '.overlay-header',
			'property' => 'background-color',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'header_overlay',
			'operator' => '==',
			'value'    => true,
		),
	),
) );

/*
/* e-option start */
/*
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'custon_favicon',
	'label'    => __( 'Custom Favicon', 'royal' ),
	'section'  => 'header',
	'type'     => 'upload',
	'default'  => '',
) ); */
/* e-option start */ 
/* Blog page section */


/* Blog panel */

Royal_Kirki::add_panel( 'blog_panel', array(     
	'title'       => __( 'Blog', 'royal' ),
	'description' => __( 'Blog Related Options', 'royal' ),   

) ); 
Royal_Kirki::add_section( 'blog', array(
	'title'          => __( 'Blog Page','royal' ),
	'description'    => __( 'Blog Related Options', 'royal'),
	'panel'          => 'blog_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'blog-slider',
	'label'    => __( 'Enable to show the slider on blog page', 'royal' ),
	'section'  => 'blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'off',
	'tooltip' => __('To show the slider on posts page','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'blog_slider_cat',
	'label'    => __( 'Blog Slider Posts category', 'royal' ),
	'section'  => 'blog',
	'type'     => 'select',
	'choices' => Kirki_Helper::get_terms( 'category' ),
	'active_callback' => array(
		array(
			'setting'  => 'blog-slider',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Create post ( Goto Dashboard => Post => Add New ) and Post Featured Image ( Preferred size is 1200 x 450 pixels ) as taken as slider image and Post Content as taken as Flexcaption.','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'blog_slider_count',
	'label'    => __( 'No. of Sliders', 'royal' ),
	'section'  => 'blog',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 999,
		'step' => 1,
	),
	'default'  => 2,
	'active_callback' => array(
		array(
			'setting'  => 'blog-slider',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Enter number of slides you want to display under your selected Category','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'blog_layout',
	'label'    => __( 'Select Blog Page Layout you prefer', 'royal' ),
	'section'  => 'blog',
	'type'     => 'select',
	'multiple'  => 1,
	'choices' => array(
		1  => esc_attr__( 'Default ( One Column )', 'royal' ),
		2 => esc_attr__( 'Two Columns ', 'royal' ),
		3 => esc_attr__( 'Three Columns ( Without Sidebar ) ', 'royal' ),
		4 => esc_attr__( 'Two Columns With Masonry', 'royal' ),
		5 => esc_attr__( 'Three Columns With Masonry ( Without Sidebar ) ', 'royal' ),
	),
	'default'  => 1,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'featured_image',
	'label'    => __( 'Enable Featured Image', 'royal' ),
	'section'  => 'blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
	'tooltip' => __('Enable Featured Image for blog page','royal'),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'featured_image_size',
	'label'    => __( 'Choose the Featured Image Size for Blog Page', 'royal' ),
	'section'  => 'blog',
	'type'     => 'select',
	'multiple'  => 1,
	'choices' => array(
		1 => esc_attr__( 'Large Featured Image', 'royal' ),
		2 => esc_attr__( 'Small Featured Image', 'royal' ),
		3 => esc_attr__( 'Original Size', 'royal' ),
		4 => esc_attr__( 'Medium', 'royal' ),
		5 => esc_attr__( 'Large', 'royal' ), 
	),
	'default'  => 1,
	'active_callback' => array(
		array(
			'setting'  => 'featured_image',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Set large and medium image size: Goto Dashboard => Settings => Media', 'royal') ,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'more_text',
	'label'    => __( 'More Text', 'royal' ),
	'section'  => 'blog',
	'type'     => 'text',
	'description' => __('Text to display in case of text too long','royal'),
	'default' => __('Read More','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_single_post_top_meta',
	'label'    => __( 'Enable to display top post meta data', 'royal' ),
	'section'  => 'blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
	'tooltip' => __('Enable to Display Top Post Meta Details. This will reflect for blog page, single blog page, blog full width & blog large templates','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_post_top_meta',
	'label'    => __( 'Activate and Arrange the Order of Top Post Meta elements', 'royal' ),
	'section'  => 'blog',
	'type'     => 'sortable',
	'choices'     => array(
		1 => esc_attr__( 'date', 'royal' ),
		2 => esc_attr__( 'author', 'royal' ),
		3 => esc_attr__( 'comment', 'royal' ),
		4 => esc_attr__( 'category', 'royal' ),
		5 => esc_attr__( 'tags', 'royal' ),
		6 => esc_attr__( 'edit', 'royal' ),
	),
	'default'  => array(1, 2, 6),
	'active_callback' => array(
		array(
			'setting'  => 'enable_single_post_top_meta',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Click above eye icon in order to activate the field, This will reflect for blog page, single blog page, blog full width & blog large templates','royal'),

) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_single_post_bottom_meta',
	'label'    => __( 'Enable to display bottom post meta data', 'royal' ),
	'section'  => 'blog', 
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'tooltip' => __('Enable to Display Top Post Meta Details. This will reflect for blog page, single blog page, blog full width & blog large templates','royal'),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_post_bottom_meta',
	'label'    => __( 'Activate and arrange the Order of Bottom Post Meta elements', 'royal' ),
	'section'  => 'blog',
	'type'     => 'sortable',
	'choices'     => array(
		1 => esc_attr__( 'date', 'royal' ),
		2 => esc_attr__( 'author', 'royal' ),
		3 => esc_attr__( 'comment', 'royal' ),
		4 => esc_attr__( 'category', 'royal' ),
		5 => esc_attr__( 'tags', 'royal' ),
		6 => esc_attr__( 'edit', 'royal' ),
	),
	'default'  => array(),
	'active_callback' => array(
		array(
			'setting'  => 'enable_single_post_bottom_meta',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Click above eye icon in order to activate the field, This will reflect for blog page, single blog page, blog full width & blog large templates','royal'),
) );


/* Single Blog page section */

Royal_Kirki::add_section( 'single_blog', array(
	'title'          => __( 'Single Blog Page','royal' ),
	'description'    => __( 'Single Blog Page Related Options', 'royal'),
	'panel'          => 'blog_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_featured_image',
	'label'    => __( 'Enable Single Post Featured Image', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
	'tooltip' => __('Enable Featured Image for Single Post Page','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_featured_image_size',
	'label'    => __( 'Choose the featured image display type for Single Post Page', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'radio',
	'choices' => array(
		1  => esc_attr__( 'Large Featured Image', 'royal' ),
		2 => esc_attr__( 'Small Featured Image', 'royal' ),
		3 => esc_attr__( 'FullWidth Featured Image', 'royal' ),
	),
	'default'  => 1,
	'active_callback' => array(
		array(
			'setting'  => 'single_featured_image',
			'operator' => '==',
			'value'    => true,
		),
    ),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'author_bio_box',
	'label'    => __( 'Enable Author Bio Box below single post', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'social_sharing_box',
	'label'    => __( 'Enable Social Sharing options Box below single post', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'related_posts',
	'label'    => __( 'Show Related Posts', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'off',
	'tooltip' => __('Show the Related Post for Single Blog Page','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'related_posts_hierarchy',
	'label'    => __( 'Related Posts Must Be Shown As:', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'radio',
	'choices' => array(
		1  => esc_attr__( 'Related Posts By Tags', 'royal' ),
		2 => esc_attr__( 'Related Posts By Categories', 'royal' ) 
	),
	'default'  => 1,
	'active_callback' => array(
		array(
			'setting'  => 'related_posts',
			'operator' => '==',
			'value'    => true,
		),
    ),
    'tooltip' => __('Select the Hierarchy','royal'),

) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'comments',
	'label'    => __( ' Show Comments', 'royal' ),
	'section'  => 'single_blog',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
	'tooltip' => __('Show the Comments for Single Blog Page','royal'),
) );
/* FOOTER SECTION 
footer panel */

Royal_Kirki::add_panel( 'footer_panel', array(     
	'title'       => __( 'Footer', 'royal' ),
	'description' => __( 'Footer Related Options', 'royal' ),     
) );  

Royal_Kirki::add_section( 'footer', array(
	'title'          => __( 'Footer','royal' ),
	'description'    => __( 'Footer related options', 'royal'),
	'panel'          => 'footer_panel', // Not typically needed.
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_widgets',
	'label'    => __( 'Footer Widget Area', 'royal' ),
	'description' => sprintf(__('Select widgets, Goto <a href="%1$s"target="_blank"> Customizer </a> => Widgets','royal'),admin_url('customize.php') ),
	'section'  => 'footer',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
/* Choose No.Of Footer area */
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_widgets_count',
	'label'    => __( 'Choose No.of widget area you want in footer', 'royal' ),
	'section'  => 'footer',
	'type'     => 'radio-buttonset',
	'choices' => array(
		1  => esc_attr__( '1', 'royal' ),
		2  => esc_attr__( '2', 'royal' ),
		3  => esc_attr__( '3', 'royal' ),
		4  => esc_attr__( '4', 'royal' ),
	),
	'default'  => 4,
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'copyright',
	'label'    => __( 'Footer Copyright Text', 'royal' ),
	'section'  => 'footer',
	'type'     => 'textarea',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_top_margin',
	'label'    => __( 'Footer Top Margin', 'royal' ),
	'description' => __('Select the top margin of footer in pixels','royal'),
	'section'  => 'footer',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 1000,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.site-footer',
			'property' => 'margin-top',
			'units' => 'px',
		),
	),
	'default'  => 0,
) );

/* CUSTOM FOOTER BACKGROUND IMAGE 
footer background image section  */

Royal_Kirki::add_section( 'footer_image', array(
	'title'          => __( 'Footer Image','royal' ),
	'description'    => __( 'Custom Footer Image options', 'royal'),
	'panel'          => 'footer_panel', // Not typically needed.
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_bg_image',
	'label'    => __( 'Upload Footer Background Image', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'upload',
	'default'  => '',
	'output'   => array(
		array(
			'element'  => '.site-footer .footer-widgets,.footer-image',
			'property' => 'background-image',
			'suffix' => '!important'
		),
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_bg_size',
	'label'    => __( 'Footer Background Size', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'radio-buttonset',
    'choices' => array(
		'cover'  => esc_attr__( 'Cover', 'royal' ),
		'contain' => esc_attr__( 'Contain', 'royal' ),
		'auto'  => esc_attr__( 'Auto', 'royal' ),
		'inherit'  => esc_attr__( 'Inherit', 'royal' ),
	),
	'output'   => array(
		array(
			'element'  => '.footer-image,.site-footer .footer-widgets',
			'property' => 'background-size',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'footer_bg_image',
			'operator' => '=',
			'value'    => true,
		),
	),
	'default'  => 'cover',
	'tooltip' => __('Footer Background Image Size','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_bg_repeat',
	'label'    => __( 'Footer Background Repeat', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'no-repeat' => esc_attr__('No Repeat', 'royal'),
        'repeat' => esc_attr__('Repeat', 'royal'),
        'repeat-x' => esc_attr__('Repeat Horizontally','royal'),
        'repeat-y' => esc_attr__('Repeat Vertically','royal'),
	),
	'output'   => array(
		array(
			'element'  => '.footer-image,.site-footer .footer-widgets',
			'property' => 'background-repeat',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'footer_bg_image',
			'operator' => '=',
			'value'    => true,
		),
	),
	'default'  => 'repeat',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_bg_position',
	'label'    => __( 'Footer Background Position', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'center top' => esc_attr__('Center Top', 'royal'),
        'center center' => esc_attr__('Center Center', 'royal'),
        'center bottom' => esc_attr__('Center Bottom', 'royal'),
        'left top' => esc_attr__('Left Top', 'royal'),
        'left center' => esc_attr__('Left Center', 'royal'),
        'left bottom' => esc_attr__('Left Bottom', 'royal'),
        'right top' => esc_attr__('Right Top', 'royal'),
        'right center' => esc_attr__('Right Center', 'royal'),
        'right bottom' => esc_attr__('Right Bottom', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.footer-image,.site-footer .footer-widgets',
			'property' => 'background-position',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'footer_bg_image',
			'operator' => '=',
			'value'    => true,
		),
	),
	'default'  => 'center center',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_bg_attachment',
	'label'    => __( 'Footer Background Attachment', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'scroll' => esc_attr__('Scroll', 'royal'),
        'fixed' => esc_attr__('Fixed', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.footer-image,.site-footer .footer-widgets',
			'property' => 'background-attachment',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'footer_bg_image',
			'operator' => '=',
			'value'    => true,
		),
	),
	'default'  => 'scroll',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_overlay',
	'label'    => __( 'Enable Footer( Background ) Overlay', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' )
	),
	'default'  => 'off',
) );
  
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_overlay_color',
	'label'    => __( 'Footer Overlay ( Background )color', 'royal' ),
	'section'  => 'footer_image',
	'type'     => 'color',
	'choices' => array(
		'alpha'  => true,
	),
	'default'  => '#E5493A', 
	'active_callback' => array(
		array(
			'setting'  => 'footer_overlay',
			'operator' => '==',
			'value'    => true,
		),
	),
	'output'   => array(
		array(
			'element'  => '.overlay-footer',
			'property' => 'background-color',
		),
	),
) );


// single page section //

Royal_Kirki::add_section( 'single_page', array(
	'title'          => __( 'Single Page','royal' ),
	'description'    => __( 'Single Page Related Options', 'royal'),

) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_page_featured_image',
	'label'    => __( 'Enable Single Page Featured Image', 'royal' ),
	'section'  => 'single_page',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'single_page_featured_image_size',
	'label'    => __( 'Single Page Featured Image Size', 'royal' ),
	'section'  => 'single_page',
	'type'     => 'radio-buttonset',
	'choices' => array(
		1  => esc_attr__( 'Normal', 'royal' ),
		2 => esc_attr__( 'FullWidth', 'royal' ) 
	),
	'default'  => 1,
	'active_callback' => array(
		array(
			'setting'  => 'single_page_featured_image',
			'operator' => '==',
			'value'    => true,
		),
    ),
) );

// Layout section //

Royal_Kirki::add_section( 'layout', array(
	'title'          => __( 'Layout','royal' ),
	'description'    => __( 'Layout Related Options', 'royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'site-style',
	'label'    => __( 'Site Style', 'royal' ),
	'section'  => 'layout',
	'type'     => 'select',
	'choices' => array(
		'wide' =>  esc_attr__('Wide', 'royal'),
        'boxed' =>  esc_attr__('Boxed', 'royal'),
        'fluid' =>  esc_attr__('Fluid', 'royal'),  
        //'static' =>  esc_attr__('Static ( Non Responsive )', 'royal'),
    ),
	'default'  => 'wide',
	'tooltip' => __('Select the default site layout. Defaults to "Wide".','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'sidebar_position',
	'label'    => __( 'Main Layout', 'royal' ),
	'section'  => 'layout',
	'type'     => 'radio-image',   
	'description' => __('Select main content and sidebar allignment.','royal'),
	'choices' => array(
		'left' =>  get_template_directory_uri() . '/admin/kirki/assets/images/2cl.png',
        'right' =>  get_template_directory_uri() . '/admin/kirki/assets/images/2cr.png',
        'two-sidebar' =>  get_template_directory_uri() . '/admin/kirki/assets/images/3cm.png',  
        'two-sidebar-left' =>  get_template_directory_uri() . '/admin/kirki/assets/images/3cl.png',
        'two-sidebar-right' =>  get_template_directory_uri() . '/admin/kirki/assets/images/3cr.png',
        'fullwidth' =>  get_template_directory_uri() . '/admin/kirki/assets/images/1c.png',
        'no-sidebar' =>  get_template_directory_uri() . '/images/no-sidebar.png',
    ),
	'default'  => 'right',
	'tooltip' => __('This layout will be reflected in all pages unless unique layout template is set for specific page','royal'),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'body_top_margin',
	'label'    => __( 'Body Top Margin', 'royal' ),
	'description' => __('Select the top margin of body element in pixels','royal'),
	'section'  => 'layout',
	'type'     => 'number',
	'choices' => array(
		'min' => 0,
		'max' => 200,
		'step' => 1,
	),
	'active_callback'    => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
	),
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'margin-top',
			'units'    => 'px',
		),
	),
	'default'  => 0,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'body_bottom_margin',
	'label'    => __( 'Body Bottom Margin', 'royal' ),
	'description' => __('Select the bottom margin of body element in pixels','royal'),
	'section'  => 'layout',
	'type'     => 'number',
	'choices' => array(
		'min' => 0,
		'max' => 200,
		'step' => 1,
	),
	'active_callback'    => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
	),
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'margin-bottom',
			'units'    => 'px',
		),
	),
	'default'  => 0,
) );

/* LAYOUT SECTION  */
/*
Royal_Kirki::add_section( 'layout', array(
	'title'          => __( 'Layout','royal' ),   
	'description'    => __( 'Layout settings that affects overall site', 'royal'),
	'panel'          => 'royal_options', // Not typically needed.
) );



Royal_Kirki::add_field( 'royal', array(
	'settings' => 'primary_sidebar_width',
	'label'    => __( 'Primary Sidebar Width', 'royal' ),
	'section'  => 'layout',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'1' => __( 'One Column', 'royal' ),
		'2' => __( 'Two Column', 'royal' ),
		'3' => __( 'Three Column', 'royal' ),
		'4' => __( 'Four Column', 'royal' ),
		'5' => __( 'Five Column ', 'royal' ),
	),
	'default'  => '5',  
	'tooltip' => __('Select the width of the Primary Sidebar. Please note that the values represent grid columns. The total width of the page is 16 columns, so selecting 5 here will make the primary sidebar to have a width of approximately 1/3 ( 4/16 ) of the total page width.','royal'),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'secondary_sidebar_width',
	'label'    => __( 'Secondary Sidebar Width', 'royal' ),
	'section'  => 'layout',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'1' => __( 'One Column', 'royal' ),
		'2' => __( 'Two Column', 'royal' ),
		'3' => __( 'Three Column', 'royal' ),
		'4' => __( 'Four Column', 'royal' ),
		'5' => __( 'Five Column ', 'royal' ),
	),            
	'default'  => '5',  
	'tooltip' => __('Select the width of the Secondary Sidebar. Please note that the values represent grid columns. The total width of the page is 16 columns, so selecting 5 here will make the primary sidebar to have a width of approximately 1/3 ( 4/16 ) of the total page width.','royal'),
) ); 

*/

/* FOOTER SECTION 
footer panel */

Royal_Kirki::add_panel( 'footer_panel', array(     
	'title'       => __( 'Footer', 'royal' ),
	'description' => __( 'Footer Related Options', 'royal' ),     
) );  

Royal_Kirki::add_section( 'footer', array(
	'title'          => __( 'Footer','royal' ),
	'description'    => __( 'Footer related options', 'royal'),
	'panel'          => 'footer_panel', // Not typically needed.
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_widgets',
	'label'    => __( 'Footer Widget Area', 'royal' ),
	'description' => sprintf(__('Select widgets, Goto <a href="%1$s"target="_blank"> Customizer </a> => Widgets','royal'),admin_url('customize.php') ),
	'section'  => 'footer',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
/* Choose No.Of Footer area */
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_widgets_count',
	'label'    => __( 'Choose No.of widget area you want in footer', 'royal' ),
	'section'  => 'footer',
	'type'     => 'radio-buttonset',
	'choices' => array(
		1  => esc_attr__( '1', 'royal' ),
		2  => esc_attr__( '2', 'royal' ),
		3  => esc_attr__( '3', 'royal' ),
		4  => esc_attr__( '4', 'royal' ),
	),
	'default'  => 4,
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'copyright',
	'label'    => __( 'Footer Copyright Text', 'royal' ),
	'section'  => 'footer',
	'type'     => 'textarea',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'footer_top_margin',
	'label'    => __( 'Footer Top Margin', 'royal' ),
	'description' => __('Select the top margin of footer in pixels','royal'),
	'section'  => 'footer',
	'type'     => 'number',
	'choices' => array(
		'min' => 1,
		'max' => 1000,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.site-footer',
			'property' => 'margin-top',
			'units' => 'px',
		),
	),
	'default'  => 0,
) );


//  social network panel //

Royal_Kirki::add_panel( 'social_panel', array(
	'title'        =>__( 'Social Networks', 'royal'),
	'description'  =>__( 'social networks', 'royal'),
	'priority'  =>11,	
));

//social sharing box section

Royal_Kirki::add_section( 'social_sharing_box', array(
	'title'          =>__( 'Social Sharing Box', 'royal'),
	'description'   =>__('Social Sharing box related options', 'royal'),
	'panel'			 =>'social_panel',
));

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'facebook_sb',
	'label'    => __( 'Enable facebook sharing option below single post', 'royal' ),
	'section'  => 'social_sharing_box',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'twitter_sb',
	'label'    => __( 'Enable twitter sharing option below single post', 'royal' ),
	'section'  => 'social_sharing_box',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'linkedin_sb',
	'label'    => __( 'Enable linkedin sharing option below single post', 'royal' ),
	'section'  => 'social_sharing_box',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'google-plus_sb',
	'label'    => __( 'Enable googleplus sharing option below single post', 'royal' ),
	'section'  => 'social_sharing_box',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'email_sb',
	'label'    => __( 'Enable email sharing option below single post', 'royal' ),
	'section'  => 'social_sharing_box',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'on',
) );
//  slider panel //

Royal_Kirki::add_panel( 'slider_panel', array(   
	'title'       => __( 'Slider Settings', 'royal' ),  
	'description' => __( 'Flex slider related options', 'royal' ), 
	'priority'    => 11,    
) );

//  flexslider section  //

Royal_Kirki::add_section( 'flex_caption_section', array(
	'title'          => __( 'Flexcaption Settings','royal' ),
	'description'    => __( 'Flexcaption Related Options', 'royal'),
	'panel'          => 'slider_panel', // Not typically needed.
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'enable_flex_caption_edit',
	'label'    => __( 'Enable Custom Flexcaption Settings', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'switch',
	'choices' => array(
		'on'  => esc_attr__( 'Enable', 'royal' ),
		'off' => esc_attr__( 'Disable', 'royal' ) 
	),
	'default'  => 'off',
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_bg',
	'label'    => __( 'Select Flexcaption Background Color', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'color',
	'default'  => 'rgba(255, 255, 255, 0.5)',
	'choices' => array(
		'alpha'  => true,
	),
	'output'   => array(
		array(
			'element'  => '.flexslider .flex-caption h1, .flexslider .flex-caption h2,
							 .flexslider .flex-caption h3, .flexslider .flex-caption h4, .flexslider .flex-caption h5, 
							 .flexslider .flex-caption h6, 
							.flexslider .flex-caption p, .flexslider .flex-caption li',
			'property' => 'background-color',
			'suffix' => '!important',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_align',
	'label'    => __( 'Select Flexcaption Alignment', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'select',
	'default'  => 'left',
	'choices' => array(
		'left' => esc_attr__( 'Left', 'royal' ),
		'right' => esc_attr__( 'Right', 'royal' ),
		'center' => esc_attr__( 'Center', 'royal' ),
		'justify' => esc_attr__( 'Justify', 'royal' ),
	),
	'output'   => array(
		array(
			'element'  => '.home .flexslider .slides .flex-caption p,.home .flexslider .slides .flex-caption h1, .home .flexslider .slides .flex-caption h2, .home .flexslider .slides .flex-caption h3, .home .flexslider .slides .flex-caption h4, .home .flexslider .slides .flex-caption h5, .home .flexslider .slides .flex-caption h6,.flexslider .slides .flex-caption,.flexslider .slides .flex-caption h1, .flexslider .slides .flex-caption h2, .flexslider .slides .flex-caption h3, .flexslider .slides .flex-caption h4, .flexslider .slides .flex-caption h5, .flexslider .slides .flex-caption h6,.flexslider .slides .flex-caption p,.flexslider .slides .flex-caption',
			'property' => 'text-align',
			//'suffix' => '!important',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) );
 Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_bg_position',
	'label'    => __( 'Select Flexcaption Background Horizontal Position', 'royal' ),
	'tooltip' => __('Select how far from right, Default value Right = 0 ( in % )','royal'),
	'section'  => 'flex_caption_section',
	'type'     => 'number',
	'default'  => '0',
	'choices'     => array(
		'min'  => 0,
		'max'  => 100,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.flexslider .slides .flex-caption,.home .flexslider .slides .flex-caption',
			'property' => 'right',
			'suffix' => '%',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
		
) ); 
 Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_bg_vertical_position',
	'label'    => __( 'Select Flexcaption Background Vertical Position', 'royal' ),
	'tooltip' => __('Select how far from top, Default value top= 5 ( in % )','royal'),
	'section'  => 'flex_caption_section',
	'type'     => 'number',
	'default'  => '5',
	'choices'     => array(
		'min'  => 0,
		'max'  => 100,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.flexslider .slides .flex-caption,.home .flexslider .slides .flex-caption',
			'property' => 'top',
			'suffix' => '%',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) ); 
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_bg_width',
	'label'    => __( 'Select Flexcaption Background Width', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'number',
	'default'  => '50',
	'tooltip' => __('Select Flexcaption Background Width , Default width value 50','royal'),
	'choices'     => array(
		'min'  => 0,
		'max'  => 100,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.flexslider .slides .flex-caption,.home .flexslider .slides .flex-caption',
			'property' => 'width',
			'suffix' => '%',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) ); 
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_responsive_bg_width',
	'label'    => __( 'Select Responsive Flexcaption Background Width', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'number',
	'default'  => '100',
	'tooltip' => __('Select Responsive Flexcaption Background Width, Default width value 100 ( This value will apply for max-width: 768px )','royal'),
	'choices'     => array(
		'min'  => 0,
		'max'  => 100,
		'step' => 1, 
	),
	'output'   => array(
		array(
			'element'  => '.flexslider .slides .flex-caption,.home .flexslider .slides .flex-caption',
			'property' => 'width',
			'media_query' => '@media (max-width: 768px)',
			'value_pattern' => 'calc($%)',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'flexcaption_color',
	'label'    => __( 'Select Flexcaption Font Color', 'royal' ),
	'section'  => 'flex_caption_section',
	'type'     => 'color',
	'default'  => '#fff',
	'choices' => array(
		'alpha'  => true,
	),
	'output'   => array(
		array(
			'element'  => '.home .flexslider .slides .flex-caption p a,.flex-caption,.home .flexslider .slides .flex-caption p,.flexslider .slides .flex-caption p,.home .flexslider .slides .flex-caption h1, .home .flexslider .slides .flex-caption h2, .home .flexslider .slides .flex-caption h3, .home .flexslider .slides .flex-caption h4, .home .flexslider .slides .flex-caption h5, .home .flexslider .slides .flex-caption h6,.flexslider .slides .flex-caption h1,.flexslider .slides .flex-caption h2,.flexslider .slides .flex-caption h3,.flexslider .slides .flex-caption h4,.flexslider .slides .flex-caption h5,.flexslider .slides .flex-caption h6',
			'property' => 'color',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'enable_flex_caption_edit',
			'operator' => '==',
			'value'    => true,
		),
    ),
	
) );

 if( class_exists( 'WooCommerce' ) ) {
	Royal_Kirki::add_section( 'woocommerce_section', array(
		'title'          => __( 'WooCommerce','royal' ),
		'description'    => __( 'Theme options related to woocommerce', 'royal'),
		'priority'       => 11, 

		'theme_supports' => '', // Rarely needed.
	) );
	Royal_Kirki::add_field( 'woocommerce', array(
		'settings' => 'woocommerce_sidebar',
		'label'    => __( 'Enable Woocommerce Sidebar', 'royal' ),
		'description' => __('Enable Sidebar for shop page','royal'),
		'section'  => 'woocommerce_section',
		'type'     => 'switch',
		'choices' => array(
			'on'  => esc_attr__( 'Enable', 'royal' ),
			'off' => esc_attr__( 'Disable', 'royal' ) 
		),

		'default'  => 'on',
	) );
}
	
// background color ( rename )

Royal_Kirki::add_section( 'colors', array(
	'title'          => __( 'Background Color','royal' ),
	'description'    => __( 'This will affect overall site background color', 'royal'),
	//'panel'          => 'skin_color_panel', // Not typically needed.
	'priority' => 11,
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_color',
	'label'    => __( 'General Background Color', 'royal' ),
	'section'  => 'colors',
	'type'     => 'color',
	'choices' => array(
		'alpha'  => true,
	),
	'default'  => '#ffffff',
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'background-color',
		),
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'content_background_color',
	'label'    => __( 'Content Background Color', 'royal' ),
	'section'  => 'colors',
	'type'     => 'color',
	'description' => __('when you are select boxed layout content background color will reflect the grid area','royal'), 
	'choices' => array(
		'alpha'  => true,
	),  
	'default'  => '#ffffff',
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-color',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
	),
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_image',
	'label'    => __( 'General Background Image', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'upload',
	'default'  => '',
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'background-image',
		),
	),
) );

// background image ( general & boxed layout ) //


Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_repeat',
	'label'    => __( 'General Background Repeat', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'no-repeat' => esc_attr__('No Repeat', 'royal'),
        'repeat' => esc_attr__('Repeat', 'royal'),
        'repeat-x' => esc_attr__('Repeat Horizontally','royal'),
        'repeat-y' => esc_attr__('Repeat Vertically','royal'),
	),
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'background-repeat',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'general_background_image',
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'repeat',  
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_size',
	'label'    => __( 'General Background Size', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
    'choices' => array(
		'cover'  => esc_attr__( 'Cover', 'royal' ),
		'contain' => esc_attr__( 'Contain', 'royal' ),
		'auto'  => esc_attr__( 'Auto', 'royal' ),
		'inherit'  => esc_attr__( 'Inherit', 'royal' ),
	),
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'background-size',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'general_background_image',
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'cover',  
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_attachment',
	'label'    => __( 'General Background Attachment', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'scroll' => esc_attr__('Scroll', 'royal'),
        'fixed' => esc_attr__('Fixed', 'royal'),
	),
	'output'   => array(  
		array(
			'element'  => 'body',
			'property' => 'background-attachment',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'general_background_image',
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'fixed',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'general_background_position',
	'label'    => __( 'General Background Position', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'center top' => esc_attr__('Center Top', 'royal'),
        'center center' => esc_attr__('Center Center', 'royal'),
        'center bottom' => esc_attr__('Center Bottom', 'royal'),
        'left top' => esc_attr__('Left Top', 'royal'),
        'left center' => esc_attr__('Left Center', 'royal'),
        'left bottom' => esc_attr__('Left Bottom', 'royal'),
        'right top' => esc_attr__('Right Top', 'royal'),
        'right center' => esc_attr__('Right Center', 'royal'),
        'right bottom' => esc_attr__('Right Bottom', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => 'body',
			'property' => 'background-position',
		),
	),
	'active_callback'    => array(
		array(
			'setting'  => 'general_background_image', 
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'center top',  
) );


/* CONTENT BACKGROUND ( boxed background image )*/

Royal_Kirki::add_field( 'royal', array(  
	'settings' => 'content_background_image',
	'label'    => __( 'Content Background Image', 'royal' ),
	'description' => __('when you are select boxed layout content background image will reflect the grid area','royal'),
	'section'  => 'background_image',
	'type'     => 'upload',
	'default'  => '',
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-image',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
	),
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'content_background_repeat',
	'label'    => __( 'Content Background Repeat', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'no-repeat' => esc_attr__('No Repeat', 'royal'),
        'repeat' => esc_attr__('Repeat', 'royal'),
        'repeat-x' => esc_attr__('Repeat Horizontally','royal'),
        'repeat-y' => esc_attr__('Repeat Vertically','royal'),
	),
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-repeat',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
		array(
			'setting'  => 'content_background_image', 
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'repeat',  
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'content_background_size',
	'label'    => __( 'Content Background Size', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
    'choices' => array(
		'cover'  => esc_attr__( 'Cover', 'royal' ),
		'contain' => esc_attr__( 'Contain', 'royal' ),
		'auto'  => esc_attr__( 'Auto', 'royal' ),
		'inherit'  => esc_attr__( 'Inherit', 'royal' ),
	),
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-size',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
		array(
			'setting'  => 'content_background_image', 
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'cover',  
) );

Royal_Kirki::add_field( 'royal', array(
	'settings' => 'content_background_attachment',
	'label'    => __( 'Content Background Attachment', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'scroll' => esc_attr__('Scroll', 'royal'),
        'fixed' => esc_attr__('Fixed', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-attachment',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
		array(
			'setting'  => 'content_background_image', 
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'fixed',  
) );
Royal_Kirki::add_field( 'royal', array(
	'settings' => 'content_background_position',
	'label'    => __( 'Content Background Position', 'royal' ),
	'section'  => 'background_image',
	'type'     => 'select',
	'multiple'    => 1,
	'choices'     => array(
		'center top' => esc_attr__('Center Top', 'royal'),
        'center center' => esc_attr__('Center Center', 'royal'),
        'center bottom' => esc_attr__('Center Bottom', 'royal'),
        'left top' => esc_attr__('Left Top', 'royal'),
        'left center' => esc_attr__('Left Center', 'royal'),
        'left bottom' => esc_attr__('Left Bottom', 'royal'),
        'right top' => esc_attr__('Right Top', 'royal'),
        'right center' => esc_attr__('Right Center', 'royal'),
        'right bottom' => esc_attr__('Right Bottom', 'royal'),
	),
	'output'   => array(
		array(
			'element'  => '.boxed-container',
			'property' => 'background-position',
		),
	),
	'active_callback' => array(
		array(
			'setting'  => 'site-style',
			'operator' => '==',
			'value'    => 'boxed',
		),
		array(
			'setting'  => 'content_background_image', 
			'operator' => '==',
			'value'    => true,
		),
	),
	'default'  => 'center top',  
) );

do_action('wbls-royal_pro_customizer_options');
do_action('royal_child_customizer_options');
