<?php
/**
 * Royal News Magazine functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package royal_news_magazine
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'royal_news_magazine_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function royal_news_magazine_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Royal News Magazine, use a find and replace
		 * to change 'royal-news-magazine' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'royal-news-magazine', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		remove_theme_support( 'widgets-block-editor' );

        add_image_size('royal-news-magazine-blog-thumbnail-img', 600, 400, true);
        add_image_size('royal-news-magazine-blog-single-img', 900, 500, true);
        add_image_size('royal-news-magazine-custom-size', 350, 450, true);


		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'royal-news-magazine' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'royal_news_magazine_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'royal_news_magazine_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function royal_news_magazine_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'royal_news_magazine_content_width', 640 );
}
add_action( 'after_setup_theme', 'royal_news_magazine_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function royal_news_magazine_widgets_init()
{
    register_sidebar([
        'name' => esc_html__('Sidebar', 'royal-news-magazine'),
        'id' => 'sidebar-1',
        'description' => esc_html__('Add widgets here.', 'royal-news-magazine'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title"><span>',
        'after_title' => '</span></h2>',
    ]);
    for ($i = 1; $i <= 4; $i++) {
        register_sidebar([
            'name' => esc_html__('Royal News Magazine Footer Widget', 'royal-news-magazine') . $i,
            'id' => 'royal_news_magazine_footer_' . $i,
            'description' =>
                esc_html__('Shows Widgets in Footer', 'royal-news-magazine') . $i,
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget' => '</aside>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ]);
    }
    
}
add_action('widgets_init', 'royal_news_magazine_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function royal_news_magazine_scripts() {
	wp_enqueue_style( 'royal-news-magazine-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'royal-news-magazine-style', 'rtl', 'replace' );

	wp_enqueue_script( 'royal-news-magazine-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'royal_news_magazine_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/royal-news-magazine-nav-walker.php';
/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
require get_template_directory() . '/inc/customizer-functions.php';
require get_template_directory() . '/inc/royal-news-magazine-customizers-default.php';
require_once( trailingslashit( get_template_directory() ) . 'trt-customize-pro/royal-news-magazine-upgrade/class-customize.php' );

/**
 * Extra Files
 */

require get_template_directory() . '/inc/plugin-activation.php';
require get_template_directory() . '/inc/royal-news-magazine-tgmp-plugins.php';







if (!function_exists('royal_news_magazine_archive_link')) {
    function royal_news_magazine_archive_link($post)
    {
        $year = date('Y', strtotime($post->post_date));
        $month = date('m', strtotime($post->post_date));
        $day = date('d', strtotime($post->post_date));
        $link = home_url('') . '/' . $year . '/' . $month . '?day=' . $day;
        return $link;
    }
}
if (!function_exists('wp_body_open')) {
    function wp_body_open()
    {
        do_action('wp_body_open');
    }
}



if (!function_exists('royal_news_magazine_blank_widget')) {
    function royal_news_magazine_blank_widget()
    {
        echo '<div class="col-md-3">';
        if (is_user_logged_in() && current_user_can('edit_theme_options')) {
            echo '<a href="' .
                esc_url(admin_url('widgets.php')) .
                '" target="_blank"><i class="fa fa-plus-circle"></i> ' .
                esc_html__('Add Footer Widget', 'royal-news-magazine') .
                '</a>';
        }
        echo '</div>';
    }
}

if (!function_exists('royal_news_magazine_get_excerpt')):
    function royal_news_magazine_get_excerpt($post_id, $count)
    {
        $content_post = get_post($post_id);
        $excerpt = $content_post->post_content;

        $excerpt = strip_shortcodes($excerpt);
        $excerpt = strip_tags($excerpt);

        $excerpt = preg_replace('/\s\s+/', ' ', $excerpt);
        $excerpt = preg_replace('#\[[^\]]+\]#', ' ', $excerpt);
        $strip = explode(' ', $excerpt);
        foreach ($strip as $key => $single) {
            if (!filter_var($single, FILTER_VALIDATE_URL) === false) {
                unset($strip[$key]);
            }
        }
        $excerpt = implode(' ', $strip);

        $excerpt = substr($excerpt, 0, $count);
        if (strlen($excerpt) >= $count) {
            $excerpt = substr($excerpt, 0, strripos($excerpt, ' '));
            $excerpt = $excerpt . '...';
        }
        return $excerpt;
    }
endif;


/**
 * Enqueue scripts and styles.
 */
function royal_news_magazine_scripts_enqueue()
{
    wp_enqueue_style('royal-news-magazine-style', get_stylesheet_uri());
    wp_enqueue_style('royal-news-magazine-font', royal_news_magazine_font_url(), [], null);
    wp_enqueue_style(
        'bootstrap-css',
        get_template_directory_uri() . '/assets/css/bootstrap.min.css',
        [],
        '1.0'
    );

	wp_enqueue_script('custom_script_js', get_template_directory_uri() . '/js/custom-script.js', array('jquery'), '', true);
    wp_enqueue_style(
        'fontawesome-css',
        get_template_directory_uri() . '/assets/css/font-awesome.css',
        [],
        '1.0'
    );
    wp_enqueue_style(
        'slick-css',
        get_template_directory_uri() . '/assets/css/slick.css',
        [],
        '1.0'
    );

    wp_enqueue_style(
        'royal-news-magazine-css',
        get_template_directory_uri() . '/royal-news-magazine.css',
        [],
        '1.0'
    );

    wp_enqueue_style(
        'royal-news-magazine-media-css',
        get_template_directory_uri() . '/assets/css/media-queries-css.css',
        [],
        '1.0'
    );
    wp_enqueue_script(
        'royal-news-magazine-navigation',
        get_template_directory_uri() . '/js/navigation.js',
        ['jquery'],
        '1.0',
        true
    );
    wp_enqueue_script(
        'bootstrap-js',
        get_template_directory_uri() . '/assets/js/bootstrap.min.js',
        ['jquery'],
        '1.0',
        true
    );

    wp_enqueue_script(
        'slick-js',
        get_template_directory_uri() . '/assets/js/slick.min.js',
        ['jquery'],
        '1.0',
        true
    );

    wp_enqueue_script(
        'royal-news-magazine-app',
        get_template_directory_uri() . '/assets/js/main.js',
        ['jquery'],
        '1.0',
        true
    );


    wp_enqueue_script(
        'royal-news-magazine-skip-link-focus-fix',
        get_template_directory_uri() . '/js/skip-link-focus-fix.js',
        ['jquery'],
        '',
        true
    );

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'royal_news_magazine_scripts_enqueue');

function royal_news_magazine_custom_customize_enqueue()
{
    wp_enqueue_style(
        'royal-news-magazine-customizer-style',
        trailingslashit(get_template_directory_uri()) .
            'inc/customizer/css/customizer-control.css'
    );
}

add_action(
    'customize_controls_enqueue_scripts',
    'royal_news_magazine_custom_customize_enqueue'
);



if (!function_exists('royal_news_magazine_font_url')):
    function royal_news_magazine_font_url()
    {
        $fonts_url = '';
        $fonts = [];

        if ('off' !== _x('on', 'PT Serif font: on or off', 'royal-news-magazine')) {
            $fonts[] = 'PT Serif:700';
        }

        if ('off' !== _x('on', 'Nunito font: on or off', 'royal-news-magazine')) {
            $fonts[] = 'Nunito:300,400';
        }
        if ($fonts) {
            $fonts_url = add_query_arg(
                [
                    'family' => urlencode(implode('|', $fonts)),
                ],
                '//fonts.googleapis.com/css'
            );
        }

        return $fonts_url;
    }
endif;

add_action('admin_enqueue_scripts', 'load_admin_style');
function load_admin_style()
{
	wp_enqueue_script('jquery');
	wp_enqueue_style('theme_settings_css', get_template_directory_uri() . '/assets/css/theme-settings.css', false, '1.0.0');
	wp_enqueue_style('bootstrap_min_css', get_template_directory_uri() . '/assets/css/latest.bootstrap.css', false, '1.0.0');
	wp_enqueue_script('bootstrap_bundle_min_js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery'), '', true);
}

function custom_admin_page()
{
	add_menu_page(
		'Royal News Magazine Free',    // Page title
		'Royal News Magazine Free',    // Menu title
		'manage_options', // Capability required to access the menu page
		'royal_news_magazine_free',     // Menu slug (unique identifier)
		'custom_page_callback', // Function to display the page content
		'dashicons-admin-generic', // Icon URL or a dashicon class
		99                 // Position in the menu
	);
}
add_action('admin_menu', 'custom_admin_page');
// Function to display the content of the custom page




function custom_page_callback()
{
?>



	<div class="wrap" id="theme_settings">
		<h1 hidden></h1>
		<div class="accordion bl_tab_">

			<div class="row">
				<div class="col-md-3 col-lg-2 col-sm-12">
					<div class="nav flex-column nav-pills" id="bl-pills-tab" role="tablist" aria-orientation="vertical">
						<aside>
							<div class="accordion" id="theme_settings_accordion">
								<div class="accordion-item">
									<h2 class="accordion-header">
										<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
											<i class="fa-solid fa-desktop"></i> General Settings </button>
									</h2>
									<div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#theme_settings_accordion">
										<div class="accordion-body">
											<button class="nav-link show active" id="bl-pills-2-tab" data-bs-toggle="pill" data-bs-target="#bl-pills-2" type="button" role="tab" aria-controls="bl-pills-2" aria-selected="false">Back to Top</button>
											<button class="nav-link " id="bl-pills-1-tab" data-bs-toggle="pill" data-bs-target="#bl-pills-1" type="button" role="tab" aria-controls="bl-pills-1" aria-selected="true">Breadcrumbs</button>


										</div>
									</div>
								</div>

								
								<div class="accordion-item">

									<h2 class="accordion-header">
										<button class="nav-link collapsed" aria-expanded="false" id="bl-pills-3-tab" data-bs-toggle="pill" data-bs-target="#bl-pills-3" type="button" role="tab" aria-controls="bl-pills-3" aria-selected="false">
											Supports
										</button>
									</h2>
								</div>

							</div>
						</aside>
					</div>
				</div>
				<div class="col-md-9 col-lg-10 col-sm-12">
					<div class="card p-lg-4 p-3 m-0">
						<div class="tab-content m-0" id="bl-pills-tabContent">
							<div class="tab-pane fade " id="bl-pills-1" role="tabpanel" aria-labelledby="bl-pills-1-tab">
								<form method="post">
									<input type="hidden" name="reset" value="1">
									<div class="show_hide_label">
										<div><label for="royal-news-magazine_dslc_breadcrumb_show">Show Breadcrumbs on your website</label></div>
										<div class="onoff" id="onoff2">
											<input name="royal-news-magazine_dslc_breadcrumb_show" type="checkbox" value="1" id="royal-news-magazine_dslc_breadcrumb_show" <?php echo (get_option('royal-news-magazine_dslc_breadcrumb_show') === "on") ? "checked" : ""; ?>>
											<label for="royal-news-magazine_dslc_breadcrumb_show"> </label>
										</div>
									</div>

									<div class="bl_list_">
										<ul class="template_listing" id="template_list">
											<?php
											$args = array(
												'public'   => true,
												'show_in_menu' => true, // Set to true if you also want to include built-in post types like 'post' and 'page'.
											);

											$post_types = get_post_types($args, 'names');
											asort($post_types);
											foreach ($post_types as $key => $item) {
											?>
												<li>
													<label class="all new">
														<input class="royal-news-magazine_breadcrumb_post" name="<?php echo 'royal-news-magazine_dslc_' . $key; ?>" <?php echo ((get_option('royal-news-magazine_dslc_' . $key) == 1) ? "checked" : ""); ?> type="checkbox"><?php echo $item ?>
													</label>
												</li>

											<?php } ?>


										</ul>
										<label class="bread_all">
											<input class="Select All" name="royal-news-magazine_dslc_bread_all" <?php echo ((get_option('royal-news-magazine_dslc_bread_all') == 1) ? "checked" : "") ?> type="checkbox">Apply to all
										</label>
									</div>
									<button type="submit" class="btn bttn">Save</button>
								</form>
							</div>
							<div class="tab-pane fade show active" id="bl-pills-2" role="tabpanel" aria-labelledby="bl-pills-2-tab">
								<form method="post">
									<input type="hidden" value="1" name="royal-news-magazine_free_back_top_top_enable_form">
									<div class="show_hide_label">
										<div><label for="back_top_top_enable">Show Back To Top button on your website</label></div>
										<div class="onoff">
											<input type="checkbox" id="back_top_top_enable" name="back_top_top_enable" <?php if (get_option('royal-news-magazine_free_back_top_top_enable') && get_option('royal-news-magazine_free_back_top_top_enable') == "on") {
																															echo "checked";
																														} ?>>
											<label for="back_top_top_enable"></label>
										</div>
									</div>

									<?php submit_button(); ?>
								</form>
							</div>
							<div class="tab-pane fade" id="bl-pills-3" role="tabpanel" aria-labelledby="bl-pills-3-tab">
								<div>
									<a href="https://support.elegantblogthemes.com/hc/1148218989/category/76" target="blank">Click here</a> to access our Knowledge Base.
								</div>
							</div>
							<div class="tab-pane fade" id="bl-pills-4" role="tabpanel" aria-labelledby="bl-pills-4-tab">
								<form method="post" action="options.php">

									<?php

									settings_fields('royal-news-magazine_theme_option_group');
									do_settings_sections('royal-news-magazine_theme_options');
									submit_button();
									?>

								</form>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	</div>
	</div>



	<script>
		// on off js
		jQuery(document).ready(function($) {
			if ($('#onoff2 input').is(':checked')) {
				$('.bl_tab_ .bl_list_').fadeIn('slow');
			} else {
				$('.bl_tab_ .bl_list_').fadeOut('slow');
			}
		});

	jQuery(document).ready(function($) {
	// When "Apply to all" checkbox changes
	$('input.Select.All[name="royal-news-magazine_dslc_bread_all"]').on('change', function() {
		let isChecked = $(this).is(':checked');

		// Toggle all other checkboxes
		$('input.royal-news-magazine_breadcrumb_post[type="checkbox"]').prop('checked', isChecked);
	});
});

		jQuery(document).ready(function($) {
			$('#onoff2 input').change(function() {
				if ($(this).is(':checked')) {
					$('.bl_tab_ .bl_list_').fadeIn('slow');
				} else {
					$('.bl_tab_ .bl_list_').fadeOut('slow');
				}
			});
			<?php 
				if (isset($_POST) && isset($_POST['royal_news_pro_back_top_top_enable_form'])) {
					$current_target = 'bl-pills-2-tab';
				}
				if (isset($_POST) && isset($_POST['reset'])) {
					$current_target = 'bl-pills-1-tab';
				}
				
				



				echo  "jQuery('#$current_target').click()";
			
			?>
		});
	</script>

<?php


}










// custom callback function to print field HTML
function handle_post__request()
{
	if (isset($_POST) && isset($_POST['royal-news-magazine_free_back_top_top_enable_form'])) {

		if (!empty($_POST['back_top_top_enable'])) {
			update_option('royal-news-magazine_free_back_top_top_enable', $_POST['back_top_top_enable']);
		} else {
			update_option('royal-news-magazine_free_back_top_top_enable', 0);
		}
	}
	if (isset($_POST) &&  isset($_POST['reset'])) {
		try {
			$args = array(
				'public'   => true,
				'show_in_menu' => true, // Set to true if you also want to include built-in post types like 'post' and 'page'.
			);
			$post_types = get_post_types($args, 'names');
			foreach ($post_types as $t_key => $t_item) {
				update_option('royal-news-magazine_dslc_' . $t_key, 0);
			}

			update_option('royal-news-magazine_dslc_bread_all', 0);
			foreach ($post_types as $t_key => $t_item) {
				if (isset($_POST['royal-news-magazine_dslc_' . $t_key])) {
					update_option('royal-news-magazine_dslc_' . $t_key, 1);
				}
			}
			if (isset($_POST['royal-news-magazine_dslc_bread_all'])) {
				update_option('royal-news-magazine_dslc_bread_all', 1);
			}
			if (isset($_POST['royal-news-magazine_dslc_breadcrumb_show'])) {
				update_option('royal-news-magazine_dslc_breadcrumb_show', 'on');
			} else {
				update_option('royal-news-magazine_dslc_breadcrumb_show', 'off');
			}
		} catch (\Throwable $th) {
		}
	}
}
add_action('admin_init', 'handle_post__request');

// Hook to add the custom menu page
add_action('admin_menu', 'custom_admin_page');
// Breadcrumb function
function custom_breadcrumbs()
{
	// Home page link
	echo '<a href="' . home_url('/') . '">' . __('Home', 'royal-news-magazine') . '</a> <span class="separator">/</span> ';

	// Check if on a singular post or page
	if (is_singular()) {
		global $post;

		// Get the category for the post
		$categories = get_the_category($post->ID);

		if ($categories) {
			$category = $categories[0]; // Use the first category
			echo '<a href="' . get_category_link($category->term_id) . '">' . esc_html($category->name) . '</a> <span class="separator">/</span> ';
		}

		// Display the post title
		echo '<span class="current">' . get_the_title() . '</span>';
	} elseif (is_category()) {
		// Display the current category
		echo '<span class="current">' . single_cat_title('', false) . '</span>';
	} elseif (is_tag()) {
		// Display the current tag
		echo '<span class="current">' . single_tag_title('', false) . '</span>';
	} elseif (is_archive()) {
		// Display the current archive
		echo '<span class="current">' . get_the_archive_title() . '</span>';
	} elseif (is_search()) {
		// Display the search term
		echo '<span class="current">' . __('Search results for: ', 'royal-news-magazine') . get_search_query() . '</span>';
	} elseif (is_404()) {
		// Display 404 message
		echo '<span class="current">' . __('404 Not Found', 'royal-news-magazine') . '</span>';
	}
	echo "
	<style>.separator {
		margin: 0 5px;
	}
	 
	.current {
		font-weight: bold;
	}
	 </style>";
}

function check_breadcrumb()
{
	if (get_option('royal-news-magazine_dslc_breadcrumb_show') == 'on') {
		if (is_single()) {
			$post_type = get_post_type();
			if (get_option('royal-news-magazine_dslc_' . $post_type) == 1) {
				$already_set = 1;
				if (function_exists('custom_breadcrumbs')) custom_breadcrumbs();
			}
		} elseif (is_page()) {
			if (get_option('royal-news-magazine_dslc_page') == 1) {
				$already_set = 1;
				if (function_exists('custom_breadcrumbs')) custom_breadcrumbs();
			}
		}
		if (get_option('royal-news-magazine_dslc_bread_all') == 1 && !isset($already_set)) {
			if (function_exists('custom_breadcrumbs')) custom_breadcrumbs();
		}
	}
}


?>