<?php
 /**
  * Title: Footer Two Columns
  * Slug: rock-tune/footer-two-columns
  * Categories: rock-tune, footer
  */
?>
<!-- wp:group {"align":"full","className":"footer footer-two-columns","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull footer footer-two-columns">
	<!-- wp:group {"align":"wide","className":"upper-col-wrap","layout":{"type":"constrained"}} -->
	<div class="wp-block-group alignwide upper-col-wrap">
		<!-- wp:columns {"align":"wide","className":"upper-footer"} -->
		<div class="wp-block-columns alignwide upper-footer">
			<!-- wp:column {"className":"footer-contact"} -->
			<div class="wp-block-column footer-contact">
				<!-- wp:paragraph {"className":"footer-title footer-site-title"} -->
				<p class="footer-title footer-site-title">Rock Tune</p>
				<!-- /wp:paragraph -->
				<!-- wp:paragraph {"fontSize":"small"} -->
				<p class="has-small-font-size">Rock Music WordPress Theme</p>
				<!-- /wp:paragraph -->
				<!-- wp:social-links {"className":"is-style-default"} -->
				<ul class="wp-block-social-links is-style-default">
					<!-- wp:social-link {"url":"#","service":"facebook"} /-->
					<!-- wp:social-link {"url":"#","service":"twitter"} /-->
					<!-- wp:social-link {"url":"#","service":"linkedin"} /-->
				</ul>
				<!-- /wp:social-links -->
			</div>
			<!-- /wp:column -->
		<!-- wp:column {"className":"footer-details"} -->
		<div class="wp-block-column footer-details">
			<!-- wp:paragraph {"className":"footer-title footer-site-title"} -->
			<p class="footer-title footer-site-title"><?php esc_html_e('Contact', 'rock-tune'); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:group {"layout":{"type":"constrained"}} -->
			<div class="wp-block-group">
				<!-- wp:paragraph {"fontSize":"upper-heading"} -->
				<p class="has-upper-heading-font-size"><?php esc_html_e('+123 456 7890', 'rock-tune'); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:paragraph {"fontSize":"upper-heading"} -->
					<p class="has-upper-heading-font-size"><?php esc_html_e('171 Horseshoe Crescent,', 'rock-tune'); ?>
						
					<br><?php esc_html_e('Beimingham, B43 7BH', 'rock-tune'); ?>
					
					</p>
				<!-- /wp:paragraph -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
	<!-- wp:group {"align":"wide","className":"wp-block-footer  wp-block-site-generator bottom-footer","layout":{"inherit":true,"type":"constrained"}} -->
	<div class="wp-block-group alignwide wp-block-footer wp-block-site-generator bottom-footer">
		<!-- wp:group {"align":"wide","className":"wp-block-site-info","layout":{"type":"flex","justifyContent":"space-between","orientation":"horizontal"}} -->
		<div class="wp-block-group alignwide wp-block-site-info">
				<!-- wp:paragraph -->
				<p>
						<?php 
						printf( 
							/* translators: %1$s: Year, %2$s: Year */
							esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL, 3: Privacy Policy Link', 'rock-tune' ), 
							esc_attr( date_i18n( __( 'Y', 'rock-tune' ) ) ), 
							'<a href="' . esc_url( home_url( '/' ) ) . '">' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '</a><span class="sep"> | </span>Rock Tune by <a target="_blank" href="https://catchthemes.com">Catch Themes</a>' ); 
						?>
						</p>
					<!-- /wp:paragraph -->
			<!-- wp:navigation {"overlayMenu":"never","layout":{"type":"flex","justifyContent":"right"}} /-->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->