<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package Rock_Tune
 * @since 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since 0.1
	 *
	 * @return void
	 */
	function rock_tune_register_block_styles() {

		//Wp Block Padding Zero
		register_block_style(
			'core/group',
			array(
				'name'  => 'rock-tune-padding-0',
				'label' => esc_html__( 'No Padding', 'rock-tune' ),
			)
		);

		//Wp Block Post Author Style
		register_block_style(
			'core/post-author',
			array(
				'name'  => 'rock-tune-post-author-card',
				'label' => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);

		//Wp Block Button Style
		register_block_style(
			'core/button',
			array(
				'name'         => 'rock-tune-button',
				'label'        => esc_html__( 'Plain', 'rock-tune' ),
			)
		);

		//Post Comments Style
		register_block_style(
			'core/post-comments',
			array(
				'name'         => 'rock-tune-post-comments',
				'label'        => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);

		//Latest Comments Style
		register_block_style(
			'core/latest-comments',
			array(
				'name'         => 'rock-tune-latest-comments',
				'label'        => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);


		//Wp Block Table Style
		register_block_style(
			'core/table',
			array(
				'name'         => 'rock-tune-wp-table',
				'label'        => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);


		//Wp Block Pre Style
		register_block_style(
			'core/preformatted',
			array(
				'name'         => 'rock-tune-wp-preformatted',
				'label'        => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);

		//Wp Block Verse Style
		register_block_style(
			'core/verse',
			array(
				'name'         => 'rock-tune-wp-verse',
				'label'        => esc_html__( 'Theme Style', 'rock-tune' ),
			)
		);
	}
	add_action( 'init', 'rock_tune_register_block_styles' );
}
