<?php

/**
 * Theme About Page
 *
 * @package Rock Tune
 * @since 1.0
 */

function rock_tune_admin_plugin_notice()
{

	if ( ! PAnD::rock_tune_is_admin_notice_active( 'notice-seven-7' ) ) {
		return;
	}

	$screen = get_current_screen();

	if (! empty($screen->base) && 'appearance_page_rock-tune-theme' === $screen->base) {
		return false;
	}
?>
	<div data-dismissible="notice-seven-7" class="notice notice-info is-dismissible rock-tune-admin-notice">
		<div class="rock-tune-admin-notice-wrapper">
			<h2><?php esc_html_e('Rock Tune Pro', 'rock-tune'); ?></h2>
			<p><?php esc_html_e('Get your hands on the WordPress Full Site Editing features. Start building your website with advanced block patterns and custom blocks! Get 35+ block patterns, 28 Templates, and 12 Template Parts that are highly customizable and fully responsive.', 'rock-tune'); ?></p>

			<a target="_blank" class="button-primary button green" href="<?php echo esc_url('https://catchthemes.com/themes/rock-tune-pro/'); ?>"><?php esc_html_e('Get Rock Tune Pro', 'rock-tune'); ?></a>

			<a class="button" href="<?php echo esc_url(admin_url('themes.php?page=rock-tune-theme')); ?>"><?php esc_html_e('Theme Info', 'rock-tune'); ?></a>
		</div>
	</div>
<?php
}
add_action( 'admin_init', array( 'PAnD', 'init' ) );
add_action( 'admin_notices', 'rock_tune_admin_plugin_notice' );

function rock_tune_theme_page_admin_style($hook)
{
	// Register theme stylesheet.
	$theme_version = wp_get_theme()->get('Version');

	$version_string = is_string($theme_version) ? $theme_version : false;
	wp_enqueue_style(
		'rock-tune-theme-admin-style',
		get_theme_file_uri('assets/css/about-admin.css'),
		array(),
		$version_string
	);
}
add_action( 'admin_enqueue_scripts', 'rock_tune_theme_page_admin_style' );

/**
 * Add theme page
 */
function rock_tune_menu()
{
	add_theme_page(esc_html__('Rock Tune', 'rock-tune'), esc_html__('Rock Tune', 'rock-tune'), 'edit_theme_options', 'rock-tune-theme', 'rock_tune_theme_page_display');
}
add_action( 'admin_menu', 'rock_tune_menu' );

/**
 * Display About page
 */
function rock_tune_theme_page_display()
{
	$theme = wp_get_theme();

	if (is_child_theme()) {
		$theme = wp_get_theme()->parent();
	}
?>

	<div id="welcome-panel" class="welcome-panel">
		<div class="welcome-panel-content">
			<div class="welcome-panel-header">
				<h2><?php echo esc_html($theme->Name); ?></h2>
				<p><?php esc_html_e('Free Full Site Editing WordPress Theme', 'rock-tune'); ?></p>
			</div>

			<div class="welcome-panel-column-container">
				<div class="container-wrap">
					<div class="welcome-panel-column two-columns">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Getting Started with Rock Tune!', 'rock-tune'); ?></h3>
							<p><?php esc_html_e('Awesome! Rock Tune has been installed and activated successfully. Now, you can start building your dream website with a wide range of highly-customizable block patterns, templates, and template parts available in this astounding theme.', 'rock-tune'); ?></p>
							<a target="_blank" href="https://catchthemes.com/themes/rock-tune/#theme-instructions"><?php esc_html_e('Theme instructions', 'rock-tune'); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column two-columns">
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('More Features with Rock Tune Pro Theme', 'rock-tune'); ?></h3>
							<p><?php esc_html_e('To get more beautiful block patterns and templates, we recommend you upgrade to Rock Tune Pro. With the pro theme installed, get more options, blocks, block patterns, templates and template parts.', 'rock-tune'); ?></p>
							<a target="_blank" class="button green button-primary button-hero green" href="https://catchthemes.com/themes/rock-tune-pro/"><?php esc_html_e('Buy Rock Tune Pro', 'rock-tune'); ?></a>
						</div>
					</div>

				</div>
				<div class="sidebar">
					<div class="welcome-panel-column important-links">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Important Links', 'rock-tune'); ?></h3>
							<a target="_blank" href="<?php echo esc_url($theme->get('ThemeURI')); ?>"><?php esc_html_e('Theme Info', 'rock-tune'); ?></a>
							<a target="_blank" href="https://fse.catchthemes.com/rock-tune/"><?php esc_html_e('View Demo', 'rock-tune'); ?></a>
							<a target="_blank" href="<?php echo esc_url('https://catchthemes.com/fse-faq'); ?>"><?php esc_html_e('FSE FAQs', 'rock-tune'); ?></a>
							<a target="_blank" href="<?php echo esc_url($theme->get('ThemeURI') . '/#changelog'); ?>"><?php esc_html_e('Change log', 'rock-tune'); ?></a>
							<a target="_blank" href="<?php echo esc_url('https://catchthemes.com/support-forum/forum/full-site-editing/'); ?>"><?php esc_html_e('Support', 'rock-tune'); ?></a>
						</div>
					</div>

					<div class="welcome-panel-column review">
						<!-- <div class="welcome-panel-icon-pages"></div> -->
						<div class="welcome-panel-column-content">
							<h3><?php esc_html_e('Leave us a review', 'rock-tune'); ?></h3>
							<p><?php esc_html_e('Loved Rock Tune? Feel free to leave your feedback. Your opinion helps us reach more audiences!', 'rock-tune'); ?></p>
							<a href="https://wordpress.org/support/theme/rock-tune/reviews/" class="button button-primary button-hero" style="text-decoration: none;" target="_blank"><?php esc_html_e('Review', 'rock-tune'); ?></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
}
