<?php

/**
 * Rock Tune functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Rock_Tune
 * @since 1.0
 */

if (!function_exists('rock_tune_support')) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since 1.0
	 *
	 * @return void
	 */
	function rock_tune_support()
	{

		// Add support for block styles.
		add_theme_support('wp-block-styles');

		// Enqueue editor styles.
		add_editor_style('style.css');
	}

endif;

add_action('after_setup_theme', 'rock_tune_support');

if (!function_exists('rock_tune_styles')) :

	/**
	 * Enqueue styles.
	 *
	 * @since 1.0
	 *
	 * @return void
	 */

	function rock_tune_styles()
	{
		// Enqueue theme stylesheet.
		wp_enqueue_style(
			'rock-tune-style',
			get_template_directory_uri() . '/style.css',
			array(),
			filemtime(get_theme_file_path('style.css'))
		);

		wp_enqueue_script(
			'rock-tune-script',
			get_theme_file_uri('assets/js/custom.js'),
			array(),
			filemtime(get_theme_file_path('assets/js/custom.js')),
			true
		);
	}

endif;

add_action('wp_enqueue_scripts', 'rock_tune_styles');

if (!function_exists('rock_tune_dismissible_script')) :

	/**
	 * Enqueue Dismissible Notice Script
	 */

	function rock_tune_dismissible_script()
	{
		wp_enqueue_script(
            'dismissible-notices',
            get_theme_file_uri( 'assets/js/dismiss-notice.js' ),
            array(),
            filemtime( get_theme_file_path( 'assets/js/dismiss-notice.js' ) ),
            true
        );

        wp_localize_script(
			'dismissible-notices',
			'dismissible_notice',
			array(
				'nonce' => wp_create_nonce( 'dismissible-notice' ),
			)
		);
	}

endif;

add_action( 'admin_enqueue_scripts', 'rock_tune_dismissible_script' );

if (!function_exists('rock_tune_block_editor_styles')) :

	/**
	 * Enqueue rtl editor styles
	 */

	function rock_tune_block_editor_styles()
	{
		if (is_rtl()) {
			wp_enqueue_style(
				'rock-tune-rtl',
				get_theme_file_uri('rtl.css'),
				array(),
				filemtime(get_theme_file_path('rtl.css'))
			);
		}
	}

endif;

add_action('enqueue_block_editor_assets', 'rock_tune_block_editor_styles');

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';

// Add block styles
require get_template_directory() . '/inc/block-styles.php';

// Block Filters
require get_template_directory() . '/inc/block-filters.php';

// Svg icons
require get_template_directory() . '/inc/icon-function.php';

// Admin Notice Dismissal
require get_template_directory() . '/inc/persist-admin-notices-dismissal.php';

// Theme About Page
require get_template_directory() . '/inc/about.php';
