import { Icon, Sidebar, Card, Heading } from "../../components";
import { __ } from '@wordpress/i18n';

const Homepage = () => {
    const cardLists = [
        {
            iconSvg: <Icon icon="site" />,
            heading: __('Site Identity', 'ridhi'),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.custom_logo
        },
        {
            iconSvg: <Icon icon="colorsetting" />,
            heading: __("Appearance Settings", 'ridhi'),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.appearance
        },
        {
            iconSvg: <Icon icon="layoutsetting" />,
            heading: __("General Sidebar Layout", 'ridhi'),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.layout
        },
        {
            iconSvg: <Icon icon="frontpagesetting" />,
            heading: __("Front Page Settings", 'ridhi'),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.frontpage
        },
        {
            iconSvg: <Icon icon="generalsetting" />,
            heading: __("General Settings"),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.general
        },
        {
            iconSvg: <Icon icon="footersetting" />,
            heading: __('Footer Settings', 'ridhi'),
            buttonText: __('Customize', 'ridhi'),
            buttonUrl: cw_dashboard.footer
        }
    ];

    const proSettings = [
        {
            heading: __('Header Layouts', 'ridhi'),
            para: __('Choose from different unique header layouts.', 'ridhi'),
            buttonText: __('Learn More', 'ridhi'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            heading: __('Multiple Layouts', 'ridhi'),
            para: __('Choose layouts for blogs, banners, posts and more.', 'ridhi'),
            buttonText: __('Learn More', 'ridhi'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            heading: __('Multiple Sidebar', 'ridhi'),
            para: __('Set different sidebars for posts and pages.', 'ridhi'),
            buttonText: "Learn More",
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Boost your website performance with ease.', 'ridhi'),
            heading: __('Performance Settings', 'ridhi'),
            buttonText: __('Learn More', 'ridhi'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Choose typography for different heading tags.', 'ridhi'),
            heading: __('Typography Settings', 'ridhi'),
            buttonText: __('Learn More', 'ridhi'),
            buttonUrl: cw_dashboard?.get_pro
        },
        {
            para: __('Import the demo content to kickstart your site.', 'ridhi'),
            heading: __('One Click Demo Import', 'ridhi'),
            buttonText: __('Learn More', 'ridhi'),
            buttonUrl: cw_dashboard?.get_pro
        }
    ];

    const sidebarSettings = [
        {
            heading: __('We Value Your Feedback!', 'ridhi'),
            icon: "star",
            para: __("Your review helps us improve and assists others in making informed choices. Share your thoughts today!", 'ridhi'),
            imageurl: <Icon icon="review" />,
            buttonText: __('Leave a Review', 'ridhi'),
            buttonUrl: cw_dashboard.review
        },
        {
            heading: __('Knowledge Base', 'ridhi'),
            para: __("Need help using our theme? Visit our well-organized Knowledge Base!", 'ridhi'),
            imageurl: <Icon icon="documentation" />,
            buttonText: __('Explore', 'ridhi'),
            buttonUrl: cw_dashboard.docmentation
        },
        {
            heading: __('Need Assistance? ', 'ridhi'),
            para: __("If you need help or have any questions, don't hesitate to contact our support team. We're here to assist you!", 'ridhi'),
            imageurl: <Icon icon="supportTwo" />,
            buttonText: __('Submit a Ticket', 'ridhi'),
            buttonUrl: cw_dashboard.support
        }
    ];

    return (
        <>
             <div className="customizer-settings">
                <div className="cw-customizer">
                    <Heading
                        heading={__( 'Quick Customizer Settings', 'ridhi' )}
                        buttonText={__( 'Go To Customizer', 'ridhi' )}
                        buttonUrl={cw_dashboard?.customizer_url}
                        openInNewTab={true}
                    />
                    <Card
                        cardList={cardLists}
                        cardPlace='customizer'
                        cardCol='three-col'
                    />
                    <Heading
                        heading={__( 'More features with Pro version', 'ridhi' )}
                        buttonText={__( 'Go To Customizer', 'ridhi' )}
                        buttonUrl={cw_dashboard?.customizer_url}
                        openInNewTab={true}
                    />
                    <Card
                        cardList={proSettings}
                        cardPlace='cw-pro'
                        cardCol='two-col'
                    />
                    <div className="cw-button">
                        <a href={cw_dashboard?.get_pro} target="_blank" className="cw-button-btn primary-btn long-button">{__('Learn more about the Pro version', 'ridhi')}</a>
                    </div>
                </div>
                <Sidebar sidebarSettings={sidebarSettings} openInNewTab={true} />
            </div>
        </>
    );
}

export default Homepage;