<?php

/**
 * Option Panel
 *
 * @package ReviewNews
 */

$reviewnews_default = reviewnews_get_default_theme_options();
/*theme option panel info*/
require get_template_directory() . '/inc/customizer/frontpage-options.php';

//font and color options
require get_template_directory() . '/inc/customizer/font-color-options.php';

//selective refresh
require get_template_directory() . '/inc/customizer/customizer-refresh.php';


/**
 * Front-page options section
 *
 * @package ReviewNews
 */


// Add Front-page Options Panel.
$wp_customize->add_panel(
  'site_header_option_panel',
  array(
    'title' => esc_html__('Header Options', 'reviewnews'),
    'priority' => 198,
    'capability' => 'edit_theme_options',
    'type'     => 'reviewnews-panel',
  )
);

/**
 * Header section
 *
 * @package ReviewNews
 */

// Front-page Section.
$wp_customize->add_section(
  'header_options_settings',
  array(
    'title' => esc_html__('Header Settings', 'reviewnews'),
    'priority' => 49,
    'capability' => 'edit_theme_options',
    'panel' => 'site_header_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'enable_site_mode_switch',
  array(
    'default' => $reviewnews_default['enable_site_mode_switch'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'enable_site_mode_switch',
  array(
    'label' => esc_html__('Site Mode Switch', 'reviewnews'),
    'section' => 'header_builder',
    'settings' => 'enable_site_mode_switch',
    'type' => 'select',
    'choices' => array(
      'aft-enable-mode-switch' => esc_html__('Enable', 'reviewnews'),
      'aft-disable-mode-switch' => esc_html__('Disable', 'reviewnews'),
    ),
    'priority' => 5,
  )
);

// Setting - sticky_header_option.
$wp_customize->add_setting(
  'disable_sticky_header_option',
  array(
    'default'           => $reviewnews_default['disable_sticky_header_option'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'disable_sticky_header_option',
  array(
    'label'    => esc_html__('Disable Sticky Header', 'reviewnews'),
    'section'  => 'header_builder',
    'type'     => 'checkbox',
    'priority' => 5,
    'description' => esc_html__('Sticky header works only with builder at bottom.', 'reviewnews'),

  )
);

//section title
$wp_customize->add_setting(
  'show_top_header_section_title',
  array(
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  new ReviewNews_Section_Title(
    $wp_customize,
    'show_top_header_section_title',
    array(
      'label' => esc_html__("Top Header Section", 'reviewnews'),
      'section' => 'header_builder',
      'priority' => 5,

    )
  )
);


// Setting - show_site_title_section.
$wp_customize->add_setting(
  'show_top_header_section',
  array(
    'default' => $reviewnews_default['show_top_header_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'show_top_header_section',
  array(
    'label' => esc_html__('Show Top Header', 'reviewnews'),
    'section' => 'header_builder',
    'settings' => 'show_top_header_section',
    'type' => 'checkbox',
    'priority' => 5,
    
  )
);


// Setting - show_site_title_section.
$wp_customize->add_setting(
  'show_date_section',
  array(
    'default' => $reviewnews_default['show_date_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'show_date_section',
  array(
    'label' => esc_html__('Show Date', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'checkbox',
    'priority' => 5,
    'active_callback' => function ($control) {
      return (
        reviewnews_top_header_status($control)
        &&
        reviewnews_is_inactive_builder($control)
      );
    },
  )
);

// Setting - show_site_title_section.
$wp_customize->add_setting(
  'show_time_section',
  array(
    'default' => $reviewnews_default['show_time_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);
$wp_customize->add_control(
  'show_time_section',
  array(
    'label' => esc_html__('Show Time', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'checkbox',
    'priority' => 5,
    'active_callback' => 'reviewnews_top_header_status'
  )
);

// Setting - select_main_banner_section_mode.
$wp_customize->add_setting(
  'top_header_time_format',
  array(
    'default' => $reviewnews_default['top_header_time_format'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'top_header_time_format',
  array(
    'label' => esc_html__('Time Format', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'select',
    'choices' => array(
      'en-US' => esc_html__('12 hours', 'reviewnews'),
      'en-GB' => esc_html__('24 hours', 'reviewnews'),
      'en-WP' => esc_html__('From WordPress Settings', 'reviewnews'),
    ),
    'priority' => 5,
    'active_callback' => function ($control) {
      return (
        reviewnews_top_header_status($control)
        &&
        reviewnews_show_time_status($control)


      );
    },

  )
);


// Advertisement Section.
$wp_customize->add_section(
  'frontpage_advertisement_settings',
  array(
    'title' => esc_html__('Header Advertisement', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'site_header_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);



//section title
$wp_customize->add_setting(
  'banner_advertisement_section_title',
  array(
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  new ReviewNews_Section_Title(
    $wp_customize,
    'banner_advertisement_section_title',
    array(
      'label' => esc_html__("Header Advertisement", 'reviewnews'),
      'section' => 'header_builder',
      'priority' => 120,

    )
  )
);


// Setting banner_advertisement_section.
$wp_customize->add_setting(
  'banner_advertisement_section',
  array(
    'default' => $reviewnews_default['banner_advertisement_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'absint',
  )
);




$wp_customize->add_control(
  new WP_Customize_Cropped_Image_Control(
    $wp_customize,
    'banner_advertisement_section',
    array(
      'label' => esc_html__('Header Section Advertisement', 'reviewnews'),
      'description' => esc_html(sprintf(__('Recommended Size %1$s px X %2$s px', 'reviewnews'), 930, 110)),
      'section' => 'header_builder',
      'width' => 930,
      'height' => 110,
      'flex_width' => true,
      'flex_height' => true,
      'priority' => 120,
    )
  )
);

/*banner_advertisement_section_url*/
$wp_customize->add_setting(
  'banner_advertisement_section_url',
  array(
    'default' => $reviewnews_default['banner_advertisement_section_url'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
  )
);
$wp_customize->add_control(
  'banner_advertisement_section_url',
  array(
    'label' => esc_html__('URL Link', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'text',
    'priority' => 130,
  )
);


// Add Theme Options Panel.
$wp_customize->add_panel(
  'theme_option_panel',
  array(
    'title' => esc_html__('Theme Options', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'type'     => 'reviewnews-panel',
  )
);





// Breadcrumb Section.
$wp_customize->add_section(
  'site_breadcrumb_settings',
  array(
    'title' => esc_html__('Breadcrumb Options', 'reviewnews'),
    'priority' => 49,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - breadcrumb.
$wp_customize->add_setting(
  'enable_breadcrumb',
  array(
    'default' => $reviewnews_default['enable_breadcrumb'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'enable_breadcrumb',
  array(
    'label' => esc_html__('Show breadcrumbs', 'reviewnews'),
    'section' => 'site_breadcrumb_settings',
    'type' => 'checkbox',
    'priority' => 10,
  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'select_breadcrumb_mode',
  array(
    'default' => $default['select_breadcrumb_mode'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'select_breadcrumb_mode',
  array(
    'label' => esc_html__('Select Breadcrumbs', 'reviewnews'),
    'description' => esc_html__("Please ensure that you have enabled the plugin's breadcrumbs before choosing other than Default", 'reviewnews'),
    'section' => 'site_breadcrumb_settings',
    'settings' => 'select_breadcrumb_mode',
    'type' => 'select',
    'choices' => array(
      'default' => esc_html__('Default', 'reviewnews'),
      'yoast' => esc_html__('Yoast SEO', 'reviewnews'),
      'rankmath' => esc_html__('Rank Math', 'reviewnews'),
      'bcn' => esc_html__('NavXT', 'reviewnews'),
    ),
    'priority' => 100,
  )
);




/**
 * Layout options section
 *
 * @package ReviewNews
 */

// Layout Section.
$wp_customize->add_section(
  'site_layout_settings',
  array(
    'title' => esc_html__('Global Settings', 'reviewnews'),
    'priority' => 9,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - preloader.
$wp_customize->add_setting(
  'enable_site_preloader',
  array(
    'default' => $reviewnews_default['enable_site_preloader'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'enable_site_preloader',
  array(
    'label' => esc_html__('Enable Preloader', 'reviewnews'),
    'section' => 'site_layout_settings',
    'type' => 'checkbox',
    'priority' => 10,
  )
);


// Setting - Disable Emoji Script.
$wp_customize->add_setting(
  'disable_wp_emoji',
  array(
    'default'           => $reviewnews_default['disable_wp_emoji'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'disable_wp_emoji',
  array(
    'label'    => esc_html__('Disable Emoji Script', 'reviewnews'),
    'description'       => esc_html__('GDPR friendly & better performance', 'reviewnews'),
    'section'  => 'site_layout_settings', // Use your preferred section.
    'type'     => 'checkbox',
    'priority' => 10,
  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_content_alignment',
  array(
    'default' => $reviewnews_default['global_content_alignment'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_content_alignment',
  array(
    'label' => esc_html__('Global Content Alignment', 'reviewnews'),
    'section' => 'site_layout_settings',
    'type' => 'select',
    'choices' => array(
      'align-content-left' => esc_html__('Content - Primary sidebar', 'reviewnews'),
      'align-content-right' => esc_html__('Primary sidebar - Content', 'reviewnews'),
      'full-width-content' => esc_html__('Full width content', 'reviewnews')
    ),
    'priority' => 130,
  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_fetch_content_image_setting',
  array(
    'default'           => $default['global_fetch_content_image_setting'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_fetch_content_image_setting',
  array(
    'label'       => esc_html__('Also Show Content Image in Archive', 'reviewnews'),
    'description'       => esc_html__('If there is no Post Featured image set', 'reviewnews'),
    'section'     => 'site_layout_settings',
    'type'        => 'select',
    'choices'               => array(
      'enable' => esc_html__('Enable ', 'reviewnews'),
      'disable' => esc_html__('Disable', 'reviewnews'),

    ),
    'priority'    => 130,
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_toggle_image_lazy_load_setting',
  array(
    'default'           => $default['global_toggle_image_lazy_load_setting'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_toggle_image_lazy_load_setting',
  array(
    'label'       => esc_html__('Image Lazy Loading', 'reviewnews'),
    'description'       => esc_html__('Set for better performance', 'reviewnews'),
    'section'     => 'site_layout_settings',
    'type'        => 'select',
    'choices'               => array(
      'enable' => esc_html__('Enable ', 'reviewnews'),
      'disable' => esc_html__('Disable', 'reviewnews'),

    ),
    'priority'    => 130,
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_decoding_image_async_setting',
  array(
    'default'           => $default['global_decoding_image_async_setting'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_decoding_image_async_setting',
  array(
    'label'       => esc_html__('Image Async Decoding', 'reviewnews'),
    'description'       => esc_html__('Set to enhance rendering speed', 'reviewnews'),
    'section'     => 'site_layout_settings',
    'type'        => 'select',
    'choices'               => array(
      'enable' => esc_html__('Enable ', 'reviewnews'),
      'disable' => esc_html__('Disable', 'reviewnews'),

    ),
    'priority'    => 130,
  )
);



// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_scroll_to_top_position',
  array(
    'default' => $reviewnews_default['global_scroll_to_top_position'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_scroll_to_top_position',
  array(
    'label' => esc_html__('Scroll to Top Position', 'reviewnews'),
    'section' => 'site_layout_settings',
    'settings' => 'global_scroll_to_top_position',
    'type' => 'select',
    'choices' => array(
      'right' => esc_html__('Right', 'reviewnews'),
      'left' => esc_html__('Left', 'reviewnews'),

    ),
    'priority' => 130,
  )
);


// Global Section.
$wp_customize->add_section(
  'site_categories_settings',
  array(
    'title' => esc_html__('Categories Settings', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_show_categories',
  array(
    'default' => $reviewnews_default['global_show_categories'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_show_categories',
  array(
    'label' => esc_html__('Post Categories', 'reviewnews'),
    'section' => 'site_categories_settings',
    'type' => 'select',
    'choices' => array(
      'yes' => esc_html__('Show', 'reviewnews'),
      'no' => esc_html__('Hide', 'reviewnews'),

    ),
    'priority' => 130,
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_number_of_categories',
  array(
    'default' => $reviewnews_default['global_number_of_categories'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_number_of_categories',
  array(
    'label' => esc_html__('Categories to be displayed', 'reviewnews'),
    'section' => 'site_categories_settings',
    'type' => 'select',
    'choices' => array(
      'all' => esc_html__('Show All', 'reviewnews'),
      'one' => esc_html__('Top One Category', 'reviewnews'),

    ),
    'priority' => 130,
    'active_callback' => 'reviewnews_global_show_category_number_status'

  )
);

// Setting - sticky_header_option.
$wp_customize->add_setting(
  'global_custom_number_of_categories',
  array(
    'default' => $reviewnews_default['global_custom_number_of_categories'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'absint',
  )
);
$wp_customize->add_control(
  'global_custom_number_of_categories',
  array(
    'label' => esc_html__('Number of Categories', 'reviewnews'),
    'section' => 'site_categories_settings',
    'type' => 'number',
    'priority' => 130,
    'active_callback' => 'reviewnews_global_show_custom_category_number_status'
  )
);

// Global Section.
$wp_customize->add_section(
  'site_author_and_date_settings',
  array(
    'title' => esc_html__('Author and Date Settings', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_author_icon_gravatar_display_setting',
  array(
    'default' => $reviewnews_default['global_author_icon_gravatar_display_setting'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_author_icon_gravatar_display_setting',
  array(
    'label' => esc_html__('Author Icon', 'reviewnews'),
    'section' => 'site_author_and_date_settings',
    'type' => 'select',
    'choices' => array(
      'display-gravatar' => esc_html__('Show Gravatar', 'reviewnews'),
      'display-icon' => esc_html__('Show Icon', 'reviewnews'),
      'display-none' => esc_html__('None', 'reviewnews'),
    ),
    'priority' => 130,

  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_date_display_setting',
  array(
    'default' => $reviewnews_default['global_date_display_setting'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_date_display_setting',
  array(
    'label' => esc_html__('Date Format', 'reviewnews'),
    'section' => 'site_author_and_date_settings',
    'type' => 'select',
    'choices' => array(
      'default-date' => esc_html__('WordPress Default Date Format', 'reviewnews'),
      'theme-date' => esc_html__('Ago Date Format', 'reviewnews'),
    ),
    'priority' => 130,

  )
);


//========== minutes read count options ===============

// Global Section.
$wp_customize->add_section(
  'site_min_read_settings',
  array(
    'title' => esc_html__('Minutes Read Count', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_show_min_read',
  array(
    'default' => $reviewnews_default['global_show_min_read'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_show_min_read',
  array(
    'label' => esc_html__('Minutes Read Count', 'reviewnews'),
    'section' => 'site_min_read_settings',
    'type' => 'select',
    'choices' => array(
      'yes' => esc_html__('Show', 'reviewnews'),
      'no' => esc_html__('Hide', 'reviewnews'),

    ),
    'priority' => 130,
  )
);



// Global Section.
$wp_customize->add_section(
  'site_excerpt_settings',
  array(
    'title' => esc_html__('Excerpt Settings', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);



// Setting - related posts.
$wp_customize->add_setting(
  'global_read_more_texts',
  array(
    'default' => $reviewnews_default['global_read_more_texts'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  'global_read_more_texts',
  array(
    'label' => __('Global Excerpt Read More', 'reviewnews'),
    'section' => 'site_excerpt_settings',
    'type' => 'text',
    'priority' => 130,

  )
);


//============= Watch Online Section ==========
//section title
$wp_customize->add_setting(
  'show_watch_online_section_section_title',
  array(
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  new ReviewNews_Section_Title(
    $wp_customize,
    'show_watch_online_section_section_title',
    array(
      'label' => esc_html__("Primary Menu Section", 'reviewnews'),
      'section' => 'header_builder',
      'priority' => 100,

    )
  )
);

$wp_customize->add_setting(
  'show_primary_menu_desc',
  array(
    'default' => $reviewnews_default['show_primary_menu_desc'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'show_primary_menu_desc',
  array(
    'label' => esc_html__('Show Primary Menu Description', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'checkbox',
    'priority' => 100,

  )
);

$wp_customize->add_setting(
  'show_watch_online_section',
  array(
    'default' => $reviewnews_default['show_watch_online_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'show_watch_online_section',
  array(
    'label' => esc_html__('Enable Custom Menu Section', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'checkbox',
    'priority' => 100,
    'active_callback' => 'reviewnews_is_inactive_builder'

  )
);


// Setting - related posts.
$wp_customize->add_setting(
  'aft_custom_title',
  array(
    'default' => $reviewnews_default['aft_custom_title'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  'aft_custom_title',
  array(
    'label' => __('Title', 'reviewnews'),
    'section' => 'header_builder',
    'type' => 'text',
    'priority' => 100,
    'active_callback' => 'reviewnews_show_watch_online_section_status'
  )
);

// Setting - related posts.
$wp_customize->add_setting(
  'aft_custom_link',
  array(
    'default' => $reviewnews_default['aft_custom_link'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
  )
);

$wp_customize->add_control(
  'aft_custom_link',
  array(
    'label' => __('Link', 'reviewnews'),
    'section' => 'header_builder',
    'settings' => 'aft_custom_link',
    'type' => 'text',
    'priority' => 100,
    'active_callback' => 'reviewnews_show_watch_online_section_status'
  )
);


//========== single posts options ===============

// Single Section.
$wp_customize->add_section(
  'site_single_posts_settings',
  array(
    'title' => esc_html__('Single Post', 'reviewnews'),
    'priority' => 9,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);

// Setting - related posts.
$wp_customize->add_setting(
  'single_show_featured_image',
  array(
    'default' => $reviewnews_default['single_show_featured_image'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'single_show_featured_image',
  array(
    'label' => __('Show Featured Image', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'type' => 'checkbox',
    'priority' => 100,
  )
);


$wp_customize->add_setting(
  'single_featured_image_view',
  array(
    'default' => $reviewnews_default['single_featured_image_view'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);


$wp_customize->add_control(
  'single_featured_image_view',
  array(
    'label' => esc_html__('Featured Image Width', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'type' => 'select',
    'choices' => array(
      'full' => esc_html__('Full - Default', 'reviewnews'),
      'original' => esc_html__('Original', 'reviewnews')
    ),
    'priority' => 100,
    'active_callback' => 'reviewnews_featured_image_status'
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'global_single_content_mode',
  array(
    'default'           => $default['global_single_content_mode'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'global_single_content_mode',
  array(
    'label'       => esc_html__('Single Content Mode', 'reviewnews'),
    'section'     => 'site_single_posts_settings',
    'settings'     => 'global_single_content_mode',
    'type'        => 'select',
    'choices'               => array(
      'single-content-mode-default' => esc_html__('Default', 'reviewnews'),
      'single-content-mode-boxed' => esc_html__('Spacious', 'reviewnews'),
    ),
    'priority'    => 100,
  )
);






// Setting - trending posts.
$wp_customize->add_setting(
  'single_show_theme_author_bio',
  array(
    'default' => $default['single_show_theme_author_bio'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'single_show_theme_author_bio',
  array(
    'label' => __('Show Author Bio under Content', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'settings' => 'single_show_theme_author_bio',
    'type' => 'checkbox',
    'priority' => 100,
  )
);

// Setting - trending posts.
$wp_customize->add_setting(
  'single_show_tags_list',
  array(
    'default' => $default['single_show_tags_list'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'single_show_tags_list',
  array(
    'label' => __('Show Tags under Content', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'settings' => 'single_show_tags_list',
    'type' => 'checkbox',
    'priority' => 100,
  )
);


//Social share option

$wp_customize->add_setting(
  'single_social_share_section_title',
  array(
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  new reviewnews_Section_Title(
    $wp_customize,
    'single_social_share_section_title',
    array(
      'label' => esc_html__("Social Share Options", 'reviewnews'),
      'section' => 'site_single_posts_settings',
      'priority' => 100,

    )
  )
);

$wp_customize->add_setting(
  'single_post_social_share_type',
  array(
    'default' => $reviewnews_default['single_post_social_share_type'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'single_post_social_share_type',
  array(
    'label' => esc_html__('Defined Links', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'type' => 'select',
    'choices' => array(
      'theme' => esc_html__('Theme', 'reviewnews'),
      'jetpack' => esc_html__('JetPack', 'reviewnews'),
      'none' => esc_html__('None', 'reviewnews'),
    ),
    'priority' => 100,
  )
);
$wp_customize->add_setting(
  'single_post_social_share_view',
  array(
    'default' => $reviewnews_default['single_post_social_share_view'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'single_post_social_share_view',
  array(
    'label' => esc_html__('Position', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'type' => 'select',
    'choices' => array(      
      'after-title-default' => esc_html__('Before Content', 'reviewnews'),
      'after-content' => esc_html__('After Content', 'reviewnews'),
    ),
    'priority' => 100,
    'active_callback' => 'reviewnews_single_post_social_share_status'
  )
);

//========== related posts  options ===============

$wp_customize->add_setting(
  'single_related_posts_section_title',
  array(
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  new ReviewNews_Section_Title(
    $wp_customize,
    'single_related_posts_section_title',
    array(
      'label' => esc_html__("Related Posts Settings", 'reviewnews'),
      'section' => 'site_single_posts_settings',
      'priority' => 100,

    )
  )
);

// Setting - related posts.
$wp_customize->add_setting(
  'single_show_related_posts',
  array(
    'default' => $reviewnews_default['single_show_related_posts'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'single_show_related_posts',
  array(
    'label' => __('Enable Related Posts', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'type' => 'checkbox',
    'priority' => 100,
  )
);

// Setting - related posts.
$wp_customize->add_setting(
  'single_related_posts_title',
  array(
    'default' => $reviewnews_default['single_related_posts_title'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  'single_related_posts_title',
  array(
    'label' => __('Title', 'reviewnews'),
    'section' => 'site_single_posts_settings',
    'settings' => 'single_related_posts_title',
    'type' => 'text',
    'priority' => 100,
    'active_callback' => 'reviewnews_related_posts_status'
  )
);



/**
 * Archive options section
 *
 * @package ReviewNews
 */

// Archive Section.
$wp_customize->add_section(
  'site_archive_settings',
  array(
    'title' => esc_html__('Archive Settings', 'reviewnews'),
    'priority' => 9,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Disable main banner in blog
$wp_customize->add_setting(
  'disable_main_banner_on_blog_archive',
  array(
    'default'           => $default['disable_main_banner_on_blog_archive'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'disable_main_banner_on_blog_archive',
  array(
    'label'    => esc_html__('Disable Main Banner on Blog', 'reviewnews'),
    'section'  => 'site_archive_settings',
    'type'     => 'checkbox',
    'priority' => 50,
    'active_callback' => 'reviewnews_main_banner_section_status'
  )
);

//Setting - archive content view of news.
$wp_customize->add_setting(
  'archive_layout',
  array(
    'default' => $reviewnews_default['archive_layout'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'archive_layout',
  array(
    'label' => esc_html__('Archive layout', 'reviewnews'),
    'description' => esc_html__('Select layout for archive', 'reviewnews'),
    'section' => 'site_archive_settings',
    'settings' => 'archive_layout',
    'type' => 'select',
    'choices' => array(
      'archive-layout-grid' => esc_html__('grid', 'reviewnews'),
      'archive-layout-full' => esc_html__('Full', 'reviewnews'),

    ),
    'priority' => 130,
  )
);


// Setting - archive content view of news.
$wp_customize->add_setting(
  'archive_image_alignment',
  array(
    'default' => $reviewnews_default['archive_image_alignment'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'archive_image_alignment',
  array(
    'label' => esc_html__('Image Alignment', 'reviewnews'),
    'description' => esc_html__('Select image alignment for archive', 'reviewnews'),
    'section' => 'site_archive_settings',
    'type' => 'select',
    'choices' => array(
      'archive-image-left' => esc_html__('Left', 'reviewnews'),
      'archive-image-right' => esc_html__('Right', 'reviewnews'),
    ),
    'priority' => 130,
    'active_callback' => 'reviewnews_archive_image_status'
  )
);




//Setting - archive content view of news.
$wp_customize->add_setting(
  'archive_content_view',
  array(
    'default' => $reviewnews_default['archive_content_view'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'archive_content_view',
  array(
    'label' => esc_html__('Content View', 'reviewnews'),
    'description' => esc_html__('Select content view for archive', 'reviewnews'),
    'section' => 'site_archive_settings',
    'type' => 'select',
    'choices' => array(
      'archive-content-excerpt' => esc_html__('Post Excerpt', 'reviewnews'),
      'archive-content-full' => esc_html__('Full Content', 'reviewnews'),
      'archive-content-none' => esc_html__('None', 'reviewnews'),

    ),
    'priority' => 130,
  )
);

// Breadcrumb Section.
$wp_customize->add_section(
  'site_search_settings',
  array(
    'title' => esc_html__('Search Options', 'reviewnews'),
    'priority' => 9,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
  )
);


//Setting - archive content view of news.
$wp_customize->add_setting(
  'search_archive_content_view',
  array(
    'default' => $reviewnews_default['search_archive_content_view'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'search_archive_content_view',
  array(
    'label' => esc_html__('Search Results', 'reviewnews'),
    'description' => esc_html__('Select search results for archive', 'reviewnews'),
    'section' => 'site_search_settings',
    'type' => 'select',
    'choices' => array(
      'all' => esc_html__('All (Pages, Posts, etc)', 'reviewnews'),
      'posts' => esc_html__('Posts', 'reviewnews')
    ),
    'priority' => 130,
  )
);


//Setting - archive content view of news.
$wp_customize->add_setting(
  'search_archive_enable_ajax',
  array(
    'default' => $reviewnews_default['search_archive_enable_ajax'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'absint',
  )
);

$wp_customize->add_control(
  'search_archive_enable_ajax',
  array(
    'label' => esc_html__('Ajax Results Dropdown', 'reviewnews'),    
    'section' => 'site_search_settings',
    'type' => 'checkbox',
    'priority' => 130,
  )
);



//========== sidebar blocks options ===============

// Trending Section.
$wp_customize->add_section(
  'sidebar_block_settings',
  array(
    'title' => esc_html__('Sidebar Settings', 'reviewnews'),
    'priority' => 9,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting - frontpage_sticky_sidebar.
$wp_customize->add_setting(
  'frontpage_sticky_sidebar',
  array(
    'default' => $default['frontpage_sticky_sidebar'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'frontpage_sticky_sidebar',
  array(
    'label' => esc_html__('Make Sidebar Sticky', 'reviewnews'),
    'section' => 'sidebar_block_settings',
    'type' => 'checkbox',
    'priority' => 100,

  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'frontpage_sticky_sidebar_position',
  array(
    'default' => $default['frontpage_sticky_sidebar_position'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_select',
  )
);

$wp_customize->add_control(
  'frontpage_sticky_sidebar_position',
  array(
    'label' => esc_html__('Sidebar Sticky Position', 'reviewnews'),
    'section' => 'sidebar_block_settings',
    'type' => 'select',
    'choices' => array(
      'sidebar-sticky-top' => esc_html__('Top', 'reviewnews'),
      'sidebar-sticky-bottom' => esc_html__('Bottom', 'reviewnews'),
    ),
    'priority' => 100,
    'active_callback' => 'frontpage_sticky_sidebar_status'
  )
);

//========== footer latest blog carousel options ===============

// Footer Section.



$wp_customize->add_section(
  'frontpage_latest_posts_settings',
  array(
    'title' => esc_html__('You May Have Missed', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'theme_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);
// Setting - latest blog carousel.
$wp_customize->add_setting(
  'frontpage_show_latest_posts',
  array(
    'default' => $reviewnews_default['frontpage_show_latest_posts'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'frontpage_show_latest_posts',
  array(
    'label' => __('Show Above Footer', 'reviewnews'),
    'section' => 'frontpage_latest_posts_settings',
    'type' => 'checkbox',
    'priority' => 100,
  )
);


// Setting - featured_news_section_title.
$wp_customize->add_setting(
  'frontpage_latest_posts_section_title',
  array(
    'default' => $reviewnews_default['frontpage_latest_posts_section_title'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'frontpage_latest_posts_section_title',
  array(
    'label' => esc_html__('Posts Section Title', 'reviewnews'),
    'section' => 'frontpage_latest_posts_settings',
    'settings' => 'frontpage_latest_posts_section_title',
    'type' => 'text',
    'priority' => 100,
    'active_callback' => 'reviewnews_latest_news_section_status'

  )
);



//========== footer section options ===============


// Add Front-page Options Panel.
$wp_customize->add_panel(
  'site_footer_option_panel',
  array(
    'title' => esc_html__('Footer Options', 'reviewnews'),
    'priority' => 198,
    'capability' => 'edit_theme_options',
    'type'     => 'reviewnews-panel',
  )
);

// Footer Section.
$wp_customize->add_section(
  'site_footer_settings',
  array(
    'title' => esc_html__('Footer', 'reviewnews'),
    'priority' => 50,
    'capability' => 'edit_theme_options',
    'panel' => 'site_footer_option_panel',
    'class'       => 'reviewnews-customizer-section',
  )
);


// Setting banner_advertisement_section.
$wp_customize->add_setting(
  'footer_background_image',
  array(
    'default' => $default['footer_background_image'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'absint',
  )
);


$wp_customize->add_control(
  new WP_Customize_Cropped_Image_Control(
    $wp_customize,
    'footer_background_image',
    array(
      'label' => esc_html__('Footer Background Image', 'reviewnews'),
      'description' => esc_html(sprintf(__('Recommended Size %1$s px X %2$s px', 'reviewnews'), 1024, 800)),
      'section' => 'footer_builder',
      'width' => 1024,
      'height' => 800,
      'flex_width' => true,
      'flex_height' => true,
      'priority' => 100,
    )
  )
);

// Setting - global content alignment of news.
$wp_customize->add_setting(
  'footer_copyright_text',
  array(
    'default' => $reviewnews_default['footer_copyright_text'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
  )
);

$wp_customize->add_control(
  'footer_copyright_text',
  array(
    'label' => __('Copyright Text', 'reviewnews'),
    'section' => 'footer_builder',
    'settings' => 'footer_copyright_text',
    'type' => 'text',
    'priority' => 100,
  )
);


// Setting - global content alignment of news.
$wp_customize->add_setting(
  'hide_footer_menu_section',
  array(
    'default' => $reviewnews_default['hide_footer_menu_section'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'reviewnews_sanitize_checkbox',
  )
);

$wp_customize->add_control(
  'hide_footer_menu_section',
  array(
    'label' => __('Hide footer Menu Section', 'reviewnews'),
    'section' => 'footer_builder',
    'type' => 'checkbox',
    'priority' => 100,
  )
);
