<?php
/**
 * The template for displaying comments
 *
 * Description: The area of the page that contains both current comments
 * and the comment form.
 *
 * @package retrogeek
 * @since 22.02.2021
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">
	<?php if ( have_comments() ) : ?>
	<hr>
	<h5 class="comments-title">
		<?php
		$comments_number = get_comments_number();
		if ( '1' === $comments_number ) {
			/* translators: %s: Post title. */
			printf(
				esc_attr(
					/* translators: 1: heading for comments */
					_x(
						'One thought on &ldquo;%s&rdquo;',
						'comments title',
						'retrogeek'
					)
				),
				esc_attr(
					get_the_title()
				)
			);
		} else {
			printf(
				esc_attr(
					/* translators: 1: Number of comments, 2: Post title. */
					_nx(
						'%1$s thought on &ldquo;%2$s&rdquo;',
						'%1$s thoughts on &ldquo;%2$s&rdquo;',
						$comments_number,
						'comments title',
						'retrogeek'
					)
				),
				esc_attr( number_format_i18n( $comments_number ) ),
				esc_attr(
					get_the_title()
				)
			);
		}
		?>
		</h5>

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
				wp_list_comments(
					array(
						'type'        => 'all',
						'style'       => 'ol',
						'short_ping'  => true,
						'avatar_size' => 42,
					)
				);
			?>
		</ol><!-- .comment-list -->

		<?php the_comments_navigation(); ?>

	<?php endif; // Check for have_comments(). ?>

	<?php
		// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
	<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'retrogeek' ); ?></p>
	<?php endif; ?>

	<?php
		comment_form(
			array(
				'title_reply_before' => '<h5 id="reply-title" class="comment-reply-title">',
				'title_reply_after'  => '</h5>',
			)
		);
		?>

</div><!-- .comments-area -->
