<?php
/**
 * Exit if accessed directly.
 *
 * @package Responsive
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Define constants.
 */
define( 'RESPONSIVE_THEME_VERSION', '6.3.1' );
define( 'RESPONSIVE_THEME_DIR', trailingslashit( get_template_directory() ) );
define( 'RESPONSIVE_THEME_URI', trailingslashit( esc_url( get_template_directory_uri() ) ) );
define( 'RESPONSIVE_PRO_OLDER_VERSION_CHECK', '2.4.2' );

/**
 *
 * WARNING: Please do not edit this file in any way
 *
 * Load the theme function files
 */
global $responsive_blog_layout_columns;
$responsive_blog_layout_columns = array( 'blog-2-col', 'blog-3-col', 'blog-4-col' );

$responsive_template_directory = get_template_directory();
require $responsive_template_directory . '/core/includes/functions.php';
require $responsive_template_directory . '/core/includes/functions-update.php';
require $responsive_template_directory . '/core/includes/functions-sidebar.php';
require $responsive_template_directory . '/core/includes/functions-install.php';
require $responsive_template_directory . '/core/includes/functions-admin.php';
require $responsive_template_directory . '/core/includes/functions-extras.php';
require $responsive_template_directory . '/core/includes/functions-extensions.php';
require $responsive_template_directory . '/core/includes/theme-options/theme-options.php';
require $responsive_template_directory . '/core/includes/post-custom-meta.php';
require $responsive_template_directory . '/core/includes/hooks.php';
require $responsive_template_directory . '/core/includes/version.php';
require $responsive_template_directory . '/core/includes/customizer/controls/typography/webfonts.php';
require $responsive_template_directory . '/core/includes/customizer/helper.php';
require $responsive_template_directory . '/core/includes/customizer/customizer.php';
require $responsive_template_directory . '/core/includes/customizer/custom-styles.php';
require $responsive_template_directory . '/core/includes/classes/class-responsive-local-fonts.php';
require $responsive_template_directory . '/core/includes/compatibility/woocommerce/class-responsive-woocommerce.php';
require $responsive_template_directory . '/core/includes/compatibility/sensei/class-responsive-sensei.php';
require $responsive_template_directory . '/admin/admin-functions.php';
require $responsive_template_directory . '/core/includes/classes/class-responsive-mobile-menu-markup.php';
require $responsive_template_directory . '/core/includes/classes/class-responsive-local-fonts.php';
if ( ! class_exists( 'Responsive_Addons_Pro' ) ) {
	require $responsive_template_directory . '/core/includes/classes/class-responsive-blog-markup.php';
}
require $responsive_template_directory . '/core/gutenberg/gutenberg-support.php';
require $responsive_template_directory . '/core/includes/compatibility/lifterlms/class-responsive-lifterlms.php';
require $responsive_template_directory . '/core/includes/modules/related-posts/class-responsive-related-posts.php';
require $responsive_template_directory . '/core/includes/modules/color-palette/class-responsive-global-color-palette.php';
// Deprecated functions.
require $responsive_template_directory . '/core/includes/functions-deprecated.php';
// Custom page walker.
require $responsive_template_directory . '/core/includes/classes/class-responsive-walker-page.php';
require $responsive_template_directory . '/admin/starter-custom-page/responsive-home-starter-content.php';

if ( is_admin() ) {
	/**
	 * Admin Menu Settings
	 */
	require_once $responsive_template_directory . '/core/includes/classes/class-responsive-admin-settings.php';
}

/**
 * Run setup functions.
 */
Responsive\setup();
Responsive\Admin\setup();
Responsive\Customizer\setup();
Responsive\Core\setup();
Responsive\Extra\setup();
if ( class_exists( 'WooCommerce' ) ) {
	Responsive\WooCommerce\setup();
}

// Admin-post handler to flush local fonts cache.
add_action( 'admin_post_responsive_flush_local_fonts', function() {
    if ( ! current_user_can( 'manage_options' ) ) {
        wp_die( esc_html__( 'Unauthorized request.', 'responsive' ) );
    }
    check_admin_referer( 'responsive_flush_local_fonts' );
    if ( class_exists( 'Responsive_Local_Fonts' ) ) {
        Responsive_Local_Fonts::flush_cache();
    }
    wp_safe_redirect( wp_get_referer() ? wp_get_referer() : admin_url( 'customize.php' ) );
    exit;
} );

/**
 * Return value of the supplied responsive free theme option.
 *
 * @param  string   $option  options.
 * @param  boolean $default flag.
 */
function responsive_free_get_option( $option, $default = false ) {
	global $responsive_options;

	// If the option is set then return it's value, otherwise return false.
	if ( isset( $responsive_options[ $option ] ) ) {
		return $responsive_options[ $option ];
	}

	return $default;
}


/**
 * Set the $content_width global variable used by WordPress to set image dimennsions.
 *
 * @return void
 */
function responsive_setup_content_width() {
	global $content_width;

	/**
	 * Content Width
	 */
	if ( ( 'contained' === get_theme_mod( 'responsive_width', 'contained' ) ) ) {
		$container_max_width = esc_html( get_theme_mod( 'responsive_container_width', 1140 ) );

		// Helper to resolve sidebar position with "default" fallback
		$get_sidebar_position = function( $context, $fallback = 'no' ) {
			$global = get_theme_mod( 'responsive_default_sidebar_position', 'no' );
			$value  = get_theme_mod( "responsive_{$context}_sidebar_position", $fallback );
			return ( $value === 'default' ) ? $global : $value;
		};

		if ( is_page() && ( class_exists( 'WooCommerce' ) && ( ! is_cart() && ! is_checkout() ) ) ) {

			$sidebar_position = $get_sidebar_position( 'page', 'no' );

			if ( 'no' !== $sidebar_position ) {
				$page_content_width = esc_html( get_theme_mod( 'responsive_page_content_width', 66 ) );
				$content_width      = ( $page_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}

		} elseif ( is_single() ) {

			$sidebar_position = $get_sidebar_position( 'single_blog', 'no' );

			if ( 'no' !== $sidebar_position ) {
				$single_content_width = esc_html( get_theme_mod( 'responsive_single_blog_content_width', 66 ) );
				$content_width        = ( $single_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}

		} else {

			$sidebar_position = $get_sidebar_position( 'blog', 'no' );

			if ( 'no' !== $sidebar_position ) {
				$blog_content_width = esc_html( get_theme_mod( 'responsive_blog_content_width', Responsive\Core\get_responsive_customizer_defaults( 'blog_content_width' ) ) );
				$content_width      = ( $blog_content_width / 100 ) * $container_max_width;
			} else {
				$content_width = $container_max_width;
			}
		}


		if ( class_exists( 'WooCommerce' ) ) {

			// Global default sidebar position
			$global_sidebar_position = get_theme_mod( 'responsive_default_sidebar_position', 'no' );

			$resolve_sidebar_position = function( $context_setting ) use ( $global_sidebar_position ) {
				$value = get_theme_mod( $context_setting, 'default' );
				return ( $value === 'default' ) ? $global_sidebar_position : $value;
			};

			if ( is_product() ) {
				$sidebar_position = $resolve_sidebar_position( 'responsive_single_product_sidebar_position' );
				if ( $sidebar_position !== 'no' ) {
					$content_width = ( floatval( get_theme_mod( 'responsive_single_product_content_width', 100 ) ) / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}

			} elseif ( is_shop() ) {
				$sidebar_position = $resolve_sidebar_position( 'responsive_shop_sidebar_position' );
				if ( $sidebar_position !== 'no' ) {
					$content_width = ( floatval( get_theme_mod( 'responsive_shop_content_width', Responsive\Core\get_responsive_customizer_defaults( 'shop_content_width' ) ) ) / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}

			} elseif ( is_cart() ) {
				$sidebar_position = $resolve_sidebar_position( 'responsive_cart_sidebar_position' );
				if ( $sidebar_position !== 'no' ) {
					$content_width = ( floatval( get_theme_mod( 'responsive_cart_content_width', 70 ) ) / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}

			} elseif ( is_checkout() ) {
				$sidebar_position = $resolve_sidebar_position( 'responsive_checkout_sidebar_position' );
				if ( $sidebar_position !== 'no' ) {
					$content_width = ( floatval( get_theme_mod( 'responsive_checkout_content_width', 70 ) ) / 100 ) * $container_max_width;
				} else {
					$content_width = $container_max_width;
				}
			}
		}

	}
}
add_action( 'wp', 'responsive_setup_content_width' );

/**
 * Responsive_free_setup
 */
function responsive_free_setup() {
	add_theme_support( 'title-tag' );
	add_theme_support( 'sensei' );

	// Adding Gutenberg support.
	add_theme_support( 'align-wide' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'editor-styles' );
	add_editor_style( 'core/css/gutenberg-editor.css' );
	// Gutenberg editor color palette.
	add_theme_support( 'editor-color-palette', responsive_gutenberg_color_palette() );

	// Render Custom Starter content.
	if ( class_exists( 'Responsive_Home_Starter_Content', false ) ) {
		$responsive_home_starter_content = new Responsive_Home_Starter_Content();
		add_theme_support( 'starter-content', $responsive_home_starter_content->get() );
	}

	$small_font_sizes  = get_theme_mod( 'meta_typography' );
	$normal_sizes      = get_theme_mod( 'body_typography' );
	$larger_font_sizes = get_theme_mod( 'heading_h1_typography' );
	$large_font_sizes  = get_theme_mod( 'heading_h2_typography' );
	if ( isset( $small_font_sizes['font-size'] ) ) {
		$small_font_sizes_default_value = ( $small_font_sizes && isset( $small_font_sizes['font-size'] ) ) ? str_replace( 'px', '', $small_font_sizes['font-size'] ) : '12';
	} else {
		$small_font_sizes_default_value = 13;
	}
	if ( isset( $normal_sizes['font-size'] ) ) {
		$normal_sizes_default_value = ( $normal_sizes && isset( $normal_sizes['font-size'] ) ) ? typography_unit_conversion( $normal_sizes['font-size'], 16) : '16';
	} else {
		$normal_sizes_default_value = 16;
	}
	if ( isset( $larger_font_sizes['font-size'] ) ) {
		if ( false === strpos( $larger_font_sizes['font-size'], 'px' ) ) {
			$larger_font_sizes_default_value = ( $larger_font_sizes && isset( $larger_font_sizes['font-size'] ) ) ?  $larger_font_sizes['font-size']  : '2.625em';
		} else {
			$larger_font_sizes_default_value = $larger_font_sizes['font-size'] ;
		}
		$larger_font_sizes_default_value = typography_unit_conversion($larger_font_sizes_default_value,$normal_sizes_default_value,$normal_sizes_default_value);

	} else {
		$larger_font_sizes_default_value = 33;
	}

	if ( isset( $large_font_sizes['font-size'] ) ) {
	
		if ( false === strpos( $large_font_sizes['font-size'], 'px' ) ) {
			$large_font_sizes_default_value = ( $large_font_sizes && isset( $large_font_sizes['font-size'] ) ) ?  $large_font_sizes['font-size'] : '2.250em';
		} else {
			$large_font_sizes_default_value = $large_font_sizes['font-size'] ;
		}
		$large_font_sizes_default_value = typography_unit_conversion($large_font_sizes_default_value,$normal_sizes_default_value,$normal_sizes_default_value);
	} else {
		$large_font_sizes_default_value = 26;
	}
	add_theme_support(
		'editor-font-sizes',
		array(
			array(
				'name'      => _x( 'Small', 'Name of the small font size in the block editor', 'responsive' ),
				'shortName' => _x( 'S', 'Short name of the small font size in the block editor.', 'responsive' ),
				'size'      => $small_font_sizes_default_value,
				'slug'      => 'small',
			),
			array(
				'name'      => _x( 'Regular', 'Name of the regular font size in the block editor', 'responsive' ),
				'shortName' => _x( 'M', 'Short name of the regular font size in the block editor.', 'responsive' ),
				'size'      => $normal_sizes_default_value,
				'slug'      => 'normal',
			),
			array(
				'name'      => _x( 'Large', 'Name of the large font size in the block editor', 'responsive' ),
				'shortName' => _x( 'L', 'Short name of the large font size in the block editor.', 'responsive' ),
				'size'      => $large_font_sizes_default_value,
				'slug'      => 'large',
			),
			array(
				'name'      => _x( 'Larger', 'Name of the larger font size in the block editor', 'responsive' ),
				'shortName' => _x( 'XL', 'Short name of the larger font size in the block editor.', 'responsive' ),
				'size'      => $larger_font_sizes_default_value,
				'slug'      => 'larger',
			),
		)
	);
}
add_action( 'after_setup_theme', 'responsive_free_setup' );

/**
 * Edit Customize Register
 *
 * @param array $wp_customize WP Customize.
 */
function responsive_edit_customize_register( $wp_customize ) {
	$wp_customize->selective_refresh->add_partial(
		'blogname',
		array(
			'selector' => '.site-name a',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'blogdescription',
		array(
			'selector' => '.site-description',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_headline]',
		array(
			'selector' => '.featured-title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_subheadline]',
		array(
			'selector' => '.featured-subtitle',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[cta_text]',
		array(
			'selector' => '.call-to-action',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[banner_image]',
		array(
			'selector' => '#featured',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_title]',
		array(
			'selector' => '#about_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_text]',
		array(
			'selector' => '.about_text',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[about_cta_text]',
		array(
			'selector' => '.about-cta-button',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[feature_title]',
		array(
			'selector' => '#feature_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[testimonial_title]',
		array(
			'selector' => '#testimonial_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[team_title]',
		array(
			'selector' => '#team_div .section_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'nav_menu_locations[top]',
		array(
			'selector' => '.main-nav',
		)
	);

	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-1]',
		array(
			'selector' => '#home_widget_1',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-2]',
		array(
			'selector' => '#home_widget_2',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[home-widget-3]',
		array(
			'selector' => '#home_widget_3',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[featured_content]',
		array(
			'selector' => '#featured-image',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[home_content_area]',
		array(
			'selector' => '#featured-content p',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_title]',
		array(
			'selector' => '.contact_title',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_subtitle]',
		array(
			'selector' => '.contact_subtitle',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_add]',
		array(
			'selector' => '.contact_add',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_email]',
		array(
			'selector' => '.contact_email',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_ph]',
		array(
			'selector' => '.contact_ph',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_theme_options[contact_content]',
		array(
			'selector' => '.contact_right',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'header_image',
		array(
			'selector' => '#site-branding',

		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_date_box_toggle',
		array(
			'selector' => '.responsive-date-box',
		)
	);
	// $wp_customize->selective_refresh->add_partial(
	// 	'responsive_hamburger_menu_label_text',
	// 	array(
	// 		'selector'            => '.hamburger-menu-label',
	// 		'container_inclusive' => false,
	// 		'render_callback'     => function() {
	// 			printf( esc_html( responsive_hamburger_menu_label() ) );
	// 		},
	// 		'fallback_refresh'    => true,
	// 	)
	// );
	$wp_customize->selective_refresh->add_partial(
		'responsive_hamburger_off_canvas_btn_label_text',
		array(
			'selector'            => '.off-canvas-filter-text',
			'container_inclusive' => false,
			'render_callback'     => function() {
				printf( esc_html( responsive_hamburger_off_canvas_btn_label_text_label() ) );
			},
			'fallback_refresh'    => true,
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'footer_copyright',
		array(
			'selector' => '.footer-layouts.copyright',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_header_above_row_tabs',
		array(
			'selector' => '.responsive-site-above-header-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_header_primary_row_tabs',
		array(
			'selector' => '.responsive-site-primary-header-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_header_below_row_tabs',
		array(
			'selector' => '.responsive-site-below-header-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_footer_above_row_tabs',
		array(
			'selector' => '.rspv-site-above-footer-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_footer_primary_row_tabs',
		array(
			'selector' => '.rspv-site-primary-footer-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_footer_below_row_tabs',
		array(
			'selector' => '.rspv-site-below-footer-wrap',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_header_search_tabs',
		array(
			'selector' => '.responsive-header-search',
		)
	);
	$wp_customize->selective_refresh->add_partial(
		'responsive_header_woo_cart_tabs',
		array(
			'selector' => '.responsive-header-cart',
		)
	);
}
add_action( 'customize_register', 'responsive_edit_customize_register' );
add_theme_support( 'customize-selective-refresh-widgets' );

/**
 * Custom Category Widget
 *
 * @param array $arg Arguments.
 * @return mixed
 */
function responsive_custom_category_widget( $arg ) {
	$cat = get_theme_mod( 'exclude_post_cat' );

	if ( $cat ) {
		$cat            = array_diff( array_unique( $cat ), array( '' ) );
		$arg['exclude'] = $cat;
	}
	return $arg;
}
add_filter( 'widget_categories_args', 'responsive_custom_category_widget' );
add_filter( 'widget_categories_dropdown_args', 'responsive_custom_category_widget' );

/**
 * Exclude post category recent post widget
 *
 * @param array $array Array.
 * @return mixed
 */
function responsive_exclude_post_cat_recentpost_widget( $array ) {
	$s   = '';
	$i   = 1;
	$cat = get_theme_mod( 'exclude_post_cat' );

	if ( $cat ) {
		$cat = array_diff( array_unique( $cat ), array( '' ) );
		foreach ( $cat as $c ) {
			$i++;
			$s .= '-' . $c;
			if ( count( $cat ) >= $i ) {
				$s .= ', ';
			}
		}
	}

	$array['cat'] = array( $s );

	return $array;
}
add_filter( 'widget_posts_args', 'responsive_exclude_post_cat_recentpost_widget' );

if ( ! function_exists( 'responsive_page_featured_image' ) ) :

	/**
	 * Featured image
	 */
	function responsive_page_featured_image() {
		// check if the page has a Post Thumbnail assigned to it.
		if ( has_post_thumbnail() ) {
			?>
						<div class="featured-image">
						<?php /* translators: 1 : Permalink, 2 : Title */ ?>
							<a href="<?php the_permalink(); ?>" aria-label="<?php printf( esc_attr__( 'Permalink to %s', 'responsive' ), the_title_attribute( 'echo=0' ) ); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'responsive' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark" <?php responsive_schema_markup( 'url' ); ?>>
								<?php	the_post_thumbnail(); ?>
							</a>
						</div>
					<?php
		}
	}

endif;

/**
 * Exclude post with Category from blog and archive page.
 */
if ( ! function_exists( 'responsive_exclude_post_cat' ) ) :
	/**
	 * Exclude post with Category from blog and archive page.
	 *
	 * @param  object $query Query.
	 */
	function responsive_exclude_post_cat( $query ) {
		$cat                = get_theme_mod( 'exclude_post_cat' );

		if ( $cat && ! is_admin() && $query->is_main_query() ) {
			if ( ! array( $cat ) ) {
				$cat = array( $cat );
			}
			$cat = array_diff( array_unique( $cat ), array( '' ) );
			if ( $query->is_home() || $query->is_archive() ) {
				$query->set( 'category__not_in', $cat );
			}
		}
	}
endif;
add_action( 'pre_get_posts', 'responsive_exclude_post_cat', 10 );

/**
 * Enqueue customizer styling
 */
function responsive_controls_style() {
	$suffix = '';
	if ( is_rtl() ) {
		$suffix = '-rtl';
	}
	wp_enqueue_style( 'responsive-blocks', get_template_directory_uri() . '/core/css/customizer' . $suffix . '.css', RESPONSIVE_THEME_VERSION, 'all' );
}

add_action( 'customize_controls_print_styles', 'responsive_controls_style' );

/**
 * Add rating links to the admin dashboard
 *
 * @param string $footer_text The existing footer text.
 *
 * @return      string
 * @since        2.0.6
 * @global        string $typenow
 */
function responsive_admin_rate_us( $footer_text ) {
	$page        = isset( $_GET['page'] ) ? $_GET['page'] : ''; //phpcs:ignore
	$show_footer = array( 'responsive-options' );

	if ( in_array( $page, $show_footer, true ) ) {
		$rate_text = sprintf(
			/* translators: %s Link to 5 star rating */
			__( 'If you like <strong>Responsive Theme</strong> please leave us a %s rating. It takes a minute and helps a lot. Thanks in advance!', 'responsive' ),
			'<a href="https://wordpress.org/support/theme/responsive/reviews/#new-post" target="_blank" class="responsive-rating-link" style="text-decoration:none;" data-rated="' . esc_attr__( 'Thanks :)', 'responsive' ) . '">&#9733;&#9733;&#9733;&#9733;&#9733;</a>'
		);

		return $rate_text;
	} else {
		return $footer_text;
	}
}

add_filter( 'admin_footer_text', 'responsive_admin_rate_us' );


if ( ! get_option( 'responsive_version_410' ) ) {


	/**
	 * Check the responsive version is above 4.1.0.
	 * Change the value layout if it is fullwidth_without_box.
	 */
	function responsive_check_previous_version() {
		$theme_data = wp_get_theme();

		$is_child = is_child_theme( $theme_data );

		if ( $is_child ) {
			$new_version = $theme_data->parent()->get( 'Version' );
		} else {
			$new_version = $theme_data->get( 'Version' );
		}

		global $responsive_options;
		$responsive_options = Responsive\Core\responsive_get_options();
		$header_layout      = get_theme_mod( 'header_layout_options' );
		$menu_position      = get_theme_mod( 'menu_position' );

		// Check if we had a response and compare the current version on wp.org to version 2. If it is version 2 or greater display a message.
		if ( $new_version && version_compare( $new_version, '4.1.0', '>=' ) ) {

			if ( ! $responsive_options['home_headline'] ) {
				$responsive_options['home_headline'] = __( 'HAPPINESS', 'responsive' );
			}
			if ( ! $responsive_options['home_subheadline'] ) {
				$responsive_options['home_subheadline'] = __( 'IS A WARM CUP', 'responsive' );
			}
			if ( ! $responsive_options['home_content_area'] ) {
				$responsive_options['home_content_area'] = __( 'Your title, subtitle and this very content is editable from Theme Option. Call to Action button and its destination link as well. Image on your right can be an image or even YouTube video if you like.', 'responsive' );
			}
			if ( ! $responsive_options['cta_text'] ) {
				$responsive_options['cta_text'] = __( 'Call to Action', 'responsive' );
			}
			if ( ! $responsive_options['cta_url'] ) {
				$responsive_options['cta_url'] = __( '#', 'responsive' );
			}

			( ! get_theme_mod( 'responsive_hide_tagline' ) && get_theme_mod( 'res_hide_tagline' ) ) ? set_theme_mod( 'responsive_hide_tagline', get_theme_mod( 'res_hide_tagline', 1 ) ) : '';
			( ! get_theme_mod( 'responsive_hide_title' ) && get_theme_mod( 'res_hide_site_title' ) ) ? set_theme_mod( 'responsive_hide_title', get_theme_mod( 'res_hide_site_title', 0 ) ) : '';

			( ! get_theme_mod( 'responsive_button_color' ) && get_theme_mod( 'button-color' ) ) ? set_theme_mod( 'responsive_button_color', get_theme_mod( 'button-color', '#0066CC' ) ) : '';
			( ! get_theme_mod( 'responsive_button_hover_color' ) && get_theme_mod( 'button-hover-color' ) ) ? set_theme_mod( 'responsive_button_hover_color', get_theme_mod( 'button-hover-color', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_button_text_color' ) && get_theme_mod( 'button-text-color' ) ) ? set_theme_mod( 'responsive_button_text_color', get_theme_mod( 'button-text-color', '#FFFFFF' ) ) : '';
			( ! get_theme_mod( 'responsive_button_hover_text_color' ) && get_theme_mod( 'button-hover-text-color' ) ) ? set_theme_mod( 'responsive_button_hover_text_color', get_theme_mod( 'button-hover-text-color', '#FFFFFF' ) ) : '';

			( ! get_theme_mod( 'responsive_inputs_background_color' ) && get_theme_mod( 'input-background-color' ) ) ? set_theme_mod( 'responsive_inputs_background_color', get_theme_mod( 'input-background-color', '#FFFFFF' ) ) : '';
			( ! get_theme_mod( 'responsive_inputs_text_color' ) && get_theme_mod( 'input-text-color' ) ) ? set_theme_mod( 'responsive_inputs_text_color', get_theme_mod( 'input-text-color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_inputs_border_color' ) && get_theme_mod( 'input-border-color' ) ) ? set_theme_mod( 'responsive_inputs_border_color', get_theme_mod( 'input-border-color', '#cccccc' ) ) : '';

			( ! get_theme_mod( 'responsive_label_color' ) && get_theme_mod( 'label-color' ) ) ? set_theme_mod( 'responsive_label_color', get_theme_mod( 'label-color', '#333333' ) ) : '';

			( ! get_theme_mod( 'responsive_header_menu_background_color' ) && get_theme_mod( 'responsive_menu_background_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_background_color', get_theme_mod( 'responsive_menu_background_colorpicker', '#ffffff' ) ) : '';
			( ! get_theme_mod( 'responsive_header_active_menu_background_color' ) && get_theme_mod( 'responsive_menu_active_colorpicker' ) ) ? set_theme_mod( 'responsive_header_active_menu_background_color', get_theme_mod( 'responsive_menu_active_colorpicker', '#ffffff' ) ) : '';

			if ( '#ffffff' !== get_theme_mod( 'responsive_header_active_menu_background_color', '#ffffff' ) ) {
				! get_theme_mod( 'responsive_header_menu_link_hover_color' ) ? set_theme_mod( 'responsive_header_menu_link_hover_color', get_theme_mod( 'responsive_menu_text_hover_colorpicker', '#ffffff' ) ) : '';
			}
			( ! get_theme_mod( 'responsive_header_menu_toggle_color' ) && get_theme_mod( 'responsive_menu_text_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_toggle_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_link_color' ) && get_theme_mod( 'responsive_menu_text_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_link_color', get_theme_mod( 'responsive_menu_text_colorpicker', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_border_color' ) && get_theme_mod( 'responsive_menu_border_color' ) ) ? set_theme_mod( 'responsive_header_menu_border_color', get_theme_mod( 'responsive_menu_border_color', '#eaeaea' ) ) : '';
			( ! get_theme_mod( 'responsive_header_menu_link_hover_color' ) && get_theme_mod( 'responsive_menu_text_hover_colorpicker' ) ) ? set_theme_mod( 'responsive_header_menu_link_hover_color', get_theme_mod( 'responsive_menu_text_hover_colorpicker', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_header_background_color' ) && get_theme_mod( 'responsive_fullwidth_header_color' ) ) ? set_theme_mod( 'responsive_header_background_color', get_theme_mod( 'responsive_fullwidth_header_color', '#ffffff' ) ) : '';
			( ! get_theme_mod( 'responsive_header_border_color' ) && get_theme_mod( 'responsive_header_background_color' ) ) ? set_theme_mod( 'responsive_header_border_color', get_theme_mod( 'responsive_header_background_color', '#eaeaea' ) ) : '';
			( ! get_theme_mod( 'responsive_header_site_title_color' ) && get_theme_mod( 'responsive_fullwidth_sitetitle_color' ) ) ? set_theme_mod( 'responsive_header_site_title_color', get_theme_mod( 'responsive_fullwidth_sitetitle_color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_text_color' ) && get_theme_mod( 'responsive_site_description_color' ) ) ? set_theme_mod( 'responsive_header_text_color', get_theme_mod( 'responsive_site_description_color', '#999999' ) ) : '';

			( ! get_theme_mod( 'responsive_header_sub_menu_link_color' ) && get_theme_mod( 'responsive_header_menu_link_color' ) ) ? set_theme_mod( 'responsive_header_sub_menu_link_color', get_theme_mod( 'responsive_header_menu_link_color', '#333333' ) ) : '';
			( ! get_theme_mod( 'responsive_header_sub_menu_link_hover_color' ) && get_theme_mod( 'responsive_header_menu_link_hover_color' ) ) ? set_theme_mod( 'responsive_header_sub_menu_link_hover_color', get_theme_mod( 'responsive_header_menu_link_hover_color', '#10659C' ) ) : '';

			( ! get_theme_mod( 'responsive_box_background_color' ) && get_theme_mod( 'responsive_container_background_color' ) ) ? set_theme_mod( 'responsive_box_background_color', get_theme_mod( 'responsive_container_background_color', '#ffffff' ) ) : '';
			if ( '#ffffff' !== get_theme_mod( 'responsive_box_background_color', '#ffffff' ) ) {
				! get_theme_mod( 'background_color' ) ? set_theme_mod( 'background_color', 'ffffff' ) : '';
			}

			( ! get_theme_mod( 'responsive_link_color' ) && get_theme_mod( 'link-color' ) ) ? set_theme_mod( 'responsive_link_color', get_theme_mod( 'link-color', '#0066CC' ) ) : '';
			( ! get_theme_mod( 'responsive_link_hover_color' ) && get_theme_mod( 'link-hover-color' ) ) ? set_theme_mod( 'responsive_link_hover_color', get_theme_mod( 'link-hover-color', '#10659C' ) ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_read_more_type' ) && get_theme_mod( 'responsive_display_read_more_as_button' ) ) ? set_theme_mod( 'responsive_blog_entry_read_more_type', 'button' ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_title_alignment' ) && get_theme_mod( 'responsive_blog_title_alignment_options' ) ) ? set_theme_mod( 'responsive_blog_entry_title_alignment', get_theme_mod( 'responsive_blog_title_alignment_options', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_blog_entry_meta_alignment' ) && get_theme_mod( 'responsive_blog_entries_meta_position' ) ) ? set_theme_mod( 'responsive_blog_entry_meta_alignment', get_theme_mod( 'responsive_blog_entries_meta_position', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_single_blog_title_alignment' ) && get_theme_mod( 'responsive_single_title_alignment_options' ) ) ? set_theme_mod( 'responsive_single_blog_title_alignment', get_theme_mod( 'responsive_single_title_alignment_options', 'left' ) ) : '';
			( ! get_theme_mod( 'responsive_single_blog_meta_alignment' ) && get_theme_mod( 'responsive_single_post_meta_position' ) ) ? set_theme_mod( 'responsive_single_blog_meta_alignment', get_theme_mod( 'responsive_single_post_meta_position', 'left' ) ) : '';

			if ( '#ffffff' === get_theme_mod( 'responsive_footer_background_color' ) ) {
				! get_theme_mod( 'responsive_footer_text_color' ) ? set_theme_mod( 'responsive_footer_text_color', '#333333' ) : '';
				! get_theme_mod( 'responsive_footer_links_color' ) ? set_theme_mod( 'responsive_footer_links_color', '#999999' ) : '';
				! get_theme_mod( 'responsive_footer_links_hover_color' ) ? set_theme_mod( 'responsive_footer_links_hover_color', '#333333' ) : '';
			}

			$header_layout = array( 'above_header', 'below_header' );
			if ( in_array( get_theme_mod( 'menu_position' ), $header_layout, true ) ) {

				if ( 'above_header' === get_theme_mod( 'menu_position' ) ) {
					! get_theme_mod( 'responsive_header_elements' ) ? set_theme_mod( 'responsive_header_elements', array( 'main-navigation', 'site-branding' ) ) : '';
				}
			}

			if ( 'in_header' === get_theme_mod( 'menu_position' ) && 'header-logo-right' === get_theme_mod( 'header_layout_options' ) ) {
				! get_theme_mod( 'responsive_header_elements' ) ? set_theme_mod( 'responsive_header_elements', array( 'main-navigation', 'site-branding' ) ) : '';
			}

			! get_theme_mod( 'responsive_header_alignment' ) && get_theme_mod( 'header_layout_options' ) ? set_theme_mod( 'responsive_header_alignment', str_replace( 'header-logo-', '', get_theme_mod( 'header_layout_options' ) ) ) : '';
			! get_theme_mod( 'responsive_container_width' ) ? set_theme_mod( 'responsive_container_width', get_theme_mod( 'responsive_main_container_width', 1140 ) ) : '';

			$responsive_options_blog = array( 'full-width-page', 'blog-2-col', 'blog-3-col', 'blog-4-col' );

			if ( in_array( $responsive_options['blog_posts_index_layout_default'], $responsive_options_blog, true ) ) {

				if ( ! get_theme_mod( 'responsive_blog_sidebar_position' ) ) {
					set_theme_mod( 'responsive_blog_sidebar_position', 'default' ); 
				}

				if ( ! get_theme_mod( 'responsive_blog_content_width' ) ) {
					set_theme_mod( 'responsive_blog_content_width', 100 );
				}

				for ( $i = 0; $i < 4; $i++ ) {
					if ( 'blog-' . $i . '-col' === $responsive_options['blog_posts_index_layout_default'] ) {

						if ( ! get_theme_mod( 'responsive_blog_entry_columns' ) ) {
							set_theme_mod( 'responsive_blog_entry_columns', $i );
						}

						if ( ! get_theme_mod( 'responsive_blog_entry_display_masonry' ) ) {
							set_theme_mod( 'responsive_blog_entry_display_masonry', get_theme_mod( 'responsive_display_masonry' ) );
						}
					}
				}
			}

			if ( 'sidebar-content-page' === $responsive_options['blog_posts_index_layout_default'] ) {
				if ( ! get_theme_mod( 'responsive_blog_sidebar_position' ) ) {
					set_theme_mod( 'responsive_blog_sidebar_position', 'default' ); 
				}
			}


			if ( get_theme_mod( 'responsive_display_thumbnail_without_padding' ) ) {
				! get_theme_mod( 'responsive_blog_entry_featured_image_style' ) ? set_theme_mod( 'responsive_blog_entry_featured_image_style', 'stretched' ) : '';
			}

			if ( 'sidebar-content-page' === $responsive_options['single_post_layout_default'] ) {
				if ( ! get_theme_mod( 'responsive_single_blog_sidebar_position' ) ) {
					set_theme_mod( 'responsive_single_blog_sidebar_position', 'no' ); 
				}
			}

			if ( 'full-width-page' === $responsive_options['single_post_layout_default'] ) {
				if ( ! get_theme_mod( 'responsive_single_blog_sidebar_position' ) ) {
					set_theme_mod( 'responsive_single_blog_sidebar_position', 'no' ); 
				}
				if ( ! get_theme_mod( 'responsive_single_blog_content_width' ) ) {
					set_theme_mod( 'responsive_single_blog_content_width', 100 );
				}
			}

			// Static page layout defaults.
			if ( 'sidebar-content-page' === $responsive_options['static_page_layout_default'] ) {
				if ( ! get_theme_mod( 'responsive_page_sidebar_position' ) ) {
					set_theme_mod( 'responsive_page_sidebar_position', 'no' ); 
				}
			}

			if ( 'full-width-page' === $responsive_options['static_page_layout_default'] ) {
				if ( ! get_theme_mod( 'responsive_page_sidebar_position' ) ) {
					set_theme_mod( 'responsive_page_sidebar_position', 'no' ); 
				}
				if ( ! get_theme_mod( 'responsive_page_content_width' ) ) {
					set_theme_mod( 'responsive_page_content_width', 100 );
				}
			}


			if ( 'fullwidth-stretched' === $responsive_options['site_layout_option'] ) {
				if ( '#ffffff' === get_theme_mod( 'responsive_box_background_color' ) ) {
					'ffffff' !== get_theme_mod( 'background_color' ) ? set_theme_mod( 'background_color', 'ffffff' ) : '';
				}
			}

			if ( 'full' === get_theme_mod( 'header_width' ) ) {
				( ! get_theme_mod( 'responsive_header_menu_full_width' ) && 0 !== get_theme_mod( 'responsive_header_menu_full_width' ) ) ? set_theme_mod( 'responsive_header_menu_full_width', 1 ) : '';
			}

			$body_typography = get_theme_mod( 'body_typography' );
			if ( $body_typography && array_key_exists( 'color', $body_typography ) ) {
				! get_theme_mod( 'responsive_body_text_color' ) ? set_theme_mod( 'responsive_body_text_color', $body_typography['color'] ) : '';
			}

			$menu_typography        = get_theme_mod( 'menu_typography' );
			$header_menu_typography = get_theme_mod( 'header_menu_typography' );

			if ( $menu_typography ) {
				if ( ! $header_menu_typography ) {
					set_theme_mod( 'header_menu_typography', $menu_typography );
				}
			}

			$post_meta_typography = get_theme_mod( 'post_meta_typography' );
			$meta_typography      = get_theme_mod( 'meta_typography' );

			if ( $post_meta_typography ) {
				if ( ! $meta_typography ) {
					set_theme_mod( 'meta_typography', $post_meta_typography );
				}
			}

			$meta_typography = get_theme_mod( 'post_meta_typography' );
			if ( $meta_typography && array_key_exists( 'color', $meta_typography ) ) {
				! get_theme_mod( 'responsive_meta_text_color' ) ? set_theme_mod( 'responsive_meta_text_color', $meta_typography['color'] ) : '';
			}

			for ( $i = 1; $i < 7; $i++ ) {
				$heading_h = get_theme_mod( 'heading_h' . $i . '_typography' );
				$heading   = get_theme_mod( 'headings_typography' );
				if ( $heading ) {
					if ( ! get_theme_mod( 'heading_h' . $i . '_typography' ) ) {
						set_theme_mod( 'heading_h' . $i . '_typography', $heading );
					} else {
						foreach ( $heading as $key => $value ) {
							if ( 'color' !== $key && ( ! array_key_exists( $key, get_theme_mod( 'heading_h' . $i . '_typography' ) ) ) ) {
								$temp      = array( $key => $value );
								$heading_h = $temp + get_theme_mod( 'heading_h' . $i . '_typography' );
								set_theme_mod( 'heading_h' . $i . '_typography', $heading_h );
							}
						}
					}
				}

				if ( $heading_h && array_key_exists( 'color', $heading_h ) ) {
					! get_theme_mod( "responsive_h{$i}_text_color" ) ? set_theme_mod( "responsive_h{$i}_text_color", $heading_h['color'] ) : '';
				}
			}

			if ( class_exists( 'woocommerce' ) ) {
				( ! get_theme_mod( 'responsive_shop_product_rating_color' ) && get_theme_mod( 'responsive_product_rating_color' ) ) ? set_theme_mod( 'responsive_shop_product_rating_color', get_theme_mod( 'responsive_product_rating_color', '#0066CC' ) ) : '';

				( ! get_theme_mod( 'responsive_add_to_cart_button_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_add_to_cart_button_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_add_to_cart_button_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';

				( ! get_theme_mod( 'responsive_cart_buttons_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_buttons_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_cart_buttons_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';

				( ! get_theme_mod( 'responsive_cart_checkout_button_color' ) && get_theme_mod( 'responsive_button_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_color', get_theme_mod( 'responsive_button_color', '#0066CC' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_text_color' ) && get_theme_mod( 'responsive_button_text_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_text_color', get_theme_mod( 'responsive_button_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_hover_color' ) && get_theme_mod( 'responsive_button_hover_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_hover_color', get_theme_mod( 'responsive_button_hover_color', '#10659C' ) ) : '';
				( ! get_theme_mod( 'responsive_cart_checkout_button_hover_text_color' ) && get_theme_mod( 'responsive_button_hover_text_color' ) ) ? set_theme_mod( 'responsive_cart_checkout_button_hover_text_color', get_theme_mod( 'responsive_button_hover_text_color', '#ffffff' ) ) : '';
				( ! get_theme_mod( 'responsive_breadcrumb_color' ) && get_theme_mod( 'responsive_product_breadcrumb_color' ) ) ? set_theme_mod( 'responsive_breadcrumb_color', get_theme_mod( 'responsive_product_breadcrumb_color', '#0066CC' ) ) : '';

			}
		}
		update_option( 'responsive_version_410', 1 );
	}

	add_action( 'admin_init', 'responsive_check_previous_version', 5 );
	add_action( 'customize_preview_init', 'responsive_check_previous_version' );
	add_action( 'wp', 'responsive_check_previous_version', 5 );
}
/**
 * Add iFrame to allowed wp_kses_post tags
 *
 * @param array  $tags Allowed tags, attributes, and/or entities.
 * @param string $context Context to judge allowed tags by. Allowed values are 'post'.
 *
 * @return array
 */
function responsive_wpkses_post_tags( $tags, $context ) {
	if ( 'post' === $context ) {
		$tags['iframe'] = array(
			'src'             => true,
			'height'          => true,
			'width'           => true,
			'frameborder'     => true,
			'allowfullscreen' => true,
		);
	}
	return $tags;
}
add_filter( 'wp_kses_allowed_html', 'responsive_wpkses_post_tags', 10, 2 );

/**
 * Register theme locations
 *
 * @param array $elementor_theme_manager  Theme manager.
 */
function responsive_register_elementor_locations( $elementor_theme_manager ) {

	$elementor_theme_manager->register_all_core_location();

}
add_action( 'elementor/theme/register_locations', 'responsive_register_elementor_locations' );

/**
 * [responsive_header_sidebar description]
 *
 * @return void [description]
 */
// function responsive_header_sidebar() {
// 	get_sidebar( 'header' );
// }

/**
 * [responsive_header_widget_position description]
 *
 * @return void [description].
 */
// function responsive_header_widget_position() {

// 	if ( ! get_theme_mod( 'responsive_enable_header_widget', 1 ) ) {
// 		return;
// 	}

// 	$responsive_header_widget_position = 'responsive_header_' . get_theme_mod( 'responsive_header_widget_position', 'top' );

// 	add_action( $responsive_header_widget_position, 'responsive_header_sidebar', 30 );

// }
// add_action( 'wp_head', 'responsive_header_widget_position' );

if ( ! function_exists( 'wp_body_open' ) ) {
	/**
	 * Fire the wp_body_open action.
	 *
	 * Added for backwards compatibility to support WordPress versions prior to 5.2.0.
	 */
	function wp_body_open() {
		/**
		 * Triggered after the opening <body> tag.
		 */
		do_action( 'wp_body_open' );
	}
}

/**
 * [responsive_nav_menu_link_attributes]
 *
 * @param array $atts Attribute.
 * @param mixed $item Item.
 * @param mixed $args Arguments.
 * @param mixed $depth Depth.
 * @return array $atts.
 */
function responsive_nav_menu_link_attributes( $atts, $item, $args, $depth ) {

	// Add [aria-haspopup] and [aria-expanded] to menu items that have children.
	$item_has_children = in_array( 'menu-item-has-children', $item->classes );
	if ( $item_has_children ) {
		$atts['aria-haspopup'] = 'true';
		$atts['aria-expanded'] = 'false';
	}

	return $atts;
}
add_filter( 'nav_menu_link_attributes', 'responsive_nav_menu_link_attributes', 10, 4 );

/**
 * [responsive_add_sub_toggles_to_main_menu]
 *
 * @param mixed $args Arguments.
 * @param mixed $item Item.
 * @param mixed $depth Depth.
 * @return $args.
 */
function responsive_add_sub_toggles_to_main_menu( $args, $item, $depth ) {
	// Get theme_location and menu_id from args object
	$theme_location = isset( $args->theme_location ) ? $args->theme_location : '';
	$menu_id = isset( $args->menu_id ) ? $args->menu_id : '';
	
	// Check if this is header-menu, off-canvas-menu theme location, or off-canvas-menu ID
	$is_header_menu = ( 'header-menu' === $theme_location );
	$is_off_canvas_menu = ( 'off-canvas-menu' === $theme_location || 'off-canvas-menu' === $menu_id );
	
	// Priority: if menu_id is 'off-canvas-menu', treat it as off-canvas menu (even if theme_location is header-menu)
	// This handles the case when header-menu is used as fallback in off-canvas panel
	$is_off_canvas_context = ( 'off-canvas-menu' === $menu_id );
	
	if ( $is_header_menu || $is_off_canvas_menu ) {
		if ( in_array( 'menu-item-has-children', $item->classes, true ) ) {
			if ( $is_header_menu && ! $is_off_canvas_context ) {
				// Header menu (not in off-canvas context): add both inner and outer icons
				$args->after      = '<span class="res-iconify res-iconify-outer">
					<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
					</span>';
				$args->link_after = '<span class="res-iconify res-iconify-inner">
					<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
					</span>';
			} else {
				// Off-canvas menu (or header-menu used as fallback in off-canvas): only add inner icon (inside the link)
				$args->after      = '';
				$args->link_after = '<span class="res-iconify res-iconify-inner">
					<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
					</span>';
			}
		} else {
			$args->after      = '';
			$args->link_after = '';
		}
	}
	return $args;
}

add_filter( 'nav_menu_item_args', 'responsive_add_sub_toggles_to_main_menu', 10, 3 );

/**
 * [responsive_nav_secondary_menu_link_attributes]
 *
 * @param array $atts Attribute.
 * @param mixed $item Item.
 * @param mixed $args Arguments.
 * @param mixed $depth Depth.
 * @return array $atts.
 */
function responsive_nav_secondary_menu_link_attributes( $atts, $item, $args, $depth ) {

	// Add [aria-haspopup] and [aria-expanded] to menu items that have children.
	$item_has_children = in_array( 'menu-item-has-children', $item->classes );
	if ( $item_has_children ) {
		$atts['aria-haspopup'] = 'true';
		$atts['aria-expanded'] = 'false';
	}

	return $atts;
}
add_filter( 'nav_secondary_menu_link_attributes', 'responsive_secondary_nav_menu_link_attributes', 10, 4 );

/**
 * [responsive_add_sub_toggles_to_secondary_menu]
 *
 * @param mixed $args Arguments.
 * @param mixed $item Item.
 * @param mixed $depth Depth.
 * @return $args.
 */
function responsive_add_sub_toggles_to_secondary_menu( $args, $item, $depth ) {
	if ( 'secondary-menu' === $args->theme_location ) {
		if ( in_array( 'menu-item-has-children', $item->classes, true ) ) {
			$args->after      = '<span class="res-iconify res-iconify-outer">
				<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
				</span>';
			$args->link_after = '<span class="res-iconify res-iconify-inner">
				<svg width="15" height="8" viewBox="-2.5 -5 75 60" preserveAspectRatio="none"><path d="M0,0 l35,50 l35,-50" fill="none" stroke-linecap="round" stroke-width="10" /></svg>
				</span>';
		} else {
			$args->after      = '';
			$args->link_after = '';
		}
	}
	return $args;
}

add_filter( 'nav_menu_item_args', 'responsive_add_sub_toggles_to_secondary_menu', 10, 3 );

if ( ! function_exists( 'responsive_display_date_box' ) ) {
	/**
	 * Display date box on blog/archive page.
	 *
	 * @param mixed $date_box_toggle Date Box Toggle.
	 * @param mixed $toggle Toggle.
	 */
	function responsive_display_date_box( $date_box_toggle, $toggle ) {
		if ( $date_box_toggle ) {
			$datebox_day   = get_the_date( 'j' );
			$datebox_month = get_the_date( 'M' );
			$datebox_year  = get_the_date( 'Y' );
			if ( $toggle ) {
				$date_box_display_value = 'absolute';
				$date_box_special_class = 'with-thumbnail';
			} else {
				$date_box_display_value = '';
				$date_box_special_class = 'without-thumbnail';
			}
			echo '<div class="datebox-container">';
				echo '<div class="responsive-date-box ' . esc_html( $date_box_special_class ) . '" style="position: ' . esc_html( $date_box_display_value ) . '">';
					echo '<a href="' . esc_url( get_permalink() ) . '" class="date-box-links">';
						echo '<div class="date-box-month">' . esc_html( $datebox_month ) . '</div>';
						echo '<div class="date-box-day">' . esc_html( $datebox_day ) . '</div>';
						echo '<div class="date-box-year">' . esc_html( $datebox_year ) . '</div>';
					echo '</a>';
				echo '</div>';
			echo '</div>';
		} else {
			return;
		}
	}
}

if ( ! function_exists( 'responsive_fallback_menu' ) ) {
	/**
	 * Set a fallback menu that will show a home link.
	 */
	function responsive_fallback_menu() {
		$args    = array(
			'depth'               => 0,
			'sort_column'         => 'menu_order, post_title',
			'menu_class'          => 'menu',
			'include'             => '',
			'exclude'             => '',
			'echo'                => false,
			'show_home'           => true,
			'link_before'         => '',
			'link_after'          => '',
			'show_sub_menu_icons' => true,
			'walker'              => new Responsive_Walker_Page(),
		);
		$pages   = wp_page_menu( $args );
		$prepend = '<div id="header-menu" class="menu">';
		$append  = '</div>';
		$output  = $prepend . $pages . $append;

		echo wp_kses_post( $output );
	}
}

add_action( 'wp_footer', 'prevent_menu_icon_redirection' );

/**
 * Prevent redirection after menu icons are clicked.
 */
function prevent_menu_icon_redirection() {
	echo "<script>
	var iconElement = document.querySelectorAll('.res-iconify-inner');
	iconElement.forEach(function(element) {
		element.addEventListener('click', function(e) {
			e.preventDefault();
			e.stopPropagation();
		});
	});
	</script>";
}

add_action( 'wp_footer', 'responsive_pro_fixed_menu_onscroll' );

if ( ! function_exists( 'responsive_pro_fixed_menu_onscroll' ) ) {
	/**
	 * Shows fixed header on scroll if sticky-header is enabled
	 */
	function responsive_pro_fixed_menu_onscroll() {
		$responsive_options = wp_parse_args( get_option( 'responsive_theme_options', array() ) );

		if ( isset( $responsive_options['sticky-header'] ) && 1 === $responsive_options['sticky-header'] ) {

			if ( get_theme_mod( 'responsive_shrink_sticky_header' ) ) {
				?>
				<script type="text/javascript">
					var masthead = document.getElementById("masthead");
					var mastheadMobile = document.getElementById("masthead-mobile");
					if (masthead) {
						masthead.classList.add( 'shrink' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.add( 'shrink' );
					}
				</script>
				<?php } else { ?>
				<script type="text/javascript">
					var masthead = document.getElementById("masthead");
					var mastheadMobile = document.getElementById("masthead-mobile");
					if (masthead) {
						masthead.classList.remove( 'shrink' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.remove( 'shrink' );
					}
				</script>
				<?php
				}
				if ( get_theme_mod( 'responsive_sticky_header_logo_option' ) ) {
					?>
				<script type="text/javascript">
					var masthead = document.getElementById("masthead");
					var mastheadMobile = document.getElementById("masthead-mobile");
					if (masthead) {
						masthead.classList.add( 'sticky-logo' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.add( 'sticky-logo' );
					}
				</script>
				<?php } else { ?>
				<script type="text/javascript">
					var masthead = document.getElementById("masthead");
					var mastheadMobile = document.getElementById("masthead-mobile");
					if (masthead) {
						masthead.classList.remove( 'sticky-logo' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.remove( 'sticky-logo' );
					}
				</script>
			<?php } ?>

		<script type="text/javascript">
			window.addEventListener("scroll", responsiveStickyHeader);

			function responsiveStickyHeader() {
				var masthead = document.getElementById("masthead");
				var mastheadMobile = document.getElementById("masthead-mobile");
				var height = masthead ? masthead.offsetHeight : (mastheadMobile ? mastheadMobile.offsetHeight : 0);
				
				if (document.documentElement.scrollTop > 0 ) {
					if (masthead) {
						masthead.classList.add( 'sticky-header' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.add( 'sticky-header' );
					}
					
					if (document.getElementById("wrapper") ) {
						document.getElementById("wrapper").style.marginTop = height+'px';
					}
					if (document.getElementsByClassName("elementor")[0] ) {
						document.getElementsByClassName("elementor")[0].style.marginTop = height+'px';
					}

					let container = document.getElementById( 'site-navigation' );
					if (container) {
						let button = container.getElementsByTagName( 'button' )[0];
						let menu = container.getElementsByTagName( 'ul' )[0];
						if (button && menu) {
							let icon = button.getElementsByTagName( 'i' )[0];
							container.classList.remove( 'toggled' );
							menu.setAttribute( 'aria-expanded', 'false' );
							button.setAttribute( 'aria-expanded', 'false' );
							if (icon) {
								icon.setAttribute( 'class', 'icon-bars' );
							}
						}
					}
					if(document.getElementById("sidebar-menu-overlay")) {
						document.getElementById("sidebar-menu-overlay").style.display = "none";
					}

				} else {
					if (masthead) {
						masthead.classList.remove( 'sticky-header' );
					}
					if (mastheadMobile) {
						mastheadMobile.classList.remove( 'sticky-header' );
					}
					
					if (document.getElementById("wrapper") ) {
						document.getElementById("wrapper").style.marginTop = '0px';
					}
					if (document.getElementsByClassName("elementor")[0] ) {
						document.getElementsByClassName("elementor")[0].style.marginTop = '0px';
					}
				}
			}
		</script>
			<?php
		}
	}
}

/**
 * Get theme author details
 */

function responsive_get_theme_author_details() {

	$theme_author = apply_filters(
		'responsive_theme_author',
		array(
			'theme_name'       => __( 'Responsive Theme', 'responsive' ),
			'theme_author_url' => 'https://cyberchimps.com/',
		)
	);

	return $theme_author;
}

add_action( 'wp_ajax_save_footer_text', 'save_footer_text_callback' );

function save_footer_text_callback() {

	check_ajax_referer( 'responsive-save-footer-content', '_ajax_nonce' );

	if ( ! current_user_can( 'manage_options' ) ) {
		wp_send_json_error( esc_html__( 'You do not have sufficient permissions to perform this action.', 'responsive' ) );
	}

	$footer_text = wp_kses_post( $_POST['footer_text'] );

	update_option( 'footer-copyright', $footer_text );

	wp_send_json_success( 'Data saved successfully' );

	wp_die();
}

add_action( 'admin_menu', 'remove_unnecessary_wordpress_menus', 999 );

function remove_unnecessary_wordpress_menus() {
	global $submenu;
	unset( $submenu['themes.php'][15] );
	unset( $submenu['themes.php'][20] );
}

/**
 * AJAX: Flush local fonts cache
 */
function responsive_ajax_flush_local_fonts_cache() {
    check_ajax_referer( 'responsive-flush-local-fonts', '_ajax_nonce' );

    if ( ! current_user_can( 'customize' ) ) {
        wp_send_json_error( array( 'message' => __( 'Insufficient permissions.', 'responsive' ) ) );
    }

    if ( class_exists( 'Responsive_Local_Fonts' ) ) {
        Responsive_Local_Fonts::flush_cache();
        wp_send_json_success( array( 'message' => __( 'Local fonts cache flushed', 'responsive' ) ) );
    }

    wp_send_json_error( array( 'message' => __( 'Flush handler unavailable.', 'responsive' ) ) );
}
add_action( 'wp_ajax_responsive_flush_local_fonts_cache', 'responsive_ajax_flush_local_fonts_cache' );

/**
 * Admin-post fallback to allow non-AJAX triggers (optional)
 */
function responsive_admin_post_flush_local_fonts() {
    if ( ! current_user_can( 'customize' ) ) {
        wp_die( __( 'Insufficient permissions.', 'responsive' ) );
    }
    check_admin_referer( 'responsive_flush_local_fonts' );
    if ( class_exists( 'Responsive_Local_Fonts' ) ) {
        Responsive_Local_Fonts::flush_cache();
    }
    wp_safe_redirect( wp_get_referer() ? wp_get_referer() : admin_url( 'customize.php' ) );
    exit;
}
add_action( 'admin_post_responsive_flush_local_fonts', 'responsive_admin_post_flush_local_fonts' );

if ( ! function_exists( 'responsive_theme_background_updater_6_1_7' ) ) {

	/**
	 * Handle backward compatibility on version 6.1.7.
	 *
	 * @since 6.1.7
	 * @return void
	 */
	function responsive_theme_background_updater_6_1_7() {

		$theme_options = get_option( 'responsive_theme_options' );
		/**
		 * Ensure Blog page title, blog layout backward compatibility for existing users.
		 */
		if ( ! isset( $theme_options['v6-1-7-backward-done'] ) ) {
	
			if ( isset( $theme_options['blog_post_title_toggle'] ) && $theme_options['blog_post_title_toggle'] ) {
				set_theme_mod( 'responsive_blog_post_title_toggle', 1 );
			}
			if ( 1 == get_theme_mod( 'responsive_blog_entry_columns' ) ) {
				set_theme_mod( 'responsive_blog_entry_columns', 2 );
				set_theme_mod( 'responsive_blog_layout', 'list' );
			}
			$theme_options['v6-1-7-backward-done'] = true;
			update_option( 'responsive_theme_options', $theme_options );
		}
	}
}

if ( ! function_exists( 'responsive_theme_background_updater_6_2_3' ) ) {

	/**
	 * Handle backward compatibility on version 6.2.3
	 *
	 * @since 6.2.3
	 * @return void
	 */
	function responsive_theme_background_updater_6_2_3() {

		if ( ! isset( $responsive_options['v6-2-3-backward-done'] ) ) {
			$responsive_options = Responsive\Core\responsive_get_options();

			// Backward compatibility for Related Posts
			/** Default sections */
			$related_post_elements = array( 'title', 'featured-image', 'meta', 'excerpt' );

			/** Get sections from Customizer */
			$related_post_elements = get_theme_mod( 'responsive_single_blog_related_post_structure', $related_post_elements );

			if( get_theme_mod( 'responsive_single_blog_enable_related_posts', 0 ) && in_array( 'excerpt', $related_post_elements, true ) ) {
				// If the related posts are enabled, set the excerpt to be enabled by default.
				set_theme_mod( 'responsive_rp_enable_excerpt', 1 );
			}

			// Transparent Header backward compatibility.
			if( get_theme_mod( 'responsive_transparent_header', 0 ) ) {
				set_theme_mod( 'responsive_enable_transparent_header_bottom_border', 1 );
			}

			// Backward compatibility for social links.
			$header_social      = get_theme_mod( 'responsive_header_social_items' );
			$footer_social      = get_theme_mod( 'responsive_footer_social_items' );
			$target_social_link = get_theme_mod( 'responsive_social_link_new_tab', '_self' ) === '_blank' ? true : false;

			if ( empty( $header_social ) && empty( $footer_social ) ) {
				$responsive_options['v6-2-3-backward-done'] = true;
				return;
			}

			if ( ! empty( $header_social ) && ! empty( $header_social['items'] ) ) {
				$social_items = $header_social['items'];
				foreach ( $social_items as &$social_item ) {
					$social_item['link']   = $responsive_options[ $social_item['id'] . '_uid' ] ?? '';
					$social_item['newTab'] = $target_social_link;
				}
				unset( $social_item );
				$header_social['items'] = $social_items;
				set_theme_mod( 'responsive_header_social_items', $header_social );
			}
			if ( ! empty( $footer_social ) && ! empty( $footer_social['items'] ) ) {
				$social_items = $footer_social['items'];
				foreach ( $social_items as &$social_item ) {
					$social_item['link']   = $responsive_options[ $social_item['id'] . '_uid' ] ?? '';
					$social_item['newTab'] = $target_social_link;
				}
				unset( $social_item );
				$footer_social['items'] = $social_items;
				set_theme_mod( 'responsive_footer_social_items', $footer_social );
			}
			$responsive_options['v6-2-3-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_6_2_4') ) {
	/**
	 * Handle backward compatibility on version 6.2.4
	 *
	 * @since 6.2.4
	 * @return void
	 */
	function responsive_theme_background_updater_6_2_4() {

		$responsive_options = Responsive\Core\responsive_get_options();

		if ( ! isset( $responsive_options['v6-2-4-backward-done'] ) ) {

			// Get all saved theme mods.
			// $all_mods = get_theme_mods();

			/**
			 * Check if 'page_sidebar_position' exists in saved mods.
			 * - If it exists: user already set a value ('right', 'left', or 'no') → do nothing.
			 * - If it does NOT exist: means old fallback 'right' was being used → set it explicitly.
			 */
			if ( 'right' === get_theme_mod( 'responsive_page_sidebar_position', 'right' ) ) {
				set_theme_mod( 'responsive_page_sidebar_position', 'right' );
			}
			if ( 'right' === get_theme_mod( 'responsive_single_blog_sidebar_position', 'right' ) ) {
				set_theme_mod( 'responsive_single_blog_sidebar_position', 'right' );
			}

			// Mark update as done
			$responsive_options['v6-2-4-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if ( ! function_exists( 'responsive_theme_background_updater_retina_logo_6_2_5' ) ) {
	/**
	 * Handle backward compatibility for retina logo setup
	 *
	 * @since 6.2.5
	 * @return void
	 */
	function responsive_theme_background_updater_retina_logo_6_2_5() {

		$responsive_options = Responsive\Core\responsive_get_options();

		if ( ! isset( $responsive_options['retina-logo-backward-done'] ) ) {

			// If retina logo option is enabled but no separate retina image has been set
			if ( get_theme_mod( 'responsive_retina_logo', 0 )
				&& ! get_theme_mod( 'responsive_retina_logo_image', '' ) ) {

				// Get the current custom logo ID
				$custom_logo_id = get_theme_mod( 'custom_logo' );

				if ( $custom_logo_id ) {
					// Fallback: set the same main logo as retina logo
					$logo_url = wp_get_attachment_url( $custom_logo_id );

					if ( $logo_url ) {
						set_theme_mod( 'responsive_retina_logo_image', $logo_url );
					}
				}
			}

			// Mark backward compatibility update as done
			$responsive_options['retina-logo-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_6_2_7') ) {
	/**
	 * Handle backward compatibility on version 6.2.7
	 * 
	 * @since 6.2.7
	 * @return void
	 */
	function responsive_theme_background_updater_6_2_7() {

		$responsive_options = Responsive\Core\responsive_get_options();

		if ( ! isset( $responsive_options['v6-2-7-backward-done'] ) ) {
			for ( $i = 1; $i <= 4; $i++ ) {
				if ( ! get_theme_mod( 'responsive_footer_widget' . $i . '_title_color' ) ) {
					set_theme_mod( 'responsive_footer_widget' . $i . '_title_color', get_theme_mod( 'responsive_footer_text_color', '#FFFFFF' ) );
				}
				if ( ! get_theme_mod( 'responsive_footer_widget' . $i . '_content_color' ) ) {
					set_theme_mod( 'responsive_footer_widget' . $i . '_content_color', get_theme_mod( 'responsive_footer_text_color', '#FFFFFF' ) );
				}
				if ( ! get_theme_mod( 'responsive_footer_widget' . $i . '_link_color' ) ) {
					set_theme_mod( 'responsive_footer_widget' . $i . '_link_color', get_theme_mod( 'responsive_footer_links_color', '#eaeaea' ) );
				}
				if ( ! get_theme_mod( 'responsive_footer_widget' . $i . '_link_hover_color' ) ) {
					set_theme_mod( 'responsive_footer_widget' . $i . '_link_hover_color', get_theme_mod( 'responsive_footer_links_hover_color', '#FFFFFF' ) );
				}
			}
			$responsive_options['v6-2-7-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}
if ( ! function_exists( 'responsive_theme_background_updater_site_title_tagline_visibility_6_2_7' ) ) {
	/**
	 * Handle backward compatibility for site title and tagline visibility controls.
	 *
	 * Converts old single toggle settings into new multi-device visibility arrays.
	 *
	 * @since 6.2.7
	 * @return void
	 */
	function responsive_theme_background_updater_site_title_tagline_visibility_6_2_7() {

		$responsive_options = Responsive\Core\responsive_get_options();

		if ( ! isset( $responsive_options['site-title-tagline-visibility-backward-done'] ) ) {

			// Fetch existing (old) settings.
			$hide_title   = get_theme_mod( 'responsive_hide_title', 0 );
			$hide_tagline = get_theme_mod( 'responsive_hide_tagline', 1 );

			// Fetch new settings (may already exist if user updated).
			$title_visibility   = get_theme_mod( 'responsive_site_title_visibility', false );
			$tagline_visibility = get_theme_mod( 'responsive_site_tagline_visibility', false );

			// Backward compatibility: if new visibility settings don’t exist yet.
			if ( false === $title_visibility ) {
				if ( $hide_title ) {
					// Title was hidden previously → no devices visible.
					set_theme_mod( 'responsive_site_title_visibility', array() );
				} else {
					// Title was visible → visible on all devices.
					set_theme_mod( 'responsive_site_title_visibility', array( 'desktop', 'tablet', 'mobile' ) );
				}
			}

			if ( false === $tagline_visibility ) {
				if ( $hide_tagline ) {
					// Tagline was hidden previously → no devices visible.
					set_theme_mod( 'responsive_site_tagline_visibility', array() );
				} else {
					// Tagline was visible → visible on all devices.
					set_theme_mod( 'responsive_site_tagline_visibility', array( 'desktop', 'tablet', 'mobile' ) );
				}
			}

			// Mark backward compatibility update as done.
			$responsive_options['site-title-tagline-visibility-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( !function_exists( 'responsive_theme_background_updater_responsive_logo_6_2_7' ) ) {
	/** 
	 * Handle backward compatibility for responsive logo setup
	 * @since 6.2.7
	 * @return void
	*/
	function responsive_theme_background_updater_responsive_logo_6_2_7()
	{
		$responsive_options = Responsive\Core\responsive_get_options();
		if( !isset( $responsive_options['responsive-logo-backward-done'])) {
	
			// if custom logo width is set but no separate width is mentioned for tablet and phone
			// then use the same width everywhere
			$desktop_width = get_theme_mod( 'responsive_logo_width' );
			if( $desktop_width ) {
				if( !get_theme_mod('responsive_logo_width_tablet') ) {
					set_theme_mod( 'responsive_logo_width_tablet', $desktop_width );
				}
				if( !get_theme_mod('responsive_logo_width_mobile') ) {
					set_theme_mod( 'responsive_logo_width_mobile', $desktop_width );
				}
			}

			// Mark backward compatibility update as done
			$responsive_options['responsive-logo-backward-done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}
if( ! function_exists( 'responsive_theme_background_updater_content_boxed_flat_padding_margin_6_2_7' )) {
	/**
	 * Handle backward compatibility for existing users who are using flat or content boxes layouts 
	 * We need to adjust the padding and margin for the product cards in woocommerce shop page
	 * @since 6.2.7
	 * @return void
	 */
	function responsive_theme_background_updater_content_boxed_flat_padding_margin_6_2_7(){
		$responsive_options = Responsive\Core\responsive_get_options();
		if( !isset( $responsive_options['content_boxed_flat_padding_margin_fix'])) {
			$header_layout = get_theme_mod( 'responsive_style', 'boxed' );
			if($header_layout === 'flat' || $header_layout === 'content-boxed')
			{
				set_theme_mod('responsive_product_card_outside_container_top_padding',0);
				set_theme_mod('responsive_product_card_outside_container_bottom_padding',28);
				set_theme_mod('responsive_product_card_outside_container_left_padding',0);
				set_theme_mod('responsive_product_card_outside_container_right_padding',0);
				set_theme_mod('responsive_product_card_outside_container_tablet_top_padding',0);
	
				set_theme_mod('responsive_product_card_outside_container_tablet_top_padding',0);
				set_theme_mod('responsive_product_card_outside_container_tablet_bottom_padding',28);
				set_theme_mod('responsive_product_card_outside_container_tablet_left_padding',0);
				set_theme_mod('responsive_product_card_outside_container_tablet_right_padding',0);
	
				set_theme_mod('responsive_product_card_outside_container_mobile_top_padding',0);
				set_theme_mod('responsive_product_card_outside_container_mobile_bottom_padding',28);
				set_theme_mod('responsive_product_card_outside_container_mobile_left_padding',0);
				set_theme_mod('responsive_product_card_outside_container_mobile_right_padding',0);
	
				set_theme_mod('responsive_product_card_inside_container_top_padding',0);
				set_theme_mod('responsive_product_card_inside_container_bottom_padding',30);
				set_theme_mod('responsive_product_card_inside_container_left_padding',0);
				set_theme_mod('responsive_product_card_inside_container_right_padding',30);
	
				set_theme_mod('responsive_product_card_inside_container_tablet_top_padding',0);
				set_theme_mod('responsive_product_card_inside_container_tablet_bottom_padding',47);
				set_theme_mod('responsive_product_card_inside_container_tablet_left_padding',0);
				set_theme_mod('responsive_product_card_inside_container_tablet_right_padding',7);
				
				set_theme_mod('responsive_product_card_inside_container_mobile_top_padding',0);
				set_theme_mod('responsive_product_card_inside_container_mobile_bottom_padding',47);
				set_theme_mod('responsive_product_card_inside_container_mobile_left_padding',0);
				set_theme_mod('responsive_product_card_inside_container_mobile_right_padding',0);
			}

			$responsive_options['content_boxed_flat_padding_margin_fix'] = true;
            update_option( 'responsive_theme_options', $responsive_options );
			
		}
	}

}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_builder_6_2_9' )) {
	/**
	 * Handle backward compatibility for users who had set up border radius for toggle button through
	 * the settings in Primary Menu as its deprecated and new control and settings are added.
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_builder_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		if( !isset( $responsive_options['mobile_header_builder_backward_done'])) {
			$menu_button_radius = get_theme_mod( 'responsive_menu_button_radius', 'false' );
			if( $menu_button_radius!= false )
			{
				set_theme_mod( 'responsive_header_toggle_button_border_radius_tablet_left_padding', $menu_button_radius ); 
				get_theme_mod( 'responsive_header_toggle_button_border_radius_tablet_right_padding', $menu_button_radius );
				get_theme_mod( 'responsive_header_toggle_button_border_radius_tablet_bottom_padding', $menu_button_radius );
				get_theme_mod( 'responsive_header_toggle_button_border_radius_tablet_left_padding', $menu_button_radius ); 
				get_theme_mod( 'responsive_header_toggle_button_border_radius_mobile_top_padding', $menu_button_radius );
				get_theme_mod( 'responsive_header_toggle_button_border_radius_mobile_right_padding', $menu_button_radius );
				get_theme_mod( 'responsive_header_toggle_button_border_radius_mobile_bottom_padding', $menu_button_radius );
				get_theme_mod( 'responsive_header_toggle_button_border_radius_mobile_left_padding', $menu_button_radius ); 
			}

			// Migrate old header primary row background colors to new device-specific settings
			// This ensures backward compatibility when upgrading to the new color control system
			$old_bg_color = get_theme_mod( 'responsive_header_primary_row_bg_color', false );
			$old_bg_hover_color = get_theme_mod( 'responsive_header_primary_row_bg_hover_color', false );
			
			// Check if old settings exist (not false) but new device-specific settings don't exist (are false)
			if ( false !== $old_bg_color && false === get_theme_mod( 'responsive_header_primary_row_bg_color_tablet', false ) ) {
				// Migrate normal colors to all devices
				set_theme_mod( 'responsive_header_primary_row_bg_color_tablet', $old_bg_color );
				set_theme_mod( 'responsive_header_primary_row_bg_color_mobile', $old_bg_color );
			}
			
			if ( false !== $old_bg_hover_color && false === get_theme_mod( 'responsive_header_primary_row_bg_color_hover', false ) ) {
				// Migrate hover colors to all devices
				set_theme_mod( 'responsive_header_primary_row_bg_color_hover', $old_bg_hover_color );
				set_theme_mod( 'responsive_header_primary_row_bg_color_tablet_hover', $old_bg_hover_color );
				set_theme_mod( 'responsive_header_primary_row_bg_color_mobile_hover', $old_bg_hover_color );
			}

			// Migrate old header primary row bottom border colors to new device-specific settings
			$old_border_color = get_theme_mod( 'responsive_header_primary_row_bottom_border_color', false );
			$old_border_hover_color = get_theme_mod( 'responsive_header_primary_row_bottom_border_hover_color', false );
			
			// Check if old settings exist (not false) but new device-specific settings don't exist (are false)
			if ( false !== $old_border_color && false === get_theme_mod( 'responsive_header_primary_row_bottom_border_color_tablet', false ) ) {
				// Migrate normal border colors to all devices
				set_theme_mod( 'responsive_header_primary_row_bottom_border_color_tablet', $old_border_color );
				set_theme_mod( 'responsive_header_primary_row_bottom_border_color_mobile', $old_border_color );
			}
			
			if ( false !== $old_border_hover_color && false === get_theme_mod( 'responsive_header_primary_row_bottom_border_color_hover', false ) ) {
				// Migrate hover border colors to all devices
				set_theme_mod( 'responsive_header_primary_row_bottom_border_color_hover', $old_border_hover_color );
				set_theme_mod( 'responsive_header_primary_row_bottom_border_color_tablet_hover', $old_border_hover_color );
				set_theme_mod( 'responsive_header_primary_row_bottom_border_color_mobile_hover', $old_border_hover_color );
			}

			// Migrate old header above row background colors to new device-specific settings
			$old_above_bg_color = get_theme_mod( 'responsive_header_above_row_bg_color', false );
			$old_above_bg_hover_color = get_theme_mod( 'responsive_header_above_row_bg_hover_color', false );
			
			if ( false !== $old_above_bg_color && false === get_theme_mod( 'responsive_header_above_row_bg_color_tablet', false ) ) {
				// Migrate normal colors to all devices
				set_theme_mod( 'responsive_header_above_row_bg_color_tablet', $old_above_bg_color );
				set_theme_mod( 'responsive_header_above_row_bg_color_mobile', $old_above_bg_color );
			}
			
			if ( false !== $old_above_bg_hover_color && false === get_theme_mod( 'responsive_header_above_row_bg_color_hover', false ) ) {
				// Migrate hover colors to all devices
				set_theme_mod( 'responsive_header_above_row_bg_color_hover', $old_above_bg_hover_color );
				set_theme_mod( 'responsive_header_above_row_bg_color_tablet_hover', $old_above_bg_hover_color );
				set_theme_mod( 'responsive_header_above_row_bg_color_mobile_hover', $old_above_bg_hover_color );
			}

			// Migrate old header above row bottom border colors to new device-specific settings
			$old_above_border_color = get_theme_mod( 'responsive_header_above_row_bottom_border_color', false );
			$old_above_border_hover_color = get_theme_mod( 'responsive_header_above_row_bottom_border_hover_color', false );
			
			if ( false !== $old_above_border_color && false === get_theme_mod( 'responsive_header_above_row_bottom_border_color_tablet', false ) ) {
				// Migrate normal border colors to all devices
				set_theme_mod( 'responsive_header_above_row_bottom_border_color_tablet', $old_above_border_color );
				set_theme_mod( 'responsive_header_above_row_bottom_border_color_mobile', $old_above_border_color );
			}
			
			if ( false !== $old_above_border_hover_color && false === get_theme_mod( 'responsive_header_above_row_bottom_border_color_hover', false ) ) {
				// Migrate hover border colors to all devices
				set_theme_mod( 'responsive_header_above_row_bottom_border_color_hover', $old_above_border_hover_color );
				set_theme_mod( 'responsive_header_above_row_bottom_border_color_tablet_hover', $old_above_border_hover_color );
				set_theme_mod( 'responsive_header_above_row_bottom_border_color_mobile_hover', $old_above_border_hover_color );
			}

			// Migrate old header below row background colors to new device-specific settings
			$old_below_bg_color = get_theme_mod( 'responsive_header_below_row_bg_color', false );
			$old_below_bg_hover_color = get_theme_mod( 'responsive_header_below_row_bg_hover_color', false );
			
			if ( false !== $old_below_bg_color && false === get_theme_mod( 'responsive_header_below_row_bg_color_tablet', false ) ) {
				// Migrate normal colors to all devices
				set_theme_mod( 'responsive_header_below_row_bg_color_tablet', $old_below_bg_color );
				set_theme_mod( 'responsive_header_below_row_bg_color_mobile', $old_below_bg_color );
			}
			
			if ( false !== $old_below_bg_hover_color && false === get_theme_mod( 'responsive_header_below_row_bg_color_hover', false ) ) {
				// Migrate hover colors to all devices
				set_theme_mod( 'responsive_header_below_row_bg_color_hover', $old_below_bg_hover_color );
				set_theme_mod( 'responsive_header_below_row_bg_color_tablet_hover', $old_below_bg_hover_color );
				set_theme_mod( 'responsive_header_below_row_bg_color_mobile_hover', $old_below_bg_hover_color );
			}

			// Migrate old header below row bottom border colors to new device-specific settings
			$old_below_border_color = get_theme_mod( 'responsive_header_below_row_bottom_border_color', false );
			$old_below_border_hover_color = get_theme_mod( 'responsive_header_below_row_bottom_border_hover_color', false );
			
			if ( false !== $old_below_border_color && false === get_theme_mod( 'responsive_header_below_row_bottom_border_color_tablet', false ) ) {
				// Migrate normal border colors to all devices
				set_theme_mod( 'responsive_header_below_row_bottom_border_color_tablet', $old_below_border_color );
				set_theme_mod( 'responsive_header_below_row_bottom_border_color_mobile', $old_below_border_color );
			}
			
			if ( false !== $old_below_border_hover_color && false === get_theme_mod( 'responsive_header_below_row_bottom_border_color_hover', false ) ) {
				// Migrate hover border colors to all devices
				set_theme_mod( 'responsive_header_below_row_bottom_border_color_hover', $old_below_border_hover_color );
				set_theme_mod( 'responsive_header_below_row_bottom_border_color_tablet_hover', $old_below_border_hover_color );
				set_theme_mod( 'responsive_header_below_row_bottom_border_color_mobile_hover', $old_below_border_hover_color );
			}

			// Migrate old header row bottom border sizes to new device-specific settings
			// Header Above Row Border Size
			$old_above_border_size = get_theme_mod( 'responsive_header_above_row_bottom_border_size' );
			if ( $old_above_border_size !== false && ! get_theme_mod( 'responsive_header_above_row_bottom_border_size_tablet' ) ) {
				set_theme_mod( 'responsive_header_above_row_bottom_border_size_tablet', $old_above_border_size );
				set_theme_mod( 'responsive_header_above_row_bottom_border_size_mobile', $old_above_border_size );
			}

			// Header Primary Row Border Size
			$old_primary_border_size = get_theme_mod( 'responsive_header_primary_row_bottom_border_size' );
			if ( $old_primary_border_size !== false && ! get_theme_mod( 'responsive_header_primary_row_bottom_border_size_tablet' ) ) {
				set_theme_mod( 'responsive_header_primary_row_bottom_border_size_tablet', $old_primary_border_size );
				set_theme_mod( 'responsive_header_primary_row_bottom_border_size_mobile', $old_primary_border_size );
			}

			// Header Below Row Border Size
			$old_below_border_size = get_theme_mod( 'responsive_header_below_row_bottom_border_size' );
			if ( $old_below_border_size !== false && ! get_theme_mod( 'responsive_header_below_row_bottom_border_size_tablet' ) ) {
				set_theme_mod( 'responsive_header_below_row_bottom_border_size_tablet', $old_below_border_size );
				set_theme_mod( 'responsive_header_below_row_bottom_border_size_mobile', $old_below_border_size );
			}

			$responsive_options['mobile_header_builder_backward_done'] = true;
            update_option( 'responsive_theme_options', $responsive_options );
			
		}
	}

}

if( ! function_exists( 'responsive_theme_background_updater_mobile_tablet_items_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile/tablet header items migration.
	 * 
	 * Migrates old header elements from responsive_header_elements and responsive_header_desktop_items
	 * to the new responsive_header_mobile_tablet_items structure, preserving element positions
	 * across zones and regions.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_tablet_items_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_tablet_items_backward_done'])) {
			
			// Get default mobile/tablet items structure
			$mobile_tablet_items = get_theme_mod( 
				'responsive_header_mobile_tablet_items', 
				Responsive\Core\get_responsive_customizer_defaults( 'responsive_header_mobile_tablet_items' ) 
			);
			
			// Check if mobile_tablet_items has been manually configured (not default)
			$is_default = true;
			$default_items = Responsive\Core\get_responsive_customizer_defaults( 'responsive_header_mobile_tablet_items' );
			
			// Compare current structure with defaults to see if user has customized it
			if ( is_array( $mobile_tablet_items ) && is_array( $default_items ) ) {
				// Check if primary row has more than just logo and toggle_button
				if ( !empty( $mobile_tablet_items['primary']['primary_left'] ) && 
					 count( $mobile_tablet_items['primary']['primary_left'] ) > 1 ) {
					$is_default = false;
				}
				if ( !empty( $mobile_tablet_items['primary']['primary_right'] ) && 
					 count( $mobile_tablet_items['primary']['primary_right'] ) > 1 ) {
					$is_default = false;
				}
				// Check if any other zones have items
				foreach ( array( 'above', 'below' ) as $row ) {
					foreach ( $mobile_tablet_items[ $row ] as $zone => $items ) {
						if ( !empty( $items ) ) {
							$is_default = false;
							break 2;
						}
					}
				}
			}
			
			// Only migrate if using default structure
			if ( $is_default ) {
				
				// Get old header elements (simple array like ['site-branding', 'main-navigation'])
				$old_header_elements = get_theme_mod( 'responsive_header_elements', array() );
				
				// Get desktop items to understand element positions
				$desktop_items = get_theme_mod( 
					'responsive_header_desktop_items', 
					Responsive\Core\get_responsive_customizer_defaults( 'responsive_header_desktop_items' ) 
				);
				
				// Track if primary navigation exists in desktop items
				$has_primary_navigation = false;
				
				// Element mapping: old name => new name
				$element_mapping = array(
					'site-branding' => 'logo',
					'main-navigation' => 'primary_navigation',
				);
				
				// Map old elements to new element names
				$mapped_elements = array();
				if ( is_array( $old_header_elements ) ) {
					foreach ( $old_header_elements as $old_element ) {
						if ( isset( $element_mapping[ $old_element ] ) ) {
							$mapped_elements[] = $element_mapping[ $old_element ];
						}
					}
				}
				
				// Check if primary navigation exists in desktop items
				if ( is_array( $desktop_items ) && !empty( $desktop_items ) ) {
					foreach ( array( 'above', 'primary', 'below' ) as $row ) {
						if ( isset( $desktop_items[ $row ] ) && is_array( $desktop_items[ $row ] ) ) {
							foreach ( $desktop_items[ $row ] as $zone => $elements ) {
								if ( is_array( $elements ) && in_array( 'primary_navigation', $elements, true ) ) {
									$has_primary_navigation = true;
									break 2;
								}
							}
							if ( $has_primary_navigation ) {
								break;
							}
						}
					}
				}
				
				// Also check in old_header_elements for 'main-navigation'
				if ( !$has_primary_navigation && is_array( $old_header_elements ) && in_array( 'main-navigation', $old_header_elements, true ) ) {
					$has_primary_navigation = true;
				}
				
				// If we have desktop items, use them to determine positions
				if ( is_array( $desktop_items ) && !empty( $desktop_items ) ) {
					
					// Migrate elements from desktop items to mobile/tablet items
					// Check each row (above, primary, below)
					foreach ( array( 'above', 'primary', 'below' ) as $row ) {
						if ( isset( $desktop_items[ $row ] ) && is_array( $desktop_items[ $row ] ) ) {
							// Check each zone in the row
							foreach ( $desktop_items[ $row ] as $zone => $elements ) {
								if ( is_array( $elements ) && !empty( $elements ) ) {
									// Map each element to mobile/tablet equivalent
									foreach ( $elements as $element ) {
										$mobile_element = null;
										$target_zone = $zone;
										
										// Map elements for mobile/tablet
										switch ( $element ) {
											case 'logo':
												// Logo stays in primary_left for mobile/tablet
												if ( $row === 'primary' ) {
													$mobile_element = 'logo';
													$target_zone = 'primary_left';
												}
												break;
												
											case 'primary_navigation':
												// Primary navigation becomes off_canvas_menu in popup and toggle_button in primary_right
												// Only add if primary navigation exists in desktop items
												if ( $row === 'primary' && $has_primary_navigation ) {
													// Add off_canvas_menu to popup if not already present
													if ( !in_array( 'off_canvas_menu', $mobile_tablet_items['popup']['popup_content'], true ) ) {
														$mobile_tablet_items['popup']['popup_content'][] = 'off_canvas_menu';
													}
													// Add toggle_button to primary_right if not already present
													if ( !in_array( 'toggle_button', $mobile_tablet_items['primary']['primary_right'], true ) ) {
														$mobile_tablet_items['primary']['primary_right'][] = 'toggle_button';
													}
												}
												break;
												
											case 'secondary_navigation':
												// Secondary navigation can stay in same position or move to above row
												$mobile_element = 'secondary_navigation';
												break;
												
											case 'social':
												// Social icons stay in same position
												$mobile_element = 'social';
												break;
												
											case 'header_html':
												// HTML stays in same position
												$mobile_element = 'header_html';
												break;
												
											case 'header_button':
												// Button stays in same position
												$mobile_element = 'header_button';
												break;
												
											case 'header_widgets1':
												// Widgets stay in same position
												$mobile_element = 'header_widgets1';
												break;
												
											case 'header_contact_info':
												// Contact info stays in same position
												$mobile_element = 'header_contact_info';
												break;
												
											case 'search':
												// Search stays in same position
												$mobile_element = 'search';
												break;
												
											case 'woo-cart':
												// WooCommerce cart stays in same position
												if ( class_exists( 'WooCommerce' ) ) {
													$mobile_element = 'woo-cart';
												}
												break;
										}
										
										// Add element to mobile/tablet items if mapped
										if ( $mobile_element && isset( $mobile_tablet_items[ $row ][ $target_zone ] ) ) {
											if ( !in_array( $mobile_element, $mobile_tablet_items[ $row ][ $target_zone ], true ) ) {
												$mobile_tablet_items[ $row ][ $target_zone ][] = $mobile_element;
											}
										}
									}
								}
							}
						}
					}
					
				} else {
					// Fallback: Use old header_elements array if desktop_items is not available
					if ( is_array( $old_header_elements ) && !empty( $old_header_elements ) ) {
						
						// Default positions for common elements
						if ( in_array( 'site-branding', $old_header_elements, true ) ) {
							// Logo in primary_left
							if ( !in_array( 'logo', $mobile_tablet_items['primary']['primary_left'], true ) ) {
								$mobile_tablet_items['primary']['primary_left'][] = 'logo';
							}
						}
						
						// Only add toggle_button if primary navigation exists
						if ( $has_primary_navigation ) {
							// Off canvas menu in popup
							if ( !in_array( 'off_canvas_menu', $mobile_tablet_items['popup']['popup_content'], true ) ) {
								$mobile_tablet_items['popup']['popup_content'][] = 'off_canvas_menu';
							}
							// Toggle button in primary_right
							if ( !in_array( 'toggle_button', $mobile_tablet_items['primary']['primary_right'], true ) ) {
								$mobile_tablet_items['primary']['primary_right'][] = 'toggle_button';
							}
						}
					}
				}
				
				// Ensure we always have at least logo if nothing was migrated
				if ( empty( $mobile_tablet_items['primary']['primary_left'] ) ) {
					$mobile_tablet_items['primary']['primary_left'] = array( 'logo' );
				}
				
				// Only add toggle_button and off_canvas_menu if primary navigation exists
				if ( $has_primary_navigation ) {
					if ( empty( $mobile_tablet_items['primary']['primary_right'] ) ) {
						$mobile_tablet_items['primary']['primary_right'] = array( 'toggle_button' );
					}
					if ( empty( $mobile_tablet_items['popup']['popup_content'] ) ) {
						$mobile_tablet_items['popup']['popup_content'] = array( 'off_canvas_menu' );
					}
				} else {
					// Remove toggle_button if primary navigation doesn't exist
					if ( isset( $mobile_tablet_items['primary']['primary_right'] ) && is_array( $mobile_tablet_items['primary']['primary_right'] ) ) {
						$mobile_tablet_items['primary']['primary_right'] = array_values( array_filter( $mobile_tablet_items['primary']['primary_right'], function( $item ) {
							return $item !== 'toggle_button';
						} ) );
					}
					// Remove off_canvas_menu if primary navigation doesn't exist
					if ( isset( $mobile_tablet_items['popup']['popup_content'] ) && is_array( $mobile_tablet_items['popup']['popup_content'] ) ) {
						$mobile_tablet_items['popup']['popup_content'] = array_values( array_filter( $mobile_tablet_items['popup']['popup_content'], function( $item ) {
							return $item !== 'off_canvas_menu';
						} ) );
					}
				}
				
				// Save the migrated mobile/tablet items
				set_theme_mod( 'responsive_header_mobile_tablet_items', $mobile_tablet_items );
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_tablet_items_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_html_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile header HTML settings migration.
	 * 
	 * Migrates old header_html theme mod values to the new mobile_header_html theme mods
	 * since earlier the same styles were getting applied for both mobile and desktop.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_html_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_header_html_backward_done'])) {
			
			// Mapping of old header_html theme mods to new mobile_header_html theme mods
			$theme_mod_mapping = array(
				'responsive_header_html_content' => 'responsive_mobile_header_html_content',
				'responsive_header_html_auto_add_paragraph' => 'responsive_mobile_header_html_auto_add_paragraph',
				'responsive_header_html_link_style' => 'responsive_mobile_header_html_link_style',
				'responsive_header_html_link_color' => 'responsive_mobile_header_html_link_color',
				'responsive_header_html_link_hover_color' => 'responsive_mobile_header_html_link_hover_color',
				'responsive_header_html_margin_top_padding' => 'responsive_mobile_header_html_margin_top_padding',
				'responsive_header_html_margin_right_padding' => 'responsive_mobile_header_html_margin_right_padding',
				'responsive_header_html_margin_bottom_padding' => 'responsive_mobile_header_html_margin_bottom_padding',
				'responsive_header_html_margin_left_padding' => 'responsive_mobile_header_html_margin_left_padding',
				'responsive_header_html_margin_tablet_top_padding' => 'responsive_mobile_header_html_margin_tablet_top_padding',
				'responsive_header_html_margin_tablet_right_padding' => 'responsive_mobile_header_html_margin_tablet_right_padding',
				'responsive_header_html_margin_tablet_bottom_padding' => 'responsive_mobile_header_html_margin_tablet_bottom_padding',
				'responsive_header_html_margin_tablet_left_padding' => 'responsive_mobile_header_html_margin_tablet_left_padding',
				'responsive_header_html_margin_mobile_top_padding' => 'responsive_mobile_header_html_margin_mobile_top_padding',
				'responsive_header_html_margin_mobile_right_padding' => 'responsive_mobile_header_html_margin_mobile_right_padding',
				'responsive_header_html_margin_mobile_bottom_padding' => 'responsive_mobile_header_html_margin_mobile_bottom_padding',
				'responsive_header_html_margin_mobile_left_padding' => 'responsive_mobile_header_html_margin_mobile_left_padding',
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_header_html_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_contact_info_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile header contact info settings migration.
	 * 
	 * Migrates old header_contact_info theme mod values to the new mobile_header_contact_info theme mods
	 * since earlier there was only header contact info and now there's a separate one for mobile and tablet.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_contact_info_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_header_contact_info_backward_done'])) {
			
			// Mapping of old header_contact_info theme mods to new mobile_header_contact_info theme mods
			$theme_mod_mapping = array(
				'responsive_header_contact_info' => 'responsive_mobile_header_contact_info',
				'responsive_header_contact_info_icon_shape' => 'responsive_mobile_header_contact_info_icon_shape',
				'responsive_header_contact_info_icon_style' => 'responsive_mobile_header_contact_info_icon_style',
				'responsive_header_contact_info_icon_size' => 'responsive_mobile_header_contact_info_icon_size',
				'responsive_header_contact_info_item_spacing' => 'responsive_mobile_header_contact_info_item_spacing',
				'responsive_header_contact_info_icons_color' => 'responsive_mobile_header_contact_info_icons_color',
				'responsive_header_contact_info_icons_hover_color' => 'responsive_mobile_header_contact_info_icons_hover_color',
				'responsive_header_contact_info_background_color' => 'responsive_mobile_header_contact_info_background_color',
				'responsive_header_contact_info_background_hover_color' => 'responsive_mobile_header_contact_info_background_hover_color',
				'responsive_header_contact_info_font_color' => 'responsive_mobile_header_contact_info_font_color',
				'responsive_header_contact_info_font_hover_color' => 'responsive_mobile_header_contact_info_font_hover_color',
				'responsive_header_contact_info_margin_top_padding' => 'responsive_mobile_header_contact_info_margin_top_padding',
				'responsive_header_contact_info_margin_right_padding' => 'responsive_mobile_header_contact_info_margin_right_padding',
				'responsive_header_contact_info_margin_bottom_padding' => 'responsive_mobile_header_contact_info_margin_bottom_padding',
				'responsive_header_contact_info_margin_left_padding' => 'responsive_mobile_header_contact_info_margin_left_padding',
				'responsive_header_contact_info_margin_tablet_top_padding' => 'responsive_mobile_header_contact_info_margin_tablet_top_padding',
				'responsive_header_contact_info_margin_tablet_right_padding' => 'responsive_mobile_header_contact_info_margin_tablet_right_padding',
				'responsive_header_contact_info_margin_tablet_bottom_padding' => 'responsive_mobile_header_contact_info_margin_tablet_bottom_padding',
				'responsive_header_contact_info_margin_tablet_left_padding' => 'responsive_mobile_header_contact_info_margin_tablet_left_padding',
				'responsive_header_contact_info_margin_mobile_top_padding' => 'responsive_mobile_header_contact_info_margin_mobile_top_padding',
				'responsive_header_contact_info_margin_mobile_right_padding' => 'responsive_mobile_header_contact_info_margin_mobile_right_padding',
				'responsive_header_contact_info_margin_mobile_bottom_padding' => 'responsive_mobile_header_contact_info_margin_mobile_bottom_padding',
				'responsive_header_contact_info_margin_mobile_left_padding' => 'responsive_mobile_header_contact_info_margin_mobile_left_padding',
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Migrate typography settings
			$header_contact_info_typography = get_theme_mod( 'header_contact_info_typography', false );
			$mobile_header_contact_info_typography = get_theme_mod( 'mobile_header_contact_info_typography', false );
			if ( false !== $header_contact_info_typography && false === $mobile_header_contact_info_typography ) {
				set_theme_mod( 'mobile_header_contact_info_typography', $header_contact_info_typography );
			}
			
			$header_contact_info_tablet_typography = get_theme_mod( 'header_contact_info_tablet_typography', false );
			$mobile_header_contact_info_tablet_typography = get_theme_mod( 'mobile_header_contact_info_tablet_typography', false );
			if ( false !== $header_contact_info_tablet_typography && false === $mobile_header_contact_info_tablet_typography ) {
				set_theme_mod( 'mobile_header_contact_info_tablet_typography', $header_contact_info_tablet_typography );
			}
			
			$header_contact_info_mobile_typography = get_theme_mod( 'header_contact_info_mobile_typography', false );
			$mobile_header_contact_info_mobile_typography = get_theme_mod( 'mobile_header_contact_info_mobile_typography', false );
			if ( false !== $header_contact_info_mobile_typography && false === $mobile_header_contact_info_mobile_typography ) {
				set_theme_mod( 'mobile_header_contact_info_mobile_typography', $header_contact_info_mobile_typography );
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_header_contact_info_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_social_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile header social settings migration.
	 * 
	 * Migrates old header_social theme mod values to the new mobile_header_social theme mods
	 * since earlier there was only header social and now there's a separate one for mobile and tablet.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_social_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_header_social_backward_done'])) {
			
			// Mapping of old header_social theme mods to new mobile_header_social theme mods
			$theme_mod_mapping = array(
				'responsive_header_social_items' => 'responsive_mobile_header_social_items',
				'responsive_header_social_show_label' => 'responsive_mobile_header_social_show_label',
				'responsive_header_social_item_spacing' => 'responsive_mobile_header_social_item_spacing',
				'responsive_header_social_item_style' => 'responsive_mobile_header_social_item_style',
				'responsive_header_social_item_use_brand_colors' => 'responsive_mobile_header_social_item_use_brand_colors',
				'responsive_header_social_item_color' => 'responsive_mobile_header_social_item_color',
				'responsive_header_social_item_hover_color' => 'responsive_mobile_header_social_item_hover_color',
				'responsive_header_social_item_background_color' => 'responsive_mobile_header_social_item_background_color',
				'responsive_header_social_item_background_hover_color' => 'responsive_mobile_header_social_item_background_hover_color',
				'responsive_header_social_item_border_style' => 'responsive_mobile_header_social_item_border_style',
				'responsive_header_social_item_border_width' => 'responsive_mobile_header_social_item_border_width',
				'responsive_header_social_item_border_color' => 'responsive_mobile_header_social_item_border_color',
				'responsive_header_social_item_border_hover_color' => 'responsive_mobile_header_social_item_border_hover_color',
				'responsive_header_social_item_icon_size' => 'responsive_mobile_header_social_item_icon_size',
				'responsive_header_social_item_margin_top_padding' => 'responsive_mobile_header_social_item_margin_top_padding',
				'responsive_header_social_item_margin_right_padding' => 'responsive_mobile_header_social_item_margin_right_padding',
				'responsive_header_social_item_margin_bottom_padding' => 'responsive_mobile_header_social_item_margin_bottom_padding',
				'responsive_header_social_item_margin_left_padding' => 'responsive_mobile_header_social_item_margin_left_padding',
				'responsive_header_social_item_margin_tablet_top_padding' => 'responsive_mobile_header_social_item_margin_tablet_top_padding',
				'responsive_header_social_item_margin_tablet_right_padding' => 'responsive_mobile_header_social_item_margin_tablet_right_padding',
				'responsive_header_social_item_margin_tablet_bottom_padding' => 'responsive_mobile_header_social_item_margin_tablet_bottom_padding',
				'responsive_header_social_item_margin_tablet_left_padding' => 'responsive_mobile_header_social_item_margin_tablet_left_padding',
				'responsive_header_social_item_margin_mobile_top_padding' => 'responsive_mobile_header_social_item_margin_mobile_top_padding',
				'responsive_header_social_item_margin_mobile_right_padding' => 'responsive_mobile_header_social_item_margin_mobile_right_padding',
				'responsive_header_social_item_margin_mobile_bottom_padding' => 'responsive_mobile_header_social_item_margin_mobile_bottom_padding',
				'responsive_header_social_item_margin_mobile_left_padding' => 'responsive_mobile_header_social_item_margin_mobile_left_padding',
				'responsive_header_social_radius_top_left_radius' => 'responsive_mobile_header_social_radius_top_left_radius',
				'responsive_header_social_radius_top_right_radius' => 'responsive_mobile_header_social_radius_top_right_radius',
				'responsive_header_social_radius_bottom_right_radius' => 'responsive_mobile_header_social_radius_bottom_right_radius',
				'responsive_header_social_radius_bottom_left_radius' => 'responsive_mobile_header_social_radius_bottom_left_radius',
				'responsive_header_social_radius_tablet_top_left_radius' => 'responsive_mobile_header_social_radius_tablet_top_left_radius',
				'responsive_header_social_radius_tablet_top_right_radius' => 'responsive_mobile_header_social_radius_tablet_top_right_radius',
				'responsive_header_social_radius_tablet_bottom_right_radius' => 'responsive_mobile_header_social_radius_tablet_bottom_right_radius',
				'responsive_header_social_radius_tablet_bottom_left_radius' => 'responsive_mobile_header_social_radius_tablet_bottom_left_radius',
				'responsive_header_social_radius_mobile_top_left_radius' => 'responsive_mobile_header_social_radius_mobile_top_left_radius',
				'responsive_header_social_radius_mobile_top_right_radius' => 'responsive_mobile_header_social_radius_mobile_top_right_radius',
				'responsive_header_social_radius_mobile_bottom_right_radius' => 'responsive_mobile_header_social_radius_mobile_bottom_right_radius',
				'responsive_header_social_radius_mobile_bottom_left_radius' => 'responsive_mobile_header_social_radius_mobile_bottom_left_radius',
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Migrate typography settings
			$header_social_item_typography = get_theme_mod( 'header_social_item_typography', false );
			$mobile_header_social_item_typography = get_theme_mod( 'mobile_header_social_item_typography', false );
			if ( false !== $header_social_item_typography && false === $mobile_header_social_item_typography ) {
				set_theme_mod( 'mobile_header_social_item_typography', $header_social_item_typography );
			}
			
			$header_social_item_tablet_typography = get_theme_mod( 'header_social_item_tablet_typography', false );
			$mobile_header_social_item_tablet_typography = get_theme_mod( 'mobile_header_social_item_tablet_typography', false );
			if ( false !== $header_social_item_tablet_typography && false === $mobile_header_social_item_tablet_typography ) {
				set_theme_mod( 'mobile_header_social_item_tablet_typography', $header_social_item_tablet_typography );
			}
			
			$header_social_item_mobile_typography = get_theme_mod( 'header_social_item_mobile_typography', false );
			$mobile_header_social_item_mobile_typography = get_theme_mod( 'mobile_header_social_item_mobile_typography', false );
			if ( false !== $header_social_item_mobile_typography && false === $mobile_header_social_item_mobile_typography ) {
				set_theme_mod( 'mobile_header_social_item_mobile_typography', $header_social_item_mobile_typography );
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_header_social_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_button_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile header button settings migration.
	 * 
	 * Migrates old header_button theme mod values to the new mobile_header_button theme mods
	 * since earlier there was only header button and now there's a separate one for mobile and tablet.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_button_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_header_button_backward_done'])) {
			
			// Mapping of old header_button theme mods to new mobile_header_button theme mods
			$theme_mod_mapping = array(
				// Basic settings
				'responsive_header_button_label' => 'responsive_mobile_header_button_label',
				'responsive_header_button_url' => 'responsive_mobile_header_button_url',
				'responsive_header_button_open_in_new_tab' => 'responsive_mobile_header_button_open_in_new_tab',
				'responsive_header_button_set_nofollow' => 'responsive_mobile_header_button_set_nofollow',
				'responsive_header_button_set_sponsored' => 'responsive_mobile_header_button_set_sponsored',
				'responsive_header_button_set_download' => 'responsive_mobile_header_button_set_download',
				'responsive_header_button_style' => 'responsive_mobile_header_button_style',
				'responsive_header_button_visibility' => 'responsive_mobile_header_button_visibility',
				'responsive_header_button_size' => 'responsive_mobile_header_button_size',
				
				// Color settings
				'responsive_header_button_color' => 'responsive_mobile_header_button_color',
				'responsive_header_button_hover_color' => 'responsive_mobile_header_button_hover_color',
				'responsive_header_button_bg_color' => 'responsive_mobile_header_button_bg_color',
				'responsive_header_button_bg_hover_color' => 'responsive_mobile_header_button_bg_hover_color',
				'responsive_header_button_border_color' => 'responsive_mobile_header_button_border_color',
				'responsive_header_button_border_color_hover' => 'responsive_mobile_header_button_border_color_hover',
				
				// Border settings
				'responsive_header_button_border_style' => 'responsive_mobile_header_button_border_style',
				'responsive_header_button_border_width' => 'responsive_mobile_header_button_border_width',
				
				// Padding settings - Desktop
				'responsive_header_button_top_padding' => 'responsive_mobile_header_button_top_padding',
				'responsive_header_button_right_padding' => 'responsive_mobile_header_button_right_padding',
				'responsive_header_button_bottom_padding' => 'responsive_mobile_header_button_bottom_padding',
				'responsive_header_button_left_padding' => 'responsive_mobile_header_button_left_padding',
				
				// Padding settings - Tablet
				'responsive_header_button_tablet_top_padding' => 'responsive_mobile_header_button_tablet_top_padding',
				'responsive_header_button_tablet_right_padding' => 'responsive_mobile_header_button_tablet_right_padding',
				'responsive_header_button_tablet_bottom_padding' => 'responsive_mobile_header_button_tablet_bottom_padding',
				'responsive_header_button_tablet_left_padding' => 'responsive_mobile_header_button_tablet_left_padding',
				
				// Padding settings - Mobile
				'responsive_header_button_mobile_top_padding' => 'responsive_mobile_header_button_mobile_top_padding',
				'responsive_header_button_mobile_right_padding' => 'responsive_mobile_header_button_mobile_right_padding',
				'responsive_header_button_mobile_bottom_padding' => 'responsive_mobile_header_button_mobile_bottom_padding',
				'responsive_header_button_mobile_left_padding' => 'responsive_mobile_header_button_mobile_left_padding',
				
				// Border radius settings - Desktop
				'responsive_header_button_radius_top_left_radius' => 'responsive_mobile_header_button_radius_top_left_radius',
				'responsive_header_button_radius_top_right_radius' => 'responsive_mobile_header_button_radius_top_right_radius',
				'responsive_header_button_radius_bottom_right_radius' => 'responsive_mobile_header_button_radius_bottom_right_radius',
				'responsive_header_button_radius_bottom_left_radius' => 'responsive_mobile_header_button_radius_bottom_left_radius',
				
				// Border radius settings - Tablet
				'responsive_header_button_radius_tablet_top_left_radius' => 'responsive_mobile_header_button_radius_tablet_top_left_radius',
				'responsive_header_button_radius_tablet_top_right_radius' => 'responsive_mobile_header_button_radius_tablet_top_right_radius',
				'responsive_header_button_radius_tablet_bottom_right_radius' => 'responsive_mobile_header_button_radius_tablet_bottom_right_radius',
				'responsive_header_button_radius_tablet_bottom_left_radius' => 'responsive_mobile_header_button_radius_tablet_bottom_left_radius',
				
				// Border radius settings - Mobile
				'responsive_header_button_radius_mobile_top_left_radius' => 'responsive_mobile_header_button_radius_mobile_top_left_radius',
				'responsive_header_button_radius_mobile_top_right_radius' => 'responsive_mobile_header_button_radius_mobile_top_right_radius',
				'responsive_header_button_radius_mobile_bottom_right_radius' => 'responsive_mobile_header_button_radius_mobile_bottom_right_radius',
				'responsive_header_button_radius_mobile_bottom_left_radius' => 'responsive_mobile_header_button_radius_mobile_bottom_left_radius',
				
				// Margin settings - Desktop
				'responsive_header_button_margin_top_padding' => 'responsive_mobile_header_button_margin_top_padding',
				'responsive_header_button_margin_right_padding' => 'responsive_mobile_header_button_margin_right_padding',
				'responsive_header_button_margin_bottom_padding' => 'responsive_mobile_header_button_margin_bottom_padding',
				'responsive_header_button_margin_left_padding' => 'responsive_mobile_header_button_margin_left_padding',
				
				// Margin settings - Tablet
				'responsive_header_button_margin_tablet_top_padding' => 'responsive_mobile_header_button_margin_tablet_top_padding',
				'responsive_header_button_margin_tablet_right_padding' => 'responsive_mobile_header_button_margin_tablet_right_padding',
				'responsive_header_button_margin_tablet_bottom_padding' => 'responsive_mobile_header_button_margin_tablet_bottom_padding',
				'responsive_header_button_margin_tablet_left_padding' => 'responsive_mobile_header_button_margin_tablet_left_padding',
				
				// Margin settings - Mobile
				'responsive_header_button_margin_mobile_top_padding' => 'responsive_mobile_header_button_margin_mobile_top_padding',
				'responsive_header_button_margin_mobile_right_padding' => 'responsive_mobile_header_button_margin_mobile_right_padding',
				'responsive_header_button_margin_mobile_bottom_padding' => 'responsive_mobile_header_button_margin_mobile_bottom_padding',
				'responsive_header_button_margin_mobile_left_padding' => 'responsive_mobile_header_button_margin_mobile_left_padding',
				
				// Shadow settings
				'responsive_header_button_shadow_x_axis' => 'responsive_mobile_header_button_shadow_x_axis',
				'responsive_header_button_shadow_y_axis' => 'responsive_mobile_header_button_shadow_y_axis',
				'responsive_header_button_shadow_blur' => 'responsive_mobile_header_button_shadow_blur',
				'responsive_header_button_shadow_spread' => 'responsive_mobile_header_button_shadow_spread',
				'responsive_header_button_shadow_inset' => 'responsive_mobile_header_button_shadow_inset',
				'responsive_header_button_shadow_color' => 'responsive_mobile_header_button_shadow_color',
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Migrate typography settings
			$header_button_typography = get_theme_mod( 'header_button_typography', false );
			$mobile_header_button_typography = get_theme_mod( 'mobile_header_button_typography', false );
			if ( false !== $header_button_typography && false === $mobile_header_button_typography ) {
				set_theme_mod( 'mobile_header_button_typography', $header_button_typography );
			}
			
			$header_button_tablet_typography = get_theme_mod( 'header_button_tablet_typography', false );
			$mobile_header_button_tablet_typography = get_theme_mod( 'mobile_header_button_tablet_typography', false );
			if ( false !== $header_button_tablet_typography && false === $mobile_header_button_tablet_typography ) {
				set_theme_mod( 'mobile_header_button_tablet_typography', $header_button_tablet_typography );
			}
			
			$header_button_mobile_typography = get_theme_mod( 'header_button_mobile_typography', false );
			$mobile_header_button_mobile_typography = get_theme_mod( 'mobile_header_button_mobile_typography', false );
			if ( false !== $header_button_mobile_typography && false === $mobile_header_button_mobile_typography ) {
				set_theme_mod( 'mobile_header_button_mobile_typography', $header_button_mobile_typography );
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_header_button_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_mobile_header_widgets_6_2_9' )) {
	/**
	 * Handle backward compatibility for mobile header widgets settings migration.
	 * 
	 * Migrates old header_widget theme mod values to the new mobile_header_widget theme mods
	 * since earlier there was only header widgets and now there's a separate one for mobile and tablet.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_header_widgets_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();
		
		if( !isset( $responsive_options['mobile_header_widgets_backward_done'])) {
			
			// Mapping of old header_widget theme mods to new mobile_header_widget theme mods
			$theme_mod_mapping = array(
				// Color settings
				'responsive_header_widget_text_color' => 'responsive_mobile_header_widget_text_color',
				'responsive_header_widget_background_color' => 'responsive_mobile_header_widget_background_color',
				'responsive_header_widget_border_color' => 'responsive_mobile_header_widget_border_color',
				'responsive_header_widget_link_color' => 'responsive_mobile_header_widget_link_color',
				'responsive_header_widget_link_hover_color' => 'responsive_mobile_header_widget_link_hover_color',
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Migrate typography settings
			$header_widgets_typography = get_theme_mod( 'header_widgets_typography', false );
			$mobile_header_widgets_typography = get_theme_mod( 'mobile_header_widgets_typography', false );
			if ( false !== $header_widgets_typography && false === $mobile_header_widgets_typography ) {
				set_theme_mod( 'mobile_header_widgets_typography', $header_widgets_typography );
			}
			
			$header_widgets_tablet_typography = get_theme_mod( 'header_widgets_tablet_typography', false );
			$mobile_header_widgets_tablet_typography = get_theme_mod( 'mobile_header_widgets_tablet_typography', false );
			if ( false !== $header_widgets_tablet_typography && false === $mobile_header_widgets_tablet_typography ) {
				set_theme_mod( 'mobile_header_widgets_tablet_typography', $header_widgets_tablet_typography );
			}
			
			$header_widgets_mobile_typography = get_theme_mod( 'header_widgets_mobile_typography', false );
			$mobile_header_widgets_mobile_typography = get_theme_mod( 'mobile_header_widgets_mobile_typography', false );
			if ( false !== $header_widgets_mobile_typography && false === $mobile_header_widgets_mobile_typography ) {
				set_theme_mod( 'mobile_header_widgets_mobile_typography', $header_widgets_mobile_typography );
			}
			
			// Migrate widgets from old 'header-widgets' sidebar to new 'mobile-header-widgets' sidebar
			$sidebars_widgets = wp_get_sidebars_widgets();
			
			// Check if old header-widgets sidebar has widgets
			$header_widgets = isset( $sidebars_widgets['header-widgets'] ) ? $sidebars_widgets['header-widgets'] : array();
			
			// Check if new mobile-header-widgets sidebar is empty
			$mobile_header_widgets = isset( $sidebars_widgets['mobile-header-widgets'] ) ? $sidebars_widgets['mobile-header-widgets'] : array();
			
			// Only migrate if old sidebar has widgets and new sidebar is empty
			if ( ! empty( $header_widgets ) && empty( $mobile_header_widgets ) ) {
				// Copy widgets from header-widgets to mobile-header-widgets
				$sidebars_widgets['mobile-header-widgets'] = $header_widgets;
				
				// Update the sidebars_widgets option
				wp_set_sidebars_widgets( $sidebars_widgets );
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_header_widgets_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if ( ! function_exists( 'responsive_theme_background_updater_global_palette_revamp' ) ) {

	/**
     * Migrates old Responsive theme global color palette settings 
     * to the new global palette structure (revamp v2).
     *
     * This function runs once as a backward-compatibility updater.
     * It checks whether the new palette format (`global_palette_revamp_v2`)
     * has been applied. If not, it retrieves values from legacy
     * `responsive_color_scheme` and old individual palette theme_mods,
     * converts them into the new palette array format, and saves them
     * into the `responsive_global_color_palette` theme_mod.
     *
     * After migration, it marks the revamp as completed inside
     * `responsive_theme_options` to avoid running again.
     *
     * @since 6.3.0
     *
     * @return void
     */
	function responsive_theme_background_updater_global_palette_revamp() {
		$responsive_options = Responsive\Core\responsive_get_options();

		if ( empty( $responsive_options['global_palette_revamp_v2'] ) ) {
			$old_palette_scheme = get_theme_mod( 'responsive_color_scheme' );
			if ( $old_palette_scheme ) {
				$new_palette = array (
					'style' => $old_palette_scheme,
					'palette' => array (
						'label'              => '',
						'accent'             => get_theme_mod( 'responsive_global_color_palette_accent_color', '#0066CC' ),
						'link_hover'		 => get_theme_mod( 'responsive_global_color_palette_link_hover_color', '#10659C' ),
						'text'               => get_theme_mod( 'responsive_global_color_palette_text_color', '#333333' ),
						'header_text'        => get_theme_mod( 'responsive_global_color_palette_headings_color', '#333333' ),
						'content_background' => get_theme_mod( 'responsive_global_color_palette_content_bg_color', '#ffffff' ),
						'site_background'    => get_theme_mod( 'responsive_global_color_palette_site_background_color', '#f0f5fa' ),
						'alt_background'     => get_theme_mod( 'responsive_global_color_palette_alt_background_color', '#eaeaea' ),
					)
				);
				set_theme_mod( 'responsive_global_color_palette', $new_palette );
			}

			// Mark backward compatibility update as done
			$responsive_options['global_palette_revamp_v2'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}
if( ! function_exists( 'responsive_theme_background_updater_off_canvas_menu_6_2_9') ) {
	/**
	 * Handle backward compatibility for off-canvas menu background settings migration.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_off_canvas_menu_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();

		if( !isset( $responsive_options['off_canvas_menu_background_backward_done'])) {
			
			// Mapping of old off_canvas_menu background theme mods to new ones
			$theme_mod_mapping = array(
				'responsive_header_menu_toggle_color' => 'responsive_header_toggle_button_icon_color',
				'responsive_header_menu_link_color' => 'responsive_header_off_canvas_menu_link_default_color',
				'responsive_header_active_menu_link_color' => 'responsive_header_off_canvas_menu_link_active_color',
				'responsive_header_menu_link_hover_color' => 'responsive_header_off_canvas_menu_link_hover_color',
				'responsive_header_hover_menu_background_color' => 'responsive_header_off_canvas_menu_bg_hover_color',
				'responsive_header_mobile_menu_background_color'=>'responsive_header_off_canvas_menu_bg_default_color',
				'responsive_header_active_menu_background_color' => 'responsive_header_off_canvas_menu_bg_active_color',
			);

			$check_trans_header = get_theme_mod( 'responsive_transparent_header', 0 ); 
			if( $check_trans_header === 1) 
			{
				$theme_mod_mapping['responsive_transparent_header_mobile_menu_background_color'] = 'responsive_header_mobile_menu_background_color';
			}
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Mark backward compatibility update as done
			$responsive_options['off_canvas_menu_background_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( ! function_exists( 'responsive_theme_background_updater_off_canvas_fonts_toggle_button_color_new_6_2_9') ) {
	/**
	 * Handle backward compatibility for off-canvas menu background settings migration.
	 * 
	 * @since 6.2.9
	 * @return void
	 */
	function responsive_theme_background_updater_off_canvas_fonts_toggle_button_color_new_6_2_9(){
		$responsive_options = Responsive\Core\responsive_get_options();

		if( !isset( $responsive_options['off_canvas_menu_font_toggle_button_color_backward_done'])) {
			
			// Mapping of old off_canvas_menu background theme mods to new ones
			$theme_mod_mapping = array(
				'responsive_header_menu_toggle_color' => 'responsive_header_toggle_button_icon_color',
				'header_menu_typography' => 'header_off_canvas_menu_typography',

			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists and new value doesn't exist
				if ( false !== $old_value && false === $new_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Mark backward compatibility update as done
			$responsive_options['off_canvas_menu_font_toggle_button_color_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}

if( !function_exists( 'responsive_theme_background_updater_mobile_footer_6_3_0' ) ) {
	/**
	 * Handle backward compatibility for mobile footer settings migration.
	 * 
	 * Migrates desktop footer elements to mobile footer items, preserving element positions
	 * across rows and columns.
	 * 
	 * @since 6.3.0
	 * @return void
	 */
	function responsive_theme_background_updater_mobile_footer_6_3_0(){
		$responsive_options = Responsive\Core\responsive_get_options();

		if( !isset( $responsive_options['mobile_footer_6_3_0_backward_done'])) {
			
			// Get default mobile items structure
			$mobile_items = get_theme_mod( 
				'responsive_footer_mobile_items', 
				Responsive\Core\get_responsive_customizer_defaults( 'responsive_footer_mobile_items' ) 
			);
			
			// Check if mobile_items has been manually configured (not default)
			$is_default = true;
			$default_items = Responsive\Core\get_responsive_customizer_defaults( 'responsive_footer_mobile_items' );
			
			// Compare current structure with defaults to see if user has customized it
			if ( is_array( $mobile_items ) && is_array( $default_items ) ) {
				// Check each row (above, primary, below)
				foreach ( array( 'above', 'primary', 'below' ) as $row ) {
					if ( isset( $mobile_items[ $row ] ) && is_array( $mobile_items[ $row ] ) ) {
						// Check each column in the row
						foreach ( $mobile_items[ $row ] as $column => $items ) {
							if ( is_array( $items ) && !empty( $items ) ) {
								// Check if this differs from default (default only has footer_copyright in below_1)
								if ( $row !== 'below' || $column !== 'below_1' || 
									 !in_array( 'footer_copyright', $items, true ) || 
									 count( $items ) > 1 ) {
									$is_default = false;
									break 2;
								}
							}
						}
					}
				}
			}
			
			// Only migrate if using default structure
			if ( $is_default ) {
				
				// Get desktop items to understand element positions
				$desktop_items = get_theme_mod( 
					'responsive_footer_items', 
					Responsive\Core\get_responsive_customizer_defaults( 'responsive_footer_items' ) 
				);
				
				// If we have desktop items, copy them to mobile items
				if ( is_array( $desktop_items ) && !empty( $desktop_items ) ) {
					
					// Start with a clean mobile items structure (no default elements)
					$mobile_items = array(
						'above' => array(
							'above_1' => array(),
							'above_2' => array(),
							'above_3' => array(),
							'above_4' => array(),
							'above_5' => array(),
							'above_6' => array(),
						),
						'primary' => array(
							'primary_1' => array(),
							'primary_2' => array(),
							'primary_3' => array(),
							'primary_4' => array(),
							'primary_5' => array(),
							'primary_6' => array(),
						),
						'below' => array(
							'below_1' => array(),
							'below_2' => array(),
							'below_3' => array(),
							'below_4' => array(),
							'below_5' => array(),
							'below_6' => array(),
						),
					);
					
					// Migrate elements from desktop items to mobile items
					// Check each row (above, primary, below)
					foreach ( array( 'above', 'primary', 'below' ) as $row ) {
						if ( isset( $desktop_items[ $row ] ) && is_array( $desktop_items[ $row ] ) ) {
							// Check if this row has any elements at all in desktop
							$row_has_elements = false;
							foreach ( $desktop_items[ $row ] as $column => $elements ) {
								if ( is_array( $elements ) && !empty( $elements ) ) {
									$row_has_elements = true;
									break;
								}
							}
							
							// If row has no elements in desktop, keep all columns empty (already initialized above)
							// If row has elements, copy them column by column
							if ( $row_has_elements ) {
								foreach ( $desktop_items[ $row ] as $column => $elements ) {
									if ( is_array( $elements ) && isset( $mobile_items[ $row ][ $column ] ) ) {
										// Copy only the elements that exist in desktop
										$mobile_items[ $row ][ $column ] = $elements;
									}
								}
							}
							// If row has no elements, columns remain empty (no action needed)
						}
					}
					
					// Save the migrated mobile items
					set_theme_mod( 'responsive_footer_mobile_items', $mobile_items );
				}
			}

			// Mapping of old off_canvas_menu background theme mods to new ones
			$theme_mod_mapping = array(
				'responsive_footer_above_row_bg_color'				   => 'responsive_footer_above_row_bg_color_tablet',
				'responsive_footer_primary_row_bg_color' 			   => 'responsive_footer_primary_row_bg_color_tablet',
				'responsive_footer_below_row_bg_color'  			   => 'responsive_footer_below_row_bg_color_tablet',
				'responsive_footer_above_row_bg_color'   	           => 'responsive_footer_above_row_bg_color_mobile',
				'responsive_footer_primary_row_bg_color' 	           => 'responsive_footer_primary_row_bg_color_mobile',
				'responsive_footer_below_row_bg_color' 	 	           => 'responsive_footer_below_row_bg_color_mobile',
				'responsive_footer_above_height' 					   => 'responsive_footer_above_height_tablet',
				'responsive_footer_primary_height' 					   => 'responsive_footer_primary_height_tablet',
				'responsive_footer_below_height' 					   => 'responsive_footer_below_height_tablet',
				'responsive_footer_above_height' 			 		   => 'responsive_footer_above_height_mobile',
				'responsive_footer_primary_height' 					   => 'responsive_footer_primary_height_mobile',
				'responsive_footer_below_height'		 			   => 'responsive_footer_below_height_mobile',
				'responsive_scroll_to_top_icon_radius'                 => 'responsive_scroll_to_top_icon_radius_tablet',
				'responsive_scroll_to_top_icon_radius'                 => 'responsive_scroll_to_top_icon_radius_mobile',
				'responsive_scroll_to_top_icon_size'                   => 'responsive_scroll_to_top_icon_size_tablet',
				'responsive_scroll_to_top_icon_size'                   => 'responsive_scroll_to_top_icon_size_mobile',
				'responsive_scroll_to_top_icon_color'				   => 'responsive_scroll_to_top_icon_color_tablet',
				'responsive_scroll_to_top_icon_color'                  => 'responsive_scroll_to_top_icon_color_mobile',
				'responsive_scroll_to_top_icon_hover_color' 		   => 'responsive_scroll_to_top_icon_color_tablet_hover',
				'responsive_scroll_to_top_icon_hover_color' 		   => 'responsive_scroll_to_top_icon_color_mobile_hover',
				'responsive_scroll_to_top_icon_background_hover_color' => 'responsive_scroll_to_top_icon_background_color_hover',
				'responsive_scroll_to_top_icon_background_hover_color' => 'responsive_scroll_to_top_icon_background_color_mobile_hover',
				'responsive_scroll_to_top_icon_background_hover_color' => 'responsive_scroll_to_top_icon_background_color_tablet_hover',
				'responsive_footer_menu_background_color'              => 'responsive_footer_menu_background_color_tablet',
				'responsive_footer_menu_background_color'              => 'responsive_footer_menu_background_color_mobile',
				'responsive_footer_menu_background_color_hover'        => 'responsive_footer_menu_background_color_tablet_hover',
				'responsive_footer_menu_background_color_hover'        => 'responsive_footer_menu_background_color_mobile_hover',
				'responsive_footer_copyright_text_color'               => 'responsive_footer_copyright_text_color_tablet',
				'responsive_footer_copyright_text_color'			   => 'responsive_footer_copyright_text_color_mobile',
				'responsive_footer_copyright_text_hover_color'   	   => 'responsive_footer_copyright_text_color_tablet_hover',
				'responsive_footer_copyright_text_hover_color'		   => 'responsive_footer_copyright_text_color_mobile_hover',
				'responsive_footer_copyright_links_color'			   => 'responsive_footer_copyright_links_color_tablet',
				'responsive_footer_copyright_links_color'			   => 'responsive_footer_copyright_links_color_mobile',
				'responsive_footer_copyright_links_hover_color'		   => 'responsive_footer_copyright_links_color_tablet_hover',
				'responsive_footer_copyright_links_hover_color'		   => 'responsive_footer_copyright_links_color_mobile_hover',
				'responsive_footer_social_item_spacing'				   => 'responsive_footer_social_item_spacing_tablet',
				'responsive_footer_social_item_spacing'                => 'responsive_footer_social_item_spacing_mobile',
				'responsive_footer_social_item_color'                  => 'responsive_footer_social_item_color_tablet',
				'responsive_footer_social_item_color'                  => 'responsive_footer_social_item_color_mobile',
				'responsive_footer_social_item_hover_color'            => 'responsive_footer_social_item_color_tablet_hover',
				'responsive_footer_social_item_hover_color'            => 'responsive_footer_social_item_color_mobile_hover',
				'responsive_footer_social_item_background_color'       => 'responsive_footer_social_item_background_color_tablet',
				'responsive_footer_social_item_background_color'       => 'responsive_footer_social_item_background_color_mobile',
				'responsive_footer_social_item_background_hover_color' => 'responsive_footer_social_item_background_color_tablet_hover',
				'responsive_footer_social_item_background_hover_color' => 'responsive_footer_social_item_background_color_mobile_hover',
				'responsive_footer_social_item_icon_size'			   => 'responsive_footer_social_item_icon_size_tablet',
				'responsive_footer_social_item_icon_size'  			   => 'responsive_footer_social_item_icon_size_mobile',
				'responsive_footer_above_row_border_color' 			   => 'responsive_footer_above_row_border_color_tablet',
				'responsive_footer_above_row_border_color' 			   => 'responsive_footer_above_row_border_color_mobile',
				'responsive_footer_primary_row_border_color' 			   => 'responsive_footer_primary_row_border_color_tablet',
				'responsive_footer_primary_row_border_color' 			   => 'responsive_footer_primary_row_border_color_mobile',
				'responsive_footer_below_row_border_color' 			   => 'responsive_footer_below_row_border_color_tablet',
				'responsive_footer_below_row_border_color' 			   => 'responsive_footer_below_row_border_color_mobile'   
			);
			
			// Migrate each theme mod if the old value exists and new value doesn't exist
			foreach ( $theme_mod_mapping as $old_mod => $new_mod ) {
				$old_value = get_theme_mod( $old_mod, false );
				$new_value = get_theme_mod( $new_mod, false );
				
				// Only migrate if old value exists
				if ( false !== $old_value ) {
					set_theme_mod( $new_mod, $old_value );
				}
			}
			
			// Manually set tablet footer row background colors from desktop colors
			$footer_rows = array( 'above', 'primary', 'below' );
			foreach ( $footer_rows as $row ) {
				$desktop_color_mod = "responsive_footer_{$row}_row_bg_color";
				$tablet_color_mod  = "responsive_footer_{$row}_row_bg_color_tablet";
				
				$desktop_color = get_theme_mod( $desktop_color_mod, false );
				
				// If desktop color exists, set tablet color from desktop color
				if ( false !== $desktop_color ) {
					set_theme_mod( $tablet_color_mod, $desktop_color );
				}
			}
			
			// Mark backward compatibility update as done
			$responsive_options['mobile_footer_6_3_0_backward_done'] = true;
			update_option( 'responsive_theme_options', $responsive_options );
		}
	}
}