<?php
/**
 * Responsive  Theme Customizer
 *
 * @package responsive
 */

namespace Responsive\Customizer;

/**
 * Set up theme defaults and register supported WordPress features.
 *
 * @return void
 */
function setup() {
	$n = function( $function ) {
		return __NAMESPACE__ . "\\$function";
	};
	add_action( 'customize_register', $n( 'responsive_customize_register' ) );
	add_action( 'customize_preview_init', $n( 'responsive_customize_preview_js' ) );
	add_action( 'after_setup_theme', $n( 'responsive_register_options' ) );
	add_action( 'customize_register', $n( 'responsive_custom_controls' ) );
	add_action( 'customize_controls_print_scripts', $n( 'responsive_tooltip_script' ) );
	add_action( 'customize_register', $n( 'responsive_controls_helpers' ) );
	add_action( 'customize_controls_enqueue_scripts', $n( 'responsive_custom_customize_enqueue' ) );
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function responsive_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	$wp_customize->get_setting( 'header_image' )->transport    = 'refresh';
	$wp_customize->get_setting( 'custom_logo' )->transport     = 'refresh';

	/*
	--------------------------------------------------------------
	// CSS Styles
	--------------------------------------------------------------
	*/
	$wp_version = get_bloginfo( 'version' );
	if ( ! ( $wp_version >= 4.7 ) ) {
		$wp_customize->add_section(
			'css_styles',
			array(
				'title'    => __( 'CSS Styles', 'responsive' ),
				'priority' => 30,
			)
		);
		$wp_customize->add_setting(
			'responsive_theme_options[responsive_inline_css]',
			array(
				'sanitize_callback' => 'wp_filter_nohtml_kses',
				'type'              => 'option',
			)
		);
		$wp_customize->add_control(
			'res_responsive_inline_css',
			array(
				'label'    => __( 'Custom CSS Styles', 'responsive' ),
				'section'  => 'css_styles',
				'settings' => 'responsive_theme_options[responsive_inline_css]',
				'type'     => 'textarea',
			)
		);
	}

}

/**
 * Validates the Call to Action Button styles
 *
 * @param  object $input    arguments.
 *
 * @return string
 */
function responsive_pro_button_style_validate( $input ) {
	/** An array of valid results */
	$valid = array(
		'default'    => __( 'Gradient', 'responsive' ),
		'flat_style' => __( 'Flat', 'responsive' ),
	);

	if ( array_key_exists( $input, $valid ) ) {
		return $input;
	} else {
		return '';
	}
}

/**
 * Function for sanitizing
 *
 * @param object $input arguments.
 */
function responsive_sanitize_checkbox( $input ) {
	if ( $input ) {
		$output = 1;
	} else {
		$output = 0;
	}
	return $output;
}

/**
 * Function for sanitizing
 *
 * @param object $input arguments.
 */
function responsive_sanitize_posts( $input ) {
	$output            = '';
	$options_posts     = array();
	$options_posts_obj = get_posts( 'posts_per_page=-1' );
	$options_posts[''] = esc_html( __( 'Choose Post', 'responsive' ) );
	foreach ( $options_posts_obj as $posts ) {
		$options_posts[ $posts->ID ] = $posts->post_title;
	}
	$option = $options_posts;
	if ( array_key_exists( $input, $option ) ) {
		$output = $input;
	}
	return $output;
}

/**
 * Function for sanitizing checkboxes
 *
 * @param object $values arguments.
 */
function responsive_sanitize_multiple_checkboxes( $values ) {

	$multi_values = ! is_array( $values ) ? explode( ',', $values ) : $values;

	return ! empty( $multi_values ) ? array_map( 'sanitize_text_field', $multi_values ) : array();
}


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function responsive_customize_preview_js() {

	wp_enqueue_script( 'responsive_customizer', get_template_directory_uri() . '/core/js/customizer.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_color', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-color-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_checkbox', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-checkbox-control.js', array( 'customize-preview', 'jquery', 'customize-base' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_padding', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-padding-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_number', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-number-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_drag_number', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-drag-number-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_select', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-select-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_customizer_text', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-text-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_lifter_customize', get_template_directory_uri() . '/core/includes/customizer/assets/js/lifter-customize-preview.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive_theme_font-preset_customize', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-font-presets.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	if ( is_responsive_version_greater() ) {
		wp_enqueue_script( 'responsive_theme_customizer_image', get_template_directory_uri() . '/core/includes/customizer/assets/js/customize-preview-image-control.js', array( 'customize-preview' ), RESPONSIVE_THEME_VERSION, true );
	}
	$localize_array = array(
		'isDisableElementorDefaultColors' => 'yes' === get_option( 'elementor_disable_color_schemes' ) ? true : false,
		'isElementorVersion'              => defined( 'ELEMENTOR_VERSION' ) ? true : false,
	);
	wp_localize_script( 'responsive_theme_customizer_color', 'responsiveSiteLocalOptions', $localize_array );
	wp_localize_script( 'responsive_theme_customizer_padding', 'responsiveSiteLocalOptions', $localize_array );
	wp_localize_script( 'responsive_theme_customizer_number', 'responsiveSiteLocalOptions', $localize_array );
}

/**
 * Adds customizer options
 */
function responsive_register_options() {
	// Var.
	$dir = RESPONSIVE_THEME_DIR . 'core/includes/customizer/settings/';
	require get_template_directory() . '/admin/class-responsive-plugin-install-helper.php';

	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-abstract-main.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-register-customizer-controls.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/types/class-responsive-customizer-panel.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/types/class-responsive-customizer-control.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/types/class-responsive-customizer-partial.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/types/class-responsive-customizer-section.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-upsell-manager.php';

	// Customizer files array.
	$files = array(
		'class-responsive-panel',
		'class-responsive-site-layouts-customizer',
		'class-responsive-site-scripts-customizer',
		'class-responsive-site-color-palettes-scheme-customizer',
		'class-responsive-site-colors-customizer',
		'class-responsive-site-typography-customizer',
		'class-responsive-header-layout-customizer',
		'class-responsive-header-title-tagline-customizer',
		// 'class-responsive-header-colors-customizer',
		'class-responsive-header-transparent-customizer',
		'class-responsive-header-menu-layouts-customizer',
		'class-responsive-header-off-canvas-menu-layouts-customizer',
		'class-responsive-header-toggle-button-customizer',
		'class-responsive-header-secondary-menu-layouts-customizer',
		'class-responsive-content-header-colors-customizer',
		'class-responsive-content-header-layout-customizer',
		'class-responsive-content-header-typography-customizer',
		'class-responsive-blog-layout-customizer',
		'class-responsive-single-blog-layout-customizer',
		'class-responsive-page-content-customizer',
		'class-responsive-footer-layout-customizer',
		'class-responsive-typography-customizer',
		'class-responsive-theme-options-customizer',
		'class-responsive-home-page-customizer',
		'class-responsive-customizer-notices',
		'class-responsive-sidebar-colors-customizer',
		'class-responsive-scroll-to-top-customizer',
		'class-responsive-buttons-customizer',
		'class-responsive-form-fields-customizer',
		'class-responsive-header-widgets-customizer',
		'class-responsive-mobile-header-widgets-customizer',
		'class-responsive-sidebar-layout-customizer',
		'hfb-builder/class-responsive-header-footer-builder',
		'hfb-builder/header/class-responsive-hfb-header-above-row',
		'hfb-builder/header/class-responsive-hfb-header-pimary-row',
		'hfb-builder/header/class-responsive-hfb-header-below-row',
		'hfb-builder/header/class-responsive-hfb-mobile-header-off-canvas',
		'hfb-builder/footer/class-responsive-hfb-footer-above-row',
		'hfb-builder/footer/class-responsive-hfb-footer-primary-row',
		'hfb-builder/footer/class-responsive-hfb-footer-below-row',
		'class-responsive-footer-menu-customizer',
		'class-responsive-footer-copyright-customizer',
		'class-responsive-header-builder-section-customizer',
		'class-responsive-header-button-customizer',
		'class-responsive-mobile-header-button-customizer',
		'class-responsive-mobile-header-woo-cart-customizer',
		'class-responsive-header-social-customizer',
		'class-responsive-mobile-header-social-customizer',
		'class-responsive-header-contact-info-customizer',
		'class-responsive-mobile-header-contact-info-customizer',
		'class-responsive-header-search-customizer',
		'class-responsive-header-html-customizer',
		'class-responsive-mobile-header-html-customizer',
		'class-responsive-footer-social-customizer',
		'class-responsive-performance-customizer',
		'class-responsive-footer-widgets-settings-customizer',
	);

	if ( is_responsive_version_greater() ) {
		$files[] = 'class-responsive-background-image-customizer';
	}

	if ( ! class_exists( 'Responsive_Addons_Pro' ) ) {
		$files[] = 'class-responsive-container-spacing-customizer';
		$files[] = 'class-responsive-sticky-header-customizer';
		$files[] = 'class-responsive-blog-customizer';
		$files[] = 'class-responsive-footer-customizer';
	}

	foreach ( $files as $key ) {

		$setting = str_replace( '-', '_', $key );
		require_once $dir . $key . '.php';

	}
}

/**
 * Verify if the version of specified products is greater or not.
 *
 * @since 4.9.7
 */
function is_responsive_version_greater() {
	$theme                    = wp_get_theme( 'responsive' );
	$is_theme_version_greater = false;
	if ( version_compare( $theme['Version'], '4.9.6', '>' ) ) {
		$is_theme_version_greater = true;
	}
	return $is_theme_version_greater;
}

/**
 * Adds custom controls.
 *
 * @param object $wp_customize WordPress customizer.
 *
 * @since 1.0.0
 */
function responsive_custom_controls( $wp_customize ) {

	// Path.
	$dir = RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/';

	// Load customize control classes.
	require_once $dir . 'palette/class-responsive-customizer-palette-control.php';
	require_once $dir . 'color/class-responsive-customizer-color-control.php';
	require_once $dir . 'range/class-responsive-customizer-range-control.php';
	require_once $dir . 'slider/class-responsive-customizer-slider-control.php';
	require_once $dir . 'sortable/class-responsive-customizer-sortable-control.php';
	require_once $dir . 'social/class-responsive-customizer-social-control.php';
	require_once $dir . 'text/class-responsive-customizer-text-control.php';
	require_once $dir . 'typography/class-responsive-customizer-typography-control.php';
	require_once $dir . 'tinymce/class-responsive-customizer-tinymce-control.php';
	require_once $dir . 'html/class-responsive-customizer-html-control.php';
	require_once $dir . 'dimensions/class-responsive-customizer-dimensions-control.php';
	require_once $dir . 'heading/class-responsive-customizer-heading-control.php';
	require_once $dir . 'select/class-responsive-customizer-responsive-select-control.php';
	require_once $dir . 'checkbox/class-responsive-customizer-responsive-checkbox-control.php';
	require_once $dir . 'redirect/class-responsive-customizer-redirect-control.php';
	require_once $dir . 'selectbtn/class-responsive-customizer-responsive-selectbtn-control.php';
	require_once $dir . 'tabs/class-responsive-customizer-responsive-tabs-control.php';
	require_once $dir . 'imageradiobtn/class-responsive-customizer-imageradio-button-control.php';
	require_once $dir . 'iconradiobtn/class-responsive-customizer-icon-radio-button-control.php';
	require_once $dir . 'toggle/class-responsive-customizer-responsive-toggle-control.php';
	require_once $dir . 'horizontal-separator/class-responsive-customizer-responsive-horizontal-separator.php';
	require_once $dir . 'backgroundimage/class-responsive-customizer-background-image-control.php';
	require_once $dir . 'typography_group/class-responsive-customizer-responsive-group-typography-control.php';
	require_once $dir . 'builder-layout/class-responsive-customizer-layout-builder-control.php';
	require_once $dir . 'multi-select/class-responsive-customizer-multi-select-control.php';
	require_once $dir . 'range-with-switchers/class-responsive-customizer-range-with-switchers-control.php';
	require_once $dir . 'builder-row-layout/class-responsive-customizer-builder-row-layout-control.php';
	require_once $dir . 'builder-available-drag/class-responsive-customizer-builder-available-items-drag-control.php';
	require_once $dir . 'shadow/class-responsive-customizer-shadow-control.php';
	require_once $dir . 'input-with-dropdown/class-responsive-customizer-input-with-dropdown-control.php';
	require_once $dir . 'fontpresets/class-responsive-customizer-font-preset-control.php';
	require_once $dir . 'contact-info/class-responsive-customizer-contact-info-control.php';
	require_once $dir . 'color-with-devices/class-responsive-customizer-color-with-devices-control.php';
	require_once $dir . 'color-with-devices-and-hover/class-responsive-customizer-color-with-devices-and-hover-control.php';
	require_once $dir . 'section-toggle/class-responsive-customizer-section-toggle.php';
	require_once $dir . 'select-with-switchers/class-responsive-customizer-selectbtn-switchers-control.php';
	require_once $dir . 'selectbtn-with-switchers/class-responsive-customizer-selectbtn-with-switchers-control.php';

	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-control-upsell.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-generic-notice-section.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-main-notice-section.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-section-docs.php';
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/controls/upsell/class-responsive-section-upsell.php';
	// Register JS control types.
	$wp_customize->register_control_type( 'Responsive_Customizer_Palette_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Color_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Range_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Slider_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Sortable_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Text_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Typography_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Dimensions_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Heading_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Select_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Checkbox_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Redirect_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Select_Button_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Responsive_Tabs_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Imageradio_Button_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Toggle_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Horizontal_Separator' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Background_Image_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Typography_Group_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Layout_Builder_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Multi_Select_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Range_With_Switcher_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Builder_Row_Layout_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Builder_Available_Items_Drag_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Shadow_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Social_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Input_With_Dropdown_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Contact_Info_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Color_With_Devices_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Color_With_Devices_And_Hover_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Selectbtn_Switchers_Control' );
	$wp_customize->register_control_type( 'Responsive_Customizer_Selectbtn_With_Switchers_Control' );

}

/**
 * Adds customizer helpers
 */
function responsive_controls_helpers() {
	require_once RESPONSIVE_THEME_DIR . 'core/includes/customizer/sanitization-callbacks.php';
}

/**
 * Custom styles and js for customizer
 */
function responsive_custom_customize_enqueue() {
	$responsive = wp_get_theme( 'responsive' );
	$suffix     = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_style( 'icomoon-style', get_template_directory_uri() . "/core/css/icomoon/style{$suffix}.css", false, $responsive['Version'] );
	wp_enqueue_style( 'responsive-general', get_template_directory_uri() . '/core/includes/customizer/assets/min/css/general.min.css', RESPONSIVE_THEME_VERSION, true );
	wp_enqueue_script( 'responsive-general', get_template_directory_uri() . '/core/includes/customizer/assets/min/js/general.min.js', array( 'jquery', 'customize-base' ), RESPONSIVE_THEME_VERSION, true );

		// Enqueue Customizer React.JS script.

		$custom_controls_react_deps = array(
			'wp-i18n',
			'wp-components',
			'wp-element',
			'wp-media-utils',
			'wp-block-editor',
		);
		if ( ! class_exists( 'Responsive_Addons_Pro' ) ) {
			// wp_enqueue_script( 'responsive-custom-control-react-script', get_template_directory_uri() . '/core/includes/customizer/extend-controls/build/index.js', $custom_controls_react_deps, RESPONSIVE_THEME_VERSION, true );
			wp_enqueue_script( 'responsive-custom-control-react-script', get_template_directory_uri() . '/core/includes/customizer/extend-controls/dist/customizer.js', $custom_controls_react_deps, RESPONSIVE_THEME_VERSION, true );
		} else {
			$plugin_path            = WP_PLUGIN_DIR . '/responsive-addons-pro/responsive-addons-pro.php';
			$plugin_info            = get_plugin_data( $plugin_path );
			$responsive_pro_version = $plugin_info['Version'];
			$compare                = version_compare( $responsive_pro_version, RESPONSIVE_PRO_OLDER_VERSION_CHECK );
			if ( 0 === $compare || 1 === $compare ) {
				wp_enqueue_script( 'responsive-custom-control-react-script', get_template_directory_uri() . '/core/includes/customizer/extend-controls/build/index.js', $custom_controls_react_deps, RESPONSIVE_THEME_VERSION, true );
			}
		}
		$localize_array = array(
			'path' => RESPONSIVE_THEME_URI . '/core/includes/customizer/assets/images/',
			'paletteDesignStyles' => responsive_get_available_design_styles(),
		);
		wp_localize_script( 'responsive-custom-control-react-script', 'localize', $localize_array );
}

/**
 * Tooltip script
 *
 * @since 3.23
 * @return void
 */
function responsive_tooltip_script() {
	$output  = '<script type="text/javascript">';
	$output .= '
	        	wp.customize.bind(\'ready\', function() {
	            	wp.customize.control.each(function(ctrl, i) {
	                	var desc = ctrl.container.find(".customize-control-description");
	                	if( desc.length) {
	                    	var title 		= ctrl.container.find(".customize-control-title");
	                    	var li_wrapper 	= desc.closest("li");
	                    	var tooltip = desc.text().replace(/[\u00A0-\u9999<>\&]/gim, function(i) {
	                    			return \'&#\'+i.charCodeAt(0)+\';\';
								});
	                    	desc.remove();
	                    	li_wrapper.append(" <i class=\'res-control-tooltip dashicons dashicons-editor-help\'title=\'" + tooltip +"\'></i>");
	                	}
	            	});
	        	});';

	$output .= '</script>';

	// Ignoring EscapeOutput to print JS.
	echo $output; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

}
