<?php
/**
* Widget Functions.
*
* @package Responsive Landing Page
*/

function responsive_landing_page_widgets_init(){

	register_sidebar(array(
	    'name' => esc_html__('Main Sidebar', 'responsive-landing-page'),
	    'id' => 'sidebar-1',
	    'description' => esc_html__('Add widgets here.', 'responsive-landing-page'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));

	register_sidebar(array(
	    'name' => esc_html__('Header Sidebar', 'responsive-landing-page'),
	    'id' => 'sidebar-header',
	    'description' => esc_html__('Add widgets here.', 'responsive-landing-page'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));


    $responsive_landing_page_default = responsive_landing_page_get_default_theme_options();
    $responsive_landing_page_footer_column_layout = absint( get_theme_mod( 'responsive_landing_page_footer_column_layout',$responsive_landing_page_default['responsive_landing_page_footer_column_layout'] ) );

    for( $i = 0; $i < $responsive_landing_page_footer_column_layout; $i++ ){
    	
    	if( $i == 0 ){ $count = esc_html__('One','responsive-landing-page'); }
    	if( $i == 1 ){ $count = esc_html__('Two','responsive-landing-page'); }
    	if( $i == 2 ){ $count = esc_html__('Three','responsive-landing-page'); }

	    register_sidebar( array(
	        'name' => esc_html__('Footer Widget ', 'responsive-landing-page').$count,
	        'id' => 'responsive-landing-page-footer-widget-'.$i,
	        'description' => esc_html__('Add widgets here.', 'responsive-landing-page'),
	        'before_widget' => '<div id="%1$s" class="widget %2$s">',
	        'after_widget' => '</div>',
	        'before_title' => '<h2 class="widget-title">',
	        'after_title' => '</h2>',
	    ));
	}

}

add_action('widgets_init', 'responsive_landing_page_widgets_init');