<?php
/**
 * Settings for demo import
 *
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_DIR' ) ) {
	define( 'WHIZZIE_DIR', dirname( __FILE__ ) );
}
require trailingslashit( WHIZZIE_DIR ) . 'homepage-setup-contents.php';
$responsive_landing_page_current_theme = wp_get_theme();
$responsive_landing_page_theme_title = $responsive_landing_page_current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['responsive_landing_page_page_slug'] 	= 'responsive-landing-page';
$config['responsive_landing_page_page_title']	= 'Homepage Setup';

$config['steps'] = array(
	'plugins' => array(
		'id'			=> 'plugins',
		'title'			=> __( 'Install and Activate Essential Plugins', 'responsive-landing-page' ),
		'icon'			=> 'admin-plugins',
		'button_text'	=> __( 'Install Plugins', 'responsive-landing-page' ),
		'can_skip'		=> true
	),
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Setup Home Page', 'responsive-landing-page' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Start Home Page Setup', 'responsive-landing-page' ),
		'button_url'    => esc_url( admin_url( 'themes.php?page=ediot-template-importer' ) ),
		'can_skip'		=> true
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Responsive_Landing_Page_Whizzie' ) ) {
	$Responsive_Landing_Page_Whizzie = new Responsive_Landing_Page_Whizzie( $config );
}