<?php
/**
* Typography Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'responsive_landing_page_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'responsive-landing-page' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

// -----------------  Font array
$responsive_landing_page_fonts = array(
    'Select'           => __('Default Font', 'responsive-landing-page'),
    'bad-script' => 'Bad Script',
    'inter'      => 'Inter',
    'bitter'     => 'Bitter',
    'charis-sil' => 'Charis SIL',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'montserrat' => 'Montserrat',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'outfit'     => 'Outfit',
    'ubuntu'     => 'Ubuntu',
    'saira'      => 'Saira',
    'cinzel'     => 'Cinzel',
    'figtree'     => 'Figtree'
);

 // -----------------  General text font
 $wp_customize->add_setting( 'responsive_landing_page_content_typography_font', array(
    'default'           => 'inter',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_radio_sanitize',
) );
$wp_customize->add_control( 'responsive_landing_page_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_typography_setting',
    'settings' => 'responsive_landing_page_content_typography_font',
    'choices'  => $responsive_landing_page_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'responsive_landing_page_heading_typography_font', array(
    'default'           => 'inter',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_radio_sanitize',
) );
$wp_customize->add_control( 'responsive_landing_page_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_typography_setting',
    'settings' => 'responsive_landing_page_heading_typography_font',
    'choices'  => $responsive_landing_page_fonts,
) );