<?php
/**
* Custom Functions.
*
* @package Responsive Landing Page
*/

if( !function_exists( 'responsive_landing_page_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_sidebar_option( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }

        return;

    }

endif;

if ( ! function_exists( 'responsive_landing_page_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function responsive_landing_page_sanitize_checkbox( $responsive_landing_page_checked ) {

		return ( ( isset( $responsive_landing_page_checked ) && true === $responsive_landing_page_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'responsive_landing_page_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function responsive_landing_page_sanitize_select( $responsive_landing_page_input, $responsive_landing_page_setting ) {
        $responsive_landing_page_input = sanitize_text_field( $responsive_landing_page_input );
        $responsive_landing_page_choices = $responsive_landing_page_setting->manager->get_control( $responsive_landing_page_setting->id )->choices;
        return ( array_key_exists( $responsive_landing_page_input, $responsive_landing_page_choices ) ? $responsive_landing_page_input : $responsive_landing_page_setting->default );
    }

endif;