<?php
/**
* Posts Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'responsive_landing_page_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'responsive-landing-page' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'responsive_landing_page_theme_option_panel',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_single_post_image',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_post_author',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_post_date',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_post_category',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_post_tags',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_single_page_content_alignment',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'responsive_landing_page_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'responsive-landing-page' ),
        'center'  => esc_html__( 'Center', 'responsive-landing-page' ),
        'right'    => esc_html__( 'Right', 'responsive-landing-page' ),
        ),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_single_post_content_alignment',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'responsive_landing_page_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'responsive-landing-page' ),
        'center'  => esc_html__( 'Center', 'responsive-landing-page' ),
        'right'    => esc_html__( 'Right', 'responsive-landing-page' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'responsive_landing_page_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'responsive-landing-page' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'responsive_landing_page_theme_option_panel',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_format_icon',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_image',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_category',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_title',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_content',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_display_archive_post_button',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_excerpt_limit',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
    )
);
$wp_customize->add_control('responsive_landing_page_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'responsive-landing-page'),
        'section'     => 'responsive_landing_page_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'responsive_landing_page_sanitize_select',
	)
);
$wp_customize->add_control( 'responsive_landing_page_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'responsive-landing-page' ),
	'section'     => 'responsive_landing_page_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'responsive-landing-page' ),
		'large' => esc_html__( 'Big Size Image', 'responsive-landing-page' ),
		'medium' => esc_html__( 'Medium Size Image', 'responsive-landing-page' ),
		'small' => esc_html__( 'Small Size Image', 'responsive-landing-page' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'responsive-landing-page' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'responsive-landing-page' ),
	    ),
	)
);

$wp_customize->add_setting('responsive_landing_page_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
    )
);
$wp_customize->add_control('responsive_landing_page_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'responsive-landing-page'),
    'section'     => 'responsive_landing_page_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);