<?php
/**
* Layouts Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'responsive_landing_page_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'responsive-landing-page' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

$wp_customize->add_setting( 'responsive_landing_page_global_sidebar_layout',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'responsive_landing_page_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'responsive-landing-page' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'responsive-landing-page' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'responsive-landing-page' ),
        ),
    )
);

$wp_customize->add_setting('responsive_landing_page_page_sidebar_layout', array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_sidebar_option',
));

$wp_customize->add_control('responsive_landing_page_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'responsive-landing-page'),
    'section'     => 'responsive_landing_page_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'responsive-landing-page'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'responsive-landing-page'),
        'no-sidebar'    => esc_html__('No Sidebar', 'responsive-landing-page'),
    ),
));

$wp_customize->add_setting('responsive_landing_page_post_sidebar_layout', array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_sidebar_option',
));

$wp_customize->add_control('responsive_landing_page_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'responsive-landing-page'),
    'section'     => 'responsive_landing_page_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'responsive-landing-page'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'responsive-landing-page'),
        'no-sidebar'    => esc_html__('No Sidebar', 'responsive-landing-page'),
    ),
));

$wp_customize->add_setting('responsive_landing_page_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_layout_setting',
        'type' => 'checkbox',
    )
);