<?php
/**
* Footer Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

$wp_customize->add_section( 'responsive_landing_page_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'responsive-landing-page' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

$wp_customize->add_setting('responsive_landing_page_display_footer',
    array(
    'default' => $responsive_landing_page_default['responsive_landing_page_display_footer'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
)
);
$wp_customize->add_control('responsive_landing_page_display_footer',
    array(
        'label' => esc_html__('Enable Footer', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_footer_column_layout',
	array(
	'default'           => $responsive_landing_page_default['responsive_landing_page_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'responsive_landing_page_sanitize_select',
	)
);
$wp_customize->add_control( 'responsive_landing_page_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'responsive-landing-page' ),
	'section'     => 'responsive_landing_page_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'responsive-landing-page' ),
		'2' => esc_html__( 'Two Column', 'responsive-landing-page' ),
		'3' => esc_html__( 'Three Column', 'responsive-landing-page' ),
	    ),
	)
);

$wp_customize->add_setting( 'responsive_landing_page_footer_widget_title_alignment',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_footer_widget_title_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_footer_widget_title_alignment',
    )
);
$wp_customize->add_control( 'responsive_landing_page_footer_widget_title_alignment',
    array(
    'label'       => esc_html__( 'Footer Widget Title Alignment', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_footer_widget_area',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'responsive-landing-page' ),
        'center'  => esc_html__( 'Center', 'responsive-landing-page' ),
        'right'    => esc_html__( 'Right', 'responsive-landing-page' ),
        ),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_footer_copyright_text',
	array(
	'default'           => $responsive_landing_page_default['responsive_landing_page_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'responsive_landing_page_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'responsive-landing-page' ),
	'section'  => 'responsive_landing_page_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('responsive_landing_page_copyright_font_size',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
    )
);
$wp_customize->add_control('responsive_landing_page_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'responsive-landing-page'),
        'section'     => 'responsive_landing_page_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'responsive_landing_page_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'responsive-landing-page' ),
        'Reverse' => esc_html__( 'Reverse View', 'responsive-landing-page' ),
        'Center'  => esc_html__( 'Centered Content', 'responsive-landing-page' ),
    ),
) );

$wp_customize->add_setting( 'responsive_landing_page_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'responsive_landing_page_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'responsive-landing-page'),
    'description' => __('It will change the complete footer widget background color.', 'responsive-landing-page'),
    'section' => 'responsive_landing_page_footer_widget_area',
    'settings' => 'responsive_landing_page_footer_widget_background_color',
)));

$wp_customize->add_setting('responsive_landing_page_footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'responsive_landing_page_footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','responsive-landing-page'),
    'section' => 'responsive_landing_page_footer_widget_area'
)));

$wp_customize->add_setting('responsive_landing_page_enable_to_the_top',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_to_the_top_text',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_footer_widget_area',
    'type'     => 'text',
    )
);