<?php
/**
 * Default Values.
 *
 * @package Responsive Landing Page
 */

if ( ! function_exists( 'responsive_landing_page_get_default_theme_options' ) ) :
	function responsive_landing_page_get_default_theme_options() {

		$responsive_landing_page_defaults = array();
		
		// Options.
        $responsive_landing_page_defaults['responsive_landing_page_logo_width_range']                            = 200;
	    $responsive_landing_page_defaults['responsive_landing_page_global_sidebar_layout']		                 = 'right-sidebar';
        $responsive_landing_page_defaults['responsive_landing_page_theme_breadcrumb_options_alignment']          = 'left';
        $responsive_landing_page_defaults['responsive_landing_page_theme_pagination_options_alignment']          = 'Center';
        $responsive_landing_page_defaults['responsive_landing_page_theme_loader']                                = 0;
        $responsive_landing_page_defaults['responsive_landing_page_pagination_layout']                           = 'numeric';
	    $responsive_landing_page_defaults['responsive_landing_page_footer_column_layout'] 			             = 3;
        $responsive_landing_page_defaults['responsive_landing_page_menu_font_size']                              = 15;
        $responsive_landing_page_defaults['responsive_landing_page_copyright_font_size']                         = 16;
        $responsive_landing_page_defaults['responsive_landing_page_breadcrumb_font_size']                        = 16;
        $responsive_landing_page_defaults['responsive_landing_page_excerpt_limit']                               = 20;
        $responsive_landing_page_defaults['responsive_landing_page_menu_text_transform']                         = 'Capitalize';  
        $responsive_landing_page_defaults['responsive_landing_page_single_page_content_alignment']               = 'left';
        $responsive_landing_page_defaults['responsive_landing_page_per_columns']                                 = 3;  
        $responsive_landing_page_defaults['responsive_landing_page_product_per_page']                            = 9; 
        $responsive_landing_page_defaults['responsive_landing_page_custom_related_products_number']              = 6;
        $responsive_landing_page_defaults['responsive_landing_page_custom_related_products_number_per_row']      = 3;
	    $responsive_landing_page_defaults['responsive_landing_page_footer_copyright_text'] 		                 = esc_html__( 'All rights reserved.', 'responsive-landing-page' );
        $responsive_landing_page_defaults['twp_navigation_type']              			                     = 'theme-normal-navigation';
        $responsive_landing_page_defaults['responsive_landing_page_post_author']                		         = 1;
        $responsive_landing_page_defaults['responsive_landing_page_post_date']                		             = 1;
        $responsive_landing_page_defaults['responsive_landing_page_post_category']                	             = 1;
        $responsive_landing_page_defaults['responsive_landing_page_post_tags']                		             = 1;
        $responsive_landing_page_defaults['responsive_landing_page_floating_next_previous_nav']                  = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_header_title']                        = 1;
        $responsive_landing_page_defaults['responsive_landing_page_sticky']                                      = 0;
        $responsive_landing_page_defaults['responsive_landing_page_services']               	                 = 1;        
        $responsive_landing_page_defaults['responsive_landing_page_background_color']               	         = '#fff';
        $responsive_landing_page_defaults['responsive_landing_page_display_footer']                              = 1;
        $responsive_landing_page_defaults['responsive_landing_page_footer_widget_title_alignment']               = 'left'; 
        $responsive_landing_page_defaults['responsive_landing_page_show_hide_related_product']                   = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_image']                  = 1;
        $responsive_landing_page_defaults['responsive_landing_page_global_color']                                = '#8D6AEE ';
        $responsive_landing_page_defaults['responsive_landing_page_global_secondary_color']                      = '#0F131F';
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_category']               = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_title']                  = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_content']                = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_button']                 = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_single_post_image']                   = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_format_icon']            = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_single_post_image']                   = 1;
        $responsive_landing_page_defaults['responsive_landing_page_display_archive_post_format_icon']            = 1;
        $responsive_landing_page_defaults['responsive_landing_page_enable_to_the_top']                           = 1;
        $responsive_landing_page_defaults['responsive_landing_page_to_the_top_text']                             = esc_html__( 'To The Top', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_theme_breadcrumb_enable']                     = 1;
        $responsive_landing_page_defaults['responsive_landing_page_single_post_content_alignment']               = 'left';

         // Topbar
        $responsive_landing_page_defaults['responsive_landing_page_header_layout_button_text']                   = esc_html__( 'Contact', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_header_layout_button_url']                    = esc_url('#');

        // 404 Page Defaults
        $responsive_landing_page_defaults['responsive_landing_page_404_main_title']                              = esc_html__( 'Oops! That page can’t be found.', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_404_subtitle_one']                            = esc_html__( 'Maybe it’s out there, somewhere...', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_404_para_one']                                = esc_html__( 'You can always find insightful stories on our', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_404_subtitle_two']                            = esc_html__( 'Still feeling lost? You’re not alone.', 'responsive-landing-page' );
        $responsive_landing_page_defaults['responsive_landing_page_404_para_two']                                = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'responsive-landing-page' );

        // Pass through filter.
        $responsive_landing_page_defaults = apply_filters( 'responsive_landing_page_filter_default_theme_options', $responsive_landing_page_defaults );

        return $responsive_landing_page_defaults;
	}
endif;
