<?php
/**
* Customizer Custom Classes.
* @package Responsive Landing Page
*/

if ( ! function_exists( 'responsive_landing_page_sanitize_number_range' ) ) :
    function responsive_landing_page_sanitize_number_range( $responsive_landing_page_input, $responsive_landing_page_setting ) {
        $responsive_landing_page_input = absint( $responsive_landing_page_input );
        $responsive_landing_page_atts = $responsive_landing_page_setting->manager->get_control( $responsive_landing_page_setting->id )->input_attrs;
        $responsive_landing_page_min = ( isset( $responsive_landing_page_atts['min'] ) ? $responsive_landing_page_atts['min'] : $responsive_landing_page_input );
        $responsive_landing_page_max = ( isset( $responsive_landing_page_atts['max'] ) ? $responsive_landing_page_atts['max'] : $responsive_landing_page_input );
        $responsive_landing_page_step = ( isset( $responsive_landing_page_atts['step'] ) ? $responsive_landing_page_atts['step'] : 1 );
        return ( $responsive_landing_page_min <= $responsive_landing_page_input && $responsive_landing_page_input <= $responsive_landing_page_max && is_int( $responsive_landing_page_input / $responsive_landing_page_step ) ? $responsive_landing_page_input : $responsive_landing_page_setting->default );
    }
endif;

/**
 * Upsell customizer section.
 *
 * @since  1.0.0
 * @access public
 */
class Responsive_Landing_Page_Customize_Section_Upsell extends WP_Customize_Section {

    /**
     * The type of customize section being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'upsell';

    /**
     * Custom button text to output.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_text = '';

    /**
     * Custom pro button URL.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_url = '';

    public $notice = '';
    public $nonotice = '';

    /**
     * Add custom parameters to pass to the JS via JSON.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function json() {
        $json = parent::json();

        $json['pro_text'] = $this->pro_text;
        $json['pro_url']  = esc_url( $this->pro_url );
        $json['notice']  = esc_attr( $this->notice );
        $json['nonotice']  = esc_attr( $this->nonotice );

        return $json;
    }

    /**
     * Outputs the Underscore.js template.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    protected function render_template() { ?>

        <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

            <# if ( data.notice ) { #>
                <h3 class="accordion-section-notice">
                    {{ data.title }}
                </h3>
            <# } #>

            <# if ( !data.notice ) { #>
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            <# } #>
            
        </li>
    <?php }
}