<?php
/**
 * Custom Functions.
 *
 * @package Responsive Landing Page
 */

if( !function_exists( 'responsive_landing_page_fonts_url' ) ) :

    //Google Fonts URL
    function responsive_landing_page_fonts_url(){

        $responsive_landing_page_font_families = array(
            'Montserrat:ital,wght@0,100..900;1,100..900', //   font-family: "Montserrat", sans-serif;
        );

        $responsive_landing_page_fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $responsive_landing_page_font_families ),
            'display' => 'swap',
        ), 'https://fonts.googleapis.com/css2' );

        return esc_url_raw($responsive_landing_page_fonts_url);
    }

endif;

if ( ! function_exists( 'responsive_landing_page_sub_menu_toggle_button' ) ) :

    function responsive_landing_page_sub_menu_toggle_button( $responsive_landing_page_args, $responsive_landing_page_item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $responsive_landing_page_args->theme_location == 'responsive-landing-page-primary-menu' && isset( $responsive_landing_page_args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $responsive_landing_page_args->before = '<div class="submenu-wrapper">';
            $responsive_landing_page_args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $responsive_landing_page_item->classes ) ) {

                $toggle_target_string = '.menu-item.menu-item-' . $responsive_landing_page_item->ID . ' > .sub-menu';

                // Add the sub menu toggle
                $responsive_landing_page_args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'responsive-landing-page' ) . '</span>' . responsive_landing_page_get_theme_svg( 'chevron-down' ) . '</span></button>';

            }

            // Close the wrapper
            $responsive_landing_page_args->after .= '</div><!-- .submenu-wrapper -->';
            // Add sub menu icons to the main menu without toggles (the fallback menu)

        }elseif( $responsive_landing_page_args->theme_location == 'responsive-landing-page-primary-menu' ) {

            if ( in_array( 'menu-item-has-children', $responsive_landing_page_item->classes ) ) {

                $responsive_landing_page_args->before = '<div class="link-icon-wrapper">';
                $responsive_landing_page_args->after  = responsive_landing_page_get_theme_svg( 'chevron-down' ) . '</div>';

            } else {

                $responsive_landing_page_args->before = '';
                $responsive_landing_page_args->after  = '';

            }

        }

        return $responsive_landing_page_args;

    }

endif;

add_filter( 'nav_menu_item_args', 'responsive_landing_page_sub_menu_toggle_button', 10, 3 );

if ( ! function_exists( 'responsive_landing_page_the_theme_svg' ) ):
    
    function responsive_landing_page_the_theme_svg( $responsive_landing_page_svg_name, $responsive_landing_page_return = false ) {

        if( $responsive_landing_page_return ){

            return responsive_landing_page_get_theme_svg( $responsive_landing_page_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in responsive_landing_page_get_theme_svg();.

        }else{

            echo responsive_landing_page_get_theme_svg( $responsive_landing_page_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in responsive_landing_page_get_theme_svg();.

        }
    }

endif;

if ( ! function_exists( 'responsive_landing_page_get_theme_svg' ) ):

    function responsive_landing_page_get_theme_svg( $responsive_landing_page_svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $responsive_landing_page_svg = wp_kses(
            responsive_landing_page_SVG_Icons::get_svg( $responsive_landing_page_svg_name ),
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
                'polyline' => array(
                    'fill'      => true,
                    'points'    => true,
                ),
                'line' => array(
                    'fill'      => true,
                    'x1'      => true,
                    'x2' => true,
                    'y1'    => true,
                    'y2' => true,
                ),
            )
        );
        if ( ! $responsive_landing_page_svg ) {
            return false;
        }
        return $responsive_landing_page_svg;

    }

endif;

if( !function_exists( 'responsive_landing_page_post_category_list' ) ) :

    // Post Category List.
    function responsive_landing_page_post_category_list( $responsive_landing_page_select_cat = true ){

        $responsive_landing_page_post_cat_lists = get_categories(
            array(
                'hide_empty' => '0',
                'exclude' => '1',
            )
        );

        $responsive_landing_page_post_cat_cat_array = array();
        if( $responsive_landing_page_select_cat ){

            $responsive_landing_page_post_cat_cat_array[''] = esc_html__( '-- Select Category --','responsive-landing-page' );

        }

        foreach ( $responsive_landing_page_post_cat_lists as $responsive_landing_page_post_cat_list ) {

            $responsive_landing_page_post_cat_cat_array[$responsive_landing_page_post_cat_list->slug] = $responsive_landing_page_post_cat_list->name;

        }

        return $responsive_landing_page_post_cat_cat_array;
    }

endif;

if( !function_exists('responsive_landing_page_single_post_navigation') ):

    function responsive_landing_page_single_post_navigation(){

        $responsive_landing_page_default = responsive_landing_page_get_default_theme_options();
        $responsive_landing_page_twp_navigation_type = esc_attr( get_post_meta( get_the_ID(), 'twp_disable_ajax_load_next_post', true ) );
        $responsive_landing_page_current_id = '';
        $article_wrap_class = '';
        global $post;
        $responsive_landing_page_current_id = $post->ID;
        if( $responsive_landing_page_twp_navigation_type == '' || $responsive_landing_page_twp_navigation_type == 'global-layout' ){
            $responsive_landing_page_twp_navigation_type = get_theme_mod('twp_navigation_type', $responsive_landing_page_default['twp_navigation_type']);
        }

        if( $responsive_landing_page_twp_navigation_type != 'no-navigation' && 'post' === get_post_type() ){

            if( $responsive_landing_page_twp_navigation_type == 'theme-normal-navigation' ){ ?>

                <div class="navigation-wrapper">
                    <?php
                    // Previous/next post navigation.
                    the_post_navigation(array(
                        'prev_text' => '<span class="arrow" aria-hidden="true">' . responsive_landing_page_the_theme_svg('arrow-left',$responsive_landing_page_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Previous post:', 'responsive-landing-page') . '</span><span class="post-title">%title</span>',
                        'next_text' => '<span class="arrow" aria-hidden="true">' . responsive_landing_page_the_theme_svg('arrow-right',$responsive_landing_page_return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Next post:', 'responsive-landing-page') . '</span><span class="post-title">%title</span>',
                    )); ?>
                </div>
                <?php

            }else{

                $responsive_landing_page_next_post = get_next_post();
                if( isset( $responsive_landing_page_next_post->ID ) ){

                    $responsive_landing_page_next_post_id = $responsive_landing_page_next_post->ID;
                    echo '<div loop-count="1" next-post="' . absint( $responsive_landing_page_next_post_id ) . '" class="twp-single-infinity"></div>';

                }
            }

        }

    }

endif;

add_action( 'responsive_landing_page_navigation_action','responsive_landing_page_single_post_navigation',30 );

if( !function_exists('responsive_landing_page_content_offcanvas') ):

    // Offcanvas Contents
    function responsive_landing_page_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <?php echo esc_html__('Close', 'responsive-landing-page'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'responsive-landing-page'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('responsive-landing-page-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'responsive-landing-page-primary-menu',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new Responsive_Landing_Page_Walker_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'responsive_landing_page_before_footer_content_action','responsive_landing_page_content_offcanvas',30 );

if( !function_exists('responsive_landing_page_footer_content_widget') ):

    function responsive_landing_page_footer_content_widget(){
        
        $responsive_landing_page_default = responsive_landing_page_get_default_theme_options();
        
        $responsive_landing_page_footer_column_layout = absint(get_theme_mod('responsive_landing_page_footer_column_layout', $responsive_landing_page_default['responsive_landing_page_footer_column_layout']));
        $responsive_landing_page_footer_sidebar_class = 12;
        
        if($responsive_landing_page_footer_column_layout == 2) {
            $responsive_landing_page_footer_sidebar_class = 6;
        }
        
        if($responsive_landing_page_footer_column_layout == 3) {
            $responsive_landing_page_footer_sidebar_class = 4;
        }
        ?>
        
        <?php if ( get_theme_mod('responsive_landing_page_display_footer', true) == true ) : ?>
            <div class="footer-widgetarea">
                <div class="wrapper">
                    <div class="column-row">
                    
                        <?php for ($i = 0; $i < $responsive_landing_page_footer_column_layout; $i++) : ?>
                            
                            <div class="column <?php echo 'column-' . absint($responsive_landing_page_footer_sidebar_class); ?> column-sm-12">
                                
                                <?php 
                                // If no widgets are assigned, display default widgets
                                if ( ! is_active_sidebar( 'responsive-landing-page-footer-widget-' . $i ) ) : 

                                    if ($i === 0) : ?>
                                        <div id="media_image-3" class="widget widget_media_image">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo.png'); ?>" alt="<?php echo esc_attr__( 'Footer Image', 'responsive-landing-page' ); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                        <div id="text-3" class="widget widget_text">
                                            <div class="textwidget">
                                                <p class="widget_text">
                                                    <?php esc_html_e('The Responsive Landing Page Theme is designed for users who want a focused, visually appealing, and conversion-driven website without unnecessary complexity. Ideal for startups, product launches, digital services, and promotional campaigns, this theme helps you present your message clearly while keeping visitors engaged from the first scroll.', 'responsive-landing-page'); ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php elseif ($i === 1) : ?>
                                        <div id="pages-2" class="widget widget_pages">
                                            <h2 class="widget-title"><?php esc_html_e('Calendar', 'responsive-landing-page'); ?></h2>
                                            <?php get_calendar(); ?>
                                        </div>

                                    <?php elseif ($i === 2) : ?>
                                        <div id="search-2" class="widget widget_search">
                                            <h2 class="widget-title"><?php esc_html_e('Enter Keywords Here', 'responsive-landing-page'); ?></h2>
                                            <?php get_search_form(); ?>
                                        </div>
                                    <?php endif; 
                                    
                                else :
                                    // Display dynamic sidebar widget if assigned
                                    dynamic_sidebar('responsive-landing-page-footer-widget-' . $i);
                                endif;
                                ?>
                                
                            </div>
                            
                        <?php endfor; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?> 

    <?php
    }

endif;

add_action( 'responsive_landing_page_footer_content_action', 'responsive_landing_page_footer_content_widget', 10 );

if( !function_exists('responsive_landing_page_footer_content_info') ):

    /**
     * Footer Copyright Area
    **/
    function responsive_landing_page_footer_content_info(){

        $responsive_landing_page_default = responsive_landing_page_get_default_theme_options(); ?>
        <div class="site-info">
            <div class="wrapper">
                <div class="column-row">

                    <div class="column column-9">
                        <div class="footer-credits">

                            <div class="footer-copyright">

                                <?php
                                $responsive_landing_page_footer_copyright_text = wp_kses_post( get_theme_mod( 'responsive_landing_page_footer_copyright_text', $responsive_landing_page_default['responsive_landing_page_footer_copyright_text'] ) );
                                    echo esc_html( $responsive_landing_page_footer_copyright_text );
                                    echo '<br>';

                                    echo esc_html__('Theme: ', 'responsive-landing-page') . '<a href="' . esc_url('https://www.omegathemes.com/products/responsive-landing-page') . '" title="' . esc_attr__('Responsive Landing Page ', 'responsive-landing-page') . '" target="_blank"><span>' . esc_html__('Responsive Landing Page  ', 'responsive-landing-page') . '</span></a>' . esc_html__(' By ', 'responsive-landing-page') . '  <span>' . esc_html__('OMEGA ', 'responsive-landing-page') . '</span>';
                                    echo esc_html__('Powered by ', 'responsive-landing-page') . '<a href="' . esc_url('https://wordpress.org') . '" title="' . esc_attr__('WordPress', 'responsive-landing-page') . '" target="_blank"><span>' . esc_html__('WordPress.', 'responsive-landing-page') . '</span></a>';
                                 ?>
                            </div>
                        </div>
                    </div>


                    <div class="column column-3 align-text-right">
                        <a class="to-the-top" href="#site-header">
                            <span class="to-the-top-long">
                                <?php if ( get_theme_mod('responsive_landing_page_enable_to_the_top', true) == true ) : ?>
                                    <?php
                                    $responsive_landing_page_to_the_top_text = get_theme_mod( 'responsive_landing_page_to_the_top_text', __( 'To the Top', 'responsive-landing-page' ) );
                                    printf( 
                                        wp_kses( 
                                            /* translators: %s is the arrow icon markup */
                                            '%s %s', 
                                            array( 'span' => array( 'class' => array(), 'aria-hidden' => array() ) ) 
                                        ), 
                                        esc_html( $responsive_landing_page_to_the_top_text ),
                                        '<span class="arrow" aria-hidden="true">&uarr;</span>' 
                                    );
                                    ?>
                                <?php endif; ?>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'responsive_landing_page_footer_content_action','responsive_landing_page_footer_content_info',20 );

if (!function_exists('responsive_landing_page_post_format_icon')):

    // Post Format Icon.
    function responsive_landing_page_post_format_icon() {

        $responsive_landing_page_format = get_post_format(get_the_ID()) ?: 'standard';
        $responsive_landing_page_icon = '';
        $responsive_landing_page_title = '';
        if( $responsive_landing_page_format == 'video' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'video' );
            $responsive_landing_page_title = esc_html__('Video','responsive-landing-page');
        }elseif( $responsive_landing_page_format == 'audio' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'audio' );
            $responsive_landing_page_title = esc_html__('Audio','responsive-landing-page');
        }elseif( $responsive_landing_page_format == 'gallery' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'gallery' );
            $responsive_landing_page_title = esc_html__('Gallery','responsive-landing-page');
        }elseif( $responsive_landing_page_format == 'quote' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'quote' );
            $responsive_landing_page_title = esc_html__('Quote','responsive-landing-page');
        }elseif( $responsive_landing_page_format == 'image' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'image' );
            $responsive_landing_page_title = esc_html__('Image','responsive-landing-page');
        } elseif( $responsive_landing_page_format == 'link' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'link' );
            $responsive_landing_page_title = esc_html__('Link','responsive-landing-page');
        } elseif( $responsive_landing_page_format == 'status' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'status' );
            $responsive_landing_page_title = esc_html__('Status','responsive-landing-page');
        } elseif( $responsive_landing_page_format == 'aside' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'aside' );
            $responsive_landing_page_title = esc_html__('Aside','responsive-landing-page');
        } elseif( $responsive_landing_page_format == 'chat' ){
            $responsive_landing_page_icon = responsive_landing_page_get_theme_svg( 'chat' );
            $responsive_landing_page_title = esc_html__('Chat','responsive-landing-page');
        }
        
        if (!empty($responsive_landing_page_icon)) { ?>
            <div class="theme-post-format">
                <span class="post-format-icom"><?php echo responsive_landing_page_svg_escape($responsive_landing_page_icon); ?></span>
                <?php if( $responsive_landing_page_title ){ echo '<span class="post-format-label">'.esc_html( $responsive_landing_page_title ).'</span>'; } ?>
            </div>
        <?php }
    }

endif;

if ( ! function_exists( 'responsive_landing_page_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $responsive_landing_page_svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function responsive_landing_page_svg_escape( $responsive_landing_page_input ) {

        // Make sure that only our allowed tags and attributes are included.
        $responsive_landing_page_svg = wp_kses(
            $responsive_landing_page_input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $responsive_landing_page_svg ) {
            return false;
        }

        return $responsive_landing_page_svg;

    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_sidebar_option_meta' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_sidebar_option_meta( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_pagination_meta( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'Center','Right','Left');
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_menu_transform' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_menu_transform( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'capitalize','uppercase','lowercase');
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_page_content_alignment' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_page_content_alignment( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'left','center','right');
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_footer_widget_title_alignment' ) ) :

    // Footer Option Sanitize.
    function responsive_landing_page_sanitize_footer_widget_title_alignment( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'left','center','right');
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'responsive_landing_page_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $responsive_landing_page_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function responsive_landing_page_sanitize_pagination_type( $responsive_landing_page_input ) {
        // Define valid options for the pagination type.
        $responsive_landing_page_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $responsive_landing_page_input, $responsive_landing_page_valid_options, true ) ) {
            return $responsive_landing_page_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('responsive_landing_page_sanitize_enable_pagination') ) :
    function responsive_landing_page_sanitize_enable_pagination( $responsive_landing_page_input ) {
        return (bool) $responsive_landing_page_input;
    }
endif;

if( !function_exists( 'responsive_landing_page_sanitize_copyright_alignment_meta' ) ) :

    // Sidebar Option Sanitize.
    function responsive_landing_page_sanitize_copyright_alignment_meta( $responsive_landing_page_input ){

        $responsive_landing_page_metabox_options = array( 'Default','Reverse','Center');
        if( in_array( $responsive_landing_page_input,$responsive_landing_page_metabox_options ) ){

            return $responsive_landing_page_input;

        }else{

            return '';

        }
    }

endif;

/**
 * Sidebar Layout Function
 */
function responsive_landing_page_get_final_sidebar_layout() {
	$responsive_landing_page_defaults       = responsive_landing_page_get_default_theme_options();
	$responsive_landing_page_global_layout  = get_theme_mod('responsive_landing_page_global_sidebar_layout', $responsive_landing_page_defaults['responsive_landing_page_global_sidebar_layout']);
	$responsive_landing_page_page_layout    = get_theme_mod('responsive_landing_page_page_sidebar_layout', $responsive_landing_page_global_layout);
	$responsive_landing_page_post_layout    = get_theme_mod('responsive_landing_page_post_sidebar_layout', $responsive_landing_page_global_layout);
	$responsive_landing_page_meta_layout    = get_post_meta(get_the_ID(), 'responsive_landing_page_post_sidebar_option', true);

	if (!empty($responsive_landing_page_meta_layout) && $responsive_landing_page_meta_layout !== 'default') {
		return $responsive_landing_page_meta_layout;
	}
	if (is_page() || (function_exists('is_shop') && is_shop())) {
		return $responsive_landing_page_page_layout;
	}
	if (is_single()) {
		return $responsive_landing_page_post_layout;
	}
	return $responsive_landing_page_global_layout;
}