<?php
/**
 * Responsive Landing Page functions and definitions
 * @package Responsive Landing Page
 */

if ( ! function_exists( 'responsive_landing_page_after_theme_support' ) ) :

	function responsive_landing_page_after_theme_support() {
		
		add_theme_support( 'automatic-feed-links' );

		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'ffffff',
			)
		);

		$GLOBALS['content_width'] = apply_filters( 'responsive_landing_page_content_width', 1140 );
		
		add_theme_support( 'post-thumbnails' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 270,
				'width'       => 90,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		add_theme_support( 'title-tag' );

        load_theme_textdomain( 'responsive-landing-page', get_template_directory() . '/languages' );

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);

		add_theme_support( 'post-formats', array(
			'video',  
			'audio',  
			'gallery',
			'quote',  
			'image',  
			'link',   
			'status', 
			'aside',  
			'chat',   
		) );
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
        add_theme_support( 'woocommerce' );
		add_theme_support( 'wp-block-styles' );

		require get_template_directory() . '/inc/metabox.php';
		require get_template_directory() . '/inc/homepage-setup/homepage-setup-settings.php';

		if (! defined( 'RESPONSIVE_LANDING_PAGE_BUY_NOW' ) ){
		define('RESPONSIVE_LANDING_PAGE_BUY_NOW',__('https://www.omegathemes.com/products/landing-page-wordpress-theme','responsive-landing-page'));
		}
		if (! defined( 'RESPONSIVE_LANDING_PAGE_SUPPORT_FREE' ) ){
		define('RESPONSIVE_LANDING_PAGE_SUPPORT_FREE',__('https://wordpress.org/support/theme/responsive-landing-page/','responsive-landing-page'));
		}
		if (! defined( 'RESPONSIVE_LANDING_PAGE_DEMO_PRO' ) ){
		define('RESPONSIVE_LANDING_PAGE_DEMO_PRO',__('https://layout.omegathemes.com/responsive-landing-page/','responsive-landing-page'));
		}
		if (! defined( 'RESPONSIVE_LANDING_PAGE_LITE_DOCS_PRO' ) ){
		define('RESPONSIVE_LANDING_PAGE_LITE_DOCS_PRO',__('https://layout.omegathemes.com/steps/free-responsive-landing-page/','responsive-landing-page'));
		}
		if (! defined('RESPONSIVE_LANDING_PAGE_BUNDLE_BUTTON') ){
			define('RESPONSIVE_LANDING_PAGE_BUNDLE_BUTTON',__('https://www.omegathemes.com/products/wp-theme-bundle','responsive-landing-page'));
		}
	}

endif;

add_action( 'after_setup_theme', 'responsive_landing_page_after_theme_support' );

/**
 * Register and Enqueue Styles.
 */
function responsive_landing_page_register_styles() {

	wp_enqueue_style( 'dashicons' );

    $responsive_landing_page_theme_version = wp_get_theme()->get( 'Version' );
	$responsive_landing_page_fonts_url = responsive_landing_page_fonts_url();
    if( $responsive_landing_page_fonts_url ){
    	require get_theme_file_path( 'lib/custom/css/wptt-webfont-loader.php' );
        wp_enqueue_style(
			'responsive-landing-page-google-fonts',
			wptt_get_webfont_url( $responsive_landing_page_fonts_url ),
			array(),
			$responsive_landing_page_theme_version
		);
    }
	wp_enqueue_style( 'responsive-landing-page-style', get_stylesheet_uri(), array(), $responsive_landing_page_theme_version );

	wp_enqueue_style( 'responsive-landing-page-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom_css.php' );
	wp_add_inline_style( 'responsive-landing-page-style',$responsive_landing_page_custom_css );

	$responsive_landing_page_css = '';

	if ( get_header_image() ) :

		$responsive_landing_page_css .=  '
			.header-navbar{
				background-image: url('.esc_url(get_header_image()).');
				-webkit-background-size: cover !important;
				-moz-background-size: cover !important;
				-o-background-size: cover !important;
				background-size: cover !important;
			}';

	endif;

	wp_add_inline_style( 'responsive-landing-page-style', $responsive_landing_page_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

	wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'responsive-landing-page-custom', get_template_directory_uri() . '/lib/custom/js/theme-custom-script.js', array('jquery'), '', 1);
	wp_localize_script(
        'responsive-landing-page-custom',
        'ajax_obj',
        array(
            'ajaxurl' => admin_url('admin-ajax.php')
        )
    );

    // Global Query
    if( is_front_page() ){

    	$responsive_landing_page_posts_per_page = absint( get_option('posts_per_page') );
        $responsive_landing_page_c_paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
        $responsive_landing_page_posts_args = array(
            'posts_per_page'        => $responsive_landing_page_posts_per_page,
            'paged'                 => $responsive_landing_page_c_paged,
        );
        $posts_qry = new WP_Query( $responsive_landing_page_posts_args );
        $max = $posts_qry->max_num_pages;

    }else{
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $responsive_landing_page_c_paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
    }

    $responsive_landing_page_default = responsive_landing_page_get_default_theme_options();
    $responsive_landing_page_pagination_layout = get_theme_mod( 'responsive_landing_page_pagination_layout',$responsive_landing_page_default['responsive_landing_page_pagination_layout'] );
}

add_action( 'wp_enqueue_scripts', 'responsive_landing_page_register_styles',200 );

function responsive_landing_page_admin_enqueue_scripts_callback() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
    wp_enqueue_media();
    }
    wp_enqueue_script('responsive-landing-page-uploaderjs', get_stylesheet_directory_uri() . '/lib/custom/js/uploader.js', array(), "1.0", true);
}
add_action( 'admin_enqueue_scripts', 'responsive_landing_page_admin_enqueue_scripts_callback' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 */
function responsive_landing_page_menus() {

	$responsive_landing_page_locations = array(
		'responsive-landing-page-primary-menu'  => esc_html__( 'Primary Menu', 'responsive-landing-page' ),
	);

	register_nav_menus( $responsive_landing_page_locations );
}

add_action( 'init', 'responsive_landing_page_menus' );

add_filter('loop_shop_columns', 'responsive_landing_page_loop_columns');
if (!function_exists('responsive_landing_page_loop_columns')) {
	function responsive_landing_page_loop_columns() {
		$responsive_landing_page_columns = get_theme_mod( 'responsive_landing_page_per_columns', 3 );
		return $responsive_landing_page_columns;
	}
}

add_filter( 'loop_shop_per_page', 'responsive_landing_page_per_page', 20 );
function responsive_landing_page_per_page( $responsive_landing_page_cols ) {
  	$responsive_landing_page_cols = get_theme_mod( 'responsive_landing_page_product_per_page', 9 );
	return $responsive_landing_page_cols;
}

function responsive_landing_page_products_args( $responsive_landing_page_args ) {

    $responsive_landing_page_args['posts_per_page'] = get_theme_mod( 'responsive_landing_page_custom_related_products_number', 6 );

    $responsive_landing_page_args['columns'] = get_theme_mod( 'responsive_landing_page_custom_related_products_number_per_row', 3 );

    return $responsive_landing_page_args;
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/classes/class-svg-icons.php';
require get_template_directory() . '/classes/class-walker-menu.php';
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/classes/body-classes.php';
require get_template_directory() . '/inc/widgets/widgets.php';
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/lib/breadcrumbs/breadcrumbs.php';
require get_template_directory() . '/lib/custom/css/dynamic-style.php';
require get_template_directory() . '/inc/general.php';

function responsive_landing_page_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'responsive_landing_page_remove_customize_register', 11 );

function responsive_landing_page_radio_sanitize(  $responsive_landing_page_input, $responsive_landing_page_setting  ) {
	$responsive_landing_page_input = sanitize_key( $responsive_landing_page_input );
	$responsive_landing_page_choices = $responsive_landing_page_setting->manager->get_control( $responsive_landing_page_setting->id )->choices;
	return ( array_key_exists( $responsive_landing_page_input, $responsive_landing_page_choices ) ? $responsive_landing_page_input : $responsive_landing_page_setting->default );
}

// NOTICE FUNCTION

function responsive_landing_page_admin_notice() { 
    global $pagenow;
    $theme_args = wp_get_theme();
    $meta = get_option( 'responsive_landing_page_admin_notice' );
    $name = $theme_args->get( 'Name' );
    $current_screen = get_current_screen();

    if ( ! $meta ) {
        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( $current_screen->base != 'appearance_page_responsivelandingpage-wizard' ) {
            ?>
            <div class="notice notice-success notice-content">
                <h2><?php esc_html_e('Welcome! Thank you for choosing Responsive Landing Page. Let’s Set Up Your Website!', 'responsive-landing-page') ?> </h2>
                <p><?php esc_html_e('Before you dive into customization, let’s go through a quick setup process to ensure everything runs smoothly. Click below to start setting up your website in minutes!', 'responsive-landing-page') ?> </p>
                <div class="info-link">
                    <a href="<?php echo esc_url( admin_url( 'themes.php?page=responsivelandingpage-wizard' ) ); ?>"><?php esc_html_e('Get Started with Responsive Landing Page', 'responsive-landing-page'); ?></a>
                </div>
                <p class="dismiss-link"><strong><a href="?responsive_landing_page_admin_notice=1"><?php esc_html_e( 'Dismiss', 'responsive-landing-page' ); ?></a></strong></p>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'responsive_landing_page_admin_notice' );

if ( ! function_exists( 'responsive_landing_page_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
 */
function responsive_landing_page_update_admin_notice() {
    if ( isset( $_GET['responsive_landing_page_admin_notice'] ) && $_GET['responsive_landing_page_admin_notice'] == '1' ) {
        update_option( 'responsive_landing_page_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'responsive_landing_page_update_admin_notice' );