<?php
/**
 * Header Layout
 * @package Responsive Landing Page
 */

$responsive_landing_page_defaults = responsive_landing_page_get_default_theme_options();

$responsive_landing_page_sticky = get_theme_mod('responsive_landing_page_sticky');
    $responsive_landing_page_data_sticky = "false";
    if ($responsive_landing_page_sticky) {
    $responsive_landing_page_data_sticky = "true";
    }
    global $wp_customize;

$responsive_landing_page_header_layout_button_text = esc_html( get_theme_mod( 'responsive_landing_page_header_layout_button_text',
$responsive_landing_page_defaults['responsive_landing_page_header_layout_button_text'] ) );

$responsive_landing_page_header_layout_button_url = esc_html( get_theme_mod( 'responsive_landing_page_header_layout_button_url',
$responsive_landing_page_defaults['responsive_landing_page_header_layout_button_url'] ) );

?>
<header id="site-header" class="site-header-layout header-layout" role="banner">
    <div class="header-navbar <?php if( is_user_logged_in() && !isset( $wp_customize ) ){ echo "login-user";} ?>" data-sticky="<?php echo esc_attr($responsive_landing_page_data_sticky); ?>">
        <div class="wrapper header-wrapper">
            <div class="theme-header-areas header-areas-left aa">
                <div class="header-titles">
                    <?php
                    responsive_landing_page_site_logo();
                    responsive_landing_page_site_description();
                    ?>
                </div>
            </div>
            <div class="header-right-box">
                <div class="theme-header-areas header-areas-right bb">
                    <div class="site-navigation">
                        <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'responsive-landing-page'); ?>" role="navigation">
                            <ul class="primary-menu theme-menu">
                                <?php
                                if (has_nav_menu('responsive-landing-page-primary-menu')) {
                                    wp_nav_menu(
                                        array(
                                            'container' => '',
                                            'items_wrap' => '%3$s',
                                            'theme_location' => 'responsive-landing-page-primary-menu',
                                        )
                                    );
                                } else {
                                    wp_list_pages(
                                        array(
                                            'match_menu_classes' => true,
                                            'show_sub_menu_icons' => true,
                                            'title_li' => false,
                                            'walker' => new Responsive_Landing_Page_Walker_Page(),
                                        )
                                    );
                                } ?>
                            </ul>
                        </nav>
                    </div>
                    <div class="navbar-controls twp-hide-js">
                        <button type="button" class="navbar-control navbar-control-offcanvas">
                            <span class="navbar-control-trigger" tabindex="-1">
                                <?php responsive_landing_page_the_theme_svg('menu'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div class="theme-header-areas header-areas-right header-contact cc">
                    <div class="header-btn">
                        <a href="<?php echo esc_url( $responsive_landing_page_header_layout_button_url ); ?>"><?php echo esc_html( $responsive_landing_page_header_layout_button_text ); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>