<?php
/**
 * The template for displaying single posts and pages.
 * @package Responsive Landing Page
 * @since 1.0.0
 */

get_header();

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();
$responsive_landing_page_global_layout = get_theme_mod('responsive_landing_page_global_sidebar_layout', $responsive_landing_page_default['responsive_landing_page_global_sidebar_layout']);
$responsive_landing_page_page_layout = get_theme_mod('responsive_landing_page_page_sidebar_layout', $responsive_landing_page_global_layout);
$responsive_landing_page_post_layout = get_theme_mod('responsive_landing_page_post_sidebar_layout', $responsive_landing_page_global_layout);
$responsive_landing_page_post_meta = get_post_meta(get_the_ID(), 'responsive_landing_page_post_sidebar_option', true);

$responsive_landing_page_final_layout = $responsive_landing_page_global_layout;
if (!empty($responsive_landing_page_post_meta) && $responsive_landing_page_post_meta !== 'default') {
    $responsive_landing_page_final_layout = $responsive_landing_page_post_meta;
} elseif (is_page() || (function_exists('is_shop') && is_shop())) {
    $responsive_landing_page_final_layout = $responsive_landing_page_page_layout;
} elseif (is_single()) {
    $responsive_landing_page_final_layout = $responsive_landing_page_post_layout;
}

// Set content column order based on sidebar layout
$responsive_landing_page_sidebar_column_class = 'column-order-1';
if ($responsive_landing_page_final_layout === 'left-sidebar') {
    $responsive_landing_page_sidebar_column_class = 'column-order-2';
}

?>

<div id="single-page" class="singular-main-block">
    <div class="wrapper">
        <div class="column-row <?php echo esc_attr($responsive_landing_page_final_layout === 'no-sidebar' ? 'no-sidebar-layout' : ''); ?>">

            <?php if ($responsive_landing_page_final_layout === 'left-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

            <div id="primary" class="content-area <?php echo esc_attr($responsive_landing_page_final_layout === 'no-sidebar' ? 'full-width-content' : $responsive_landing_page_sidebar_column_class); ?>">
                <main id="site-content" role="main">

                    <?php
                    responsive_landing_page_breadcrumb(); // Display breadcrumb

                    if (have_posts()) : ?>

                        <div class="article-wraper">
                            <?php while (have_posts()) : the_post(); ?>

                                <?php get_template_part('template-parts/content', 'single'); ?>

                                <?php if ((is_single() || is_page()) && (comments_open() || get_comments_number()) && !post_password_required()) : ?>
                                    <div class="comments-wrapper">
                                        <?php comments_template(); ?>
                                    </div>
                                <?php endif; ?>

                            <?php endwhile; ?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('template-parts/content', 'none'); ?>

                    <?php endif;

                    do_action('responsive_landing_page_navigation_action');
                    ?>

                </main>
            </div>

            <?php if ($responsive_landing_page_final_layout === 'right-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>