<?php
$responsive_landing_page_layout = responsive_landing_page_get_final_sidebar_layout();
$responsive_landing_page_sidebar_class = 'column-order-1';

if ( $responsive_landing_page_layout === 'left-sidebar' ) {
    $responsive_landing_page_sidebar_class = 'column-order-1';
} elseif ( $responsive_landing_page_layout === 'right-sidebar' ) {
    $responsive_landing_page_sidebar_class = 'column-order-2';
}

if ( $responsive_landing_page_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $responsive_landing_page_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'responsive-landing-page'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'responsive-landing-page'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'responsive-landing-page'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'responsive-landing-page'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'responsive-landing-page'); ?></h3>
                    <?php
                    $responsive_landing_page_tags = get_tags();
                    if ( $responsive_landing_page_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $responsive_landing_page_tags as $responsive_landing_page_tag ) {
                            $responsive_landing_page_link = get_tag_link($responsive_landing_page_tag->term_id);
                            echo '<a href="' . esc_url($responsive_landing_page_link) . '" class="tag-cloud-link">' . esc_html($responsive_landing_page_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'responsive-landing-page') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
