<?php
/**
 *
 * Pagination Functions
 *
 * @package Responsive Landing Page
 */

/**
 * Pagination for archive.
 */
function responsive_landing_page_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $responsive_landing_page_is_pagination_enabled = get_theme_mod( 'responsive_landing_page_enable_pagination', true );

    // Check if pagination is enabled
    if ( $responsive_landing_page_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $responsive_landing_page_pagination_type = get_theme_mod( 'responsive_landing_page_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $responsive_landing_page_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'responsive-landing-page' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'responsive-landing-page' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'responsive-landing-page' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'responsive-landing-page' ),
                    'next_text' => __( 'Next &raquo;', 'responsive-landing-page' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'responsive-landing-page' ),
                )
            );
        endif;
    }
}
add_action( 'responsive_landing_page_posts_pagination', 'responsive_landing_page_render_posts_pagination', 10 );