<?php

function responsive_landing_page_enqueue_fonts() {
    $responsive_landing_page_default_font_content = 'inter';
    $responsive_landing_page_default_font_heading = 'inter';

    $responsive_landing_page_font_content = esc_attr(get_theme_mod('responsive_landing_page_content_typography_font', $responsive_landing_page_default_font_content));
    $responsive_landing_page_font_heading = esc_attr(get_theme_mod('responsive_landing_page_heading_typography_font', $responsive_landing_page_default_font_heading));

    $responsive_landing_page_css = '';

    // Always enqueue main font
    $responsive_landing_page_css .= '
    :root {
        --font-main: ' . $responsive_landing_page_font_content . ', ' . (in_array($responsive_landing_page_font_content, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . ' !important;
    }';
    wp_enqueue_style('responsive-landing-page-style-font-general', get_template_directory_uri() . '/fonts/' . $responsive_landing_page_font_content . '/font.css');

    // Always enqueue header font
    $responsive_landing_page_css .= '
    :root {
        --font-head: ' . $responsive_landing_page_font_heading . ', ' . (in_array($responsive_landing_page_font_heading, ['bitter', 'charis-sil']) ? 'serif' : 'serif ') . ' !important;
    }';
    wp_enqueue_style('responsive-landing-page-style-font-h', get_template_directory_uri() . '/fonts/' . $responsive_landing_page_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('responsive-landing-page-style-font-general', $responsive_landing_page_css);
}
add_action('wp_enqueue_scripts', 'responsive_landing_page_enqueue_fonts', 50);