<?php
/**
* Header Options.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'responsive_landing_page_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'responsive-landing-page' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

$wp_customize->add_setting( 'responsive_landing_page_header_layout_button_text',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_header_layout_button_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_header_layout_button_text',
    array(
    'label'    => esc_html__( 'Header Button', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'responsive_landing_page_header_layout_button_url',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_header_layout_button_url'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'responsive_landing_page_header_layout_button_url',
    array(
    'label'    => esc_html__( 'Button Url', 'responsive-landing-page' ),
    'section'  => 'responsive_landing_page_button_header_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting('responsive_landing_page_sticky',
    array(
        'default' => $responsive_landing_page_default['responsive_landing_page_sticky'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_checkbox',
    )
);
$wp_customize->add_control('responsive_landing_page_sticky',
    array(
        'label' => esc_html__('Enable Sticky Header', 'responsive-landing-page'),
        'section' => 'responsive_landing_page_button_header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('responsive_landing_page_menu_font_size',
    array(
        'default'           => $responsive_landing_page_default['responsive_landing_page_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
    )
);
$wp_customize->add_control('responsive_landing_page_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'responsive-landing-page'),
        'section'     => 'responsive_landing_page_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'responsive_landing_page_menu_text_transform',
    array(
    'default'           => $responsive_landing_page_default['responsive_landing_page_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'responsive_landing_page_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'responsive_landing_page_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'responsive-landing-page' ),
    'section'     => 'responsive_landing_page_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'responsive-landing-page' ),
        'uppercase'  => esc_html__( 'Uppercase', 'responsive-landing-page' ),
        'lowercase'    => esc_html__( 'Lowercase', 'responsive-landing-page' ),
        ),
    )
);