<?php
/**
* Global Color Settings.
*
* @package Responsive Landing Page
*/

$responsive_landing_page_default = responsive_landing_page_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'responsive_landing_page_global_secondary_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'responsive-landing-page' ),
	'priority'   => 1,
	'capability' => 'edit_theme_options',
	'panel'      => 'responsive_landing_page_theme_option_panel',
	)
);

$wp_customize->add_setting( 'responsive_landing_page_global_color',
    array(
    'default'           => '#8D6AEE ',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'responsive_landing_page_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'responsive-landing-page' ),
        'section'    => 'responsive_landing_page_global_color_setting',
        'settings'   => 'responsive_landing_page_global_color',
    ) ) 
);

$wp_customize->add_setting( 'responsive_landing_page_global_secondary_color',
    array(
    'default'           => '#0F131F',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'responsive_landing_page_global_secondary_color',
    array(
        'label'      => esc_html__( 'Secondary Color', 'responsive-landing-page' ),
        'section'    => 'responsive_landing_page_global_color_setting',
        'settings'   => 'responsive_landing_page_global_secondary_color',
    ) ) 
);