<?php
/**
 * Responsive Landing Page Theme Customizer
 * @package Responsive Landing Page
 */

/** Sanitize Functions. **/
	require get_template_directory() . '/inc/customizer/default.php';

if (!function_exists('responsive_landing_page_customize_register')) :

function responsive_landing_page_customize_register( $wp_customize ) {

	require get_template_directory() . '/inc/customizer/custom-classes.php';
	require get_template_directory() . '/inc/customizer/sanitize.php';
	require get_template_directory() . '/inc/customizer/header-button.php';
	require get_template_directory() . '/inc/customizer/custom-addon.php';
	require get_template_directory() . '/inc/customizer/global-color-setting.php';
	require get_template_directory() . '/inc/customizer/colors.php';
	require get_template_directory() . '/inc/customizer/typography.php';
	require get_template_directory() . '/inc/customizer/post.php';
	require get_template_directory() . '/inc/customizer/footer.php';
	require get_template_directory() . '/inc/customizer/layout-setting.php';
	require get_template_directory() . '/inc/customizer/additional-woocommerce.php';
	require get_template_directory() . '/inc/customizer/404-page-settings.php';

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	$wp_customize->get_section( 'colors' )->panel = 'responsive_landing_page_theme_colors_panel';
	$wp_customize->get_section( 'colors' )->title = esc_html__('Color Options','responsive-landing-page');
	$wp_customize->get_section( 'title_tagline' )->panel = 'responsive_landing_page_theme_general_settings';
	$wp_customize->get_section( 'header_image' )->panel = 'responsive_landing_page_theme_general_settings';
	$wp_customize->get_section( 'background_image' )->panel = 'responsive_landing_page_theme_general_settings';

	if ( isset( $wp_customize->selective_refresh ) ) {
		
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.header-titles .custom-logo-name',
			'render_callback' => 'responsive_landing_page_customize_partial_blogname',
		) );

		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'responsive_landing_page_customize_partial_blogdescription',
		) );

	}

	$wp_customize->add_panel( 'responsive_landing_page_theme_general_settings',
		array(
			'title'      => esc_html__( 'General Settings', 'responsive-landing-page' ),
			'priority'   => 10,
			'capability' => 'edit_theme_options',
		)
	);

	$wp_customize->add_panel( 'responsive_landing_page_theme_colors_panel',
		array(
			'title'      => esc_html__( 'Color Settings', 'responsive-landing-page' ),
			'priority'   => 15,
			'capability' => 'edit_theme_options',
		)
	);

	// Theme Options Panel.
	$wp_customize->add_panel( 'responsive_landing_page_theme_footer_option_panel',
		array(
			'title'      => esc_html__( 'Footer Setting', 'responsive-landing-page' ),
			'priority'   => 150,
			'capability' => 'edit_theme_options',
		)
	);

	// Template Options
	$wp_customize->add_panel( 'responsive_landing_page_theme_home_pannel',
		array(
			'title'      => esc_html__( 'Frontpage Settings', 'responsive-landing-page' ),
			'priority'   => 4,
			'capability' => 'edit_theme_options',
		)
	);

		// Theme Addons Panel.
	$wp_customize->add_panel( 'responsive_landing_page_theme_addons_panel',
		array(
			'title'      => esc_html__( 'Theme Addons', 'responsive-landing-page' ),
			'priority'   => 5,
			'capability' => 'edit_theme_options',
		)
	);
	
	// Theme Options Panel.
	$wp_customize->add_panel( 'responsive_landing_page_theme_option_panel',
		array(
			'title'      => esc_html__( 'Theme Options', 'responsive-landing-page' ),
			'priority'   => 5,
			'capability' => 'edit_theme_options',
		)
	);
	$wp_customize->add_setting('responsive_landing_page_logo_width_range',
	    array(
	        'default'           => $responsive_landing_page_default['responsive_landing_page_logo_width_range'],
	        'capability'        => 'edit_theme_options',
	        'sanitize_callback' => 'responsive_landing_page_sanitize_number_range',
	    )
	);
	$wp_customize->add_control('responsive_landing_page_logo_width_range',
	    array(
	        'label'       => esc_html__('Logo width', 'responsive-landing-page'),
	        'description'       => esc_html__( 'Specify the range for logo size with a minimum of 200px and a maximum of 700px, in increments of 20px.', 'responsive-landing-page' ),
	        'section'     => 'title_tagline',
	        'type'        => 'range',
	        'input_attrs' => array(
	           'min'   => 100,
	           'max'   => 700,
	           'step'   => 20,
        	),
	    )
	);

	// Register custom section types.
	$wp_customize->register_section_type( 'Responsive_Landing_Page_Customize_Section_Upsell' );

	// Register sections.
	$wp_customize->add_section(
		new Responsive_Landing_Page_Customize_Section_Upsell(
			$wp_customize,
			'theme_upsell',
			array(
				'title'    => esc_html__( 'Responsive Landing Pro', 'responsive-landing-page' ),
				'pro_text' => esc_html__( 'Upgrade To Pro', 'responsive-landing-page' ),
				'pro_url'  => esc_url('https://www.omegathemes.com/products/clothing-store-wordpress-theme'),
				'priority'  => 1,
			)
		)
	);

}

endif;
add_action( 'customize_register', 'responsive_landing_page_customize_register' );

/**
 * Customizer Enqueue scripts and styles.
 */

if (!function_exists('responsive_landing_page_customizer_scripts')) :

    function responsive_landing_page_customizer_scripts(){
    	
    	wp_enqueue_script('jquery-ui-button');
    	wp_enqueue_style('responsive-landing-page-customizer', get_template_directory_uri() . '/lib/custom/css/customizer.css');
        wp_enqueue_script('responsive-landing-page-customizer', get_template_directory_uri() . '/lib/custom/js/customizer.js', array('jquery','customize-controls'), '', 1);

        $ajax_nonce = wp_create_nonce('responsive_landing_page_ajax_nonce');
        wp_localize_script( 
		    'responsive-landing-page-customizer',
		    'responsive_landing_page_customizer',
		    array(
		        'ajax_url'   => esc_url( admin_url( 'admin-ajax.php' ) ),
		        'ajax_nonce' => $ajax_nonce,
		     )
		);
    }

endif;

add_action('customize_controls_enqueue_scripts', 'responsive_landing_page_customizer_scripts');
add_action('customize_controls_init', 'responsive_landing_page_customizer_scripts');

function responsive_landing_page_customize_preview_js() {
	wp_enqueue_script( 'responsive-landing-page-customizer-preview', get_template_directory_uri() . '/lib/custom/js/customizer-preview.js', array( 'customize-preview' ), '', true );
}
add_action( 'customize_preview_init', 'responsive_landing_page_customize_preview_js' );

if (!function_exists('responsive_landing_page_customize_partial_blogname')) :
	function responsive_landing_page_customize_partial_blogname() {
		bloginfo( 'name' );
	}
endif;

if (!function_exists('responsive_landing_page_customize_partial_blogdescription')) :
	function responsive_landing_page_customize_partial_blogdescription() {
		bloginfo( 'description' );
	}
endif;